/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import kafka.tier.store.objects.FragmentType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FragmentTypeTest {
    @Test
    public void testBytesForFragmentTypesAreInOrderAndContinuous() {
        byte expectedByte = 0;
        for (FragmentType dataType : FragmentType.values()) {
            Assertions.assertEquals((byte)expectedByte, (byte)dataType.getByte());
            expectedByte = (byte)(expectedByte + 1);
        }
    }

    @Test
    public void testByteToFragmentTypeConversionCorrectForAllDataTypes() {
        for (FragmentType dataType : FragmentType.values()) {
            byte byteValue = dataType.getByte();
            Assertions.assertEquals((Object)dataType, (Object)FragmentType.byteToFragmentType((byte)byteValue), (String)String.format("Byte value %02x of FragmentType %s does not map to correct data type according to byteToFragmentType method", byteValue, dataType.name()));
        }
    }

    @Test
    public void testByteToFragmentTypeThrowsOnInvalidByte() {
        byte invalidByte = (byte)FragmentType.values().length;
        Assertions.assertThrows(IllegalArgumentException.class, () -> FragmentType.byteToFragmentType((byte)invalidByte));
    }
}

