/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import java.util.Optional;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class ObjectTypeTest {
    ObjectTypeTest() {
    }

    @Test
    public void testBytesForObjectTypesAreInOrderAndContinuous() {
        byte expectedByte = 0;
        for (ObjectType objectType : ObjectType.values()) {
            Assertions.assertEquals((byte)expectedByte, (byte)objectType.getByte());
            expectedByte = (byte)(expectedByte + 1);
        }
    }

    @Test
    public void testByteToObjectTypeConversionCorrectForAllObjectTypes() {
        for (ObjectType objectType : ObjectType.values()) {
            byte byteValue = objectType.getByte();
            Assertions.assertEquals((Object)objectType, (Object)ObjectType.byteToObjectType((byte)byteValue), (String)String.format("Byte value %02x of ObjectType %s does not map to correct data type according to byteToObjectType method", byteValue, objectType.name()));
        }
    }

    @Test
    public void testByteToObjectTypeThrowsOnInvalidByte() {
        byte invalidByte = (byte)ObjectType.values().length;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectType.byteToObjectType((byte)invalidByte));
    }

    @Test
    public void testObjectTypeDesignatedFragmentTypeMatchesFragmentTypeDefaultObjectType() {
        for (ObjectType objectType : ObjectType.values()) {
            if (!objectType.getDesignatedFragmentType().isPresent()) continue;
            Assertions.assertEquals((Object)objectType, ObjectType.getDefaultObjectTypeForFragmentType((FragmentType)((FragmentType)objectType.getDesignatedFragmentType().get())).get(), (String)"Designated fragment type of an object and default object type of a fragment must be inverses");
        }
        for (ObjectType objectType : FragmentType.values()) {
            Optional defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType((FragmentType)objectType);
            if (!defaultObjectType.isPresent()) continue;
            Assertions.assertEquals((Object)objectType, ((ObjectType)defaultObjectType.get()).getDesignatedFragmentType().get(), (String)"Designated fragment type of an object and default object type of a fragment must be inverses");
        }
    }

    @Test
    void testToE2EChecksumProtectedObjectType() {
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.SEGMENT, (Object)ObjectType.SEGMENT.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.OFFSET_INDEX, (Object)ObjectType.OFFSET_INDEX.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIMESTAMP_INDEX, (Object)ObjectType.TIMESTAMP_INDEX.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TRANSACTION_INDEX, (Object)ObjectType.TRANSACTION_INDEX.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.PRODUCER_STATE, (Object)ObjectType.PRODUCER_STATE.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.EPOCH_STATE, (Object)ObjectType.EPOCH_STATE.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIER_STATE_SNAPSHOT, (Object)ObjectType.TIER_STATE_SNAPSHOT.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.LIFECYCLE_MANAGER_STATE, (Object)ObjectType.LIFECYCLE_MANAGER_STATE.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.BACKUP_OBJECTS_LIST, (Object)ObjectType.BACKUP_OBJECTS_LIST.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.HEALTH_CHECK, (Object)ObjectType.HEALTH_CHECK.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT, (Object)ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIER_TOPIC_SNAPSHOT, (Object)ObjectType.TIER_TOPIC_SNAPSHOT.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.DA_OFFSET_MAP, (Object)ObjectType.DA_OFFSET_MAP.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.SEGMENT_WITH_METADATA, (Object)ObjectType.SEGMENT_WITH_METADATA.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.FILE_TIER_PARTITION_STATE_UPLOAD, (Object)ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIER_RECOVERY_METADATA_UPLOAD, (Object)ObjectType.TIER_RECOVERY_METADATA_UPLOAD.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIER_OFFSETS_UPLOAD, (Object)ObjectType.TIER_OFFSETS_UPLOAD.toE2EChecksumProtectedObjectType());
        Assertions.assertEquals((Object)E2EChecksumProtectedObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT, (Object)ObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT.toE2EChecksumProtectedObjectType());
    }

    @ParameterizedTest
    @EnumSource(value=ObjectType.class)
    void toE2EChecksumProtectedObjectTypeDoesntThrowIllegalArgumentException(ObjectType objectType) {
        try {
            objectType.toE2EChecksumProtectedObjectType();
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)("toE2EChecksumProtectedObjectType() shouldn't throw\n   * IllegalArgumentException for any file type" + e));
        }
    }
}

