/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.cloud.EpochAndSeqNumber;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.BackupObjectsListMetadata;
import kafka.tier.store.objects.metadata.DurabilityAuditsOffsetMapMetadata;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.store.objects.metadata.HealthMetadata;
import kafka.tier.store.objects.metadata.KRaftSnapshotMetadata;
import kafka.tier.store.objects.metadata.LifecycleManagerStateMetadata;
import kafka.tier.store.objects.metadata.TierOffsetsRecoveryUploadMetadata;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.store.objects.metadata.TierStateRestoreSnapshotMetadata;
import kafka.tier.store.objects.metadata.TierTopicHeadDataLossReportMetadata;
import kafka.tier.store.objects.metadata.TierTopicSnapshotMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectStoreMetadataTest {
    private static final String CLUSTER = "pkc-12345";
    private static final String DATE = "05-10-1999";
    private static final String IDENTIFIER = "identifier";
    private static final TopicIdPartition TPID = new TopicIdPartition("topic", UUID.randomUUID(), 0);
    public static final String LOG_DIR = "/logDir";

    @Test
    public void testObjectPathSuffix() {
        String backupObjectListsPath = ((FragmentLocation)new BackupObjectsListMetadata(CLUSTER, DATE, IDENTIFIER).toFragmentLocation("", FragmentType.BACKUP_OBJECTS_LIST).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)backupObjectListsPath), (Object)ObjectType.BACKUP_OBJECTS_LIST.suffix());
        String durabilityAuditsOffsetMapPath = ((FragmentLocation)new DurabilityAuditsOffsetMapMetadata(TPID, UUID.randomUUID()).toFragmentLocation("", FragmentType.DA_OFFSET_MAP).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)durabilityAuditsOffsetMapPath), (Object)ObjectType.DA_OFFSET_MAP.suffix());
        String ftpsRecoveryUploadMetadataPath = ((FragmentLocation)new FileTierPartitionStateRecoveryUploadMetadata(IDENTIFIER, Integer.valueOf(0), TPID, new FileTierPartitionStateUploadObject("base", Algorithm.NO_CHECKSUM)).toFragmentLocation("", FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)ftpsRecoveryUploadMetadataPath), (Object)ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD.suffix());
        String healthMetadataPath = ((FragmentLocation)new HealthMetadata(Optional.of(CLUSTER), Optional.of(1)).toFragmentLocation("", FragmentType.HEALTH_CHECK).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)healthMetadataPath), (Object)ObjectType.HEALTH_CHECK.suffix());
        KRaftSnapshotObject kRaftSnapshotObject = new KRaftSnapshotObject(Uuid.METADATA_TOPIC_ID, 0, CLUSTER, 0, 0L, new OffsetAndEpoch(0L, 0));
        String kraftSnapshotPath = ((FragmentLocation)new KRaftSnapshotMetadata(kRaftSnapshotObject).toFragmentLocation("", FragmentType.KRAFT_SNAPSHOT).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)kraftSnapshotPath), (Object)ObjectType.KRAFT_SNAPSHOT.suffix());
        String lifecycleManagerStatePath = ((FragmentLocation)new LifecycleManagerStateMetadata(CLUSTER).toFragmentLocation("", FragmentType.LIFECYCLE_MANAGER_STATE).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)lifecycleManagerStatePath), (Object)ObjectType.LIFECYCLE_MANAGER_STATE.suffix());
        String tierOffsetsRecoveryUploadPath = ((FragmentLocation)new TierOffsetsRecoveryUploadMetadata(LOG_DIR, IDENTIFIER, Integer.valueOf(0)).toFragmentLocation("", FragmentType.TIER_OFFSETS_UPLOAD).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)tierOffsetsRecoveryUploadPath), (Object)ObjectType.TIER_OFFSETS_UPLOAD.suffix());
        FileTierPartitionStateSnapshotObject ftpsSnapshot = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), 0L, new kafka.tier.state.OffsetAndEpoch(0L, Optional.of(0)), 0, "baseName", Algorithm.NO_CHECKSUM);
        String tierPartitionStateSnapshotPath = ((FragmentLocation)new TierPartitionStateSnapshotMetadata(TPID, ftpsSnapshot).toFragmentLocation("", FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)tierPartitionStateSnapshotPath), (Object)ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT.suffix());
        String tierRecoveryUploadPath = ((FragmentLocation)new TierOffsetsRecoveryUploadMetadata(LOG_DIR, IDENTIFIER, Integer.valueOf(0)).toFragmentLocation("", FragmentType.TIER_OFFSETS_UPLOAD).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)tierRecoveryUploadPath), (Object)ObjectType.TIER_OFFSETS_UPLOAD.suffix());
        String tierStateRestoreSnapshotPath = ((FragmentLocation)new TierStateRestoreSnapshotMetadata(TPID, 0L, 10L, "hash", Algorithm.NO_CHECKSUM, 0).toFragmentLocation("", FragmentType.TIER_STATE_SNAPSHOT).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)tierStateRestoreSnapshotPath), (Object)ObjectType.TIER_STATE_SNAPSHOT.suffix());
        String tierTopicHeadDataLossReportPath = ((FragmentLocation)new TierTopicHeadDataLossReportMetadata(IDENTIFIER, 0, "reportCreationTimstamp").toFragmentLocation("", FragmentType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)tierTopicHeadDataLossReportPath), (Object)ObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT.suffix());
        TierTopicSnapshotObject ttpSnapshot = new TierTopicSnapshotObject(0L, 100L, new EpochAndSeqNumber(0, 0L), new EpochAndSeqNumber(1, 1L));
        String tierTopicSnapshotPath = ((FragmentLocation)new TierTopicSnapshotMetadata(ttpSnapshot).toFragmentLocation("", FragmentType.TIER_TOPIC_SNAPSHOT).get()).objectPath();
        Assertions.assertEquals((Object)ObjectType.getObjectTypeSuffix((String)tierTopicSnapshotPath), (Object)ObjectType.TIER_TOPIC_SNAPSHOT.suffix());
    }
}

