/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierTopicHeadDataLossReportMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicHeadDataLossReportMetadataTest {
    @Test
    public void testObjectStorePathSerDe() {
        String keyPrefix = "foo";
        String identifier = "rcca-1234";
        int broker = 5;
        String reportCreationTimestamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSzz").format(new Date());
        TierTopicHeadDataLossReportMetadata metadata = new TierTopicHeadDataLossReportMetadata(identifier, broker, reportCreationTimestamp);
        String objectPath = ((FragmentLocation)metadata.toFragmentLocation(keyPrefix, FragmentType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT).get()).objectPath();
        String expectedObjectPath = String.format("%s%s/recovery-%s/%d/tier-topic-head-data-loss-report/%s_v0.%s", keyPrefix, TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), identifier, broker, reportCreationTimestamp, ObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT.suffix());
        Assertions.assertEquals((Object)objectPath, (Object)expectedObjectPath);
        TierTopicHeadDataLossReportMetadata decodedMetadata = TierTopicHeadDataLossReportMetadata.fromPath((String)objectPath);
        Assertions.assertEquals((Object)metadata, (Object)decodedMetadata);
    }

    @Test
    public void testMetadata() {
        final String identifier = "rcca-1234";
        final Integer broker = 5;
        final String reportCreationTimestamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSzz").format(new Date());
        TierTopicHeadDataLossReportMetadata metadata = new TierTopicHeadDataLossReportMetadata(identifier, broker.intValue(), reportCreationTimestamp);
        Map serializedMetadata = metadata.objectMetadata(Optional.empty(), Optional.empty());
        HashMap<String, String> expected = new HashMap<String, String>(){
            {
                this.put("identifier", identifier);
                this.put("broker", broker.toString());
                this.put("version", "0");
                this.put("reportCreationTimestamp", reportCreationTimestamp);
            }
        };
        Assertions.assertEquals((Object)serializedMetadata, (Object)expected);
    }
}

