/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.MockTask;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTaskQueue;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u00047\u0001\u0001\u0006I\u0001\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u00191\u0005\u0001)A\u0005s!9q\t\u0001b\u0001\n\u0013A\u0005B\u0002'\u0001A\u0003%\u0011\nC\u0004N\u0001\t\u0007I\u0011\u0002(\t\rU\u0003\u0001\u0015!\u0003P\u0011\u001d1\u0006A1A\u0005\n]Caa\u0017\u0001!\u0002\u0013A\u0006\"\u0002/\u0001\t\u0003i\u0006\"\u00027\u0001\t\u0003i\u0006\"B9\u0001\t\u0003i\u0006\"B:\u0001\t\u0003i\u0006\"B;\u0001\t\u0003i\u0006\"B<\u0001\t\u0003i\u0006\"B=\u0001\t\u0003i\u0006\"B>\u0001\t\u0003i\u0006\"B?\u0001\t\u0003i\u0006\"B@\u0001\t\u0003i\u0006BBA\u0002\u0001\u0011\u0005Q\f\u0003\u0004\u0002\b\u0001!\t!\u0018\u0005\u0007\u0003\u0017\u0001A\u0011A/\t\r\u0005=\u0001\u0001\"\u0001^\u0011\u0019\t\u0019\u0002\u0001C\u0001;\n\t2\t[1oO\u0016l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005uq\u0012!\u0002;bg.\u001c(BA\u0010!\u0003\u0011!\u0018.\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\u000f\u0002\u0007\r$\b0F\u00011!\t\tD'D\u00013\u0015\t\u0019d$A\u0004gKR\u001c\u0007.\u001a:\n\u0005U\u0012$aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\nA\u0001^5nKV\t\u0011\b\u0005\u0002;\t6\t1H\u0003\u0002={\u0005)Q\u000f^5mg*\u0011ahP\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005\u0002%BA!C\u0003\u0019\t\u0007/Y2iK*\t1)A\u0002pe\u001eL!!R\u001e\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\t[\u0006DH+Y:lgV\t\u0011\n\u0005\u0002&\u0015&\u00111J\n\u0002\u0004\u0013:$\u0018!C7bqR\u000b7o[:!\u0003\u0015\tX/Z;f+\u0005y\u0005cA\u0017Q%&\u0011\u0011\u000b\b\u0002\u000e)&,'\u000fV1tWF+X-^3\u0011\u00055\u001a\u0016B\u0001+\u001d\u0005!iunY6UCN\\\u0017AB9vKV,\u0007%A\nmK\u0006$WM]\"iC:<W-T1oC\u001e,'/F\u0001Y!\ti\u0013,\u0003\u0002[9\ti1\t[1oO\u0016l\u0015M\\1hKJ\fA\u0003\\3bI\u0016\u00148\t[1oO\u0016l\u0015M\\1hKJ\u0004\u0013\u0001\u0003;fCJ$wn\u001e8\u0015\u0003y\u0003\"!J0\n\u0005\u00014#\u0001B+oSRD#\u0001\u00042\u0011\u0005\rTW\"\u00013\u000b\u0005\u00154\u0017aA1qS*\u0011q\r[\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI')A\u0003kk:LG/\u0003\u0002lI\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018i\u0016\u001cH\u000fT3bI\u0016\u00148\u000f[5q\u001fZ,'O]5eKND#!\u00048\u0011\u0005\r|\u0017B\u00019e\u0005\u0011!Vm\u001d;\u0002AQ,7\u000f\u001e'fC\u0012,'o\u001d5ja\u000eC\u0017M\\4fg\u000e\u000bgnY3m)\u0006\u001c8n\u001d\u0015\u0003\u001d9\fQ\u0004^3ti\u0016C\u0018m\u0019;ms>s7-\u001a+bg.\u0004&o\\2fgNLgn\u001a\u0015\u0003\u001f9\fq\u0005^3ti2+\u0017\rZ3sg\"L\u0007o\u00115b]\u001e,G)\u001e:j]\u001e$\u0016m]6Fq\u0016\u001cW\u000f^5p]\"\u0012\u0001C\\\u0001 i\u0016\u001cH\u000fT8tg>3G*Z1eKJ\u001c\b.\u001b9SK6|g/Z:UCN\\\u0007FA\to\u00035!Xm\u001d;US6,G)\u001a7bs\"\u0012!C\\\u0001\u000fi\u0016\u001cH/\u0012:s_J\u001cF/\u0019;fQ\t\u0019b.\u0001\u000euKN$H)\u001a7bs^KG\u000f['vYRL\u0007\u000f\\3UCN\\7\u000f\u000b\u0002\u0015]\u0006\u0001B/Z:u\u001b\u0006DH+Y:lgB{G\u000e\u001c\u0015\u0003+9\f!\u0004^3tiR{\u0007/[2EK2,G/[8o'R|\u0007o\u001d+bg.D#A\u00068\u0002IQ,7\u000f^\"b]\u000e,G\u000e\\1uS>t'+Z7pm\u0016\u001cH+Y:l\rJ|W.U;fk\u0016D#a\u00068\u0002\u0019Q,7\u000f\u001e+bg.$uN\\3)\u0005aq\u0017a\b;fgR\u0004&o\\2fgN\u0014V\r^;s]N|e.U;fk\u0016\u001c\u0005.\u00198hK\"\u0012\u0011D\\\u0001\u001ai\u0016\u001cH\u000f\u0015:pG\u0016\u001c8OU3ukJt7o\u00148DY>\u001cX\r\u000b\u0002\u001b]\u0002")
public class ChangeManagerTest {
    private final CancellationContext kafka$tier$tasks$ChangeManagerTest$$ctx = CancellationContext.newContext();
    private final Time kafka$tier$tasks$ChangeManagerTest$$time = new MockTime();
    private final int kafka$tier$tasks$ChangeManagerTest$$maxTasks;
    private final TierTaskQueue<MockTask> queue = new TierTaskQueue<MockTask>(this){
        private final /* synthetic */ ChangeManagerTest $outer;

        public List<MockTask> sortTasks(List<MockTask> tasks) {
            return tasks;
        }

        public MockTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
            if (metadata instanceof StartLeadership) {
                StartLeadership startLeadership = (StartLeadership)metadata;
                return new MockTask(this.$outer.kafka$tier$tasks$ChangeManagerTest$$ctx().subContext(), topicIdPartition, startLeadership.leaderEpoch());
            }
            throw new IllegalStateException(new StringBuilder(11).append("Unexpected ").append(metadata).toString());
        }

        public boolean mayProcess(ChangeMetadata metadata) {
            return metadata instanceof LeadershipChange;
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$tier$tasks$ChangeManagerTest$$ctx().subContext(), $outer.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), $outer.kafka$tier$tasks$ChangeManagerTest$$time());
        }
    };
    private final ChangeManager leaderChangeManager = new ChangeManager(this.kafka$tier$tasks$ChangeManagerTest$$ctx().subContext(), (Seq)new .colon.colon(this.queue(), (List)Nil$.MODULE$), this.kafka$tier$tasks$ChangeManagerTest$$time());

    public CancellationContext kafka$tier$tasks$ChangeManagerTest$$ctx() {
        return this.kafka$tier$tasks$ChangeManagerTest$$ctx;
    }

    public Time kafka$tier$tasks$ChangeManagerTest$$time() {
        return this.kafka$tier$tasks$ChangeManagerTest$$time;
    }

    public int kafka$tier$tasks$ChangeManagerTest$$maxTasks() {
        return this.kafka$tier$tasks$ChangeManagerTest$$maxTasks;
    }

    private TierTaskQueue<MockTask> queue() {
        return this.queue;
    }

    private ChangeManager leaderChangeManager() {
        return this.leaderChangeManager;
    }

    @AfterEach
    public void teardown() {
        this.kafka$tier$tasks$ChangeManagerTest$$ctx().cancel();
    }

    @Test
    public void testLeadershipOverrides() {
        TopicIdPartition tp1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition tp2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        this.leaderChangeManager().onBecomeLeader(tp1, 0);
        this.leaderChangeManager().process();
        this.leaderChangeManager().onBecomeLeader(tp1, 1);
        this.leaderChangeManager().onBecomeLeader(tp2, 0);
        this.leaderChangeManager().onBecomeLeader(tp2, 1);
        this.leaderChangeManager().process();
        List task = (List)this.queue().poll().get();
        Assertions.assertEquals((int)2, (int)task.size());
        Assertions.assertEquals((Object)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)), (Object)task.map((Function1 & Serializable)x$1 -> x$1.topicIdPartition()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1})), (Object)task.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.leaderEpoch())));
    }

    @Test
    public void testLeadershipChangesCancelTasks() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().onBecomeLeader(tp1, 0);
        this.leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        Assertions.assertEquals((Object)new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)), (Object)tasks.map((Function1 & Serializable)x$3 -> x$3.topicIdPartition()));
        MockTask tp0Task = (MockTask)tasks.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ChangeManagerTest.$anonfun$testLeadershipChangesCancelTasks$2(tp0, x$4))).get();
        MockTask tp1Task = (MockTask)tasks.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ChangeManagerTest.$anonfun$testLeadershipChangesCancelTasks$3(tp1, x$5))).get();
        this.leaderChangeManager().onBecomeFollower(tp0);
        this.leaderChangeManager().process();
        Assertions.assertTrue((boolean)tp0Task.ctx().isCancelled(), (String)"expected tp0 task to be cancelled due to become follower");
        this.leaderChangeManager().onBecomeLeader(tp1, 1);
        this.leaderChangeManager().process();
        Assertions.assertTrue((boolean)tp1Task.ctx().isCancelled(), (String)"expected tp1 task to be cancelled due to new leadership");
    }

    @Test
    public void testExactlyOnceTaskProcessing() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        Assertions.assertEquals((Object)tp0, (Object)tp0Task.topicIdPartition());
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty(), (String)"expected no other tasks to be available");
        this.queue().done((TierTask)tp0Task);
        tp0Task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        Assertions.assertEquals((Object)tp0, (Object)tp0Task.topicIdPartition());
    }

    @Test
    public void testLeadershipChangeDuringTaskExecution() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        Assertions.assertEquals((Object)tp0, (Object)tp0Task.topicIdPartition());
        this.leaderChangeManager().onBecomeLeader(tp0, 1);
        this.leaderChangeManager().process();
        this.queue().done((TierTask)tp0Task);
        Assertions.assertTrue((boolean)tp0Task.ctx().isCancelled(), (String)"expected task to be immediately canceled since a new onBecomeLeader event occurred");
        List tasks = (List)Option$.MODULE$.option2Iterable(this.queue().poll()).head();
        Assertions.assertEquals((int)1, (int)tasks.size());
        Assertions.assertEquals((int)1, (int)((MockTask)tasks.head()).leaderEpoch());
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty(), (String)"expected to find nothing else in the queue");
    }

    @Test
    public void testLossOfLeadershipRemovesTask() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().onBecomeLeader(tp1, 0);
        this.leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        MockTask tp0Task = (MockTask)tasks.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ChangeManagerTest.$anonfun$testLossOfLeadershipRemovesTask$1(tp0, x$6))).get();
        MockTask tp1Task = (MockTask)tasks.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ChangeManagerTest.$anonfun$testLossOfLeadershipRemovesTask$2(tp1, x$7))).get();
        this.queue().done((TierTask)tp0Task);
        this.leaderChangeManager().onBecomeFollower(tp0);
        this.leaderChangeManager().process();
        Assertions.assertTrue((boolean)tp0Task.ctx().isCancelled(), (String)"expected task to be cancelled due to leadership change");
        Assertions.assertEquals((int)1, (int)this.queue().taskCount(), (String)"expected task to be removed from the queue due to leadership change");
        this.leaderChangeManager().onBecomeFollower(tp1);
        this.leaderChangeManager().process();
        Assertions.assertTrue((boolean)tp1Task.ctx().isCancelled(), (String)"expected task to be cancelled due to leadership change");
        Assertions.assertEquals((int)this.queue().taskCount(), (int)0, (String)"expected queue to be empty");
    }

    @Test
    public void testTimeDelay() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        Assertions.assertEquals((Object)tp0Task.topicIdPartition(), (Object)tp0);
        tp0Task.retryTaskLater(5000, this.kafka$tier$tasks$ChangeManagerTest$$time().hiResClockMs(), new Throwable());
        this.queue().done((TierTask)tp0Task);
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(200L);
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(4801L);
        Assertions.assertEquals((Object)tp0, (Object)((MockTask)((IterableOps)this.queue().poll().get()).head()).topicIdPartition());
    }

    @Test
    public void testErrorState() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        Assertions.assertEquals((Object)tp0Task.topicIdPartition(), (Object)tp0);
        tp0Task.cancelAndSetErrorState(new Throwable("failed"));
        this.queue().done((TierTask)tp0Task);
        Assertions.assertEquals((int)1, (int)this.queue().errorPartitionCount());
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(200L);
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        this.leaderChangeManager().onBecomeLeader(tp0, 1);
        this.leaderChangeManager().process();
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.leaderChangeManager().onBecomeLeader(tp1, 0);
        this.leaderChangeManager().process();
        Assertions.assertEquals((Object)((MockTask)((IterableOps)this.queue().poll().get()).head()).topicIdPartition(), (Object)tp1);
        Assertions.assertEquals((int)1, (int)this.queue().errorPartitionCount());
        this.leaderChangeManager().onBecomeFollower(tp0);
        this.leaderChangeManager().process();
        Assertions.assertEquals((int)0, (int)this.queue().errorPartitionCount());
    }

    @Test
    public void testDelayWithMultipleTasks() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().onBecomeLeader(tp1, 0);
        this.leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        Assertions.assertEquals((int)2, (int)tasks.size());
        MockTask tp0Task = (MockTask)tasks.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ChangeManagerTest.$anonfun$testDelayWithMultipleTasks$1(tp0, x$8))).get();
        MockTask tp1Task = (MockTask)tasks.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ChangeManagerTest.$anonfun$testDelayWithMultipleTasks$2(tp1, x$9))).get();
        tp0Task.retryTaskLater(5000, this.kafka$tier$tasks$ChangeManagerTest$$time().hiResClockMs(), new Throwable());
        this.queue().done((TierTask)tp0Task);
        this.queue().done((TierTask)tp1Task);
        Assertions.assertEquals((Object)new .colon.colon((Object)tp1, (List)Nil$.MODULE$), (Object)((List)this.queue().poll().get()).map((Function1 & Serializable)x$10 -> x$10.topicIdPartition()));
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(200L);
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(4801L);
        Assertions.assertEquals((Object)new .colon.colon((Object)tp0, (List)Nil$.MODULE$), (Object)((List)this.queue().poll().get()).map((Function1 & Serializable)x$11 -> x$11.topicIdPartition()));
        Assertions.assertEquals((int)2, (int)this.queue().taskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.queue().poll());
    }

    @Test
    public void testMaxTasksPoll() {
        int numTasks = 2 * this.kafka$tier$tasks$ChangeManagerTest$$maxTasks();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTasks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TopicIdPartition tp = new TopicIdPartition(new StringBuilder(4).append("foo-").append(i).toString(), UUID.randomUUID(), 0);
            this.leaderChangeManager().onBecomeLeader(tp, 0);
        });
        this.leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        Assertions.assertEquals((int)this.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), (int)tasks.size());
        Assertions.assertEquals((int)this.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), (int)tasks.map((Function1 & Serializable)x$12 -> x$12.topicIdPartition()).size());
        Assertions.assertTrue((boolean)this.queue().poll().isEmpty());
        MockTask doneTask = (MockTask)tasks.head();
        this.queue().done((TierTask)doneTask);
        Assertions.assertEquals((int)1, (int)((SeqOps)this.queue().poll().get()).size());
    }

    @Test
    public void testTopicDeletionStopsTask() {
        TopicIdPartition tp = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.leaderChangeManager().onBecomeLeader(tp, 0);
        this.leaderChangeManager().process();
        MockTask task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        this.leaderChangeManager().onDelete(tp);
        this.leaderChangeManager().process();
        this.queue().done((TierTask)task);
        Assertions.assertTrue((boolean)task.ctx().isCancelled(), (String)"expected task to be canceled");
        Assertions.assertEquals((int)0, (int)this.queue().taskCount(), (String)"expected no tasks to be present");
    }

    @Test
    public void testCancellationRemovesTaskFromQueue() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        this.leaderChangeManager().process();
        MockTask task = (MockTask)((IterableOps)this.queue().poll().get()).head();
        Assertions.assertFalse((boolean)task.ctx().isCancelled(), (String)"expected task not to be canceled");
        this.queue().withAllTasks((Function1 & Serializable)allTasks -> {
            ChangeManagerTest.$anonfun$testCancellationRemovesTaskFromQueue$1(allTasks);
            return BoxedUnit.UNIT;
        });
        task.ctx().cancel();
        this.queue().done((TierTask)task);
        this.queue().withAllTasks((Function1 & Serializable)allTasks -> {
            ChangeManagerTest.$anonfun$testCancellationRemovesTaskFromQueue$2(allTasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTaskDone() {
        int numTasks = this.kafka$tier$tasks$ChangeManagerTest$$maxTasks();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTasks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TopicIdPartition tp = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), i);
            this.leaderChangeManager().onBecomeLeader(tp, 0);
        });
        this.leaderChangeManager().process();
        List polledTasks = (List)this.queue().poll().get();
        Assertions.assertEquals((int)this.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), (int)polledTasks.size());
        this.queue().done((TierTask)polledTasks.apply(0));
        this.queue().done((TierTask)polledTasks.apply(2));
        Assertions.assertEquals((Object)new .colon.colon((Object)((MockTask)polledTasks.apply(0)), (List)new .colon.colon((Object)((MockTask)polledTasks.apply(2)), (List)Nil$.MODULE$)), (Object)this.queue().poll().get());
    }

    @Test
    public void testProcessReturnsOnQueueChange() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        Future future = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> scala.concurrent.package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> this.leaderChangeManager().processAtLeastOne()), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertFalse((boolean)future.isCompleted());
        this.leaderChangeManager().onBecomeLeader(tp0, 0);
        Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.create(200L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)future.isCompleted());
        Assertions.assertTrue((boolean)((Try)future.value().get()).isSuccess());
        Assertions.assertEquals((int)1, (int)this.queue().taskCount());
    }

    @Test
    public void testProcessReturnsOnClose() {
        Future future = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> scala.concurrent.package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> this.leaderChangeManager().processAtLeastOne()), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertFalse((boolean)future.isCompleted());
        this.leaderChangeManager().close();
        Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.create(200L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)future.isCompleted());
        Assertions.assertTrue((boolean)((Try)future.value().get()).isFailure());
        Assertions.assertEquals((int)0, (int)this.queue().taskCount());
    }

    public static final /* synthetic */ boolean $anonfun$testLeadershipChangesCancelTasks$2(TopicIdPartition tp0$1, MockTask x$4) {
        TopicIdPartition topicIdPartition = x$4.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(tp0$1) : tp0$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLeadershipChangesCancelTasks$3(TopicIdPartition tp1$1, MockTask x$5) {
        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(tp1$1) : tp1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLossOfLeadershipRemovesTask$1(TopicIdPartition tp0$2, MockTask x$6) {
        TopicIdPartition topicIdPartition = x$6.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(tp0$2) : tp0$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLossOfLeadershipRemovesTask$2(TopicIdPartition tp1$2, MockTask x$7) {
        TopicIdPartition topicIdPartition = x$7.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(tp1$2) : tp1$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayWithMultipleTasks$1(TopicIdPartition tp0$3, MockTask x$8) {
        TopicIdPartition topicIdPartition = x$8.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(tp0$3) : tp0$3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayWithMultipleTasks$2(TopicIdPartition tp1$3, MockTask x$9) {
        TopicIdPartition topicIdPartition = x$9.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(tp1$3) : tp1$3 != null);
    }

    public static final /* synthetic */ void $anonfun$testCancellationRemovesTaskFromQueue$1(Set allTasks) {
        Assertions.assertTrue((boolean)allTasks.nonEmpty(), (String)"expected there to be at least one task in the queue");
    }

    public static final /* synthetic */ void $anonfun$testCancellationRemovesTaskFromQueue$2(Set allTasks) {
        Assertions.assertTrue((boolean)allTasks.isEmpty(), (String)"expected all tasks to have been removed");
    }

    public ChangeManagerTest() {
        this.kafka$tier$tasks$ChangeManagerTest$$maxTasks = 3;
    }
}

