/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskIntegrationTest$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\rur!\u0002\u001e<\u0011\u0003!e!\u0002$<\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005\"\u0002)\u0002\t\u0003\tf\u0001\u0002$<\u0001)DQA\u0014\u0003\u0005\u0002-D\u0011\"\u001c\u0003A\u0002\u0003\u0007I\u0011\u00018\t\u0013U$\u0001\u0019!a\u0001\n\u00031\b\"\u0003?\u0005\u0001\u0004\u0005\t\u0015)\u0003p\u0011\u001diH\u00011A\u0005\u0004yD\u0011\"!\u0003\u0005\u0001\u0004%\t!a\u0003\t\u000f\u0005=A\u0001)Q\u0005\u007f\"Y\u0011\u0011\u0003\u0003A\u0002\u0003\u0007I\u0011AA\n\u0011-\ti\u0002\u0002a\u0001\u0002\u0004%\t!a\b\t\u0017\u0005\rB\u00011A\u0001B\u0003&\u0011Q\u0003\u0005\n\u0003K!!\u0019!C\u0001\u0003OA\u0001\"!\u000e\u0005A\u0003%\u0011\u0011\u0006\u0005\n\u0003o!\u0001\u0019!C\u0001\u0003sA\u0011\"a\u0012\u0005\u0001\u0004%\t!!\u0013\t\u0011\u00055C\u0001)Q\u0005\u0003wA\u0011\"a\u0014\u0005\u0005\u0004%\t!!\u0015\t\u0011\u0005eC\u0001)A\u0005\u0003'B1\"a\u0017\u0005\u0001\u0004\u0005\r\u0011\"\u0001\u0002^!Y\u00111\u000e\u0003A\u0002\u0003\u0007I\u0011AA7\u0011-\t\t\b\u0002a\u0001\u0002\u0003\u0006K!a\u0018\t\u0017\u0005MD\u00011AA\u0002\u0013\u0005\u0011Q\f\u0005\f\u0003k\"\u0001\u0019!a\u0001\n\u0003\t9\bC\u0006\u0002|\u0011\u0001\r\u0011!Q!\n\u0005}\u0003\"CA?\t\t\u0007I\u0011AA@\u0011!\t\u0019\n\u0002Q\u0001\n\u0005\u0005\u0005\"CAK\t\t\u0007I\u0011AAL\u0011!\t)\u000b\u0002Q\u0001\n\u0005e\u0005\"CAT\t\t\u0007I\u0011AAU\u0011!\t9\f\u0002Q\u0001\n\u0005-\u0006\"CA]\t\t\u0007I\u0011AA^\u0011!\tI\r\u0002Q\u0001\n\u0005u\u0006\"CAf\t\t\u0007I\u0011AAg\u0011!\tY\u000e\u0002Q\u0001\n\u0005=\u0007\"CAo\t\t\u0007I\u0011AAp\u0011!\tY\u000f\u0002Q\u0001\n\u0005\u0005\b\"CAw\t\t\u0007I\u0011AAx\u0011!\t9\u0010\u0002Q\u0001\n\u0005E\b\"CA}\t\t\u0007I\u0011AA~\u0011!\u0011\u0019\u0001\u0002Q\u0001\n\u0005u\b\"\u0003B\u0003\t\t\u0007I\u0011\u0001B\u0004\u0011!\u0011\t\u0003\u0002Q\u0001\n\t%\u0001b\u0002B\u0012\t\u0011\u0005!Q\u0005\u0005\b\u0005k!A\u0011\u0001B\u0013\u0011\u001d\u0011y\u0004\u0002C\u0005\u0005\u0003BqA!\u0016\u0005\t\u0013\u00119F\u0002\u0004\u0003\n\u0012\u0001!1\u0012\u0005\u0007\u001dJ\"\tA!*\t\u000f\t-&\u0007\"\u0011\u0003.\"9!1\u001b\u001a\u0005B\tU\u0007b\u0002Bl\t\u0011\u0005!\u0011\u001c\u0005\b\u0005w$A\u0011\u0001B\u007f\u0011\u001d\u0019i\u0001\u0002C\u0001\u0007\u001fAqaa\b\u0005\t\u0003\u0019\t#\u0001\u000eBe\u000eD\u0017N^3UCN\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002={\u00059\u0011M]2iSZ,'B\u0001 @\u0003\u0015!\u0018m]6t\u0015\t\u0001\u0015)\u0001\u0003uS\u0016\u0014(\"\u0001\"\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q)A\u0007\u0002w\tQ\u0012I]2iSZ,G+Y:l\u0013:$Xm\u001a:bi&|g\u000eV3tiN\u0011\u0011\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0015!K4f]\u0016\u0014\u0018\r^3C_>dW-\u00198D_6\u0014\u0017N\\1uS>t7\u000fN,ji\"|W\u000f^)v_J,X.F\u0001S!\r\u0019&\fX\u0007\u0002)*\u0011QKV\u0001\u0007gR\u0014X-Y7\u000b\u0005]C\u0016\u0001B;uS2T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\)\n11\u000b\u001e:fC6\u0004\"!\u00185\u000e\u0003yS!a\u00181\u0002\u0011A\u0014xN^5eKJT!!\u00192\u0002\rA\f'/Y7t\u0015\t\u0019G-A\u0004kkBLG/\u001a:\u000b\u0005\u00154\u0017!\u00026v]&$(\"A4\u0002\u0007=\u0014x-\u0003\u0002j=\nI\u0011I]4v[\u0016tGo]\n\u0003\t!#\u0012\u0001\u001c\t\u0003\u000b\u0012\t\u0001\"\u001a=fGV$xN]\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!OV\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001;r\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001D3yK\u000e,Ho\u001c:`I\u0015\fHCA<{!\tI\u00050\u0003\u0002z\u0015\n!QK\\5u\u0011\u001dYx!!AA\u0002=\f1\u0001\u001f\u00132\u0003%)\u00070Z2vi>\u0014\b%\u0001\u0002fGV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u0015QBAA\u0002\u0015\t\u0011(*\u0003\u0003\u0002\b\u0005\r!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019)7m\u0018\u0013fcR\u0019q/!\u0004\t\u000fmT\u0011\u0011!a\u0001\u007f\u0006\u0019Qm\u0019\u0011\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>tWCAA\u000b!\u0011\t9\"!\u0007\u000e\u0003}J1!a\u0007@\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\u000bu_BL7-\u00133QCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0004o\u0006\u0005\u0002\u0002C>\u000e\u0003\u0003\u0005\r!!\u0006\u0002#Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF!\u0002\u000f\rdWo\u001d;fe&!\u00111GA\u0017\u0005%\u0001\u0016M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\naaY8oM&<WCAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\u0003\u000611/\u001a:wKJLA!!\u0012\u0002@\tY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0004o\u0006-\u0003\u0002C>\u0013\u0003\u0003\u0005\r!a\u000f\u0002\u000f\r|gNZ5hA\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003'\u0002B!!\u0010\u0002V%!\u0011qKA \u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/A\tce>\\WM\u001d+pa&\u001c7\u000b^1ug\u0002\na\u0001^7q\t&\u0014XCAA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA31\u0006\u0011\u0011n\\\u0005\u0005\u0003S\n\u0019G\u0001\u0003GS2,\u0017A\u0003;na\u0012K'o\u0018\u0013fcR\u0019q/a\u001c\t\u0011m<\u0012\u0011!a\u0001\u0003?\nq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\u000bY><G)\u001b:`I\u0015\fHcA<\u0002z!A1PGA\u0001\u0002\u0004\ty&A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u00115|7m\u001b+j[\u0016,\"!!!\u0011\t\u0005\r\u0015qR\u0007\u0003\u0003\u000bS1aVAD\u0015\u0011\t\t%!#\u000b\u0007\t\u000bYIC\u0002\u0002\u000e\u001a\fa!\u00199bG\",\u0017\u0002BAI\u0003\u000b\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\n\u0011\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ssV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011qT \u0002\u000bM$\u0018\r^3\n\t\u0005\r\u0016Q\u0014\u0002\u001a)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u00180\u0001\u000euS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JL\b%A\tuS\u0016\u0014Hj\\4D_6\u0004xN\\3oiN,\"!a+\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-B\u0003\rawnZ\u0005\u0005\u0003k\u000byKA\tUS\u0016\u0014Hj\\4D_6\u0004xN\\3oiN\f!\u0003^5fe2{wmQ8na>tWM\u001c;tA\u0005\u0011BO]1og&$\u0018n\u001c8XC&$H+[7f+\t\ti\f\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\u0011\t\u0019-a\u0001\u0002\u0011\u0011,(/\u0019;j_:LA!a2\u0002B\nqa)\u001b8ji\u0016$UO]1uS>t\u0017a\u0005;sC:\u001c\u0018\u000e^5p]^\u000b\u0017\u000e\u001e+j[\u0016\u0004\u0013a\u0005;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cXCAAh!\u001d\u0001\u0018\u0011[A\u000b\u0003+L1!a5r\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u00037\u000b9.\u0003\u0003\u0002Z\u0006u%A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\fA\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKN\u0004\u0013a\u0004;jKJ$\u0016m]6t\u0007>tg-[4\u0016\u0005\u0005\u0005\b\u0003BAr\u0003Ol!!!:\u000b\u0007\u0005]R(\u0003\u0003\u0002j\u0006\u0015(a\u0004+jKJ$\u0016m]6t\u0007>tg-[4\u0002!QLWM\u001d+bg.\u001c8i\u001c8gS\u001e\u0004\u0013AD2mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u0003\u0003c\u00042!SAz\u0013\r\t)P\u0013\u0002\u0005\u0019>tw-A\bdY\u0016\fg.\u001e9EK2\f\u00170T:!\u0003E\u0019G.Z1okBLe\u000e^3sm\u0006dWj]\u000b\u0003\u0003{\u00042!SA\u0000\u0013\r\u0011\tA\u0013\u0002\u0004\u0013:$\u0018AE2mK\u0006tW\u000f]%oi\u0016\u0014h/\u00197Ng\u0002\nab\u00195fG.\u001cX/\u001c)be\u0006l7/\u0006\u0002\u0003\nA!!1\u0002B\u000f\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011\u0001C2iK\u000e\\7/^7\u000b\t\tM!QC\u0001\bgR|'/Y4f\u0015\r\u0011%q\u0003\u0006\u0005\u00053\u0011Y\"A\u0005d_:4G.^3oi*\u0011\u0011QM\u0005\u0005\u0005?\u0011iA\u0001\bDQ\u0016\u001c7n];n!\u0006\u0014\u0018-\\:\u0002\u001f\rDWmY6tk6\u0004\u0016M]1ng\u0002\nQa]3ukB$\u0012a\u001e\u0015\u0004]\t%\u0002\u0003\u0002B\u0016\u0005ci!A!\f\u000b\u0007\t=\"-A\u0002ba&LAAa\r\u0003.\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D3a\fB\u001d!\u0011\u0011YCa\u000f\n\t\tu\"Q\u0006\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004\\8h!J|g/\u001b3j]\u001e\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$bAa\u0011\u0003J\t-\u0003\u0003BA\u001f\u0005\u000bJAAa\u0012\u0002@\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bbBA\ta\u0001\u0007\u0011Q\u0003\u0005\b\u0005\u001b\u0002\u0004\u0019\u0001B(\u0003-\t'm\u001d;sC\u000e$Hj\\4\u0011\t\u00055&\u0011K\u0005\u0005\u0005'\nyKA\u0006BEN$(/Y2u\u0019><\u0017\u0001G2sK\u0006$X\rV5feB\u000b'\u000f^5uS>t7\u000b^1uKR\u0001\u0012Q\u001bB-\u00057\u0012yG!\u001f\u0003~\t\u0005%Q\u0011\u0005\b\u0003#\t\u0004\u0019AA\u000b\u0011\u001d\u0011i&\ra\u0001\u0005?\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003\u0002B1\u0005Wj!Aa\u0019\u000b\t\u0005E&Q\r\u0006\u0005\u0005O\u0012I'A\u0005j]R,'O\\1mg*!!1CAE\u0013\u0011\u0011iGa\u0019\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0011\u001d\u0011\t(\ra\u0001\u0005g\nqb\u00195fG.\u001cX/\\#oC\ndW\r\u001a\t\u0004\u0013\nU\u0014b\u0001B<\u0015\n9!i\\8mK\u0006t\u0007b\u0002B>c\u0001\u0007!1O\u0001\u000fG>l\u0007/Y2u\u000b:\f'\r\\3e\u0011\u001d\u0011y(\ra\u0001\u0005g\nab\u00197fC:,\b/\u00128bE2,G\rC\u0004\u0003\u0004F\u0002\rAa\u001d\u0002CQLWM\u001d)beRLG/[8o'R\fG/Z*oCB\u001c\bn\u001c;F]\u0006\u0014G.\u001a3\t\u000f\t\u001d\u0015\u00071\u0001\u0002~\u0006A!M]8lKJLEM\u0001\u000bN_\u000e\\G+[3s)>\u0004\u0018nY'b]\u0006<WM]\n\u0006e\t5%\u0011\u0014\t\u0005\u0005\u001f\u0013)*\u0004\u0002\u0003\u0012*\u0019!1\u0013-\u0002\t1\fgnZ\u0005\u0005\u0005/\u0013\tJ\u0001\u0004PE*,7\r\u001e\t\u0005\u00057\u0013\t+\u0004\u0002\u0003\u001e*\u0019!qT \u0002\u000bQ|\u0007/[2\n\t\t\r&Q\u0014\u0002\u0012)&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014HC\u0001BT!\r\u0011IKM\u0007\u0002\t\u0005Y\u0011\r\u001a3NKR\fG-\u0019;b)\u0011\u0011yKa1\u0011\u000bA\u0014\tL!.\n\u0007\tM\u0016OA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004BAa.\u0003>:!\u00111\u0014B]\u0013\u0011\u0011Y,!(\u0002%QKWM\u001d)beRLG/[8o'R\fG/Z\u0005\u0005\u0005\u007f\u0013\tM\u0001\u0007BaB,g\u000e\u001a*fgVdGO\u0003\u0003\u0003<\u0006u\u0005b\u0002Bci\u0001\u0007!qY\u0001\u0006K:$(/\u001f\t\u0005\u0005\u0013\u0014y-\u0004\u0002\u0003L*\u0019!QZ \u0002\r\u0011|W.Y5o\u0013\u0011\u0011\tNa3\u0003)\u0005\u00137\u000f\u001e:bGR$\u0016.\u001a:NKR\fG-\u0019;b\u0003AI7OU3bIf4uN],sSR,7\u000f\u0006\u0002\u0003t\u00059B/Z:u\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8.R7qifdun\u001a\u000b\no\nm'Q\u001cBp\u0005CDqA!\u001d7\u0001\u0004\u0011\u0019\bC\u0004\u0003|Y\u0002\rAa\u001d\t\u000f\t}d\u00071\u0001\u0003t!9!1\u0011\u001cA\u0002\tM\u0004f\u0001\u001c\u0003fB!!q\u001dBu\u001b\u0005\u0001\u0017b\u0001BvA\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000fY\u0012yO!>\u0003xB\u0019QL!=\n\u0007\tMhL\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0003z\u0006\n\u0001+A\u0012uKN$\u0018I]2iSZ,G+Y:l+Bdw.\u00193t!J|G-^2feN#\u0018\r^3\u0015\u0013]\u0014yp!\u0001\u0004\u0004\r\u0015\u0001b\u0002B9o\u0001\u0007!1\u000f\u0005\b\u0005w:\u0004\u0019\u0001B:\u0011\u001d\u0011yh\u000ea\u0001\u0005gBqAa!8\u0001\u0004\u0011\u0019\bK\u00028\u0005KDsa\u000eBx\u0005k\u001cY\u0001\f\u0002\u0003z\u0006aC/Z:u\u0003J\u001c\u0007.\u001b<feJ+GO]5fg>s7i\u001c8dkJ\u0014XM\u001c;EK2,G/\u001a*fG>\u0014Hm\u001d\u000b\no\u000eE11CB\u000b\u0007/AqA!\u001d9\u0001\u0004\u0011\u0019\bC\u0004\u0003|a\u0002\rAa\u001d\t\u000f\t}\u0004\b1\u0001\u0003t!9!1\u0011\u001dA\u0002\tM\u0004f\u0001\u001d\u0003f\":\u0001Ha<\u0003v\u000euAF\u0001B}\u0003!\"Xm\u001d;Be\u000eD\u0017N^3s\u000bb\u001cW\r\u001d;j_:|e\u000eU1si&$\u0018n\u001c8EK2,G/[8o)%981EB\u0013\u0007O\u0019I\u0003C\u0004\u0003re\u0002\rAa\u001d\t\u000f\tm\u0014\b1\u0001\u0003t!9!qP\u001dA\u0002\tM\u0004b\u0002BBs\u0001\u0007!1\u000f\u0015\u0004s\t\u0015\bfB\u001d\u0003p\nU8q\u0006\u0017\u0003\u0005sDs\u0001BB\u001a\u0005k\u001cI\u0004\u0005\u0003\u0003,\rU\u0012\u0002BB\u001c\u0005[\u00111\u0001V1hC\t\u0019Y$A\u0006j]R,wM]1uS>t\u0007")
public class ArchiveTaskIntegrationTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private TopicIdPartition topicIdPartition;
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private File tmpDir;
    private File logDir;
    private final MockTime mockTime = new MockTime();
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, this.tierPartitionStateFactory(), (Option)None$.MODULE$);
    private final FiniteDuration transitionWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private final ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates = new ConcurrentHashMap();
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, 1, 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final ChecksumParams checksumParams = TestUtils$.MODULE$.createChecksumParams();

    public static Stream<Arguments> generateBooleanCombinations4WithoutQuorum() {
        return ArchiveTaskIntegrationTest$.MODULE$.generateBooleanCombinations4WithoutQuorum();
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public FiniteDuration transitionWaitTime() {
        return this.transitionWaitTime;
    }

    public ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setup() {
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka"));
        this.executor_$eq(Executors.newFixedThreadPool(1));
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        File parseTopicPartitionName_dir = this.logDir();
        Object var24_23 = null;
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.topicIdPartition_$eq(new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.executor().shutdownNow();
        this.brokerTopicStats().close();
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.tierPartitionStates().values()).asScala().foreach((Function1 & Serializable)tierPartitionState -> {
            ArchiveTaskIntegrationTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        this.tierPartitionStates().clear();
        Utils.delete((File)this.tmpDir(), (boolean)false);
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    private ReplicaManager logProvidingReplicaManager(TopicIdPartition topicIdPartition, AbstractLog abstractLog) {
        return (ReplicaManager)Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)abstractLog)).getMock();
    }

    private TierPartitionState createTierPartitionState(TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled, int brokerId) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(TestUtils.tempDirectory(null, null), logDirFailureChannel, topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler, checksumEnabled, compactEnabled, (Time)this.mockTime(), new TierPartitionStateCleanupConfig(cleanupEnabled, this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), tierPartitionStateSnapshotEnabled, brokerId);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates().put(topicIdPartition, (TierPartitionState)tierPartitionState);
        return tierPartitionState;
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiveTaskEmptyLog(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(brokerId)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        long x$3 = 604800000L;
        long x$4 = 604800000L;
        long x$5 = -2L;
        long x$6 = -1L;
        long x$7 = -2L;
        long x$8 = 0L;
        String x$9 = "delete";
        int x$10 = 0x10000C;
        int x$11 = 4096;
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, 0x500000, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        File x$23 = this.logDir();
        BrokerTopicStats x$25 = this.brokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        TierLogComponents x$28 = this.tierLogComponents();
        ChecksumParams x$30 = this.checksumParams();
        long x$31 = 0L;
        long x$32 = 0L;
        int x$33 = 300000;
        ProducerStateManagerConfig x$34 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$35 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$23, logConfig, x$25, (Scheduler)x$26, (Time)x$27, x$31, x$32, x$33, x$34, x$35, x$28, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$30);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        ArchiveTask nextState = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertTrue((boolean)(nextState.state() instanceof BeforeUpload), (String)"expected to be in BeforeUpload");
        Assertions.assertFalse((boolean)nextState.ctx().isCancelled(), (String)"expected task to not be cancelled");
        Assertions.assertEquals((Integer)tierObjectStore.getObjectCounts().getOrDefault(ObjectType.SEGMENT, Predef$.MODULE$.int2Integer(0)), (int)0, (String)"expected zero segments to be uploaded");
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiveTaskUploadsProducerState(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$52 = -1L;
        long x$62 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        String x$12 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$13 = 60000L;
        boolean x$14 = false;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 1024, x$3, x$4, x$52, x$62, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        File x$23 = this.logDir();
        BrokerTopicStats x$25 = this.brokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        TierLogComponents x$28 = this.tierLogComponents();
        ChecksumParams x$30 = this.checksumParams();
        long x$31 = 0L;
        long x$32 = 0L;
        int x$33 = 300000;
        ProducerStateManagerConfig x$34 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$35 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$23, logConfig, x$25, (Scheduler)x$26, (Time)x$27, x$31, x$32, x$33, x$34, x$35, x$28, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$30);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        long pid1 = 1L;
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            .colon.colon x$41 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            byte x$45 = 2;
            CompressionType x$46 = CompressionType.NONE;
            long x$47 = 0L;
            int x$48 = -1;
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$41, x$45, x$46, pid1, (short)0, i, x$47, x$48), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            lastOffset$1.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size(), (String)"expected 5 local log segments");
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size(), (String)"expected 4 tierable segments");
        List snapshotFiles = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()))).toList().flatMap((Function1 & Serializable)x$6 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(log.producerStateManager().snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)x$6)))));
        Assertions.assertEquals((int)4, (int)snapshotFiles.size(), (String)"expected to be able to use segment base offset to get snapshot files for 4 segments");
        ArchiveTask maybeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload.state().getClass(), (String)"expected successful transition to Upload");
        ArchiveTask maybeAfterUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(AfterUpload.class, maybeAfterUpload.state().getClass(), (String)"expected successful transition to afterUpload");
        ConcurrentHashMap objectCounts = tierObjectStore.getObjectCounts();
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(ObjectType.SEGMENT)), (String)"expected 1 segment file");
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(ObjectType.PRODUCER_STATE)), (String)"expected 1 producer state");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)maybeAfterUpload.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime())).state() instanceof BeforeUpload), (String)"expected successful transition to beforeUpload");
        Assertions.assertEquals((int)tierPartitionState.numSegments(), (int)1, (String)"expected 1 segment to be materialized");
        Assertions.assertTrue((boolean)((TierLogSegment)tierPartitionState.metadata(0L).get()).metadata().hasProducerState(), (String)"expected hasProducerState metadata flag to be set");
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiverRetriesOnConcurrentDeleteRecords(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(brokerId)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        String x$12 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$13 = 60000L;
        boolean x$14 = false;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 1024, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$23 = this.logDir();
        BrokerTopicStats x$25 = this.brokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        TierLogComponents x$28 = this.tierLogComponents();
        ChecksumParams x$30 = this.checksumParams();
        long x$31 = 0L;
        long x$32 = 0L;
        int x$33 = 300000;
        ProducerStateManagerConfig x$34 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$35 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$23, logConfig, x$25, (Scheduler)x$26, (Time)x$27, x$31, x$32, x$33, x$34, x$35, x$28, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$30);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            .colon.colon x$41 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            byte x$45 = 2;
            CompressionType x$46 = CompressionType.NONE;
            long x$47 = 0L;
            int x$48 = -1;
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$41, x$45, x$46, pid1, (short)0, i, x$47, x$48), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            lastOffset$2.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        ArchiveTask maybeUpload_1 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        File segmentFileBeingUploaded = ((Upload)maybeUpload_1.state()).uploadableSegment().logSegmentFile();
        Assertions.assertEquals(Upload.class, maybeUpload_1.state().getClass());
        Assertions.assertEquals((Object)segmentFileBeingUploaded, (Object)((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().head()).log().file());
        LogSegment newFirstSegment = (LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().toList().apply(3);
        File newFirstSegmentFile = newFirstSegment.log().file();
        log.maybeIncrementLogStartOffset(newFirstSegment.baseOffset() + 3L, LogStartOffsetIncrementReason.SegmentDeletion);
        log.deleteOldSegments();
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        ArchiveTask maybeUpload_2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload_2.state().getClass());
        Assertions.assertEquals((Object)newFirstSegmentFile, (Object)((Upload)maybeUpload_2.state()).uploadableSegment().logSegmentFile());
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiverExceptionOnPartitionDeletion(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(brokerId)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        String x$12 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$13 = 60000L;
        boolean x$14 = false;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 1024, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$23 = this.logDir();
        BrokerTopicStats x$25 = this.brokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        TierLogComponents x$28 = this.tierLogComponents();
        ChecksumParams x$30 = this.checksumParams();
        long x$31 = 0L;
        long x$32 = 0L;
        int x$33 = 300000;
        ProducerStateManagerConfig x$34 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$35 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$23, logConfig, x$25, (Scheduler)x$26, (Time)x$27, x$31, x$32, x$33, x$34, x$35, x$28, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$30);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            .colon.colon x$41 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            byte x$45 = 2;
            CompressionType x$46 = CompressionType.NONE;
            long x$47 = 0L;
            int x$48 = -1;
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$41, x$45, x$46, pid1, (short)0, i, x$47, x$48), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            lastOffset$3.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        TopicPartition logDeleteDirName_topicPartition = this.topicIdPartition().topicPartition();
        Object var71_55 = null;
        log.renameDir(LocalLog$.MODULE$.logDeleteDirName(logDeleteDirName_topicPartition), true);
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        Predef$.MODULE$.assert(ctx.isCancelled());
        tierPartitionState.delete();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(TierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public ArchiveTaskIntegrationTest() {
        this.cleanupIntervalMs = 0;
    }

    public class MockTierTopicManager
    implements TierTopicAppender {
        public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
            TierPartitionState tierPartitionState = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().topicIdPartition());
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState.append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch())))).toCompletableFuture();
        }

        public boolean isReadyForWrites() {
            return true;
        }

        public /* synthetic */ ArchiveTaskIntegrationTest kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer() {
            return ArchiveTaskIntegrationTest.this;
        }

        public MockTierTopicManager() {
            if (ArchiveTaskIntegrationTest.this == null) {
                throw null;
            }
        }
    }
}

