/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tUh\u0001B A\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019)\u0007\u0001)A\u0005;\"9a\r\u0001a\u0001\n\u00039\u0007b\u00028\u0001\u0001\u0004%\ta\u001c\u0005\u0007k\u0002\u0001\u000b\u0015\u00025\t\u000fY\u0004\u0001\u0019!C\u0001o\"9a\u0010\u0001a\u0001\n\u0003y\bbBA\u0002\u0001\u0001\u0006K\u0001\u001f\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0001\u0003\u000fA\u0011\"!\u0006\u0001\u0001\u0004%\t!a\u0006\t\u0011\u0005m\u0001\u0001)Q\u0005\u0003\u0013A\u0011\"!\b\u0001\u0001\u0004%\t!a\b\t\u0013\u00055\u0002\u00011A\u0005\u0002\u0005=\u0002\u0002CA\u001a\u0001\u0001\u0006K!!\t\t\u0013\u0005U\u0002\u00011A\u0005\u0002\u0005]\u0002\"CA#\u0001\u0001\u0007I\u0011AA$\u0011!\tY\u0005\u0001Q!\n\u0005e\u0002\"CA'\u0001\u0001\u0007I\u0011AA(\u0011%\tY\u0007\u0001a\u0001\n\u0003\ti\u0007\u0003\u0005\u0002r\u0001\u0001\u000b\u0015BA)\u0011%\t\u0019\b\u0001a\u0001\n\u0003\t)\bC\u0005\u0002\b\u0002\u0001\r\u0011\"\u0001\u0002\n\"A\u0011Q\u0012\u0001!B\u0013\t9\bC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0001\u0002\u0012\"A\u0011\u0011\u0014\u0001!\u0002\u0013\t\u0019\nC\u0005\u0002\u001c\u0002\u0011\r\u0011\"\u0001\u0002\u001e\"A\u00111\u0016\u0001!\u0002\u0013\ty\nC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u00020\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005=\u0006bBAn\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003?\u0004A\u0011AAX\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003_Cq!a:\u0001\t\u0003\ty\u000bC\u0004\u0002l\u0002!\t!a,\t\u000f\u0005=\b\u0001\"\u0001\u00020\"9\u00111\u001f\u0001\u0005\u0002\u0005=\u0006bBA|\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003w\u0004A\u0011AAX\u0011\u001d\ty\u0010\u0001C\u0001\u0003_CqAa\u0001\u0001\t\u0003\ty\u000bC\u0004\u0003\b\u0001!\t!a,\t\u000f\t-\u0001\u0001\"\u0001\u00020\"9!q\u0002\u0001\u0005\u0002\u0005=\u0006b\u0002B\n\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0005/\u0001A\u0011AAX\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003_CqAa\b\u0001\t\u0003\ty\u000bC\u0004\u0003$\u0001!\t!a,\t\u000f\t\u001d\u0002\u0001\"\u0001\u00020\"9!1\u0006\u0001\u0005\u0002\u0005=\u0006b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005[BqA!\u001e\u0001\t\u0013\u00119\bC\u0004\u0003\u0010\u0002!IA!%\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\"9!Q\u0017\u0001\u0005\n\t]\u0006\"\u0003Bo\u0001E\u0005I\u0011\u0002Bp\u0005=\t%o\u00195jm\u0016$\u0016m]6UKN$(BA!C\u0003\u001d\t'o\u00195jm\u0016T!a\u0011#\u0002\u000bQ\f7o[:\u000b\u0005\u00153\u0015\u0001\u0002;jKJT\u0011aR\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\n\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0003\"a\u0015\u0001\u000e\u0003\u0001\u000b\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003Y\u0003\"a\u0016-\u000e\u0003\u0011K!!\u0017#\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005\u0001B-\u001a4bk2$\u0018i^1jiRKW.Z\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\tIV\u0014\u0018\r^5p]*\u0011!\rT\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00013`\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0011\u0003Z3gCVdG/Q<bSR$\u0016.\\3!\u0003\r\u0019G\u000f_\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eR\u0001\bM\u0016$8\r[3s\u0013\ti'NA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/A\u0004dib|F%Z9\u0015\u0005A\u001c\bCA&r\u0013\t\u0011HJ\u0001\u0003V]&$\bb\u0002;\b\u0003\u0003\u0005\r\u0001[\u0001\u0004q\u0012\n\u0014\u0001B2uq\u0002\n\u0001\u0003^5feR{\u0007/[2NC:\fw-\u001a:\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a\u001f#\u0002\u000bQ|\u0007/[2\n\u0005uT(\u0001\u0005+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0003Q!\u0018.\u001a:U_BL7-T1oC\u001e,'o\u0018\u0013fcR\u0019\u0001/!\u0001\t\u000fQT\u0011\u0011!a\u0001q\u0006\tB/[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u0011\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016,\"!!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004E\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\t\u0019\"!\u0004\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5fe>\u0013'.Z2u'R|'/Z0%KF$2\u0001]A\r\u0011!!X\"!AA\u0002\u0005%\u0011\u0001\u0005;jKJ|%M[3diN#xN]3!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\nG\u0003\u0019\u0019XM\u001d<fe&!\u00111FA\u0013\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0019\u0001/!\r\t\u0011Q\u0004\u0012\u0011!a\u0001\u0003C\tqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\"!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010G\u0003\u001d\u0019G.^:uKJLA!a\u0011\u0002>\tI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u0007A\fI\u0005\u0003\u0005u'\u0005\u0005\t\u0019AA\u001d\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u0005i&lW-\u0006\u0002\u0002RA!\u00111KA4\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013!B;uS2\u001c(\u0002BA.\u0003;\naaY8n[>t'bA$\u0002`)!\u0011\u0011MA2\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QM\u0001\u0004_J<\u0017\u0002BA5\u0003+\u0012A\u0001V5nK\u0006AA/[7f?\u0012*\u0017\u000fF\u0002q\u0003_B\u0001\u0002\u001e\f\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0006i&lW\rI\u0001\bi6\u0004h)\u001b7f+\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0005%|'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00151\u0010\u0002\u0005\r&dW-A\u0006u[B4\u0015\u000e\\3`I\u0015\fHc\u00019\u0002\f\"AA/GA\u0001\u0002\u0004\t9(\u0001\u0005u[B4\u0015\u000e\\3!\u0003!\u0011'o\\6fe&#WCAAJ!\rY\u0015QS\u0005\u0004\u0003/c%aA%oi\u0006I!M]8lKJLE\rI\u0001\u0010i&,'\u000fV1tWN\u001cuN\u001c4jOV\u0011\u0011q\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*\u0019\u0011Q\u0015\"\u0002\r\r|gNZ5h\u0013\u0011\tI+a)\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001e\f\u0001\u0003^5feR\u000b7o[:D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0003AD3aHAZ!\u0011\t),a1\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b1!\u00199j\u0015\u0011\ti,a0\u0002\u000f),\b/\u001b;fe*!\u0011\u0011YA2\u0003\u0015QWO\\5u\u0013\u0011\t)-a.\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0001\u00131\u001a\t\u0005\u0003k\u000bi-\u0003\u0003\u0002P\u0006]&!C!gi\u0016\u0014X)Y2i\u0003i!Xm\u001d;FgR\f'\r\\5tQ&tw\rT3bI\u0016\u00148\u000f[5qQ\r\t\u0013Q\u001b\t\u0005\u0003k\u000b9.\u0003\u0003\u0002Z\u0006]&\u0001\u0002+fgR\f1\u0004^3tiRKWM]*fO6,g\u000e^%om\u0006d\u0017\u000eZ#q_\u000eD\u0007f\u0001\u0012\u0002V\u0006aB/Z:u\u001b\u0016$\u0018\rZ1uCNK'0\u001a#ve&tw-\u00169m_\u0006$\u0007fA\u0012\u0002V\u0006\u0019B/Z:u%\u0016$(/\u001f)viN+w-\\3oi\"\u001aA%!6\u00027Q,7\u000f^'fi\u0006$\u0017\r^1TSj,\u0017I\u001a;feV\u0003Hn\\1eQ\r)\u0013Q[\u0001\"i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8EkJLgnZ%oSRL\u0017\r^3Va2|\u0017\r\u001a\u0015\u0004M\u0005U\u0017!\r;fgR\u001cuN\u001d:vaR,G\r\u0016:b]N\f7\r^5p]&sG-\u001a=EkJLgnZ%oSRL\u0017\r^3Va2|\u0017\r\u001a\u0015\u0004O\u0005U\u0017a\u000e;fgR,\u0005pY3qi&|g\u000eR;sS:<\u0017J\\5uS\u0006$X-\u00169m_\u0006$w\u000b[3o!\u0006\u0014H/\u001b;j_:L5/\u00168dY\u0016\fg\u000eK\u0002)\u0003+\fA\u0007^3ti\u0016C8-\u001a9uS>tG)\u001e:j]\u001eLe.\u001b;jCR,W\u000b\u001d7pC\u0012<\u0006.\u001a8US\u0016\u0014\u0018N\\4ESN\f'\r\\3eQ\rI\u0013Q[\u0001\u001fi\u0016\u001cHoU3h[\u0016tG\u000fR3mKR,G\rR;sS:<W\u000b\u001d7pC\u0012D3AKAk\u0003\u0011\"Xm\u001d;Be\u000eD\u0017N^3UCN\\7)\u00198dK2dW\r\u001a\"fM>\u0014X-\u00169m_\u0006$\u0007fA\u0016\u0002V\u0006\u0001C/Z:u+:\\gn\\<o\u000bb\u001cW\r\u001d;j_:$UO]5oOV\u0003Hn\\1eQ\ra\u0013Q[\u0001\u001ai\u0016\u001cH\u000fV5feN+w-\\3oi:{7+Z4nK:$8\u000fK\u0002.\u0003+\fa\u0005^3tiRKWM]*fO6,g\u000e^,ji\"|W\u000f\u001e'fC\u0012,'/\u00129pG\"\u001cF/\u0019;fQ\rq\u0013Q[\u0001$i\u0016\u001cH\u000fV5feN+w-\\3oi^KG\u000f\u001b'fC\u0012,'/\u00129pG\"\u001cF/\u0019;fQ\ry\u0013Q[\u0001!i\u0016\u001cH/\u0011:dQ&4XM\u001d+bg.\u001cV\r^:QCV\u001cXm\u00148SKR\u0014\u0018\u0010K\u00021\u0003+\fq\u0005^3ti\u000e\u000bgnY3mY\u0016$\u0017I]2iSZ,G+Y:l\t>,7OT8u!J|wM]3tg\"\u001a\u0011'!6\u0002CQ,7\u000f\u001e%b]\u0012dWmU3h[\u0016tG\u000fR3mKR,G-\u0012=dKB$\u0018n\u001c8)\u0007I\n).\u0001\u001cuKN$\b*\u00198eY&twMR8s'\u0016<W.\u001a8u\t\u0016dW\r^3e\u000bb\u001cW\r\u001d;j_:$UO]5oOR\u0013\u0018M\\:ji&|g\u000eK\u00024\u0003+\f\u0001\u0006^3tiJ+GO]5bE2,W\t_2faRLwN\u001c$fi\u000eD\u0017N\\4Pa\u0006\fX/\u001a#bi\u0006D3\u0001NAk\u0003-\"Xm\u001d;Fe\u0015\u001b\u0005.Z2lgVl\u0017J\u001c<bY&$W\t_2faRLwN\u001c#ve&tw-\u00169m_\u0006$\u0007fA\u001b\u0002V\u00069C/Z:u\u0011\u0006tG\r\\5oO\u0016\u0013Ti\u00115fG.\u001cX/\\%om\u0006d\u0017\u000eZ#yG\u0016\u0004H/[8oQ\r1\u0014Q[\u0001$i\u0016\u001cH/\u00138ji&\fG/Z+qY>\fGmV5uQVs7\r\\3b]2+\u0017\rZ3s)\u0011\u0011\u0019D!\u0011\u0011\r\tU\"q\u0007B\u001e\u001b\u0005\t\u0017b\u0001B\u001dC\n1a)\u001e;ve\u0016\u00042a\u0015B\u001f\u0013\r\u0011y\u0004\u0011\u0002\u0011\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8n\u0015;bi\u0016DqAa\u00118\u0001\u0004\u0011)%A\u0007v]\u000edW-\u00198MK\u0006$WM\u001d\t\u0004\u0017\n\u001d\u0013b\u0001B%\u0019\n9!i\\8mK\u0006t\u0017!\u000b;fgR,\u0005pY3qi&|g\u000eS1oI2Lgn\u001a#ve&tw-\u00138ji&\fG/Z+qY>\fG\r\u0006\u0003\u00034\t=\u0003b\u0002B)q\u0001\u0007!1K\u0001\u0002KB!!Q\u000bB3\u001d\u0011\u00119F!\u0019\u000f\t\te#qL\u0007\u0003\u00057R1A!\u0018I\u0003\u0019a$o\\8u}%\tQ*C\u0002\u0003d1\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003h\t%$!C#yG\u0016\u0004H/[8o\u0015\r\u0011\u0019\u0007T\u0001\"i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8IC:$G.\u001b8h\tV\u0014\u0018N\\4Va2|\u0017\r\u001a\u000b\u0007\u0005g\u0011yG!\u001d\t\u000f\tE\u0013\b1\u0001\u0003T!9!1O\u001dA\u0002\t\u0015\u0013!\u00043fY\u0016$XmU3h[\u0016tG/\u0001\bn_\u000e\\Gj\\4TK\u001elWM\u001c;\u0015\t\te$Q\u0012\t\u0005\u0005w\u0012I)\u0004\u0002\u0003~)!!q\u0010BA\u0003\rawn\u001a\u0006\u0005\u0005\u0007\u0013))A\u0005j]R,'O\\1mg*!!qQA/\u0003\u001d\u0019Ho\u001c:bO\u0016LAAa#\u0003~\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005M$\b1\u0001\u0002x\u00051Rn\\2l)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0003\u0014\n}\u0005\u0003\u0002BK\u00057k!Aa&\u000b\u0007\teE)A\u0003ti\u0006$X-\u0003\u0003\u0003\u001e\n]%A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016DqA!)<\u0001\u0004\t\u0019*A\u0006mK\u0006$WM]#q_\u000eD\u0017aD7pG.\f%m\u001d;sC\u000e$Hj\\4\u0015\t\t\u001d&\u0011\u0017\t\u0005\u0005S\u0013i+\u0004\u0002\u0003,*\u0019!q\u0010$\n\t\t=&1\u0016\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u00034r\u0002\rA!\u001f\u0002\u00151|wmU3h[\u0016tG/A\u0006uS\u0016\u00148+Z4nK:$H\u0003\u0003B]\u0005\u000b\u00149M!3\u0011\t\tm&\u0011Y\u0007\u0003\u0005{S1Aa0E\u0003\u0019!w.\\1j]&!!1\u0019B_\u0005I!\u0016.\u001a:PE*,7\r^'fi\u0006$\u0017\r^1\t\u000f\t}T\b1\u0001\u0003(\"9!\u0011U\u001fA\u0002\u0005M\u0005\"\u0003Bf{A\u0005\t\u0019\u0001Bg\u00031!\bN]8ui2,'o\u00149u!\u0015Y%q\u001aBj\u0013\r\u0011\t\u000e\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tU'\u0011\\\u0007\u0003\u0005/T1!a\u0016G\u0013\u0011\u0011YNa6\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018!\u0006;jKJ\u001cVmZ7f]R$C-\u001a4bk2$HeM\u000b\u0003\u0005CTCA!4\u0003d.\u0012!Q\u001d\t\u0005\u0005O\u0014\t0\u0004\u0002\u0003j*!!1\u001eBw\u0003%)hn\u00195fG.,GMC\u0002\u0003p2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019P!;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ArchiveTaskTest {
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("cbf4eaed-cc00-47dc-b08c-f1f5685f085d"), 0);
    private final FiniteDuration defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
    private CancellationContext ctx = CancellationContext.newContext();
    private TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private Partition partition = (Partition)Mockito.mock(Partition.class);
    private Time time = new MockTime();
    private File tmpFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final int brokerId;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, this.brokerId(), 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(TierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    public void tmpFile_$eq(File x$1) {
        this.tmpFile = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    @BeforeEach
    public void setup() {
        this.tmpFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @AfterEach
    public void tearDown() {
        this.tmpFile().delete();
        this.ctx().cancel();
        Mockito.reset((Object[])new Object[]{this.tierTopicManager(), this.tierObjectStore(), this.replicaManager()});
    }

    @Test
    public void testEstablishingLeadership() {
        int leaderEpoch = 0;
        ArgumentCaptor metadataCaptor = ArgumentCaptor.forClass(TierTopicInitLeader.class);
        org.apache.kafka.raft.OffsetAndEpoch topicCreationOffsetAndEpoch = new org.apache.kafka.raft.OffsetAndEpoch(100L, 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        BeforeUpload nextState = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)nextState, (String)"Expected task to establish leadership");
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager())).addMetadata((AbstractTierMetadata)metadataCaptor.capture());
        Assertions.assertEquals(Optional.empty(), (Object)((TierTopicInitLeader)metadataCaptor.getValue()).partitionCreationOffsetAndEpoch());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)new Some((Object)topicCreationOffsetAndEpoch));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        BeforeUpload validOffsetResult = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)validOffsetResult, (String)"Expected task to establish leadership");
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.atLeast((int)1))).addMetadata((AbstractTierMetadata)metadataCaptor.capture());
        Assertions.assertEquals(Optional.of(topicCreationOffsetAndEpoch), (Object)((TierTopicInitLeader)metadataCaptor.getValue()).partitionCreationOffsetAndEpoch());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.NOT_TIERABLE));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed(new Object()));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
    }

    @Test
    public void testTierSegmentInvalidEpoch() {
        int leaderEpoch = 0;
        TierPartitionState tps = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch + 1))).getMock();
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tps);
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)nextState, (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected segment tiering to fail due to fencing");
    }

    @Test
    public void testMetadataSizeDuringUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), OpaqueData.fromByteArray((byte[])"test".getBytes()));
        int epochStateSize = 100;
        long producerStateSize = 2000000000L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = (File)Mockito.mock(File.class);
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)producerState.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)producerState.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)producerStateSize));
        ((TierObjectStore)Mockito.doNothing().when((Object)this.tierObjectStore())).putSegment((ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
    }

    @Test
    public void testRetryPutSegment() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), OpaqueData.ZEROED);
        MockInMemoryTierObjectStore inMemoryTierObjectStore = new MockInMemoryTierObjectStore(this.time(), new MockInMemoryTierObjectStoreConfig());
        int epochStateSize = 100;
        long producerStateSize = 0L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = this.tmpFile();
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
        Assertions.assertEquals((int)abortedTxnsPos, (int)abortedTxns.position());
        Assertions.assertEquals((int)0, (int)epochState.position());
        UploadableSegment uploadableSegment2 = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload2 = new Upload(leaderEpoch, uploadInitiate, uploadableSegment2);
        Future uploadResult2 = ArchiveTask$.MODULE$.upload(upload2, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload2 = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult2, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload2.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value after second retried upload");
    }

    @Test
    public void testMetadataSizeAfterUpload() {
        int testUploadSize = 400;
        String metricName = "BytesPerSec";
        new KafkaMetricsGroup(this.getClass()).removeMetric(metricName);
        Meter byteRate = new KafkaMetricsGroup(this.getClass()).newMeter(metricName, "bytes per second", TimeUnit.SECONDS);
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), OpaqueData.fromByteArray((byte[])"test".getBytes()));
        AfterUpload afterUpload = new AfterUpload(0, uploadInitiate, (long)testUploadSize);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)new Some((Object)byteRate), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)testUploadSize, (long)byteRate.count(), (String)"tier archiver mean rate shows no data uploaded to tiered storage");
    }

    @Test
    public void testExceptionDuringInitiateUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringInitiateUpload(new IllegalStateException("illegal state"));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
    }

    @Test
    public void testCorruptedTransactionIndexDuringInitiateUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringInitiateUpload((Exception)new CorruptIndexException("TransactionIndex is corrupted"));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(E2EChecksumInvalidException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenPartitionIsUnclean() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(true), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(66).append("Unexpected transition to next state ").append(state.toString()).append(" when partition needs recovery").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("is undergoing unclean leader recovery"), (String)"Unexpected cause for exception");
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(false), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_2).value();
            Assertions.assertEquals(Upload.class, state.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_2 instanceof Failure) {
            Throwable ex2 = ((Failure)try_2).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex2).toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }
        throw new MatchError((Object)try_2);
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenTieringDisabled() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn(Optional.empty());
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future maybeInitUploadState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)maybeInitUploadState, (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(72).append("Unexpected transition to next state ").append(state.toString()).append(" when partition has tiering disabled").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Assertions.assertEquals(NotTierablePartitionException.class, ex.getClass(), (String)"Unexpected exception");
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Test
    public void testSegmentDeletedDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new NoSuchFileException("segment deleted"), true);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
    }

    @Test
    public void testArchiveTaskCancelledBeforeUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), false, false, false, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.ctx().cancel();
        Future nextState = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (AfterUpload)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(TierArchiverFencedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
    }

    @Test
    public void testUnknownExceptionDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new IllegalStateException("illegal state"), false);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
    }

    @Test
    public void testTierSegmentNoSegments() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AbstractLog emptyLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)emptyLog.tierableLogSegments()).thenReturn((Object)CollectionConverters$.MODULE$.ListHasAsScala(Collections.emptyList()).asScala()).getMock();
        Partition partition = (Partition)Mockito.when((Object)((Partition)Mockito.mock(Partition.class)).log()).thenReturn((Object)new Some((Object)emptyLog)).getMock();
        Mockito.when((Object)emptyLog.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)emptyLog));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()) instanceof BeforeUpload), (String)"Expected segment tiering to complete successfully, but not progress to AfterUpload");
    }

    @Test
    public void testTierSegmentWithoutLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(Optional.empty());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn(Optional.empty());
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any(Boolean.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        TierObjectMetadata metadata = this.tierSegment(log, leaderEpoch, (Option<Throttler>)None$.MODULE$);
        Assertions.assertEquals((long)metadata.baseOffset(), (long)0L, (String)"expected start offset to be 0");
        Assertions.assertEquals((long)metadata.endOffset(), (long)9L, (String)"expected end offset to be 9");
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).putSegment((ObjectMetadata)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.eq(Optional.empty()));
    }

    @Test
    public void testTierSegmentWithLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        byte[] epochArray = new byte[100];
        LeaderEpochFileCache mockLeaderEpochCache = (LeaderEpochFileCache)Mockito.mock(LeaderEpochFileCache.class);
        Mockito.when((Object)mockLeaderEpochCache.snapshotForSegment(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)epochArray);
        long nextOffset = logSegment.readNextOffset();
        ((LeaderEpochFileCache)Mockito.doNothing().when((Object)mockLeaderEpochCache)).truncateFromEnd(nextOffset);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn(Optional.of(mockLeaderEpochCache));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any(Boolean.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(Optional.empty());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)new Some((Object)ByteBuffer.wrap(epochArray)), (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Throttler throttler = (Throttler)Mockito.mock(Throttler.class);
        Assertions.assertTrue((boolean)this.tierSegment(log, leaderEpoch, (Option<Throttler>)new Some((Object)throttler)).hasEpochState(), (String)"expected metadata to claim to have epoch state");
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).putSegment((ObjectMetadata)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.eq(Optional.of(throttler)));
    }

    @Test
    public void testArchiverTaskSetsPauseOnRetry() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierMetadataRetriableException("something"), new TierObjectStoreRetriableException("foo", (Throwable)new RuntimeException("foo"))});
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Instant pauseTime = (Instant)result.pausedUntil().get();
        this.time().sleep(100L);
        ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime), (String)"expected the second pause time to be larger than the first");
    }

    @Test
    public void testCancelledArchiveTaskDoesNotProgress() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        this.ctx().cancel();
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).state() instanceof BeforeLeader), (String)"expected task to remain in BeforeLeader");
    }

    @Test
    public void testHandleSegmentDeletedException() {
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        BeforeLeader beforeLeader = new BeforeLeader(0);
        BeforeUpload beforeUpload = new BeforeUpload(0);
        Upload upload = new Upload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), (UploadableSegment)Mockito.mock(UploadableSegment.class));
        AfterUpload afterUpload = new AfterUpload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), 0L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> beforeLeader.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        Assertions.assertEquals(BeforeUpload.class, (Object)beforeUpload.handleSegmentDeletedException(exception).getClass());
        Assertions.assertEquals(BeforeUpload.class, (Object)upload.handleSegmentDeletedException(exception).getClass());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> afterUpload.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
    }

    @Test
    public void testHandlingForSegmentDeletedExceptionDuringTransition() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenThrow(new Throwable[]{exception});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    @Test
    public void testRetriableExceptionFetchingOpaqueData() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierPartitionState tierPartitionState = this.mockTierPartitionState(42);
        TierObjectStore throwingTierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)throwingTierObjectStore.prepPutSegment()).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("key fetch error")});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), throwingTierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    @Test
    public void testE2EChecksumInvalidExceptionDuringUpload() {
        ObjectMetadata metadata = new ObjectMetadata(this.topicIdPartition(), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload((Exception)new E2EChecksumInvalidException(metadata, (Throwable)new Exception()), false);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(E2EChecksumInvalidException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
    }

    @Test
    public void testHandlingE2EChecksumInvalidException() {
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        UploadableSegment uploadableSegment = new UploadableSegment(this.mockAbstractLog(logSegment), logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), uploadableSegment);
        KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());
        metricsGroup.removeMetric("ArchiverE2EChecksumInvalidCount");
        Counter e2eChecksumInvalidCount = metricsGroup.newCounter("ArchiverE2EChecksumInvalidCount");
        Assertions.assertEquals((long)0L, (long)e2eChecksumInvalidCount.count());
        ObjectMetadata metadata = new ObjectMetadata(this.topicIdPartition(), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
        this.tierObjectStore().putSegment((ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new E2EChecksumInvalidException(metadata, (Throwable)new Exception())});
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)upload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)e2eChecksumInvalidCount)), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assertions.assertEquals((long)1L, (long)e2eChecksumInvalidCount.count());
        Assertions.assertEquals(Upload.class, result.state().getClass());
        Assertions.assertTrue((boolean)this.ctx().isCancelled());
    }

    private Future<ArchiveTaskState> testInitiateUploadWithUncleanLeader(boolean uncleanLeader) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeader));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn(Optional.empty());
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringInitiateUpload(Exception e) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenThrow(new Throwable[]{e});
        Mockito.when((Object)log.leaderEpochCache()).thenReturn(Optional.empty());
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringUpload(Exception e, boolean deleteSegment) {
        int leaderEpoch = 0;
        File fileToUse = this.tmpFile();
        if (deleteSegment) {
            fileToUse = (File)Mockito.mock(File.class);
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fileToUse.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        LogSegment logSegment = this.mockLogSegment(fileToUse);
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), false, false, false, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.tierObjectStore().putSegment((ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
    }

    private LogSegment mockLogSegment(File tmpFile) {
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.mock(OffsetIndex.class);
        Mockito.when((Object)offsetIndex.file()).thenReturn((Object)tmpFile);
        TimeIndex timeIndex = (TimeIndex)Mockito.mock(TimeIndex.class);
        Mockito.when((Object)timeIndex.file()).thenReturn((Object)tmpFile);
        TransactionIndex txnIndex = (TransactionIndex)Mockito.mock(TransactionIndex.class);
        Mockito.when((Object)txnIndex.file()).thenReturn((Object)tmpFile);
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        Mockito.when((Object)fileRecords.file()).thenReturn((Object)tmpFile);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.readNextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)10L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.largestTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1000));
        Mockito.when((Object)logSegment.log()).thenReturn((Object)fileRecords);
        Mockito.when((Object)logSegment.offsetIndex()).thenReturn((Object)offsetIndex);
        Mockito.when((Object)logSegment.timeIndex()).thenReturn((Object)timeIndex);
        Mockito.when((Object)logSegment.txnIndex()).thenReturn((Object)txnIndex);
        return logSegment;
    }

    private TierPartitionState mockTierPartitionState(int leaderEpoch) {
        return (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
    }

    private AbstractLog mockAbstractLog(LogSegment logSegment) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        return log;
    }

    private TierObjectMetadata tierSegment(AbstractLog log, int leaderEpoch, Option<Throttler> throttlerOpt) {
        Future beforeUploadResult = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Upload upload = (Upload)Await$.MODULE$.result((Awaitable)beforeUploadResult, (Duration)this.defaultAwaitTime());
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), throttlerOpt, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        TierSegmentUploadInitiate uploadInitiate = upload.uploadInitiate();
        return new TierObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.messageId(), uploadInitiate.baseOffset(), uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.firstBatchTimestamp(), uploadInitiate.size(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), TierUploadType.Archive, OpaqueData.ZEROED, true, true, -1L, Optional.empty());
    }

    private Option<Throttler> tierSegment$default$3() {
        return None$.MODULE$;
    }

    public ArchiveTaskTest() {
        this.brokerId = 1;
    }
}

