/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.Serializable;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\r\u001b\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u00047\u0001\u0001\u0006I\u0001\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u00191\u0005\u0001)A\u0005s!9q\t\u0001b\u0001\n\u0013A\u0005BB.\u0001A\u0003%\u0011\nC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001a\u0001!\u0002\u0013!\u0007\"\u00025\u0001\t\u0003I\u0007\"\u0002=\u0001\t\u0003I\u0007\"\u0002>\u0001\t\u0003I\u0007\"\u0002?\u0001\t\u0003I\u0007\"\u0002@\u0001\t\u0003I\u0007BBA\u0001\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002\u0006\u0001!\t!\u001b\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!9\u0011q\n\u0001\u0005\n\u0005E#!F!sG\"Lg/\u001a:UCN\\\u0017+^3vKR+7\u000f\u001e\u0006\u00037q\tq!\u0019:dQ&4XM\u0003\u0002\u001e=\u0005)A/Y:lg*\u0011q\u0004I\u0001\u0005i&,'OC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\t!$A\u0002dib,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003gy\tqAZ3uG\",'/\u0003\u00026e\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006!1\r\u001e=!\u0003\u0011!\u0018.\\3\u0016\u0003e\u0002\"A\u000f#\u000e\u0003mR!\u0001P\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0003}}\naa]3sm\u0016\u0014(BA\u0011A\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015[$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r1\fw-T1q+\u0005I\u0005\u0003\u0002&P#Vk\u0011a\u0013\u0006\u0003\u00196\u000bq!\\;uC\ndWM\u0003\u0002OM\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005A[%aA'baB\u0011!kU\u0007\u0002=%\u0011AK\b\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042!\n,Y\u0013\t9fE\u0001\u0004PaRLwN\u001c\t\u0003KeK!A\u0017\u0014\u0003\t1{gnZ\u0001\bY\u0006<W*\u00199!\u0003!i\u0017\r\u001f+bg.\u001cX#\u00010\u0011\u0005\u0015z\u0016B\u00011'\u0005\rIe\u000e^\u0001\n[\u0006DH+Y:lg\u0002\n\u0011#\u0019:dQ&4XM\u001d+bg.\fV/Z;f+\u0005!\u0007CA\u0017f\u0013\t1'DA\tBe\u000eD\u0017N^3s)\u0006\u001c8.U;fk\u0016\f!#\u0019:dQ&4XM\u001d+bg.\fV/Z;fA\u0005qA/Z:u%\u0016lwN^3UCN\\G#\u00016\u0011\u0005\u0015Z\u0017B\u00017'\u0005\u0011)f.\u001b;)\u00051q\u0007CA8w\u001b\u0005\u0001(BA9s\u0003\r\t\u0007/\u001b\u0006\u0003gR\fqA[;qSR,'O\u0003\u0002v\u0005\u0006)!.\u001e8ji&\u0011q\u000f\u001d\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$\bk\u001c7m)\u0006\u001c8n\u0014:eKJLgn\u001a\u0015\u0003\u001b9\f\u0001\u0004^3tiB{G\u000e\u001c+bg.\u001cH*Z:t)\"\fg.T1yQ\tqa.A\u0006uKN$(,\u001a:p\u0019\u0006<\u0007FA\bo\u0003m!Xm\u001d;BI\u0012\u0014V\r\u001d7bG\u0016\u001cX\t_5ti&tw\rV1tW\"\u0012\u0001C\\\u0001\u000ei\u0016\u001cH/\u0012:s_J$\u0016m]6)\u0005Eq\u0017A\u0006;fgR\u0014V-\\8wK\u0006sG-\u0012:s_J$\u0016m]6)\u0005Iq\u0017!\u00027bO\u001asGcA+\u0002\u000e!9\u0011qB\nA\u0002\u0005E\u0011\u0001\u0002;bg.\u00042!LA\n\u0013\r\t)B\u0007\u0002\f\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8.A\u0005va\u0012\fG/\u001a'bOR)!.a\u0007\u0002 !1\u0011Q\u0004\u000bA\u0002E\u000b\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\t\r\u0005\u0005B\u00031\u0001Y\u0003\ra\u0017mZ\u0001\u0017Y\u0006<7k\u001c:uK\u0012,E.[4jE2,G+Y:lgV\u0011\u0011q\u0005\t\u0006\u0003S\tI$\u0015\b\u0005\u0003W\t)D\u0004\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tDI\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ1!a\u000e'\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000f\u0002>\t!A*[:u\u0015\r\t9DJ\u0001\bC\u0012$G+Y:l)\u0015Q\u00171IA#\u0011\u0019\tiB\u0006a\u0001#\"1\u0011q\t\fA\u0002y\u000b1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006Q!/Z7pm\u0016$\u0016m]6\u0015\u0007)\fi\u0005\u0003\u0004\u0002\u001e]\u0001\r!U\u0001\tM&tG\rV1tWR!\u00111KA+!\u0011)c+!\u0005\t\r\u0005u\u0001\u00041\u0001R\u0001")
public class ArchiverTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final MockTime time = new MockTime();
    private final Map<TopicIdPartition, Option<Object>> lagMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int maxTasks;
    private final ArchiverTaskQueue archiverTaskQueue = new ArchiverTaskQueue(this.ctx(), this.maxTasks(), (Time)this.time(), (Function1 & Serializable)task -> this.lagFn((ArchiveTask)task), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);

    private CancellationContext ctx() {
        return this.ctx;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<TopicIdPartition, Option<Object>> lagMap() {
        return this.lagMap;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    private ArchiverTaskQueue archiverTaskQueue() {
        return this.archiverTaskQueue;
    }

    @Test
    public void testRemoveTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.removeTask(partition_1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        this.removeTask(partition_3);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveTask$3(partition_2, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 10L);
        this.updateLag(partition_3, 1L);
        this.updateLag(partition_4, 15L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        List tasks = (List)this.archiverTaskQueue().poll().get();
        Assertions.assertEquals((Object)this.lagSortedEligibleTasks().take(this.maxTasks()), (Object)tasks.map((Function1 & Serializable)x$3 -> x$3.topicIdPartition()));
    }

    @Test
    public void testPollTasksLessThanMax() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_1})), (Object)((List)this.archiverTaskQueue().poll().get()).map((Function1 & Serializable)x$4 -> x$4.topicIdPartition()).toSet());
    }

    @Test
    public void testZeroLag() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 0L);
        this.updateLag(partition_2, 0L);
        this.updateLag(partition_3, 0L);
        this.updateLag(partition_4, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.archiverTaskQueue().poll());
    }

    @Test
    public void testAddReplacesExistingTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.addTask(partition_1, 1);
        this.addTask(partition_3, 2);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$1(partition_1, partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testErrorTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        ArchiveTask task1 = (ArchiveTask)this.findTask(partition_1).get();
        task1.cancelAndSetErrorState((Throwable)new Exception("test"));
        this.archiverTaskQueue().done((TierTask)task1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testErrorTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)this.archiverTaskQueue().errorPartitionCount());
    }

    @Test
    public void testRemoveAndErrorTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        ArchiveTask task1 = (ArchiveTask)this.findTask(partition_1).get();
        this.removeTask(partition_1);
        task1.cancelAndSetErrorState((Throwable)new Exception("test"));
        this.archiverTaskQueue().done((TierTask)task1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveAndErrorTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.archiverTaskQueue().errorPartitionCount());
    }

    private Option<Object> lagFn(ArchiveTask task) {
        return (Option)this.lagMap().apply((Object)task.topicIdPartition());
    }

    private void updateLag(TopicIdPartition topicIdPartition, long lag) {
        this.lagMap().update((Object)topicIdPartition, (Object)new Some((Object)BoxesRunTime.boxToLong((long)lag)));
    }

    private List<TopicIdPartition> lagSortedEligibleTasks() {
        return ((List)this.lagMap().toList().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
                Option lag = (Option)x0$1._2();
                return new Tuple2((Object)topicPartition, lag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            }
            throw new MatchError(null);
        }).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$lagSortedEligibleTasks$3(x0$2))).sortBy((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToLong((long)ArchiverTaskQueueTest.$anonfun$lagSortedEligibleTasks$4(x0$3)), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                return (TopicIdPartition)x0$4._1();
            }
            throw new MatchError(null);
        });
    }

    private void addTask(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.archiverTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, leaderEpoch));
    }

    private void removeTask(TopicIdPartition topicIdPartition) {
        this.archiverTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(topicIdPartition));
    }

    private Option<ArchiveTask> findTask(TopicIdPartition topicIdPartition) {
        return (Option)this.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> tasks.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$findTask$2(topicIdPartition, x$11))));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$1(TopicIdPartition partition_2$1, TopicIdPartition partition_3$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$1, partition_3$1, partition_4$1})), (Object)tasks.map((Function1 & Serializable)x$1 -> x$1.topicIdPartition()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$3(TopicIdPartition partition_2$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$1, partition_4$1})), (Object)tasks.map((Function1 & Serializable)x$2 -> x$2.topicIdPartition()));
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$2(TopicIdPartition partition_1$1, ArchiveTask x$5) {
        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_1$1) : partition_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$3(TopicIdPartition partition_2$2, ArchiveTask x$6) {
        TopicIdPartition topicIdPartition = x$6.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_2$2) : partition_2$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$4(TopicIdPartition partition_3$2, ArchiveTask x$7) {
        TopicIdPartition topicIdPartition = x$7.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_3$2) : partition_3$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$5(TopicIdPartition partition_4$2, ArchiveTask x$8) {
        TopicIdPartition topicIdPartition = x$8.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_4$2) : partition_4$2 != null);
    }

    public static final /* synthetic */ void $anonfun$testAddReplacesExistingTask$1(TopicIdPartition partition_1$1, TopicIdPartition partition_2$2, TopicIdPartition partition_3$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((int)1, (int)((ArchiveTask)tasks.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$2(partition_1$1, x$5))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((ArchiveTask)tasks.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$3(partition_2$2, x$6))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)2, (int)((ArchiveTask)tasks.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$4(partition_3$2, x$7))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((ArchiveTask)tasks.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$5(partition_4$2, x$8))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)4, (int)tasks.size());
    }

    public static final /* synthetic */ void $anonfun$testErrorTask$1(TopicIdPartition partition_2$3, TopicIdPartition partition_3$3, TopicIdPartition partition_4$3, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$3, partition_3$3, partition_4$3})), (Object)tasks.map((Function1 & Serializable)x$9 -> x$9.topicIdPartition()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndErrorTask$1(TopicIdPartition partition_2$4, TopicIdPartition partition_3$4, TopicIdPartition partition_4$4, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$4, partition_3$4, partition_4$4})), (Object)tasks.map((Function1 & Serializable)x$10 -> x$10.topicIdPartition()));
    }

    public static final /* synthetic */ boolean $anonfun$lagSortedEligibleTasks$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcJ$sp() != 0L;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$lagSortedEligibleTasks$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcJ$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$findTask$2(TopicIdPartition topicIdPartition$1, ArchiveTask x$11) {
        TopicIdPartition topicIdPartition = x$11.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition$1) : topicIdPartition$1 != null);
    }

    public ArchiverTaskQueueTest() {
        this.maxTasks = 3;
    }
}

