/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Meter;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001\u0002\u001e<\u0001\u0011CQa\u0013\u0001\u0005\u00021C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0001)\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0006\"\u00030\u0001\u0001\u0004\u0005\t\u0015)\u0003R\u0011\u001dy\u0006A1A\u0005\u0002\u0001DaA\u001c\u0001!\u0002\u0013\t\u0007bB8\u0001\u0005\u0004%\t\u0001\u001d\u0005\u0007s\u0002\u0001\u000b\u0011B9\t\u000fi\u0004!\u0019!C\u0001w\"1q\u0010\u0001Q\u0001\nqD\u0011\"!\u0001\u0001\u0005\u0004%\t!a\u0001\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0005\u0001\u0005\u0004%\t!a\u0005\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003+A\u0011\"a\t\u0001\u0005\u0004%\t!!\n\t\u0011\u00055\u0002\u0001)A\u0005\u0003OA\u0011\"a\f\u0001\u0005\u0004%\t!!\r\t\u0011\u0005}\u0002\u0001)A\u0005\u0003gA\u0011\"!\u0011\u0001\u0005\u0004%\t!a\u0011\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u000bB\u0011\"a\u0015\u0001\u0001\u0004%\t!!\u0016\t\u0013\u0005\r\u0004\u00011A\u0005\u0002\u0005\u0015\u0004\u0002CA5\u0001\u0001\u0006K!a\u0016\t\u0013\u0005-\u0004A1A\u0005\u0002\u00055\u0004\u0002CA>\u0001\u0001\u0006I!a\u001c\t\u0013\u0005u\u0004A1A\u0005\u0002\u0005}\u0004\u0002CAE\u0001\u0001\u0006I!!!\t\u0013\u0005-\u0005A1A\u0005\u0002\u00055\u0005\u0002CAN\u0001\u0001\u0006I!a$\t\u0013\u0005u\u0005A1A\u0005\u0002\u0005}\u0005\u0002CAY\u0001\u0001\u0006I!!)\t\u0013\u0005M\u0006A1A\u0005\u0002\u0005U\u0006\u0002CAc\u0001\u0001\u0006I!a.\t\u0017\u0005\u001d\u0007\u00011AA\u0002\u0013\u0005\u0011\u0011\u001a\u0005\f\u0003G\u0004\u0001\u0019!a\u0001\n\u0003\t)\u000fC\u0006\u0002j\u0002\u0001\r\u0011!Q!\n\u0005-\u0007\"CAv\u0001\t\u0007I\u0011AAw\u0011!\t)\u0010\u0001Q\u0001\n\u0005=\b\"CA|\u0001\t\u0007I\u0011AA}\u0011!\u00119\u0001\u0001Q\u0001\n\u0005m\b\"\u0003B\u0005\u0001\t\u0007I\u0011\u0001B\u0006\u0011!\u00119\u0003\u0001Q\u0001\n\t5\u0001b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005\u0007\u0002A\u0011\u0001B\u0016\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005WAqAa\u0016\u0001\t\u0003\u0011Y\u0003C\u0004\u0003\\\u0001!\tAa\u000b\t\u000f\t}\u0003\u0001\"\u0001\u0003,!9!1\r\u0001\u0005\u0002\t-\u0002b\u0002B4\u0001\u0011\u0005!1\u0006\u0005\b\u0005W\u0002A\u0011\u0001B\u0016\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005WAqAa\u001d\u0001\t\u0003\u0011Y\u0003C\u0004\u0003x\u0001!\tAa\u000b\t\u000f\tm\u0004\u0001\"\u0001\u0003,!9!q\u0010\u0001\u0005\u0002\t-\u0002b\u0002BB\u0001\u0011%!Q\u0011\u0002\u0016)&,'/\u0011:dQ&4XM]*uCR,G+Z:u\u0015\taT(A\u0004be\u000eD\u0017N^3\u000b\u0005yz\u0014!\u0002;bg.\u001c(B\u0001!B\u0003\u0011!\u0018.\u001a:\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A\u001e\u0002\u0007\r$\b0F\u0001R!\t\u0011V+D\u0001T\u0015\t!v(A\u0004gKR\u001c\u0007.\u001a:\n\u0005Y\u001b&aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018aB2uq~#S-\u001d\u000b\u00033r\u0003\"A\u0012.\n\u0005m;%\u0001B+oSRDq!X\u0002\u0002\u0002\u0003\u0007\u0011+A\u0002yIE\nAa\u0019;yA\u0005AQn\\2l)&lW-F\u0001b!\t\u0011G.D\u0001d\u0015\t!W-\u0001\u0003vi&d'B\u00014h\u0003\u0019\u0019XM\u001d<fe*\u0011!\t\u001b\u0006\u0003S*\fa!\u00199bG\",'\"A6\u0002\u0007=\u0014x-\u0003\u0002nG\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u0005iA/[3s)>\u0004\u0018n\u0019(b[\u0016,\u0012!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\fA\u0001\\1oO*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\u0019\u0019FO]5oO\u0006qA/[3s)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013A\u0006;jKJ$v\u000e]5d\u001dVl\u0007+\u0019:uSRLwN\\:\u0016\u0003q\u0004\"AR?\n\u0005y<%!B*i_J$\u0018a\u0006;jKJ$v\u000e]5d\u001dVl\u0007+\u0019:uSRLwN\\:!\u0003\u001dawn\u001a#jeN,\"!!\u0002\u0011\u000b\u0005\u001d\u00111B9\u000e\u0005\u0005%!B\u00013v\u0013\u0011\ti!!\u0003\u0003\u0013\u0005\u0013(/Y=MSN$\u0018\u0001\u00037pO\u0012K'o\u001d\u0011\u0002#=\u0014'.Z2u'R|'/Z\"p]\u001aLw-\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c}\nQa\u001d;pe\u0016LA!a\b\u0002\u001a\t\tSj\\2l\u0013:lU-\\8ssRKWM](cU\u0016\u001cGo\u0015;pe\u0016\u001cuN\u001c4jO\u0006\u0011rN\u00196fGR\u001cFo\u001c:f\u0007>tg-[4!\u0003=!\u0018.\u001a:PE*,7\r^*u_J,WCAA\u0014!\u0011\t9\"!\u000b\n\t\u0005-\u0012\u0011\u0004\u0002\u001c\u001b>\u001c7.\u00138NK6|'/\u001f+jKJ|%M[3diN#xN]3\u0002!QLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\u0011\u00111\u0007\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H \u0002\u000bQ|\u0007/[2\n\t\u0005u\u0012q\u0007\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002\n\u0011\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ssV\u0011\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J \u0002\u000bM$\u0018\r^3\n\t\u0005=\u0013\u0011\n\u0002\u001a)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u00180\u0001\u000euS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JL\b%A\nuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002XA)a)!\u0017\u0002^%\u0019\u00111L$\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u001d\u0013qL\u0005\u0005\u0003C\nIE\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017a\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cx\fJ3r)\rI\u0016q\r\u0005\t;Z\t\t\u00111\u0001\u0002X\u0005!B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002\n\u0011\u0003^5fe2{wmQ8na>tWM\u001c;t+\t\ty\u0007\u0005\u0003\u0002r\u0005]TBAA:\u0015\r\t)(Q\u0001\u0004Y><\u0017\u0002BA=\u0003g\u0012\u0011\u0003V5fe2{wmQ8na>tWM\u001c;t\u0003I!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u0011\u0002%QLWM\u001d*fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u0003\u0003B!a!\u0002\u00066\tq(C\u0002\u0002\b~\u0012!\u0003V5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0019B/[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005!\"\r\\8dW&tw\rV1tW\u0016CXmY;u_J,\"!a$\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002\n\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00151\u0013\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!\u00062m_\u000e\\\u0017N\\4UCN\\W\t_3dkR|'\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002\"B!\u00111UAW\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016!B;uS2\u001c(bAAVO\u000611m\\7n_:LA!a,\u0002&\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003-i\u0017\r_,bSR$\u0016.\\3\u0016\u0005\u0005]\u0006\u0003BA]\u0003\u0003l!!a/\u000b\t\u0005u\u0016qX\u0001\tIV\u0014\u0018\r^5p]*\u0019\u0011QS$\n\t\u0005\r\u00171\u0018\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00031i\u0017\r_,bSR$\u0016.\\3!\u0003!\u0011\u0017\u0010^3SCR,WCAAf!\u0011\ti-a8\u000e\u0005\u0005='\u0002BAi\u0003'\fAaY8sK*!\u0011Q[Al\u0003\u001diW\r\u001e:jGNTA!!7\u0002\\\u00061\u00110Y7nKJT!!!8\u0002\u0007\r|W.\u0003\u0003\u0002b\u0006='!B'fi\u0016\u0014\u0018\u0001\u00042zi\u0016\u0014\u0016\r^3`I\u0015\fHcA-\u0002h\"AQlIA\u0001\u0002\u0004\tY-A\u0005csR,'+\u0019;fA\u0005A!M]8lKJLE-\u0006\u0002\u0002pB\u0019a)!=\n\u0007\u0005MxIA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001fQLWM\u001d+bg.\u001c8i\u001c8gS\u001e,\"!a?\u0011\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001>\u0003\u0019\u0019wN\u001c4jO&!!QAA\u0000\u0005=!\u0016.\u001a:UCN\\7oQ8oM&<\u0017\u0001\u0005;jKJ$\u0016m]6t\u0007>tg-[4!\u00039\u0019\u0007.Z2lgVl\u0007+\u0019:b[N,\"A!\u0004\u0011\t\t=!1E\u0007\u0003\u0005#QAAa\u0005\u0003\u0016\u0005A1\r[3dWN,XN\u0003\u0003\u0003\u0018\te\u0011aB:u_J\fw-\u001a\u0006\u0004\u0005\nm!\u0002\u0002B\u000f\u0005?\t\u0011bY8oM2,XM\u001c;\u000b\u0005\t\u0005\u0012AA5p\u0013\u0011\u0011)C!\u0005\u0003\u001d\rCWmY6tk6\u0004\u0016M]1ng\u0006y1\r[3dWN,X\u000eU1sC6\u001c\b%A\u0003tKR,\u0006\u000fF\u0001ZQ\rY#q\u0006\t\u0005\u0005c\u0011y$\u0004\u0002\u00034)!!Q\u0007B\u001c\u0003\r\t\u0007/\u001b\u0006\u0005\u0005s\u0011Y$A\u0004kkBLG/\u001a:\u000b\u0007\tu\".A\u0003kk:LG/\u0003\u0003\u0003B\tM\"A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002-\u0005\u000f\u0002BA!\r\u0003J%!!1\nB\u001a\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\ruKN$\u0018i^1ji&tw\rT3bI\u0016\u0014(+Z:vYRD3!\fB)!\u0011\u0011\tDa\u0015\n\t\tU#1\u0007\u0002\u0005)\u0016\u001cH/\u0001\u001euKN$h)Y5mK\u0012Le.\u001b;MK\u0006$WM\u001d*fiJLH\u000b[3o%\u0016\u001cHo\u001c:f)JLwmZ3sS:<')\u001a4pe\u0016dU-\u00193fe\"\u001aaF!\u0015\u0002[Q,7\u000f\u001e$bS2,G\rT3bI\u0016\u0014(+Z:vYR4\u0015-\u001b7fIJ+7\u000f^8sK:+w/\u001a:Fa>\u001c\u0007\u000eK\u00020\u0005#\nQ\u0006^3ti\u001a\u000b\u0017\u000e\\3e\u0019\u0016\fG-\u001a:SKN,H\u000e\u001e$bS2,GMU3ti>\u0014X-R9vC2,\u0005o\\2iQ\r\u0001$\u0011K\u0001.i\u0016\u001cHOR1jY\u0016$G*Z1eKJ\u0014Vm];mi\u001a\u000b\u0017\u000e\\3e%\u0016\u001cHo\u001c:f\u0019><XM]#q_\u000eD\u0007fA\u0019\u0003R\u0005qB/Z:u\u0003^\f\u0017\u000e^5oO2+\u0017\rZ3s%\u0016\u001cX\u000f\u001c;GK:\u001cW\r\u001a\u0015\u0004e\tE\u0013A\u0007;fgR\u0014Vm\u001d;pe\u00164UM\\2fI\u0016C8-\u001a9uS>t\u0007fA\u001a\u0003R\u00051B/Z:u\u0005\u00164wN]3Va2|\u0017\r\u001a$f]\u000e,G\rK\u00025\u0005#\n\u0011\f^3ti\u000e{'O];qi\u0016$\u0017J\u001c3fq\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c%/Z1uKV\u0003Hn\\1e'\u0016<W.\u001a8u%\u0016$\u0006N]8x]\u0006\u001bXIM#DQ\u0016\u001c7n];n\u0013:4\u0018\r\\5e\u000bb\u001cW\r\u001d;j_:D3!\u000eB)\u0003\t\"Xm\u001d;CK\u001a|'/Z+qY>\fGMU3uef<\u0006.\u001a8O_N+w-\\3oi\"\u001aaG!\u0015\u0002GQ,7\u000f\u001e\"fM>\u0014X-\u00169m_\u0006$\u0017\t\u001a<b]\u000e,7\u000fV8OKb$8\u000b^1uK\"\u001aqG!\u0015\u0002EQ,7\u000f\u001e\"fM>\u0014X-\u00169m_\u0006$wJ^3sY\u0006\u0004\b/\u001b8h'\u0016<W.\u001a8uQ\rA$\u0011K\u0001\u0019GJ,\u0017\r^3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003DA/\u0005\u000f\u0013)Ja(\u00034\nu\u0006b\u0002BEs\u0001\u0007!1R\u0001\u0004I&\u0014\b\u0003\u0002BG\u0005#k!Aa$\u000b\u0007\t\u0005R/\u0003\u0003\u0003\u0014\n=%\u0001\u0002$jY\u0016DqAa&:\u0001\u0004\u0011I*\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B!\u00111\u0011BN\u0013\r\u0011ij\u0010\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:DqA!):\u0001\u0004\u0011\u0019+\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0005\u0005K\u0013y+\u0004\u0002\u0003(*!\u0011Q\u000fBU\u0015\u0011\u0011YK!,\u0002\u0013%tG/\u001a:oC2\u001c(b\u0001B\fO&!!\u0011\u0017BT\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\"9!QW\u001dA\u0002\t]\u0016A\u0004;jKJLgnZ#oC\ndW\r\u001a\t\u0004\r\ne\u0016b\u0001B^\u000f\n9!i\\8mK\u0006t\u0007b\u0002B`s\u0001\u0007!qW\u0001\u000fG>l\u0007/Y2u\u000b:\f'\r\\3e\u0001")
public class TierArchiverStateTest {
    private CancellationContext ctx;
    private final MockTime mockTime = new MockTime();
    private final String tierTopicName;
    private final short tierTopicNumPartitions;
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(System.getProperty("java.io.tmpdir")));
    private final MockInMemoryTierObjectStoreConfig objectStoreConfig = new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1));
    private final MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), this.objectStoreConfig());
    private final TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private TierPartitionState[] tierPartitionStates = (TierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(TierPartitionState.class));
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), this.tierPartitionStateFactory(), (Option)None$.MODULE$);
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final ScheduledExecutorService blockingTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Time time = Time.SYSTEM;
    private final FiniteDuration maxWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private Meter byteRate;
    private final int brokerId;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, this.brokerId(), 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
    private final ChecksumParams checksumParams = TestUtils$.MODULE$.createChecksumParams();

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public String tierTopicName() {
        return this.tierTopicName;
    }

    public short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public MockInMemoryTierObjectStoreConfig objectStoreConfig() {
        return this.objectStoreConfig;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierPartitionState[] tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public void tierPartitionStates_$eq(TierPartitionState[] x$1) {
        this.tierPartitionStates = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public Time time() {
        return this.time;
    }

    public FiniteDuration maxWaitTime() {
        return this.maxWaitTime;
    }

    public Meter byteRate() {
        return this.byteRate;
    }

    public void byteRate_$eq(Meter x$1) {
        this.byteRate = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setUp() {
        this.ctx_$eq(CancellationContext.newContext());
        new KafkaMetricsGroup(this.getClass()).removeMetric("TierArchiver.UploadRate");
        this.byteRate_$eq(new KafkaMetricsGroup(this.getClass()).newMeter("TierArchiver.UploadRate", "bytes", TimeUnit.SECONDS));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void tearDown() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates()), (Function1 & Serializable)x$3 -> {
            x$3.delete();
            return BoxedUnit.UNIT;
        });
        this.ctx().cancel();
    }

    @Test
    public void testAwaitingLeaderResult() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        new Properties().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = this.createTierPartitionState(new File(this.logDirs().get(0)), topicIdPartition, logDirFailureChannel, true, false);
        this.tierReplicaManager().becomeLeader(tierPartitionState, 1);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 0, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testFailedInitLeaderRetryThenRestoreTriggeringBeforeLeader() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ERROR).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Future failedResultNextStage = failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResultAgain = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultNextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResultAgain.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED as status is still ERROR");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeLeader as correct epoch was never established in initial BeforeLeader");
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should correctly transition into BeforeUpload");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreNewerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        ArchiveTask resultCancelled = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)resultCancelled.ctx().isCancelled(), (String)"We are the stale leader and the task should be cancelled");
        Assertions.assertTrue((boolean)(resultCancelled.state() instanceof FailedState), (String)"We are the stale leader and the task should remain in FailedState");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreEqualEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreLowerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testAwaitingLeaderResultFenced() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrError((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), topicIdPartition, (TierTopicAppender)tierTopicManager, 1, replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testRestoreFencedException() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.RESTORE_FENCED));
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -1L;
        long x$9 = -2L;
        long x$10 = 0L;
        String x$11 = "delete";
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, x$10, x$11, 65536, 1, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        File logDir = Paths.get(TestUtils.tempDirectory(null, null).getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        BrokerTopicStats x$25 = new BrokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        ProducerStateManagerConfig x$31 = new ProducerStateManagerConfig(3600000, false);
        TierLogComponents x$33 = this.tierLogComponents();
        ChecksumParams x$35 = this.checksumParams();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, x$25, (Scheduler)x$26, (Time)x$27, 0L, 0L, 300000, x$31, 600000, x$33, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$35);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertThrows(TierArchiverRestoreFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadFenced() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testCorruptedIndexExceptionDuringCreateUploadSegmentReThrownAsE2EChecksumInvalidException() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -1L;
        long x$9 = -2L;
        long x$10 = 0L;
        String x$11 = "delete";
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, x$10, x$11, 65536, 1, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        File logDir = Paths.get(TestUtils.tempDirectory(null, null).getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        BrokerTopicStats x$25 = new BrokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        ProducerStateManagerConfig x$31 = new ProducerStateManagerConfig(3600000, false);
        TierLogComponents x$33 = this.tierLogComponents();
        ChecksumParams x$35 = this.checksumParams();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = (MergedLog)Mockito.spy((Object)LogTestUtils$.MODULE$.createLog(logDir, logConfig, x$25, (Scheduler)x$26, (Time)x$27, 0L, 0L, 300000, x$31, 600000, x$33, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$35));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        ((MergedLog)Mockito.doThrow((Throwable[])new Throwable[]{new CorruptIndexException("Transaction Index is corrupted")}).when((Object)log)).createUploadableSegment((LogSegment)ArgumentMatchers.any());
        Assertions.assertThrows(E2EChecksumInvalidException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadRetryWhenNoSegment() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.List().empty());
        Mockito.when((Object)log.activeSegment()).thenReturn(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testBeforeUploadAdvancesToNextState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -1L;
        long x$9 = -2L;
        long x$10 = 0L;
        String x$11 = "delete";
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, x$10, x$11, 65536, 1, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        File logDir = Paths.get(TestUtils.tempDirectory(null, null).getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        BrokerTopicStats x$25 = new BrokerTopicStats();
        MockScheduler x$26 = this.mockTime().scheduler;
        MockTime x$27 = this.mockTime();
        ProducerStateManagerConfig x$31 = new ProducerStateManagerConfig(3600000, false);
        TierLogComponents x$33 = this.tierLogComponents();
        ChecksumParams x$35 = this.checksumParams();
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, x$25, (Scheduler)x$26, (Time)x$27, 0L, 0L, 300000, x$31, 600000, x$33, logDirFailureChannel, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$35);
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to AfterUpload");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBeforeUploadOverlappingSegment() {
        void randomPartitionLogDir_parentDir;
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -1L;
        long x$9 = -2L;
        long x$10 = 0L;
        String x$11 = "delete";
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 1000, x$6, x$7, x$8, x$9, x$10, x$11, 65536, 1, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        File file = TestUtils.tempDirectory(null, null);
        TestUtils$ randomPartitionLogDir_this = TestUtils$.MODULE$;
        Object var54_22 = null;
        file = null;
        File logDir = randomPartitionLogDir_this.randomPartitionForTopicLogDir((File)randomPartitionLogDir_parentDir, "kafka");
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(logDir);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = this.createTierPartitionState(logDir, topicIdPartition, logDirFailureChannel, true, false);
        tierPartitionState.beginCatchup();
        tierPartitionState.onCatchUpComplete();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionStateFactory().mayEnableTiering(topicPartition, logConfig))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicIdPartition.topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler, (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockScheduler x$27 = this.mockTime().scheduler;
        BrokerTopicStats x$28 = new BrokerTopicStats();
        Metrics x$29 = new Metrics();
        MockTime x$30 = this.mockTime();
        ProducerStateManagerConfig x$32 = new ProducerStateManagerConfig(3600000, false);
        None$ x$34 = None$.MODULE$;
        TierLogComponents x$36 = this.tierLogComponents();
        None$ x$39 = None$.MODULE$;
        ChecksumParams x$40 = TestUtils$.MODULE$.createChecksumParams();
        LogOffsetsListener x$41 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$42 = None$.MODULE$;
        ConcurrentHashMap x$43 = new ConcurrentHashMap();
        MergedLog log = MergedLog$.MODULE$.apply(logDir, logConfig, 0L, 0L, (Scheduler)x$27, x$28, x$29, (Time)x$30, 300000, x$32, 600000, (Option)x$34, logDirFailureChannel, x$36, true, (Option)x$39, true, x$41, (Option)x$42, x$43, x$40);
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, 0, UUID.randomUUID(), 0L, 60L, 15000L, 15000L, 1000, false, false, false, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        int newTierEpoch = 1;
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, newTierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        log.updateHighWatermark(log.logEndOffset());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(null, tierPartitionState){
            private final TierPartitionState tierPartitionState$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                AbstractTierMetadata metadata = (AbstractTierMetadata)invocation.getArgument(0);
                return CompletableFuture.completedFuture(this.tierPartitionState$1.append(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(newTierEpoch), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to Upload");
    }

    private TierPartitionState createTierPartitionState(File dir, TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean tieringEnabled, boolean compactEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, logDirFailureChannel, topicIdPartition.topicPartition(), tieringEnabled, (Scheduler)this.mockTime().scheduler, false, compactEnabled, (Time)this.mockTime(), TierPartitionStateCleanupConfig.EMPTY, false, -1);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates_$eq((TierPartitionState[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates()), (Object)tierPartitionState, ClassTag$.MODULE$.apply(TierPartitionState.class)));
        return tierPartitionState;
    }

    public TierArchiverStateTest() {
        this.tierTopicName = "_confluent-tier-state";
        this.tierTopicNumPartitions = 1;
        this.brokerId = 1;
    }
}

