/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.OptionalLong;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.Defaults$;
import kafka.server.ReplicaManager;
import kafka.server.resource.DiskIOManager;
import kafka.server.resource.DiskThroughputListener;
import kafka.server.resource.ResourceUsageListener;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.ArchiverPartitionLagInfo;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;

@ScalaSignature(bytes="\u0006\u000513AAB\u0004\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u0005e\t\u0001B+[3s\u0003J\u001c\u0007.\u001b<feR+7\u000f\u001e\u0006\u0003\u0011%\tq!\u0019:dQ&4XM\u0003\u0002\u000b\u0017\u0005)A/Y:lg*\u0011A\"D\u0001\u0005i&,'OC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\tq!A\u000euKN$H*Y4DC2\u001cW\u000f\\1uS>tw+\u001b;i%\u0016\u001cX\r\u001e\u000b\u0002;A\u0011!CH\u0005\u0003?M\u0011A!\u00168ji\"\u0012!!\t\t\u0003E-j\u0011a\t\u0006\u0003I\u0015\n1!\u00199j\u0015\t1s%A\u0004kkBLG/\u001a:\u000b\u0005!J\u0013!\u00026v]&$(\"\u0001\u0016\u0002\u0007=\u0014x-\u0003\u0002-G\t!A+Z:u\u0003I!Xm\u001d;MC\u001e\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8)\u0005\r\t\u0013a\n;fgRd\u0015mZ\"bY\u000e,H.\u0019;j_:<\u0016\u000e\u001e5Be\u000eD\u0017N^5oO\u0012K7/\u00192mK\u0012D#\u0001B\u0011\u0002\u00175,GO]5d-\u0006dW/Z\u000b\u0003gY\"\"\u0001N \u0011\u0005U2D\u0002\u0001\u0003\u0006o\u0015\u0011\r\u0001\u000f\u0002\u0002)F\u0011\u0011\b\u0010\t\u0003%iJ!aO\n\u0003\u000f9{G\u000f[5oOB\u0011!#P\u0005\u0003}M\u00111!\u00118z\u0011\u0015\u0001U\u00011\u0001B\u0003\u0011q\u0017-\\3\u0011\u0005\tKeBA\"H!\t!5#D\u0001F\u0015\t1u\"\u0001\u0004=e>|GOP\u0005\u0003\u0011N\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001j\u0005")
public class TierArchiverTest {
    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", (Z)Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("tieringEnabled_$eq", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    @Test
    public void testLagCalculationWithReset() {
        TopicPartition topicPartition = new TopicPartition("mytopic-1", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime(1000L, 1000000000L);
        LogSegment segment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)segment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)20));
        Mockito.when((Object)segment.lastFlushedTimeMs()).thenReturn((Object)OptionalLong.of(250L));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)segment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer((Answer)new Answer<Iterator<Partition>>(null, partition){
            private final Partition partition$1;

            public Iterator<Partition> answer(InvocationOnMock invocation) {
                return new .colon.colon((Object)this.partition$1, (List)Nil$.MODULE$).iterator();
            }
            {
                this.partition$1 = partition$1;
            }
        });
        TierTasksConfig config = new TierTasksConfig(2, 2, 2, 1, 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
        TestUtils$.MODULE$.clearYammerMetrics();
        TierArchiver archiver = new TierArchiver(config, replicaManager, (TierTopicAppender)Mockito.mock(TierTopicManager.class), (TierObjectStore)Mockito.mock(TierObjectStore.class), CancellationContext.newContext(), config.numArchiverThreads(), (Time)time, (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)archiver.diskThroughputListenerOpt().isEmpty());
        Assertions.assertEquals((long)0L, (long)((Counter)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TierArchiverTest.$anonfun$testLagCalculationWithReset$1(x$1)))).values().headOption().get()).count());
        this.checkLag$1(20, 750L, archiver, topicPartition, time);
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer((Answer)new Answer<Iterator<Partition>>(null){

            public Iterator<Partition> answer(InvocationOnMock invocation) {
                return Nil$.MODULE$.iterator();
            }
        });
        this.checkLag$1(0, 0L, archiver, topicPartition, time);
    }

    @Test
    public void testLagCalculation() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicPartition partition1 = new TopicPartition("mytopic-1", 0);
        TopicPartition partition2 = new TopicPartition("mytopic-2", 0);
        TopicPartition partition3 = new TopicPartition("mytopic-3", 0);
        TopicPartition partition4 = new TopicPartition("mytopic-4", 0);
        TopicPartition partition5 = new TopicPartition("mytopic-5", 0);
        TopicPartition partition6 = new TopicPartition("mytopic-6", 0);
        Iterable partitions = (Iterable)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToLong((long)100L), (Object)TierPartitionStatus.ONLINE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)200L), (Object)TierPartitionStatus.ONLINE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToLong((long)300L), (Object)TierPartitionStatus.ONLINE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition4), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToLong((long)400L), (Object)TierPartitionStatus.ERROR)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition5), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)500L), (Object)TierPartitionStatus.ERROR)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition6), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToLong((long)600L), (Object)TierPartitionStatus.ERROR))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                Tuple3 partitionInfo = (Tuple3)x0$1._2();
                int segmentSize = BoxesRunTime.unboxToInt((Object)partitionInfo._1());
                long segmentRollTime = BoxesRunTime.unboxToLong((Object)partitionInfo._2());
                TierPartitionStatus status = (TierPartitionStatus)partitionInfo._3();
                LogSegment segment = (LogSegment)Mockito.mock(LogSegment.class);
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)segment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)segmentSize));
                Mockito.when((Object)segment.lastFlushedTimeMs()).thenReturn((Object)OptionalLong.of(segmentRollTime));
                AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
                Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
                Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)segment, (List)new .colon.colon((Object)segment, (List)new .colon.colon((Object)segment, (List)new .colon.colon((Object)segment, (List)Nil$.MODULE$)))));
                Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
                TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)status);
                Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
                Partition partition = (Partition)Mockito.mock(Partition.class);
                Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
                return partition;
            }
            throw new MatchError(null);
        });
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer((Answer)new Answer<Iterator<Partition>>(null, partitions){
            private final Iterable partitions$1;

            public Iterator<Partition> answer(InvocationOnMock invocation) {
                return this.partitions$1.iterator();
            }
            {
                this.partitions$1 = partitions$1;
            }
        });
        DiskIOManager diskIOManager = (DiskIOManager)Mockito.mock(DiskIOManager.class);
        ((DiskIOManager)Mockito.doNothing().when((Object)diskIOManager)).registerListener((ResourceUsageListener)ArgumentMatchers.any());
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        MockTime time = new MockTime(1000L, 1000000000L);
        TierTasksConfig config = new TierTasksConfig(2, 2, 2, 1, 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
        TestUtils$.MODULE$.clearYammerMetrics();
        TierArchiver archiver = new TierArchiver(config, replicaManager, (TierTopicAppender)tierTopicManager, tierObjectStore, CancellationContext.newContext(), config.numArchiverThreads(), (Time)time, (Option)new Some((Object)diskIOManager), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)archiver.diskThroughputListenerOpt().isDefined());
        ((DiskIOManager)Mockito.verify((Object)diskIOManager, (VerificationMode)Mockito.times((int)1))).registerListener((ResourceUsageListener)ArgumentMatchers.eq((Object)archiver.diskThroughputListenerOpt().get()));
        List laggingPartitions = archiver.partitionLagInfo();
        Assertions.assertEquals((int)6, (int)laggingPartitions.size());
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition6, TierPartitionStatus.ERROR, 120L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)600L))), (Object)laggingPartitions.apply(0));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition3, TierPartitionStatus.ONLINE, 120L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)300L))), (Object)laggingPartitions.apply(1));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition1, TierPartitionStatus.ONLINE, 80L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)100L))), (Object)laggingPartitions.apply(2));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition4, TierPartitionStatus.ERROR, 80L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)400L))), (Object)laggingPartitions.apply(3));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition5, TierPartitionStatus.ERROR, 40L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)500L))), (Object)laggingPartitions.apply(4));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition2, TierPartitionStatus.ONLINE, 40L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)200L))), (Object)laggingPartitions.apply(5));
        archiver.logPartitionLagInfo(time.milliseconds());
        Assertions.assertEquals((long)480L, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLag")));
        Assertions.assertEquals((long)240L, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLagWithoutErrorPartitions")));
        Assertions.assertEquals((long)120L, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionLagMaxValue")));
        Assertions.assertEquals((int)6, (int)BoxesRunTime.unboxToInt(this.metricValue("LaggingPartitionsCount")));
        Assertions.assertEquals((long)900L, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionTimeLagMaxValue")));
        Assertions.assertEquals((double)Defaults$.MODULE$.DiskThroughputQuotaForTierArchiveBytePerSec(), (double)BoxesRunTime.unboxToDouble(this.metricValue("TierArchiverDiskThroughputQuota")));
        ((DiskThroughputListener)archiver.diskThroughputListenerOpt().get()).setQuota(1.0);
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble(this.metricValue("TierArchiverDiskThroughputQuota")));
    }

    @Test
    public void testLagCalculationWithArchivingDisabled() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicPartition partition1 = new TopicPartition("mytopic-1", 0);
        TopicPartition partition2 = new TopicPartition("mytopic-2", 0);
        TopicPartition partition3 = new TopicPartition("mytopic-3", 0);
        Map topicIdPartitionsMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToLong((long)100L), (Object)TierPartitionStatus.ONLINE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)200L), (Object)TierPartitionStatus.ONLINE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToLong((long)300L), (Object)TierPartitionStatus.ONLINE))}));
        Answer<Object> answer = new Answer<Object>(null){
            private boolean tieringEnabled;

            public boolean tieringEnabled() {
                return this.tieringEnabled;
            }

            public void tieringEnabled_$eq(boolean x$1) {
                this.tieringEnabled = x$1;
            }

            public boolean answer(InvocationOnMock invocation) {
                return this.tieringEnabled();
            }
            {
                this.tieringEnabled = true;
            }
        };
        Iterable partitions = (Iterable)topicIdPartitionsMap.map(arg_0 -> TierArchiverTest.$anonfun$testLagCalculationWithArchivingDisabled$1(replicaManager, (Answer)answer, arg_0));
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer((Answer)new Answer<Iterator<Partition>>(null, partitions){
            private final Iterable partitions$2;

            public Iterator<Partition> answer(InvocationOnMock invocation) {
                return this.partitions$2.iterator();
            }
            {
                this.partitions$2 = partitions$2;
            }
        });
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        MockTime time = new MockTime(1000L, 1000000000L);
        TierTasksConfig config = new TierTasksConfig(2, 2, 2, 1, 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
        TestUtils$.MODULE$.clearYammerMetrics();
        TierArchiver archiver = new TierArchiver(config, replicaManager, (TierTopicAppender)tierTopicManager, tierObjectStore, CancellationContext.newContext(), config.numArchiverThreads(), (Time)time, (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)archiver.diskThroughputListenerOpt().isEmpty());
        List laggingPartitions = archiver.partitionLagInfo();
        Assertions.assertEquals((int)3, (int)laggingPartitions.size());
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition3, TierPartitionStatus.ONLINE, 120L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)300L))), (Object)laggingPartitions.apply(0));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition1, TierPartitionStatus.ONLINE, 80L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)100L))), (Object)laggingPartitions.apply(1));
        Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(partition2, TierPartitionStatus.ONLINE, 40L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)200L))), (Object)laggingPartitions.apply(2));
        archiver.logPartitionLagInfo(time.milliseconds());
        Assertions.assertEquals((long)240L, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLag")));
        Assertions.assertEquals((long)900L, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionTimeLagMaxValue")));
        try {
            TierArchiverTest.reflMethod$Method1(answer.getClass()).invoke((Object)answer, BoxesRunTime.boxToBoolean((boolean)false));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        laggingPartitions = archiver.partitionLagInfo();
        Assertions.assertEquals((int)0, (int)laggingPartitions.size());
        archiver.logPartitionLagInfo(time.milliseconds());
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLag")));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionTimeLagMaxValue")));
    }

    private <T> T metricValue(String name) {
        return (T)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierArchiverTest.$anonfun$metricValue$1(name, x$2)))).values().headOption().get()).value();
    }

    public static final /* synthetic */ boolean $anonfun$testLagCalculationWithReset$1(Tuple2 x$1) {
        String string = ((MetricName)x$1._1()).getName();
        String string2 = "ArchiverE2EChecksumInvalidCount";
        return string != null && string.equals(string2);
    }

    private final void checkLag$1(int expectedSizeLag, long expectedTimeLag, TierArchiver archiver$1, TopicPartition topicPartition$1, MockTime time$1) {
        List laggingPartitions = archiver$1.partitionLagInfo();
        int expectedPartitions = expectedSizeLag > 0 ? 1 : 0;
        Assertions.assertEquals((int)expectedPartitions, (int)laggingPartitions.size());
        if (laggingPartitions.size() == 1) {
            Assertions.assertEquals((Object)new ArchiverPartitionLagInfo(topicPartition$1, TierPartitionStatus.ONLINE, (long)expectedSizeLag, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(time$1.milliseconds() - expectedTimeLag)))), (Object)laggingPartitions.apply(0));
        }
        archiver$1.logPartitionLagInfo(time$1.milliseconds());
        Assertions.assertEquals((long)expectedSizeLag, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLag")));
        Assertions.assertEquals((long)expectedSizeLag, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLagWithoutErrorPartitions")));
        Assertions.assertEquals((long)expectedSizeLag, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionLagMaxValue")));
        Assertions.assertEquals((int)expectedPartitions, (int)BoxesRunTime.unboxToInt(this.metricValue("LaggingPartitionsCount")));
        Assertions.assertEquals((long)expectedTimeLag, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionTimeLagMaxValue")));
    }

    public static final /* synthetic */ Partition $anonfun$testLagCalculationWithArchivingDisabled$1(ReplicaManager replicaManager$2, Answer answer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Tuple3 partitionInfo = (Tuple3)x0$1._2();
            int segmentSize = BoxesRunTime.unboxToInt((Object)partitionInfo._1());
            long segmentRollTime = BoxesRunTime.unboxToLong((Object)partitionInfo._2());
            TierPartitionStatus status = (TierPartitionStatus)partitionInfo._3();
            LogSegment segment = (LogSegment)Mockito.mock(LogSegment.class);
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)segment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)segmentSize));
            Mockito.when((Object)segment.lastFlushedTimeMs()).thenReturn((Object)OptionalLong.of(segmentRollTime));
            AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
            Mockito.when((Object)replicaManager$2.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
            Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)segment, (List)new .colon.colon((Object)segment, (List)new .colon.colon((Object)segment, (List)new .colon.colon((Object)segment, (List)Nil$.MODULE$)))));
            Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
            TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenAnswer(answer$1);
            Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)status);
            Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
            return partition;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, Tuple2 x$2) {
        String string = ((MetricName)x$2._1()).getName();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }
}

