/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.delete.DeletionMetrics;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTaskQueue;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\f\u0019\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00045\u0001\u0001\u0006IA\f\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019!\u0005\u0001)A\u0005o!9Q\t\u0001b\u0001\n\u00131\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u001d!\u0006A1A\u0005\u0002\u0019Ca!\u0016\u0001!\u0002\u00139\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007=\u0002\u0001\u000b\u0011\u0002-\t\u000f}\u0003!\u0019!C\u0005A\"1A\r\u0001Q\u0001\n\u0005DQ!\u001a\u0001\u0005\u0002\u0019DQ!\u001e\u0001\u0005\u0002\u0019DQa\u001e\u0001\u0005\u0002\u0019DQ!\u001f\u0001\u0005\u0002\u0019DQa\u001f\u0001\u0005\nqDq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002.\u0001!I!a\f\u0003+\u0011+G.\u001a;j_:$\u0016m]6Rk\u0016,X\rV3ti*\u0011\u0011DG\u0001\u0007I\u0016dW\r^3\u000b\u0005ma\u0012!\u0002;bg.\u001c(BA\u000f\u001f\u0003\u0011!\u0018.\u001a:\u000b\u0003}\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\r\u0002\u0007\r$\b0F\u0001/!\ty#'D\u00011\u0015\t\tD$A\u0004gKR\u001c\u0007.\u001a:\n\u0005M\u0002$aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\nA\u0001^5nKV\tq\u0007\u0005\u00029\u00056\t\u0011H\u0003\u0002;w\u0005)Q\u000f^5mg*\u0011A(P\u0001\u0007G>lWn\u001c8\u000b\u0005}q$BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001eL!aQ\u001d\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\t[\u0006DH+Y:lgV\tq\t\u0005\u0002$\u0011&\u0011\u0011\n\n\u0002\u0004\u0013:$\u0018!C7bqR\u000b7o[:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!z\taa]3sm\u0016\u0014\u0018B\u0001*P\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0016M\u0016t7-\u001a3TK\u001elWM\u001c;t\t\u0016d\u0017-_'t\u0003Y1WM\\2fIN+w-\\3oiN$U\r\\1z\u001bN\u0004\u0013a\u0004;jKJ$\u0016m]6t\u0007>tg-[4\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u000e\u0002\r\r|gNZ5h\u0013\ti&LA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003A!\u0018.\u001a:UCN\\7oQ8oM&<\u0007%A\teK2,G/[8o)\u0006\u001c8.U;fk\u0016,\u0012!\u0019\t\u0003W\tL!a\u0019\r\u0003#\u0011+G.\u001a;j_:$\u0016m]6Rk\u0016,X-\u0001\neK2,G/[8o)\u0006\u001c8.U;fk\u0016\u0004\u0013\u0001\u0006;fgR\u0004v\u000e\u001c7UCN\\wJ\u001d3fe&tw\rF\u0001h!\t\u0019\u0003.\u0003\u0002jI\t!QK\\5uQ\t\u00012\u000e\u0005\u0002mg6\tQN\u0003\u0002o_\u0006\u0019\u0011\r]5\u000b\u0005A\f\u0018a\u00026va&$XM\u001d\u0006\u0003e\u0002\u000bQA[;oSRL!\u0001^7\u0003\tQ+7\u000f^\u0001\u000ei\u0016\u001cHoU8siR\u000b7o[:)\u0005EY\u0017A\b;fgR\u001cF/\u0019;f)J\fgn]5uS>t7oV5uQ\u001a+gnY3eQ\t\u00112.\u0001\u000buKN$8\u000b^1uKR\u0013\u0018M\\:ji&|gn\u001d\u0015\u0003'-\f1b]8si\u0016$G+Y:lgV\tQ\u0010E\u0003\u007f\u0003\u001b\t\u0019BD\u0002\u0000\u0003\u0013qA!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0001\u0013A\u0002\u001fs_>$h(C\u0001&\u0013\r\tY\u0001J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty!!\u0005\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0017!\u0003\u0003BA\u000b\u0003/i\u0011\u0001H\u0005\u0004\u00033a\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003U)\b\u000fZ1uK2\u000b7\u000f\u001e)s_\u000e,7o]3e\u001bN$RaZA\u0010\u0003GAq!!\t\u0016\u0001\u0004\t\u0019\"\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011QE\u000bA\u0002\u0005\u001d\u0012a\u00047bgR\u0004&o\\2fgN,G-T:\u0011\u0007\r\nI#C\u0002\u0002,\u0011\u0012A\u0001T8oO\u0006\t\"/\u001a;f]RLwN\\'fi\u0006$\u0017\r^1\u0015\t\u0005E\u0012q\n\t\u0005\u0003g\tIE\u0004\u0003\u00026\u0005\u0015c\u0002BA\u001c\u0003\u0007rA!!\u000f\u0002B9!\u00111HA \u001d\u0011\t\t!!\u0010\n\u0003}I!!\b\u0010\n\u0005ma\u0012BA\r\u001b\u0013\r\t9\u0005G\u0001\r\t\u0016dW\r^5p]R\u000b7o[\u0005\u0005\u0003\u0017\niE\u0001\fEK2,G/Z!t\u0019\u0016\fG-\u001a:NKR\fG-\u0019;b\u0015\r\t9\u0005\u0007\u0005\u0007\u0003#2\u0002\u0019A$\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b")
public class DeletionTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final Time time = new MockTime();
    private final int maxTasks;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final int fencedSegmentsDelayMs;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(this.maxTasks(), this.maxTasks(), this.maxTasks(), 1, (long)this.fencedSegmentsDelayMs(), 5L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
    private final DeletionTaskQueue deletionTaskQueue = new DeletionTaskQueue(this.ctx(), this.maxTasks(), this.time(), this.replicaManager(), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));

    private CancellationContext ctx() {
        return this.ctx;
    }

    private Time time() {
        return this.time;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public int fencedSegmentsDelayMs() {
        return this.fencedSegmentsDelayMs;
    }

    private TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    private DeletionTaskQueue deletionTaskQueue() {
        return this.deletionTaskQueue;
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.updateLastProcessedMs(partition_1, 5L);
        this.updateLastProcessedMs(partition_2, 10L);
        this.updateLastProcessedMs(partition_3, 1L);
        this.updateLastProcessedMs(partition_4, 15L);
        List tasks = (List)this.deletionTaskQueue().poll().get();
        Assertions.assertEquals((Object)this.sortedTasks().take(this.maxTasks()), (Object)tasks.map((Function1 & Serializable)x$1 -> x$1.topicIdPartition()).toList());
    }

    @Test
    public void testSortTasks() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        DeletionTask task_1 = new DeletionTask(this.ctx().subContext(), partition_1, (DeletionTask.State)new DeletionTask.CollectDeletableObjects((DeletionTask.StateMetadata)this.retentionMetadata(0)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_2 = new DeletionTask(this.ctx().subContext(), partition_2, (DeletionTask.State)new DeletionTask.CollectDeletableObjects((DeletionTask.StateMetadata)this.retentionMetadata(1)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_3 = new DeletionTask(this.ctx().subContext(), partition_3, (DeletionTask.State)new DeletionTask.Delete((DeletionTask.StateMetadata)this.retentionMetadata(0), Optional.of(new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1)))), (Queue)Mockito.mock(Queue.class)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_4 = new DeletionTask(this.ctx().subContext(), partition_4, (DeletionTask.State)new DeletionTask.CompleteDelete((DeletionTask.StateMetadata)this.retentionMetadata(0), Optional.of(new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1)))), (Queue)Mockito.mock(Queue.class)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_5 = new DeletionTask(this.ctx().subContext(), partition_5, (DeletionTask.State)new DeletionTask.InitiateDelete((DeletionTask.StateMetadata)this.retentionMetadata(0), Optional.of(new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(1)))), (Queue)Mockito.mock(Queue.class), 0L), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
        task_1.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 100L))));
        task_2.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 300L))));
        task_3.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() + 100L))));
        task_4.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 200L))));
        task_5.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() + 200L))));
        .colon.colon taskList = new .colon.colon((Object)task_1, (List)new .colon.colon((Object)task_2, (List)new .colon.colon((Object)task_3, (List)new .colon.colon((Object)task_4, (List)new .colon.colon((Object)task_5, (List)Nil$.MODULE$)))));
        List sortedTasks = this.deletionTaskQueue().sortTasks((List)taskList);
        Assertions.assertEquals((int)taskList.size(), (int)sortedTasks.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeletionTask[]{task_3, task_4, task_5})), (Object)sortedTasks.take(3).toSet());
        Assertions.assertEquals((Object)task_2, (Object)sortedTasks.apply(3));
        Assertions.assertEquals((Object)task_1, (Object)sortedTasks.apply(4));
    }

    @Test
    public void testStateTransitionsWithFenced() {
        TierTopicAppender tierTopicAppender = (TierTopicAppender)Mockito.mock(TierTopicAppender.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        ObjectMetadata tierObjectMetadata = (ObjectMetadata)Mockito.mock(ObjectMetadata.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        MergedLog log = (MergedLog)Mockito.mock(MergedLog.class);
        TierLogSegment tieredLogSegment = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        UUID objectId = UUID.randomUUID();
        long fileDeleteDelayMs = 19000L;
        Properties properties = new Properties();
        properties.put("retention.ms", "1");
        properties.put("file.delete.delay.ms", Long.toString(fileDeleteDelayMs));
        LogConfig logConfig = new LogConfig((Map)properties);
        Mockito.when((Object)tierTopicAppender.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.replicaManager().getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tieredLogSegments()).thenAnswer((Answer)new Answer<Iterator<TierLogSegment>>(null, tieredLogSegment){
            private final TierLogSegment tieredLogSegment$1;

            public Iterator<TierLogSegment> answer(InvocationOnMock invocation) {
                return new .colon.colon((Object)this.tieredLogSegment$1, (List)Nil$.MODULE$).iterator();
            }
            {
                this.tieredLogSegment$1 = tieredLogSegment$1;
            }
        });
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.firstNotDeletableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Mockito.when((Object)tierPartitionState.topicIdPartition()).thenReturn(Optional.of(topicIdPartition));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        Mockito.when((Object)tieredLogSegment.metadata()).thenReturn((Object)tierObjectMetadata);
        Mockito.when((Object)tieredLogSegment.objectId()).thenReturn((Object)objectId);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.fencedSegments()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TierLogSegment(topicIdPartition, new SegmentState(0, UUID.randomUUID(), 100L, 100L, 3252334L, 1000L, 1000L, 102, TierObjectMetadata.State.SEGMENT_FENCED, true, false, false, TierUploadType.Archive, OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 0L, Optional.empty())), (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)tierObjectMetadata.topicIdPartition()).thenReturn((Object)topicIdPartition);
        Mockito.when((Object)tierObjectMetadata.objectId()).thenReturn((Object)objectId);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, 0));
        long nowMs = this.time().hiResClockMs();
        DeletionTask task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        Assertions.assertEquals(DeletionTask.CollectDeletableObjects.class, task.state().getClass());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.pausedUntil());
        Future future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertEquals((Object)new Some((Object)Instant.ofEpochMilli(nowMs + (long)this.fencedSegmentsDelayMs())), (Object)task.pausedUntil());
        this.deletionTaskQueue().done((TierTask)task);
        Assertions.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assertions.assertEquals((int)1, (int)this.deletionTaskQueue().taskCount());
        this.time().sleep((long)(this.fencedSegmentsDelayMs() + 1));
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertFalse((boolean)task.pausedUntil().isDefined());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
    }

    @Test
    public void testStateTransitions() {
        TierTopicAppender tierTopicAppender = (TierTopicAppender)Mockito.mock(TierTopicAppender.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        ObjectMetadata tierObjectMetadata1 = (ObjectMetadata)Mockito.mock(ObjectMetadata.class);
        ObjectMetadata tierObjectMetadata2 = (ObjectMetadata)Mockito.mock(ObjectMetadata.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        MergedLog log = (MergedLog)Mockito.mock(MergedLog.class);
        TierLogSegment tieredLogSegment1 = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        TierLogSegment tieredLogSegment2 = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        long fileDeleteDelayMs = 19000L;
        Properties properties = new Properties();
        properties.put("retention.ms", "1");
        properties.put("file.delete.delay.ms", Long.toString(fileDeleteDelayMs));
        LogConfig logConfig = new LogConfig((Map)properties);
        Mockito.when((Object)tierTopicAppender.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.replicaManager().getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tieredLogSegments()).thenAnswer((Answer)new Answer<Iterator<TierLogSegment>>(null, tieredLogSegment1, tieredLogSegment2){
            private final TierLogSegment tieredLogSegment1$1;
            private final TierLogSegment tieredLogSegment2$1;

            public Iterator<TierLogSegment> answer(InvocationOnMock invocation) {
                return new .colon.colon((Object)this.tieredLogSegment1$1, (List)new .colon.colon((Object)this.tieredLogSegment2$1, (List)Nil$.MODULE$)).iterator();
            }
            {
                this.tieredLogSegment1$1 = tieredLogSegment1$1;
                this.tieredLogSegment2$1 = tieredLogSegment2$1;
            }
        });
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.firstNotDeletableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Mockito.when((Object)tierPartitionState.topicIdPartition()).thenReturn(Optional.of(topicIdPartition));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment1.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment1.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment1.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        Mockito.when((Object)tieredLogSegment1.metadata()).thenReturn((Object)tierObjectMetadata1);
        Mockito.when((Object)tieredLogSegment1.objectId()).thenReturn((Object)objectId1);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment2.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment2.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment2.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)99L));
        Mockito.when((Object)tieredLogSegment2.metadata()).thenReturn((Object)tierObjectMetadata2);
        Mockito.when((Object)tieredLogSegment2.objectId()).thenReturn((Object)objectId2);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.fencedSegments()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        Mockito.when((Object)tierObjectMetadata1.topicIdPartition()).thenReturn((Object)topicIdPartition);
        Mockito.when((Object)tierObjectMetadata1.objectId()).thenReturn((Object)objectId1);
        Mockito.when((Object)tierObjectMetadata2.topicIdPartition()).thenReturn((Object)topicIdPartition);
        Mockito.when((Object)tierObjectMetadata2.objectId()).thenReturn((Object)objectId2);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, 0));
        long nowMs = this.time().hiResClockMs();
        DeletionTask task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        Assertions.assertEquals(DeletionTask.CollectDeletableObjects.class, task.state().getClass());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.pausedUntil());
        Future future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertEquals((Object)new Some((Object)Instant.ofEpochMilli(nowMs + fileDeleteDelayMs)), (Object)task.pausedUntil());
        this.deletionTaskQueue().done((TierTask)task);
        Assertions.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assertions.assertEquals((int)1, (int)this.deletionTaskQueue().taskCount());
        this.time().sleep(fileDeleteDelayMs + 1L);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertFalse((boolean)task.pausedUntil().isDefined());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableOps)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
    }

    private List<TopicIdPartition> sortedTasks() {
        return (List)this.deletionTaskQueue().withAllTasks((Function1 & Serializable)tasks -> ((List)tasks.toList().sortBy((Function1 & Serializable)x$2 -> x$2.lastProcessedMs(), Ordering$.MODULE$.Option((Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable)x$3 -> x$3.topicIdPartition()));
    }

    private void updateLastProcessedMs(TopicIdPartition topicIdPartition, long lastProcessedMs) {
        this.deletionTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            DeletionTaskQueueTest.$anonfun$updateLastProcessedMs$1(topicIdPartition, lastProcessedMs, tasks);
            return BoxedUnit.UNIT;
        });
    }

    private DeletionTask.DeleteAsLeaderMetadata retentionMetadata(int leaderEpoch) {
        return new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), leaderEpoch);
    }

    public static final /* synthetic */ boolean $anonfun$updateLastProcessedMs$2(TopicIdPartition topicIdPartition$1, DeletionTask x$4) {
        TopicIdPartition topicIdPartition = x$4.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition$1) : topicIdPartition$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateLastProcessedMs$1(TopicIdPartition topicIdPartition$1, long lastProcessedMs$1, Set tasks) {
        ((DeletionTask)tasks.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeletionTaskQueueTest.$anonfun$updateLastProcessedMs$2(topicIdPartition$1, x$4))).get()).lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)lastProcessedMs$1)));
    }

    public DeletionTaskQueueTest() {
        this.maxTasks = 3;
        this.fencedSegmentsDelayMs = 61000;
    }
}

