/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.TierReplicaComponents;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.delete.TierDeletionManager;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\f\u0018\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019a\u0004\u0001)A\u0005m!9Q\b\u0001b\u0001\n\u0013q\u0004BB#\u0001A\u0003%q\bC\u0004G\u0001\t\u0007I\u0011B$\t\r9\u0003\u0001\u0015!\u0003I\u0011\u001dy\u0005A1A\u0005\nACa!\u0018\u0001!\u0002\u0013\t\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007K\u0002\u0001\u000b\u0011\u00021\t\u000f\u0019\u0004!\u0019!C\u0005O\"11\u000e\u0001Q\u0001\n!DQ\u0001\u001c\u0001\u0005\n5Dq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005]\u0003\u0001\"\u0001\u0002@!9\u00111\f\u0001\u0005\u0002\u0005}\u0002bBA0\u0001\u0011\u0005\u0011q\b\u0002\u0018)&,'\u000fR3mKRLwN\\'b]\u0006<WM\u001d+fgRT!\u0001G\r\u0002\r\u0011,G.\u001a;f\u0015\tQ2$A\u0003uCN\\7O\u0003\u0002\u001d;\u0005!A/[3s\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u0018\u0003\r\u0019G\u000f_\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001gG\u0001\bM\u0016$8\r[3s\u0013\t\u0011tFA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0003dib\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002mA\u0011qGO\u0007\u0002q)\u0011\u0011(H\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mB$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u000e\u0002\u000bQ|\u0007/[2\n\u0005\u0011\u000b%!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3fe\u0006\u0011B/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:!\u0003=!\u0018.\u001a:PE*,7\r^*u_J,W#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0005-[\u0012!B:u_J,\u0017BA'K\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017\u0001\u0005;jKJ|%M[3diN#xN]3!\u0003\u0011!\u0018.\\3\u0016\u0003E\u0003\"AU.\u000e\u0003MS!\u0001V+\u0002\tU$\u0018\u000e\u001c\u0006\u0003sYS!AH,\u000b\u0005aK\u0016AB1qC\u000eDWMC\u0001[\u0003\ry'oZ\u0005\u00039N\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0007G>tg-[4\u0016\u0003\u0001\u0004\"!Y2\u000e\u0003\tT!AX\r\n\u0005\u0011\u0014'a\u0004+jKJ$\u0016m]6t\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005Y1.\u00194lC\u000e{gNZ5h+\u0005A\u0007CA\u001cj\u0013\tQ\u0007HA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001D6bM.\f7i\u001c8gS\u001e\u0004\u0013A\u00052vS2$Wj\\2l!\u0006\u0014H/\u001b;j_:$\u0002B\u001c;\u0002\u0002\u0005-\u0011q\u0002\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cv\tqa\u00197vgR,'/\u0003\u0002ta\nI\u0001+\u0019:uSRLwN\u001c\u0005\u0006\u0005B\u0001\r!\u001e\t\u0003mvt!a^>\u0011\u0005a\u001cS\"A=\u000b\u0005i|\u0012A\u0002\u001fs_>$h(\u0003\u0002}G\u00051\u0001K]3eK\u001aL!A`@\u0003\rM#(/\u001b8h\u0015\ta8\u0005C\u0004\u0002\u0004A\u0001\r!!\u0002\u0002E9,XNU3uK:$\u0018n\u001c8CCN,G\rR3mKR\f'\r\\3TK\u001elWM\u001c;t!\r\u0011\u0013qA\u0005\u0004\u0003\u0013\u0019#aA%oi\"9\u0011Q\u0002\tA\u0002\u0005\u0015\u0011!\u00058v[\u001a+gnY3e'\u0016<W.\u001a8ug\"9\u0011\u0011\u0003\tA\u0002\u0005\u0015\u0011\u0001\u00068v[\u000e{W\u000e]1di\u0016$7+Z4nK:$8/A\fuKN$H+[3s\t\u0016dW\r^5p]6\u000bg.Y4feRa\u0011qCA\u000f\u0003g\t9$!\u000f\u0002<A\u0019!%!\u0007\n\u0007\u0005m1E\u0001\u0003V]&$\bbBA\u0010#\u0001\u0007\u0011\u0011E\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA\u0012\u0003[qg\u0002BA\u0013\u0003Sq1\u0001_A\u0014\u0013\u0005!\u0013bAA\u0016G\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003W\u0019\u0003bBA\u001b#\u0001\u0007\u0011\u0011E\u0001\u001dKb\u0004Xm\u0019;fIR{\u0007\u000fT1hO&tw\rU1si&$\u0018n\u001c8t\u0011\u001d\t\u0019!\u0005a\u0001\u0003\u000bAq!!\u0004\u0012\u0001\u0004\t)\u0001C\u0004\u0002\u0012E\u0001\r!!\u0002\u0002/Q,7\u000f^)vKV,\u0017\t\u001c7M'>\u0013%/Z1dQ\u0016$GCAA\fQ\r\u0011\u00121\t\t\u0005\u0003\u000b\n\u0019&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001b\ny%A\u0004kkBLG/\u001a:\u000b\u0007\u0005E\u0013,A\u0003kk:LG/\u0003\u0003\u0002V\u0005\u001d#\u0001\u0002+fgR\f!\u0003^3tiF+X-^3BY24UM\\2fI\"\u001a1#a\u0011\u0002+Q,7\u000f^)vKV,\u0017\t\u001c7D_6\u0004\u0018m\u0019;fI\"\u001aA#a\u0011\u0002\u0013Q,7\u000f^'jq\u0016$\u0007fA\u000b\u0002D\u0001")
public class TierDeletionManagerTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TierTopicAppender tierTopicAppender = (TierTopicAppender)Mockito.mock(TierTopicAppender.class);
    private final TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final MockTime time = new MockTime(1000L, 1000000000L);
    private final TierTasksConfig config = new TierTasksConfig(2, 2, 2, 1, 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
    private final KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);

    private CancellationContext ctx() {
        return this.ctx;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private TierTopicAppender tierTopicAppender() {
        return this.tierTopicAppender;
    }

    private TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    private MockTime time() {
        return this.time;
    }

    private TierTasksConfig config() {
        return this.config;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    private Partition buildMockPartition(String topic, int numRetentionBasedDeletableSegments, int numFencedSegments, int numCompactedSegments) {
        TopicIdPartition tpid = new TopicIdPartition(topic, UUID.randomUUID(), 0);
        TopicPartition topicPartition = tpid.topicPartition();
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log.isTierMetadataStateRecovering())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        List retentionBasedDeletableSegments = (List)package$.MODULE$.List().tabulate(numRetentionBasedDeletableSegments, (Function1 & Serializable)i -> TierDeletionManagerTest.segmentWithOffset$1(BoxesRunTime.unboxToInt((Object)i) * 10, tpid));
        IntRef offset = IntRef.create((int)(numRetentionBasedDeletableSegments * 10));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.firstNotDeletableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(offset.elem)));
        List fencedSegments = (List)package$.MODULE$.List().tabulate(numFencedSegments, (Function1 & Serializable)i -> TierDeletionManagerTest.$anonfun$buildMockPartition$2(offset, tpid, BoxesRunTime.unboxToInt((Object)i)));
        Mockito.when((Object)tierPartitionState.fencedSegments()).thenReturn((Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)fencedSegments).asJavaCollection());
        List compactedSegments = (List)package$.MODULE$.List().tabulate(numCompactedSegments, (Function1 & Serializable)i -> TierDeletionManagerTest.$anonfun$buildMockPartition$3(offset, tpid, BoxesRunTime.unboxToInt((Object)i)));
        Mockito.when((Object)tierPartitionState.compactedSegments()).thenReturn((Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)compactedSegments).asJavaCollection());
        Iterator tieredSegments = retentionBasedDeletableSegments.iterator().$plus$plus((Function0 & Serializable)() -> fencedSegments.iterator()).$plus$plus((Function0 & Serializable)() -> compactedSegments.iterator());
        Mockito.when((Object)log.tieredLogSegments()).thenReturn((Object)tieredSegments);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)package$.MODULE$.List().empty());
        Partition partition = Partition$.MODULE$.apply(topicPartition, (Option)None$.MODULE$, (Time)this.time(), this.replicaManager(), (Option)None$.MODULE$);
        partition.setLog(log, false);
        partition.topicId();
        return partition;
    }

    private void testTierDeletionManager(Iterable<Partition> partitions, Iterable<Partition> expectedTopLaggingPartitions, int numRetentionBasedDeletableSegments, int numFencedSegments, int numCompactedSegments) {
        Mockito.when((Object)this.replicaManager().leaderPartitionsIterator()).thenReturn((Object)partitions.iterator());
        TierDeletionManager tierDeletionManager = new TierDeletionManager(this.replicaManager(), this.tierTopicAppender(), this.tierObjectStore(), this.ctx().subContext(), Integer.MAX_VALUE, this.config(), (Time)this.time(), ExecutionContext.Implicits$.MODULE$.global());
        Seq candidateSegmentsForDeletion = tierDeletionManager.collectAllCandidateSegmentsForDeletion();
        Assertions.assertEquals((long)(numRetentionBasedDeletableSegments + numFencedSegments + numCompactedSegments), (long)tierDeletionManager.tierSegmentDeletionQueueSize());
        Seq topTpids = tierDeletionManager.topLaggingPartitions(candidateSegmentsForDeletion, expectedTopLaggingPartitions.size());
        Assertions.assertEquals((Object)expectedTopLaggingPartitions.map((Function1 & Serializable)x$1 -> x$1.topicPartition()), (Object)topTpids.map((Function1 & Serializable)x$2 -> ((TopicIdPartition)x$2._1()).topicPartition()));
    }

    @Test
    public void testQueueAllLSOBreached() {
        int n = 0;
        int n2 = 0;
        int n3 = 3;
        Partition partition = this.buildMockPartition("alllsobreached", n3, n2, n);
        this.testTierDeletionManager((Iterable<Partition>)new .colon.colon((Object)partition, (List)Nil$.MODULE$), (Iterable<Partition>)new .colon.colon((Object)partition, (List)Nil$.MODULE$), n3, n2, n);
    }

    @Test
    public void testQueueAllFenced() {
        int n = 0;
        int n2 = 3;
        int n3 = 0;
        Partition partition = this.buildMockPartition("allfenced", n3, n2, n);
        this.testTierDeletionManager((Iterable<Partition>)new .colon.colon((Object)partition, (List)Nil$.MODULE$), (Iterable<Partition>)new .colon.colon((Object)partition, (List)Nil$.MODULE$), n3, n2, n);
    }

    @Test
    public void testQueueAllCompacted() {
        int n = 3;
        int n2 = 0;
        int n3 = 0;
        Partition partition = this.buildMockPartition("allcompacted", n3, n2, n);
        this.testTierDeletionManager((Iterable<Partition>)new .colon.colon((Object)partition, (List)Nil$.MODULE$), (Iterable<Partition>)new .colon.colon((Object)partition, (List)Nil$.MODULE$), n3, n2, n);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMixed() {
        void var5_11;
        int n = 2;
        int n2 = 1;
        int n3 = 1;
        Partition p1 = this.buildMockPartition("mixed-p1", n3, n2, n);
        int n4 = 5;
        int n5 = 1;
        int n6 = 7;
        Partition p2 = this.buildMockPartition("mixed-p2", n6, n5, n4);
        int n7 = 2;
        int n8 = 0;
        int r3 = 4;
        Partition p3 = this.buildMockPartition("mixed-p3", (int)var5_11, n8, n7);
        this.testTierDeletionManager((Iterable<Partition>)new .colon.colon((Object)p1, (List)new .colon.colon((Object)p2, (List)new .colon.colon((Object)p3, (List)Nil$.MODULE$))), (Iterable<Partition>)new .colon.colon((Object)p2, (List)new .colon.colon((Object)p3, (List)Nil$.MODULE$)), n3 + n6 + var5_11, n2 + n5 + n8, n + n4 + n7);
    }

    private static final TierLogSegment segmentWithOffset$1(long offset, TopicIdPartition tpid$1) {
        ObjectMetadata metadata = (ObjectMetadata)Mockito.mock(ObjectMetadata.class);
        Mockito.when((Object)metadata.topicIdPartition()).thenReturn((Object)tpid$1);
        TierLogSegment segment = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segment.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)offset));
        Mockito.when((Object)segment.metadata()).thenReturn((Object)metadata);
        return segment;
    }

    public static final /* synthetic */ TierLogSegment $anonfun$buildMockPartition$2(IntRef offset$1, TopicIdPartition tpid$1, int i) {
        offset$1.elem += i * 10;
        return TierDeletionManagerTest.segmentWithOffset$1(offset$1.elem, tpid$1);
    }

    public static final /* synthetic */ TierLogSegment $anonfun$buildMockPartition$3(IntRef offset$1, TopicIdPartition tpid$1, int i) {
        offset$1.elem += i * 10;
        return TierDeletionManagerTest.segmentWithOffset$1(offset$1.elem, tpid$1);
    }

    public TierDeletionManagerTest() {
        Mockito.when((Object)this.replicaManager().config()).thenReturn((Object)this.kafkaConfig());
        Mockito.when((Object)this.replicaManager().tierReplicaComponents()).thenReturn(Mockito.mock(TierReplicaComponents.class));
        Mockito.when((Object)this.replicaManager().executor()).thenReturn(Mockito.mock(ExecutorService.class));
    }
}

