/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import java.io.Serializable;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u000e\u001d\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001b\u0001\n\u0003\u0001\u0005B\u0002)\u0001A\u0003%\u0011\tC\u0004R\u0001\t\u0007I\u0011\u0001*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\u0002aCa!\u0017\u0001!\u0002\u0013I\u0005b\u0002.\u0001\u0005\u0004%\t\u0001\u0017\u0005\u00077\u0002\u0001\u000b\u0011B%\t\u000fq\u0003!\u0019!C\u00011\"1Q\f\u0001Q\u0001\n%CqA\u0018\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004`\u0001\u0001\u0006I!\u0013\u0005\u0006A\u0002!I!\u0019\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\u0006\u007f\u0002!\t!\u001d\u0005\u0007\u0003\u0007\u0001A\u0011A9\t\r\u0005\u001d\u0001\u0001\"\u0001r\u0011\u0019\tY\u0001\u0001C\u0001c\"1\u0011q\u0002\u0001\u0005\u0002EDa!a\u0005\u0001\t\u0003\t(!H'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u)\u0006\u001c8.U;fk\u0016$Vm\u001d;\u000b\u0005uq\u0012\u0001C:oCB\u001c\bn\u001c;\u000b\u0005}\u0001\u0013!\u0002;bg.\u001c(BA\u0011#\u0003\u0011!\u0018.\u001a:\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u000f\u0002\u0007\r$\b0F\u00013!\t\u0019d'D\u00015\u0015\t)\u0004%A\u0004gKR\u001c\u0007.\u001a:\n\u0005]\"$aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\n\u0001\"\\1y)\u0006\u001c8n]\u000b\u0002wA\u0011q\u0005P\u0005\u0003{!\u00121!\u00138u\u0003%i\u0017\r\u001f+bg.\u001c\b%\u0001\u0004mC\u001el\u0015\r]\u000b\u0002\u0003B!!iR%N\u001b\u0005\u0019%B\u0001#F\u0003\u001diW\u000f^1cY\u0016T!A\u0012\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002I\u0007\n\u0019Q*\u00199\u0011\u0005)[U\"\u0001\u0011\n\u00051\u0003#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\t9c*\u0003\u0002PQ\t!Aj\u001c8h\u0003\u001da\u0017mZ'ba\u0002\n\u0011c\u001d8baNDw\u000e\u001e+bg.\fV/Z;f+\u0005\u0019\u0006CA\u0018U\u0013\t)FDA\rNKR\fG-\u0019;b':\f\u0007o\u001d5piR\u000b7o[)vKV,\u0017AE:oCB\u001c\bn\u001c;UCN\\\u0017+^3vK\u0002\nq\u0001^8qS\u000e|\u0016'F\u0001J\u0003!!x\u000e]5d?F\u0002\u0013a\u0002;pa&\u001cwLM\u0001\ti>\u0004\u0018nY03A\u00059Ao\u001c9jG~\u001b\u0014\u0001\u0003;pa&\u001cwl\r\u0011\u0002\u000fQ|\u0007/[2`i\u0005AAo\u001c9jG~#\u0004%A\u0003mC\u001e4e\u000e\u0006\u0002NE\")1M\u0005a\u0001I\u0006!A/Y:l!\tyS-\u0003\u0002g9\t!R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e+bg.\f\u0011\"\u001e9eCR,G*Y4\u0015\u0007%dg\u000e\u0005\u0002(U&\u00111\u000e\u000b\u0002\u0005+:LG\u000fC\u0003n'\u0001\u0007\u0011*\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\")qn\u0005a\u0001\u001b\u0006\u0019A.Y4\u0002\u001dQ,7\u000f\u001e*f[>4X\rV1tWR\t\u0011\u000e\u000b\u0002\u0015gB\u0011A/`\u0007\u0002k*\u0011ao^\u0001\u0004CBL'B\u0001=z\u0003\u001dQW\u000f]5uKJT!A_>\u0002\u000b),h.\u001b;\u000b\u0003q\f1a\u001c:h\u0013\tqXO\u0001\u0003UKN$\u0018\u0001\u0006;fgR\u0004v\u000e\u001c7UCN\\wJ\u001d3fe&tw\r\u000b\u0002\u0016g\u0006aB/Z:u!>dGn\u00165f]2+7o\u001d+iC:l\u0015\r\u001f+bg.\u001c\bF\u0001\ft\u0003q!Xm\u001d;Q_2dw\u000b[3o\u001b>\u0014X\r\u00165b]6\u000b\u0007\u0010V1tWND#aF:\u00027Q,7\u000f^!eIJ+\u0007\u000f\\1dKN,\u00050[:uS:<G+Y:lQ\tA2/A\u0007uKN$XI\u001d:peR\u000b7o\u001b\u0015\u00033M\fa\u0003^3tiJ+Wn\u001c<f\u0003:$WI\u001d:peR\u000b7o\u001b\u0015\u00035M\u0004")
public class MetadataSnapshotTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final int maxTasks;
    private final Map<TopicIdPartition, Object> lagMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MetadataSnapshotTaskQueue snapshotTaskQueue = new MetadataSnapshotTaskQueue(this.ctx(), this.maxTasks(), (Time)new MockTime(), (Function1 & Serializable)task -> BoxesRunTime.boxToLong((long)this.lagFn(task)), new MetadataSnapshotMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 0);
    private final TopicIdPartition topic_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
    private final TopicIdPartition topic_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
    private final TopicIdPartition topic_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
    private final TopicIdPartition topic_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);

    public CancellationContext ctx() {
        return this.ctx;
    }

    public int maxTasks() {
        return this.maxTasks;
    }

    public Map<TopicIdPartition, Object> lagMap() {
        return this.lagMap;
    }

    public MetadataSnapshotTaskQueue snapshotTaskQueue() {
        return this.snapshotTaskQueue;
    }

    public TopicIdPartition topic_1() {
        return this.topic_1;
    }

    public TopicIdPartition topic_2() {
        return this.topic_2;
    }

    public TopicIdPartition topic_3() {
        return this.topic_3;
    }

    public TopicIdPartition topic_4() {
        return this.topic_4;
    }

    private long lagFn(MetadataSnapshotTask task) {
        return BoxesRunTime.unboxToLong((Object)this.lagMap().apply((Object)task.topicIdPartition()));
    }

    private void updateLag(TopicIdPartition topicIdPartition, long lag) {
        this.lagMap().update((Object)topicIdPartition, (Object)BoxesRunTime.boxToLong((long)lag));
    }

    @Test
    public void testRemoveTask() {
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        this.snapshotTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(this.topic_1()));
        this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            MetadataSnapshotTaskQueueTest.$anonfun$testRemoveTask$1(this, tasks);
            return BoxedUnit.UNIT;
        });
        this.snapshotTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(this.topic_3()));
        this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            MetadataSnapshotTaskQueueTest.$anonfun$testRemoveTask$3(this, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPollTaskOrdering() {
        this.updateLag(this.topic_1(), 2L);
        this.updateLag(this.topic_2(), 3L);
        this.updateLag(this.topic_3(), 1L);
        this.updateLag(this.topic_4(), 4L);
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        Assertions.assertEquals((Object)new .colon.colon((Object)this.topic_3(), (List)new .colon.colon((Object)this.topic_1(), (List)new .colon.colon((Object)this.topic_2(), (List)Nil$.MODULE$))), (Object)((List)this.snapshotTaskQueue().poll().get()).map((Function1 & Serializable)x$3 -> x$3.topicIdPartition()));
    }

    @Test
    public void testPollWhenLessThanMaxTasks() {
        this.updateLag(this.topic_1(), 2L);
        this.updateLag(this.topic_2(), 0L);
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        Assertions.assertEquals((Object)new .colon.colon((Object)this.topic_2(), (List)new .colon.colon((Object)this.topic_1(), (List)Nil$.MODULE$)), (Object)((List)this.snapshotTaskQueue().poll().get()).map((Function1 & Serializable)x$4 -> x$4.topicIdPartition()));
    }

    @Test
    public void testPollWhenMoreThanMaxTasks() {
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        this.updateLag(this.topic_1(), 4L);
        this.updateLag(this.topic_2(), 3L);
        this.updateLag(this.topic_3(), 2L);
        this.updateLag(this.topic_4(), 1L);
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        Assertions.assertEquals((Object)new .colon.colon((Object)this.topic_4(), (List)new .colon.colon((Object)this.topic_3(), (List)new .colon.colon((Object)this.topic_2(), (List)Nil$.MODULE$))), (Object)((List)this.snapshotTaskQueue().poll().get()).map((Function1 & Serializable)x$5 -> x$5.topicIdPartition()));
    }

    @Test
    public void testAddReplacesExistingTask() {
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 1));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 2));
        this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            MetadataSnapshotTaskQueueTest.$anonfun$testAddReplacesExistingTask$1(this, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testErrorTask() {
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        MetadataSnapshotTask task_1 = (MetadataSnapshotTask)((Option)this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> tasks.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetadataSnapshotTaskQueueTest.$anonfun$testErrorTask$2(this, x$10))))).get();
        task_1.cancelAndSetErrorState((Throwable)new Exception("test"));
        this.snapshotTaskQueue().done((TierTask)task_1);
        Assertions.assertEquals((int)1, (int)this.snapshotTaskQueue().errorPartitionCount());
        this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            MetadataSnapshotTaskQueueTest.$anonfun$testErrorTask$3(this, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndErrorTask() {
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_1(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_2(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_3(), 0));
        this.snapshotTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(this.topic_4(), 0));
        MetadataSnapshotTask task_1 = (MetadataSnapshotTask)((Option)this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> tasks.find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataSnapshotTaskQueueTest.$anonfun$testRemoveAndErrorTask$2(this, x$12))))).get();
        this.snapshotTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(this.topic_1()));
        task_1.cancelAndSetErrorState((Throwable)new Exception("test"));
        this.snapshotTaskQueue().done((TierTask)task_1);
        Assertions.assertEquals((int)0, (int)this.snapshotTaskQueue().errorPartitionCount());
        this.snapshotTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            MetadataSnapshotTaskQueueTest.$anonfun$testRemoveAndErrorTask$3(this, tasks);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$1(MetadataSnapshotTaskQueueTest $this, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{$this.topic_2(), $this.topic_3(), $this.topic_4()})), (Object)tasks.map((Function1 & Serializable)x$1 -> x$1.topicIdPartition()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$3(MetadataSnapshotTaskQueueTest $this, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{$this.topic_2(), $this.topic_4()})), (Object)tasks.map((Function1 & Serializable)x$2 -> x$2.topicIdPartition()));
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$2(MetadataSnapshotTaskQueueTest $this, MetadataSnapshotTask x$6) {
        TopicIdPartition topicIdPartition = x$6.topicIdPartition();
        TopicIdPartition topicIdPartition2 = $this.topic_1();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$3(MetadataSnapshotTaskQueueTest $this, MetadataSnapshotTask x$7) {
        TopicIdPartition topicIdPartition = x$7.topicIdPartition();
        TopicIdPartition topicIdPartition2 = $this.topic_2();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$4(MetadataSnapshotTaskQueueTest $this, MetadataSnapshotTask x$8) {
        TopicIdPartition topicIdPartition = x$8.topicIdPartition();
        TopicIdPartition topicIdPartition2 = $this.topic_3();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$5(MetadataSnapshotTaskQueueTest $this, MetadataSnapshotTask x$9) {
        TopicIdPartition topicIdPartition = x$9.topicIdPartition();
        TopicIdPartition topicIdPartition2 = $this.topic_4();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public static final /* synthetic */ void $anonfun$testAddReplacesExistingTask$1(MetadataSnapshotTaskQueueTest $this, Set tasks) {
        Assertions.assertEquals((int)1, (int)((MetadataSnapshotTask)tasks.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataSnapshotTaskQueueTest.$anonfun$testAddReplacesExistingTask$2($this, x$6))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((MetadataSnapshotTask)tasks.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataSnapshotTaskQueueTest.$anonfun$testAddReplacesExistingTask$3($this, x$7))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)2, (int)((MetadataSnapshotTask)tasks.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetadataSnapshotTaskQueueTest.$anonfun$testAddReplacesExistingTask$4($this, x$8))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((MetadataSnapshotTask)tasks.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataSnapshotTaskQueueTest.$anonfun$testAddReplacesExistingTask$5($this, x$9))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)4, (int)tasks.size());
    }

    public static final /* synthetic */ boolean $anonfun$testErrorTask$2(MetadataSnapshotTaskQueueTest $this, MetadataSnapshotTask x$10) {
        TopicIdPartition topicIdPartition = x$10.topicIdPartition();
        TopicIdPartition topicIdPartition2 = $this.topic_1();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public static final /* synthetic */ void $anonfun$testErrorTask$3(MetadataSnapshotTaskQueueTest $this, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{$this.topic_2(), $this.topic_3(), $this.topic_4()})), (Object)tasks.map((Function1 & Serializable)x$11 -> x$11.topicIdPartition()));
    }

    public static final /* synthetic */ boolean $anonfun$testRemoveAndErrorTask$2(MetadataSnapshotTaskQueueTest $this, MetadataSnapshotTask x$12) {
        TopicIdPartition topicIdPartition = x$12.topicIdPartition();
        TopicIdPartition topicIdPartition2 = $this.topic_1();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndErrorTask$3(MetadataSnapshotTaskQueueTest $this, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{$this.topic_2(), $this.topic_3(), $this.topic_4()})), (Object)tasks.map((Function1 & Serializable)x$13 -> x$13.topicIdPartition()));
    }

    public MetadataSnapshotTaskQueueTest() {
        this.maxTasks = 3;
    }
}

