/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.exceptions.TierSnapshotChecksumValidationFailedException;
import kafka.tier.exceptions.TierSnapshotDelayedRetryException;
import kafka.tier.exceptions.TierSnapshotFailedException;
import kafka.tier.exceptions.TierSnapshotFencedException;
import kafka.tier.exceptions.TierSnapshotLastTakenSnapshotNotPresentAtObjectStoreException;
import kafka.tier.exceptions.TierSnapshotMostRecentSnapshotNotYetCommitted;
import kafka.tier.exceptions.TierSnapshotUnexpectedFileInSnapshotsDirException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.config.SnapshotTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask$;
import kafka.tier.tasks.snapshot.SnapshotTestUtils;
import kafka.tier.tasks.snapshot.TierMetadataSnapshotManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r]d\u0001\u0002+V\u0001yCQ!\u001a\u0001\u0005\u0002\u0019D\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00016\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00031\b\"\u0003?\u0001\u0001\u0004\u0005\t\u0015)\u0003l\u0011\u001di\b\u00011A\u0005\u0004yD\u0011\"!\u0003\u0001\u0001\u0004%\t!a\u0003\t\u000f\u0005=\u0001\u0001)Q\u0005\u007f\"Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011AA\n\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%\t!a\t\t\u0017\u0005\u001d\u0002\u00011A\u0001B\u0003&\u0011Q\u0003\u0005\f\u0003S\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0003C\u0006\u0002D\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0003bCA%\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[A1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002N!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011AA-\u0011-\ti\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0014\t\u0017\u0005}\u0003\u00011AA\u0002\u0013\u0005\u0011\u0011\r\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0003\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005\r\u0004\"CA<\u0001\t\u0007I\u0011AA=\u0011!\t9\t\u0001Q\u0001\n\u0005m\u0004\"CAE\u0001\t\u0007I\u0011AAF\u0011!\tI\n\u0001Q\u0001\n\u00055\u0005\"CAN\u0001\t\u0007I\u0011AAO\u0011!\tI\u000b\u0001Q\u0001\n\u0005}\u0005\"CAV\u0001\t\u0007I\u0011AAW\u0011!\tY\f\u0001Q\u0001\n\u0005=\u0006\"CA_\u0001\t\u0007I\u0011AA`\u0011!\ti\r\u0001Q\u0001\n\u0005\u0005\u0007\"CAh\u0001\t\u0007I\u0011AAi\u0011!\tI\u000e\u0001Q\u0001\n\u0005M\u0007\"CAn\u0001\t\u0007I\u0011AAo\u0011!\t)\u000f\u0001Q\u0001\n\u0005}\u0007\"CAt\u0001\t\u0007I\u0011AAu\u0011!\t9\u0010\u0001Q\u0001\n\u0005-\b\"CA}\u0001\t\u0007I\u0011AA~\u0011!\u0011\u0019\u0001\u0001Q\u0001\n\u0005u\b\"\u0003B\u0003\u0001\t\u0007I\u0011AA~\u0011!\u00119\u0001\u0001Q\u0001\n\u0005u\b\"\u0003B\u0005\u0001\t\u0007I\u0011\u0001B\u0006\u0011!\u0011y\u0002\u0001Q\u0001\n\t5\u0001\"\u0003B\u0011\u0001\t\u0007I\u0011\u0001B\u0012\u0011!\u0011Y\u0003\u0001Q\u0001\n\t\u0015\u0002\"\u0003B\u0017\u0001\t\u0007I\u0011\u0001B\u0018\u0011!\u00119\u0004\u0001Q\u0001\n\tE\u0002b\u0003B\u001d\u0001\u0001\u0007\t\u0019!C\u0001\u0005wA1Ba\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003F!Y!\u0011\n\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u001f\u0011%\u0011Y\u0005\u0001b\u0001\n\u0003\tY\u0010\u0003\u0005\u0003N\u0001\u0001\u000b\u0011BA\u007f\u0011-\u0011y\u0005\u0001a\u0001\u0002\u0004%\tA!\u0015\t\u0017\t}\u0003\u00011AA\u0002\u0013\u0005!\u0011\r\u0005\f\u0005K\u0002\u0001\u0019!A!B\u0013\u0011\u0019\u0006C\u0006\u0003h\u0001\u0001\r\u00111A\u0005\u0002\tE\u0003b\u0003B5\u0001\u0001\u0007\t\u0019!C\u0001\u0005WB1Ba\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003T!Y!\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001B:\u0011-\u0011)\t\u0001a\u0001\u0002\u0004%\tAa\"\t\u0017\t-\u0005\u00011A\u0001B\u0003&!Q\u000f\u0005\f\u0005\u001b\u0003\u0001\u0019!a\u0001\n\u0003\u0011y\tC\u0006\u0003\u0018\u0002\u0001\r\u00111A\u0005\u0002\te\u0005b\u0003BO\u0001\u0001\u0007\t\u0011)Q\u0005\u0005#C\u0011Ba(\u0001\u0005\u0004%\tA!)\t\u0011\t=\u0006\u0001)A\u0005\u0005GCqA!-\u0001\t\u0003\u0011\u0019\fC\u0004\u0003L\u0002!\tAa-\t\u000f\tU\u0007\u0001\"\u0001\u00034\"9!q\u001c\u0001\u0005\u0002\tM\u0006b\u0002Br\u0001\u0011\u0005!1\u0017\u0005\b\u0005O\u0004A\u0011\u0001BZ\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005gCqAa<\u0001\t\u0003\u0011\u0019\fC\u0004\u0003t\u0002!\tAa-\t\u000f\t]\b\u0001\"\u0001\u00034\"9!1 \u0001\u0005\u0002\tu\bbBB$\u0001\u0011\u0005!1\u0017\u0005\b\u0007\u0017\u0002A\u0011\u0001BZ\u0011\u001d\u0019y\u0005\u0001C\u0001\u0005gCqaa\u0015\u0001\t\u0003\u0011\u0019\fC\u0004\u0004X\u0001!\tAa-\t\u000f\rm\u0003\u0001\"\u0001\u00034\"91q\f\u0001\u0005\u0002\r\u0005\u0004bBB6\u0001\u0011\u00051Q\u000e\u0002\u0019\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$\u0016m]6UKN$(B\u0001,X\u0003!\u0019h.\u00199tQ>$(B\u0001-Z\u0003\u0015!\u0018m]6t\u0015\tQ6,\u0001\u0003uS\u0016\u0014(\"\u0001/\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0002E\u0006)1oY1mC&\u0011A-\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0007C\u00015\u0001\u001b\u0005)\u0016\u0001C3yK\u000e,Ho\u001c:\u0016\u0003-\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002qc\u0006!Q\u000f^5m\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^7\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\fA\"\u001a=fGV$xN]0%KF$\"a\u001e>\u0011\u0005\u0001D\u0018BA=b\u0005\u0011)f.\u001b;\t\u000fm\u001c\u0011\u0011!a\u0001W\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u0015DXmY;u_J\u0004\u0013AA3d+\u0005y\b\u0003BA\u0001\u0003\u000bi!!a\u0001\u000b\u00059\f\u0017\u0002BA\u0004\u0003\u0007\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\r\u0015\u001cw\fJ3r)\r9\u0018Q\u0002\u0005\bw\u001a\t\t\u00111\u0001\u0000\u0003\r)7\rI\u0001\u0004GRDXCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e3\u00069a-\u001a;dQ\u0016\u0014\u0018\u0002BA\u0010\u00033\u00111cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\fqa\u0019;y?\u0012*\u0017\u000fF\u0002x\u0003KA\u0001b_\u0005\u0002\u0002\u0003\u0007\u0011QC\u0001\u0005GRD\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003\u007fi!!!\r\u000b\t\u0005M\u0012QG\u0001\u0007G>lWn\u001c8\u000b\u0007q\u000b9D\u0003\u0003\u0002:\u0005m\u0012AB1qC\u000eDWM\u0003\u0002\u0002>\u0005\u0019qN]4\n\t\u0005\u0005\u0013\u0011\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003I!x\u000e]5d!\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u0007]\f9\u0005\u0003\u0005|\u0019\u0005\u0005\t\u0019AA\u0017\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\t\ty\u0005\u0005\u0003\u0002R\u0005MS\"A-\n\u0007\u0005U\u0013L\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006!Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\0%KF$2a^A.\u0011!Yx\"!AA\u0002\u0005=\u0013!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005AQn\\2l)&lW-\u0006\u0002\u0002dA!\u0011QMA6\u001b\t\t9G\u0003\u0003\u0002j\u0005E\u0012!B;uS2\u001c\u0018\u0002BA7\u0003O\u0012\u0001\"T8dWRKW.Z\u0001\r[>\u001c7\u000eV5nK~#S-\u001d\u000b\u0004o\u0006M\u0004\u0002C>\u0013\u0003\u0003\u0005\r!a\u0019\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013\u0001\u0005;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s+\t\tY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\t)W\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003\u000b\u000byH\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0006\tB/[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011Q\u0012\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*\u0019\u00111S.\u0002\rM,'O^3s\u0013\u0011\t9*!%\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0002m_\u001e,\"!a(\u0011\t\u0005\u0005\u0016QU\u0007\u0003\u0003GS1!a'\\\u0013\u0011\t9+a)\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0005Y><\u0007%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011q\u0016\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*\u0019\u0011QW.\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011XAZ\u0005%\u0001\u0016M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nq\u0002^5fe>\u0013'.Z2u'R|'/Z\u000b\u0003\u0003\u0003\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000fL\u0016!B:u_J,\u0017\u0002BAf\u0003\u000b\u0014q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0011i&,'o\u00142kK\u000e$8\u000b^8sK\u0002\n!$\u001b8NK6$\u0016.\u001a:PE*,7\r^*u_J,7i\u001c8gS\u001e,\"!a5\u0011\t\u0005\r\u0017Q[\u0005\u0005\u0003/\f)MA\u0011N_\u000e\\\u0017J\\'f[>\u0014\u0018\u0010V5fe>\u0013'.Z2u'R|'/Z\"p]\u001aLw-A\u000ej]6+W\u000eV5fe>\u0013'.Z2u'R|'/Z\"p]\u001aLw\rI\u0001\u0015S:lU-\u001c+jKJ|%M[3diN#xN]3\u0016\u0005\u0005}\u0007\u0003BAb\u0003CLA!a9\u0002F\nYRj\\2l\u0013:lU-\\8ssRKWM](cU\u0016\u001cGo\u0015;pe\u0016\fQ#\u001b8NK6$\u0016.\u001a:PE*,7\r^*u_J,\u0007%\u0001\nuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,WCAAv!\u0011\ti/a=\u000e\u0005\u0005=(bAAy3\u0006)1\u000f^1uK&!\u0011Q_Ax\u0005I!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0002'QLWM\u001d)beRLG/[8o'R\fG/\u001a\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\"!!@\u0011\u0007\u0001\fy0C\u0002\u0003\u0002\u0005\u00141!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\bt]\u0006\u00048\u000f[8u)\"\u0014X-\u00193t\u0003A\u0019h.\u00199tQ>$H\u000b\u001b:fC\u0012\u001c\b%\u0001\nt]\u0006\u00048\u000f[8u)\u0006\u001c8nQ8oM&<WC\u0001B\u0007!\u0015\u0001'q\u0002B\n\u0013\r\u0011\t\"\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tU!1D\u0007\u0003\u0005/Q1A!\u0007X\u0003\u0019\u0019wN\u001c4jO&!!Q\u0004B\f\u0005M\u0019f.\u00199tQ>$H+Y:lg\u000e{gNZ5h\u0003M\u0019h.\u00199tQ>$H+Y:l\u0007>tg-[4!\u0003=!\u0018.\u001a:UCN\\7oQ8oM&<WC\u0001B\u0013!\u0011\u0011)Ba\n\n\t\t%\"q\u0003\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\u0006\u0001B/[3s)\u0006\u001c8n]\"p]\u001aLw\rI\u0001\u0010g:\f\u0007o\u001d5pi6+GO]5dgV\u0011!\u0011\u0007\t\u0004Q\nM\u0012b\u0001B\u001b+\n9R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^'fiJL7m]\u0001\u0011g:\f\u0007o\u001d5pi6+GO]5dg\u0002\n1b[1gW\u0006\u001cuN\u001c4jOV\u0011!Q\b\t\u0005\u0003\u001f\u0013y$\u0003\u0003\u0003B\u0005E%aC&bM.\f7i\u001c8gS\u001e\fqb[1gW\u0006\u001cuN\u001c4jO~#S-\u001d\u000b\u0004o\n\u001d\u0003\u0002C>0\u0003\u0003\u0005\rA!\u0010\u0002\u0019-\fgm[1D_:4\u0017n\u001a\u0011\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\rY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0007i6\u0004H)\u001b:\u0016\u0005\tM\u0003\u0003\u0002B+\u00057j!Aa\u0016\u000b\u0007\te\u0013/\u0001\u0002j_&!!Q\fB,\u0005\u00111\u0015\u000e\\3\u0002\u0015Ql\u0007\u000fR5s?\u0012*\u0017\u000fF\u0002x\u0005GB\u0001b\u001f\u001b\u0002\u0002\u0003\u0007!1K\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u0006QAn\\4ESJ|F%Z9\u0015\u0007]\u0014i\u0007\u0003\u0005|o\u0005\u0005\t\u0019\u0001B*\u0003\u001dawn\u001a#je\u0002\nAb\u001d8baNDw\u000e^:ESJ,\"A!\u001e\u0011\t\t]$\u0011Q\u0007\u0003\u0005sRAAa\u001f\u0003~\u0005!a-\u001b7f\u0015\r\u0011y(]\u0001\u0004]&|\u0017\u0002\u0002BB\u0005s\u0012A\u0001U1uQ\u0006\u00012O\\1qg\"|Go\u001d#je~#S-\u001d\u000b\u0004o\n%\u0005\u0002C>;\u0003\u0003\u0005\rA!\u001e\u0002\u001bMt\u0017\r]:i_R\u001cH)\u001b:!\u0003%!Xm\u001d;Vi&d7/\u0006\u0002\u0003\u0012B\u0019\u0001Na%\n\u0007\tUUKA\tT]\u0006\u00048\u000f[8u)\u0016\u001cH/\u0016;jYN\fQ\u0002^3tiV#\u0018\u000e\\:`I\u0015\fHcA<\u0003\u001c\"A10PA\u0001\u0002\u0004\u0011\t*\u0001\u0006uKN$X\u000b^5mg\u0002\n\u0001\u0003Z3gCVdG/Q<bSR$\u0016.\\3\u0016\u0005\t\r\u0006\u0003\u0002BS\u0005Wk!Aa*\u000b\t\t%\u00161A\u0001\tIV\u0014\u0018\r^5p]&!!Q\u0016BT\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0011\u0003Z3gCVdG/Q<bSR$\u0016.\\3!\u0003\u0015\u0019X\r^;q)\u00059\bfA!\u00038B!!\u0011\u0018Bd\u001b\t\u0011YL\u0003\u0003\u0003>\n}\u0016aA1qS*!!\u0011\u0019Bb\u0003\u001dQW\u000f]5uKJTAA!2\u0002<\u0005)!.\u001e8ji&!!\u0011\u001aB^\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!Ia4\u0011\t\te&\u0011[\u0005\u0005\u0005'\u0014YLA\u0005BMR,'/R1dQ\u0006iB/Z:u\u0005\u00164wN]3MK\u0006$WM]*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002D\u00053\u0004BA!/\u0003\\&!!Q\u001cB^\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f\u001e\"fM>\u0014X-T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002E\u00053\f1\u0004^3tiR\u000b7o\u001b*fiJLxJ\u001c$bS2,GMU3tk2$\bfA#\u0003Z\u0006\u0019C/Z:u)\u0006\u001c8nQ1oG\u0016dG.\u0019;j_:\fe\u000eZ\"p]\u001aLw-\u00169eCR,\u0007f\u0001$\u0003Z\u0006\u0001C/Z:u':\f\u0007o\u001d5piR\u000b7o[*fiN\u0004\u0016-^:f\u001f:\u0014V\r\u001e:zQ\r9%\u0011\\\u0001@i\u0016\u001cHo\u00158baNDw\u000e^$be\n\fw-Z\"pY2,7\r^5p]^\u000b\u0017\u000e^:G_J\u001cf.\u00199tQ>$8i\\7nSR4\u0016.\u0019$uaN4E.^:iQ\rA%\u0011\\\u0001-i\u0016\u001cHo\u00158baNDw\u000e\u001e+bg.\u001c\u0015M\\2fY2,Gm\u00165f]2{w\rR5s\u0013N$U\r\\3uK\u0012D3!\u0013Bm\u0003u!Xm\u001d;T]\u0006\u00048\u000f[8u\u000f\u0006\u0014(-Y4f\u0007>dG.Z2uS>t\u0007f\u0001&\u0003Z\u0006aA/Z:u':\f\u0007o\u001d5piR\u0019qOa@\t\u000f\r\u00051\n1\u0001\u0004\u0004\u0005!\u0011\r\\4p!\u0011\u0019)aa\u0006\u000e\u0005\r\u001d!\u0002BB\u0005\u0007\u0017\t\u0001b\u00195fG.\u001cX/\u001c\u0006\u0005\u0007\u001b\u0019y!A\u0004ti>\u0014\u0018mZ3\u000b\u0007q\u001b\tB\u0003\u0003\u0004\u0014\rU\u0011!C2p]\u001adW/\u001a8u\u0015\t\u0011I&\u0003\u0003\u0004\u001a\r\u001d!!C!mO>\u0014\u0018\u000e\u001e5nQ\rY5Q\u0004\t\u0005\u0007?\u0019)#\u0004\u0002\u0004\")!11\u0005B`\u0003\u0019\u0001\u0018M]1ng&!1qEB\u0011\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\f\u0017\u000e-2qGB\u001d\u0007w\u0019i\u0004\u0005\u0003\u0004.\rMRBAB\u0018\u0015\u0011\u0019\td!\t\u0002\u0011A\u0014xN^5eKJLAa!\u000e\u00040\tQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0005\r\r\u0011!\u00028b[\u0016\u001cH\u0006BB \u0007\u0007\n#a!\u0011\u0002\u000b\u0005#E*\u0012*\"\u0005\r\u0015\u0013a\u0003(P?\u000eCUiQ&T+6\u000bQ\b^3tiNs\u0017\r]:i_R\u001cE.Z1okB$UO]5oO\u00063G/\u001a:NKR\fG-\u0019;b':\f\u0007o\u001d5piN#\u0018\r^3Ue\u0006t7/\u001b;j_:D3\u0001\u0014Bm\u0003a\"Xm\u001d;T]\u0006\u00048\u000f[8u)\u0006\\WM\\!u\u0019\u0006$XM](gMN,G\u000f\u00165b]Ns\u0017\r]:i_RLe.\u001b;jCR,wJ\u001a4tKRD3!\u0014Bm\u0003-\"Xm\u001d;T]\u0006\u00048\u000f[8u+Bdw.\u00193GC&d7\u000fR;f)>LeN^1mS\u0012\u001c\u0005.Z2lgVl\u0007f\u0001(\u0003Z\u0006\u0011D/Z:u\u00072,\u0017M\\+q\u001b>\u001cHOU3dK:$8K\\1qg\"|G/\u00118e'R\u0014\u0018-_*oCB\u001c\bn\u001c;GS2,7\u000fK\u0002P\u00053\fq\u0007^3ti\u000ecW-\u00198VaRC'o\\<t\u000bb\u001cW\r\u001d;j_:|e\u000eR3uK\u000e$\u0018n\u001c8PM:{gn\u00158baNDw\u000e\u001e$jY\u0016\u001c\bf\u0001)\u0003Z\u0006QC/Z:u\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGRLwN\\*uCR,\u0007fA)\u0003Z\u00061B/Z:u':\f\u0007o\u001d5piV+\u0018\u000eZ*fCJ\u001c\u0007\u000eF\u0002x\u0007GBqa!\u0001S\u0001\u0004\u0019\u0019\u0001K\u0002S\u0007;A3BUB\u0016\u0007o\u0019Ida\u000f\u0004j1\"1qHB\"\u0003U!Xm\u001d;QCJ\u001cXm\u00158baNDw\u000e\u001e)bi\"$2a^B8\u0011\u001d\u0019\ta\u0015a\u0001\u0007\u0007A3aUB\u000fQ-\u001961FB\u001c\u0007s\u0019Yd!\u001e-\t\r}21\t")
public class MetadataSnapshotTaskTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private CancellationContext ctx;
    private TopicPartition topicPartition;
    private TopicIdPartition topicIdPartition;
    private MockTime mockTime;
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private final TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final MockInMemoryTierObjectStoreConfig inMemTierObjectStoreConfig = new MockInMemoryTierObjectStoreConfig(Optional.of(UUID.randomUUID().toString()), Optional.of(Predef$.MODULE$.int2Integer(0)), "");
    private final MockInMemoryTierObjectStore inMemTierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), this.inMemTierObjectStoreConfig());
    private final TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
    private final int brokerId;
    private final int snapshotThreads;
    private final Option<SnapshotTasksConfig> snapshotTaskConfig = new Some((Object)new SnapshotTasksConfig(java.time.Duration.ofSeconds(30L).toMillis(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1, 15000));
    private final TierTasksConfig tierTasksConfig;
    private final MetadataSnapshotMetrics snapshotMetrics;
    private KafkaConfig kafkaConfig;
    private final int leaderEpoch;
    private File tmpDir;
    private File logDir;
    private Path snapshotsDir;
    private SnapshotTestUtils testUtils;
    private final FiniteDuration defaultAwaitTime;

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public void mockTime_$eq(MockTime x$1) {
        this.mockTime = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AbstractLog log() {
        return this.log;
    }

    public Partition partition() {
        return this.partition;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public MockInMemoryTierObjectStoreConfig inMemTierObjectStoreConfig() {
        return this.inMemTierObjectStoreConfig;
    }

    public MockInMemoryTierObjectStore inMemTierObjectStore() {
        return this.inMemTierObjectStore;
    }

    public TierPartitionState tierPartitionState() {
        return this.tierPartitionState;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int snapshotThreads() {
        return this.snapshotThreads;
    }

    public Option<SnapshotTasksConfig> snapshotTaskConfig() {
        return this.snapshotTaskConfig;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public MetadataSnapshotMetrics snapshotMetrics() {
        return this.snapshotMetrics;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public void kafkaConfig_$eq(KafkaConfig x$1) {
        this.kafkaConfig = x$1;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public Path snapshotsDir() {
        return this.snapshotsDir;
    }

    public void snapshotsDir_$eq(Path x$1) {
        this.snapshotsDir = x$1;
    }

    public SnapshotTestUtils testUtils() {
        return this.testUtils;
    }

    public void testUtils_$eq(SnapshotTestUtils x$1) {
        this.testUtils = x$1;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    @BeforeEach
    public void setup() {
        this.executor_$eq(Executors.newFixedThreadPool(this.snapshotThreads()));
        this.ctx_$eq(CancellationContext.newContext());
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka"));
        this.snapshotsDir_$eq(this.logDir().toPath().resolve("snapshots"));
        Files.createDirectory(this.snapshotsDir(), new FileAttribute[0]);
        int x$1 = this.brokerId();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = TestUtils$.MODULE$.MockZkPort();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var22_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var23_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var24_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.kafkaConfig_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21)));
        File parseTopicPartitionName_dir = this.logDir();
        Object var25_25 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        this.topicIdPartition_$eq(new TopicIdPartition(this.topicPartition().topic(), UUID.randomUUID(), this.topicPartition().partition()));
        this.mockTime_$eq(new MockTime(0L, 0L, 0L));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)this.replicaManager().onlinePartition(this.topicIdPartition().topicPartition())).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)this.log().tierPartitionState()).thenReturn((Object)this.tierPartitionState());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.log().dir()).thenReturn((Object)this.logDir());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionState().isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.tierPartitionState().tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch()));
        Mockito.when((Object)this.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch((long)this.leaderEpoch(), Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierMetadataSnapshotUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
    }

    @AfterEach
    public void tearDown() {
        this.executor().shutdownNow();
        if (this.log() != null) {
            this.log().close();
        }
        Utils.delete((File)this.tmpDir(), (boolean)false);
        Utils.delete((File)this.logDir(), (boolean)false);
        Utils.delete((File)this.snapshotsDir().toFile(), (boolean)true);
        this.ctx().cancel();
    }

    @Test
    public void testBeforeLeaderSnapshotState() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$1(true, false), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("is undergoing unclean leader recovery"), (String)"Unexpected cause for exception");
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            boolean x$2 = false;
            return (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$1(x$2, true), (Duration)this.defaultAwaitTime());
        });
        if (try_2 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }
        if (!(try_2 instanceof Failure)) {
            throw new MatchError((Object)try_2);
        }
        Throwable ex2 = ((Failure)try_2).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex2.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex2.getMessage().contains("is undergoing tier metadata recovery"), (String)"Unexpected cause for exception");
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$1(false, false), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_3 instanceof Failure) {
            Throwable ex3 = ((Failure)try_3).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex3).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        }
        throw new MatchError((Object)try_3);
    }

    @Test
    public void testBeforeMetadataSnapshotState() {
        this.mockTime().sleep(java.time.Duration.ofSeconds(10L).toMillis());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$2(java.time.Duration.ofSeconds(9L).toMillis()), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierSnapshotDelayedRetryException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("delay retry"), (String)"Unexpected cause for exception");
        this.mockTime().sleep(java.time.Duration.ofSeconds(50L).toMillis());
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$2(java.time.Duration.ofSeconds(9L).toMillis()), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex2 = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex2).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$2(-1L), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotState.class, nextState2.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_3 instanceof Failure) {
            Throwable ex3 = ((Failure)try_3).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex3).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }
        throw new MatchError((Object)try_3);
    }

    @Test
    public void testTaskRetryOnFailedResult() {
        MetadataSnapshotTask.BeforeMetadataSnapshotState state = new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch());
        MetadataSnapshotTask task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)java.time.Duration.ofSeconds(5L).toMillis()));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.FAILED));
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ERROR);
        this.mockTime().sleep(java.time.Duration.ofSeconds(100L).toMillis());
        MetadataSnapshotTask result1 = (MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result1.pausedUntil().isDefined(), (String)"task should be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"task should not be cancelled");
        Instant pauseTime1 = (Instant)result1.pausedUntil().get();
        this.mockTime().sleep(java.time.Duration.ofSeconds(100L).toMillis());
        MetadataSnapshotTask result2 = (MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"task should be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"task should not be cancelled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime1), (String)"second pause time should be greater than first pause time");
    }

    @Test
    public void testTaskCancellationAndConfigUpdate() {
        String baseNameStr = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        FileTierPartitionStateSnapshotObject snapshotMetadata = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), 123L, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, Algorithm.ADLER);
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), UUID.randomUUID(), new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        .colon.colon states = new .colon.colon((Object)new MetadataSnapshotTask.BeforeLeaderSnapshotState(this.leaderEpoch()), (List)new .colon.colon((Object)new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch()), (List)new .colon.colon((Object)new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate), (List)new .colon.colon((Object)new MetadataSnapshotTask.AfterMetadataSnapshotState(this.leaderEpoch(), this.snapshotsDir(), snapshotInitiate, snapshotMetadata), (List)new .colon.colon((Object)new MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState(this.leaderEpoch()), (List)new .colon.colon((Object)new MetadataSnapshotTask.FailedMetadataSnapshotState(this.leaderEpoch()), (List)Nil$.MODULE$))))));
        TierTasks tierTasks = new TierTasks(this.tierTasksConfig(), this.replicaManager(), (TierReplicaManager)Mockito.mock(TierReplicaManager.class), (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class), (TierTopicAppender)Mockito.mock(TierTopicManager.class), (TierObjectStore)new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(this.brokerId()))), (Time)this.mockTime(), (Option)None$.MODULE$);
        Assertions.assertEquals((int)this.tierTasksConfig().numSnapshotThreads(), (int)((ThreadPoolExecutor)tierTasks.snapshotExecutor()).getCorePoolSize());
        Assertions.assertEquals((Object)this.tierTasksConfig(), (Object)((TierMetadataSnapshotManager)tierTasks.tierMetadataSnapshotManager().get()).config());
        this.cancelledTasksDoNotProgress$1((List)states);
        int x$1 = this.tierTasksConfig().numArchiverThreads();
        int x$2 = this.tierTasksConfig().numCleanerThreads();
        int x$3 = this.tierTasksConfig().numSnapshotThreads();
        int x$4 = this.tierTasksConfig().brokerId();
        None$ x$5 = None$.MODULE$;
        long x$6 = 600000L;
        long x$7 = 500L;
        int x$8 = 50;
        int x$9 = 300000;
        boolean x$10 = false;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        TierTasksConfig newTierTasksConfig = new TierTasksConfig(x$1, x$2, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$12, (Option)x$5);
        this.disabledConfigCancelsProgress$1((List)states, newTierTasksConfig);
    }

    @Test
    public void testSnapshotTaskSetsPauseOnRetry() {
        MetadataSnapshotTask.BeforeMetadataSnapshotState state = new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch());
        MetadataSnapshotTask task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)java.time.Duration.ofSeconds(5L).toMillis()));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierMetadataRetriableException("foo"), new TierObjectStoreRetriableException("bar")});
        this.mockTime().sleep(java.time.Duration.ofSeconds(100L).toMillis());
        MetadataSnapshotTask result1 = (MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result1.pausedUntil().isDefined(), (String)"task should be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"task should not be cancelled");
        Instant pauseTime1 = (Instant)result1.pausedUntil().get();
        this.mockTime().sleep(java.time.Duration.ofSeconds(100L).toMillis());
        MetadataSnapshotTask result2 = (MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"task should be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"task should not be cancelled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime1), (String)"second pause time should be greater than first pause time");
    }

    @Test
    public void testSnapshotGarbageCollectionWaitsForSnapshotCommitViaFtpsFlush() {
        MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState state = new MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState(this.leaderEpoch());
        MetadataSnapshotTask task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        UUID committedSnapshotId = UUID.randomUUID();
        UUID latestSnapshotId = UUID.randomUUID();
        Mockito.when((Object)this.tierPartitionState().lastCommittedSnapshotId()).thenReturn((Object)committedSnapshotId);
        Mockito.when((Object)this.tierPartitionState().lastSnapshotId()).thenReturn((Object)latestSnapshotId);
        FileTierPartitionStateSnapshotObject snapshotMetadata = new FileTierPartitionStateSnapshotObject(latestSnapshotId, this.mockTime().milliseconds(), new OffsetAndEpoch(0L, Optional.empty()), this.leaderEpoch(), "test-log.tierstate", Algorithm.ADLER);
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.log().tierPartitionState()).thenReturn((Object)this.tierPartitionState());
        Assertions.assertEquals((int)task.retryCount(), (int)0);
        Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)task.pausedUntil().isDefined(), (String)"task should be delayed after FTPS flush did not take place");
        Instant expectedPauseUntilInstant = Instant.ofEpochMilli((long)((SnapshotTasksConfig)this.snapshotTaskConfig().get()).snapshotCommitIntervalMs() + this.mockTime().hiResClockMs());
        Assertions.assertEquals((Object)task.pausedUntil().get(), (Object)expectedPauseUntilInstant, (String)new StringBuilder(101).append("task should sleep for precisely snapshotCommitIntervalMs ").append("(").append(((SnapshotTasksConfig)this.snapshotTaskConfig().get()).snapshotCommitIntervalMs()).append(") ms after failing due to FTPS not flushing").toString());
        Assertions.assertEquals((int)task.retryCount(), (int)1);
        Assertions.assertFalse((boolean)task.isErrorState(), (String)"Delay due to FTPS not flushing should not be considered error state since it is retriable");
        Mockito.when((Object)this.tierPartitionState().lastCommittedSnapshotId()).thenReturn((Object)latestSnapshotId);
        String snapshotPrefix = TierPartitionStateSnapshotMetadata.pathPrefix((String)"", (TopicIdPartition)this.topicIdPartition());
        HashMap<String, Object> listKeysResult = new HashMap<String, Object>();
        listKeysResult.put(((FragmentLocation)new TierPartitionStateSnapshotMetadata(this.topicIdPartition(), snapshotMetadata).toFragmentLocation("", FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).get()).objectPath(), null);
        Mockito.when((Object)this.tierObjectStore().listObject(snapshotPrefix, false)).thenReturn(listKeysResult);
        this.mockTime().sleep((long)(((SnapshotTasksConfig)this.snapshotTaskConfig().get()).snapshotCommitIntervalMs() + 1));
        Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals(task.state().getClass(), MetadataSnapshotTask.BeforeMetadataSnapshotState.class);
    }

    @Test
    public void testSnapshotTaskCancelledWhenLogDirIsDeleted() {
        UUID snapshotId = UUID.randomUUID();
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        MetadataSnapshotTask.MetadataSnapshotState state = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate);
        MetadataSnapshotTask task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Utils.delete((File)this.logDir(), (boolean)false);
        Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)this.ctx().isCancelled(), (String)"task should be cancelled after logDir was not found");
        Assertions.assertTrue((boolean)task.isErrorState());
        Assertions.assertTrue((task.errorStates().stream().filter(t -> {
            Class<?> clazz = t.getClass();
            Class<NoSuchFileException> clazz2 = NoSuchFileException.class;
            return clazz != null && clazz.equals(clazz2);
        }).count() == 1L ? 1 : 0) != 0);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)None$.MODULE$);
        task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)this.ctx().isCancelled(), (String)"task should be cancelled after logDir was not found");
        Assertions.assertFalse((boolean)task.isErrorState());
    }

    @Test
    public void testSnapshotGarbageCollection() {
        String baseName = "test-log.tierstate";
        String topic = "test";
        File testFile = new File(new StringBuilder(17).append(this.tmpDir().getAbsolutePath()).append("/mockSnapshotFile").toString());
        testFile.createNewFile();
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topic, topicId, 1);
        TopicIdPartition topicIdPartition10 = new TopicIdPartition(topic, topicId, 10);
        this.mockTime_$eq(new MockTime(0L, 1688888888888L, 0L));
        this.inMemTierObjectStore().clearForClusterId();
        FileTierPartitionStateSnapshotObject snapshotMetadata1 = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), this.mockTime().milliseconds(), new OffsetAndEpoch(0L, Optional.empty()), this.leaderEpoch(), baseName, Algorithm.ADLER);
        TierPartitionStateSnapshotMetadata objectMetadata1 = new TierPartitionStateSnapshotMetadata(topicIdPartition1, snapshotMetadata1);
        FileTierPartitionStateSnapshotObject snapshotMetadataExpired = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), this.mockTime().milliseconds() - TimeUnit.DAYS.toMillis(((SnapshotTasksConfig)this.tierTasksConfig().snapshotTaskConfig().get()).retentionDays().apply$mcI$sp()) - 10L, new OffsetAndEpoch(0L, Optional.empty()), this.leaderEpoch(), baseName, Algorithm.ADLER);
        TierPartitionStateSnapshotMetadata objectMetadataExpired = new TierPartitionStateSnapshotMetadata(topicIdPartition1, snapshotMetadataExpired);
        FileTierPartitionStateSnapshotObject snapshotMetadata10 = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), this.mockTime().milliseconds() - TimeUnit.DAYS.toMillis(((SnapshotTasksConfig)this.tierTasksConfig().snapshotTaskConfig().get()).retentionDays().apply$mcI$sp()) - 10L, new OffsetAndEpoch(0L, Optional.empty()), this.leaderEpoch(), baseName, Algorithm.ADLER);
        TierPartitionStateSnapshotMetadata objectMetadata10 = new TierPartitionStateSnapshotMetadata(topicIdPartition10, snapshotMetadata10);
        this.inMemTierObjectStore().putObject((ObjectStoreMetadata)objectMetadata1, testFile, ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
        this.inMemTierObjectStore().putObject((ObjectStoreMetadata)objectMetadataExpired, testFile, ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
        this.inMemTierObjectStore().putObject((ObjectStoreMetadata)objectMetadata10, testFile, ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
        Assertions.assertEquals((int)3, (int)this.inMemTierObjectStore().getStoredKeys().size());
        String testPrefix = TierPartitionStateSnapshotMetadata.pathPrefix((String)"", (TopicIdPartition)topicIdPartition1);
        Set listedObjectKeys = this.inMemTierObjectStore().listObject(testPrefix, false).keySet();
        Assertions.assertEquals((int)2, (int)listedObjectKeys.size());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.SetHasAsScala(listedObjectKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadata1.snapshotId().toString()))), (String)"snapshot should be listed");
        Assertions.assertFalse((boolean)CollectionConverters$.MODULE$.SetHasAsScala(listedObjectKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadata10.snapshotId().toString()))), (String)"snapshot belongs to a different partition should not be listed");
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.SetHasAsScala(listedObjectKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadataExpired.snapshotId().toString()))), (String)"snapshot should be listed");
        Mockito.when((Object)this.tierPartitionState().lastCommittedSnapshotId()).thenReturn((Object)snapshotMetadata1.snapshotId());
        Mockito.when((Object)this.tierPartitionState().lastSnapshotId()).thenReturn((Object)snapshotMetadata1.snapshotId());
        MetadataSnapshotTask$.MODULE$.garbageCollectOlderSnapshots(topicIdPartition1, this.leaderEpoch(), this.log(), (TierObjectStore)this.inMemTierObjectStore(), (Time)this.mockTime(), this.tierTasksConfig());
        java.util.List storedKeys = this.inMemTierObjectStore().getStoredKeys();
        Assertions.assertEquals((int)2, (int)storedKeys.size());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(storedKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadata1.snapshotId().toString()))), (String)"snapshot not due for retention should not be deleted");
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(storedKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadata10.snapshotId().toString()))), (String)"snapshot belongs to a different partition should not be deleted");
        Assertions.assertFalse((boolean)CollectionConverters$.MODULE$.ListHasAsScala(storedKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadataExpired.snapshotId().toString()))), (String)"snapshot due for retention should be deleted");
        this.inMemTierObjectStore().clearForClusterId();
        this.inMemTierObjectStore().putObject((ObjectStoreMetadata)objectMetadataExpired, testFile, ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
        Assertions.assertEquals((int)1, (int)this.inMemTierObjectStore().getStoredKeys().size());
        Mockito.when((Object)this.tierPartitionState().lastCommittedSnapshotId()).thenReturn((Object)snapshotMetadataExpired.snapshotId());
        Mockito.when((Object)this.tierPartitionState().lastSnapshotId()).thenReturn((Object)snapshotMetadataExpired.snapshotId());
        MetadataSnapshotTask$.MODULE$.garbageCollectOlderSnapshots(topicIdPartition1, this.leaderEpoch(), this.log(), (TierObjectStore)this.inMemTierObjectStore(), (Time)this.mockTime(), this.tierTasksConfig());
        storedKeys = this.inMemTierObjectStore().getStoredKeys();
        Assertions.assertEquals((int)1, (int)storedKeys.size());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(storedKeys).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)key.contains(snapshotMetadataExpired.snapshotId().toString()))), (String)"last snapshot should not be deleted");
        this.inMemTierObjectStore().clearForClusterId();
    }

    @ParameterizedTest
    @EnumSource(value=Algorithm.class, names={"ADLER", "NO_CHECKSUM"})
    public void testSnapshot(Algorithm algo) {
        UUID snapshotId = UUID.randomUUID();
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        MetadataSnapshotTask.MetadataSnapshotState state = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            }
            throw new MatchError((Object)try_);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        SnapshotTestUtils qual$1 = this.testUtils();
        boolean x$3 = qual$1.createRandomSnapshotFile$default$3();
        boolean x$4 = qual$1.createRandomSnapshotFile$default$4();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        qual$1.createRandomSnapshotFile(snapshotId, algo, x$3, x$4, x$5);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.AfterMetadataSnapshotState.class, nextState2.getClass(), (String)"Unexpected next state");
        Mockito.when((Object)this.tierObjectStore().putObject((ObjectStoreMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (ObjectType)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("foo"), new IllegalStateException("illegal state")});
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState3 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState3.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        }
        if (!(try_3 instanceof Failure)) {
            throw new MatchError((Object)try_3);
        }
        Throwable ex = ((Failure)try_3).exception();
        Assertions.assertEquals(TierObjectStoreRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Try try_4 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_4 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState4 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_4).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState4.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        }
        if (!(try_4 instanceof Failure)) {
            throw new MatchError((Object)try_4);
        }
        Throwable ex2 = ((Failure)try_4).exception();
        Assertions.assertEquals(IllegalStateException.class, ex2.getClass(), (String)"Unexpected exception");
        this.ctx().cancel();
        Try try_5 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_5 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState5 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_5).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState5.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        }
        if (!(try_5 instanceof Failure)) {
            throw new MatchError((Object)try_5);
        }
        Throwable ex3 = ((Failure)try_5).exception();
        Assertions.assertEquals(TierSnapshotFencedException.class, ex3.getClass(), (String)"Unexpected exception");
        Utils.delete((File)this.logDir(), (boolean)false);
        Try try_6 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_6 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState6 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_6).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState6.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        }
        if (try_6 instanceof Failure) {
            Throwable ex4 = ((Failure)try_6).exception();
            Assertions.assertEquals(NoSuchFileException.class, ex4.getClass(), (String)"Unexpected exception");
            return;
        }
        throw new MatchError((Object)try_6);
    }

    @Test
    public void testSnapshotCleanupDuringAfterMetadataSnapshotStateTransition() {
        UUID snapshotId = UUID.randomUUID();
        String baseNameStr = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        FileTierPartitionStateSnapshotObject snapshotMetadata = new FileTierPartitionStateSnapshotObject(snapshotId, 123L, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, Algorithm.ADLER);
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), UUID.randomUUID(), new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        SnapshotTestUtils qual$1 = this.testUtils();
        boolean x$3 = qual$1.createRandomSnapshotFile$default$3();
        boolean x$4 = qual$1.createRandomSnapshotFile$default$4();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        Path mostRecentSnapshotPath = qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, x$3, x$4, x$5);
        MetadataSnapshotTask.AfterMetadataSnapshotState state = new MetadataSnapshotTask.AfterMetadataSnapshotState(this.leaderEpoch(), mostRecentSnapshotPath, snapshotInitiate, snapshotMetadata);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierMetadataSnapshotUploadComplete.class))).thenThrow(new Throwable[]{new IllegalAccessException()});
        ObjectRef nextStateFuture = ObjectRef.create((Object)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((Future)nextStateFuture$1.elem), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state after logDir deletion", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(IllegalAccessException.class, ex.getClass(), (String)"Unexpected exception during snapshot upload");
        Assertions.assertFalse((boolean)Files.exists(mostRecentSnapshotPath, new LinkOption[0]));
        state = new MetadataSnapshotTask.AfterMetadataSnapshotState(this.leaderEpoch(), mostRecentSnapshotPath, snapshotInitiate, snapshotMetadata);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierMetadataSnapshotUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Utils.delete((File)this.logDir(), (boolean)false);
        nextStateFuture.elem = state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((Future)nextStateFuture$1.elem), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state after logDir deletion", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
        }
        if (!(try_2 instanceof Failure)) {
            throw new MatchError((Object)try_2);
        }
        Throwable ex2 = ((Failure)try_2).exception();
        Assertions.assertEquals(NoSuchFileException.class, ex2.getClass(), (String)"Unexpected exception during snapshot upload");
        state = new MetadataSnapshotTask.AfterMetadataSnapshotState(this.leaderEpoch(), mostRecentSnapshotPath, snapshotInitiate, snapshotMetadata);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierMetadataSnapshotUploadComplete.class))).thenThrow(new Throwable[]{new IllegalAccessException()});
        nextStateFuture.elem = state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((Future)nextStateFuture$1.elem), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state after logDir deletion", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        }
        if (try_3 instanceof Failure) {
            Throwable ex3 = ((Failure)try_3).exception();
            Assertions.assertEquals(NoSuchFileException.class, ex3.getClass(), (String)"Unexpected exception during snapshot upload");
            return;
        }
        throw new MatchError((Object)try_3);
    }

    @Test
    public void testSnapshotTakenAtLaterOffsetThanSnapshotInitiateOffset() {
        UUID snapshotId = UUID.randomUUID();
        OffsetAndEpoch snapshotInitiateOffsetAndEpoch = new OffsetAndEpoch(0L, Optional.empty());
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, snapshotInitiateOffsetAndEpoch, this.brokerId());
        ObjectRef currentState = ObjectRef.create((Object)new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate));
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        OffsetAndEpoch snapshotTakenOffsetAndEpoch = new OffsetAndEpoch(8L, Optional.empty());
        SnapshotTestUtils qual$1 = this.testUtils();
        boolean x$4 = qual$1.createRandomSnapshotFile$default$3();
        boolean x$5 = qual$1.createRandomSnapshotFile$default$4();
        qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, x$4, x$5, snapshotTakenOffsetAndEpoch);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotTaskState)currentState$1.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.inMemTierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            }
            throw new MatchError((Object)try_);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
        Assertions.assertEquals(MetadataSnapshotTask.AfterMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        Option<FileTierPartitionStateSnapshotObject> snapshotObject = this.testUtils().verifySnapshotExistenceAtObjectStore(snapshotId, true);
        Assertions.assertEquals((Object)snapshotTakenOffsetAndEpoch, (Object)((FileTierPartitionStateSnapshotObject)snapshotObject.get()).lastMaterializedEventOffsetAndEpoch());
        currentState.elem = nextState;
        ObjectRef snapshotUploadComplete = ObjectRef.create(null);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(null, snapshotUploadComplete){
            private final ObjectRef snapshotUploadComplete$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                this.snapshotUploadComplete$1.elem = (TierMetadataSnapshotUploadComplete)invocation.getArgument(0);
                return CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED);
            }
            {
                this.snapshotUploadComplete$1 = snapshotUploadComplete$1;
            }
        });
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotTaskState)currentState$1.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.inMemTierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState.class, nextState2.getClass(), (String)"Unexpected next state");
        currentState.elem = nextState2;
        Assertions.assertNotNull((Object)((TierMetadataSnapshotUploadComplete)snapshotUploadComplete.elem), (String)"TierTopicAppender not called with snapshotUploadComplete event");
        Assertions.assertEquals((Object)snapshotTakenOffsetAndEpoch, (Object)((TierMetadataSnapshotUploadComplete)snapshotUploadComplete.elem).snapshotOffsetAndEpoch());
    }

    @Test
    public void testSnapshotUploadFailsDueToInvalidChecksum() {
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        UUID snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$1 = this.testUtils();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, true, x$5);
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        ObjectRef state = ObjectRef.create((Object)new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotState)state$2.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state with invalid checksum", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierSnapshotChecksumValidationFailedException.class, ex.getClass(), (String)"Unexpected exception during snapshot upload");
        Assertions.assertNull((Object)ex.getCause());
        snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$2 = this.testUtils();
        OffsetAndEpoch x$10 = qual$2.createRandomSnapshotFile$default$5();
        qual$2.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, false, x$10);
        snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        state.elem = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotState)state$2.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state with invalid checksum", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        }
        if (try_2 instanceof Failure) {
            Throwable ex2 = ((Failure)try_2).exception();
            Assertions.assertEquals(TierSnapshotChecksumValidationFailedException.class, ex2.getClass(), (String)"Unexpected exception during snapshot upload");
            Assertions.assertNotNull((Object)ex2.getCause());
            return;
        }
        throw new MatchError((Object)try_2);
    }

    @Test
    public void testCleanUpMostRecentSnapshotAndStraySnapshotFiles() {
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        UUID snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$1 = this.testUtils();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        Path straySnapshotPath = qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, true, x$5);
        snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$2 = this.testUtils();
        OffsetAndEpoch x$10 = qual$2.createRandomSnapshotFile$default$5();
        Path mostRecentSnapshotPath = qual$2.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, true, x$10);
        Assertions.assertTrue((boolean)Files.exists(straySnapshotPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(mostRecentSnapshotPath, new LinkOption[0]));
        MetadataSnapshotTask$.MODULE$.deleteMostRecentSnapshotAndCleanSnapshotsDir(mostRecentSnapshotPath);
        Assertions.assertFalse((boolean)Files.exists(straySnapshotPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(mostRecentSnapshotPath, new LinkOption[0]));
    }

    @Test
    public void testCleanUpThrowsExceptionOnDetectionOfNonSnapshotFiles() {
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        UUID snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$1 = this.testUtils();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        Path mostRecentSnapshotPath = qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, true, x$5);
        Path nonSnapshotFile = Files.createFile(Paths.get(new StringBuilder(20).append(((Object)mostRecentSnapshotPath.getParent()).toString()).append("/nonSnapshotFile.txt").toString(), new String[0]), new FileAttribute[0]);
        Assertions.assertTrue((boolean)Files.exists(nonSnapshotFile, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(mostRecentSnapshotPath, new LinkOption[0]));
        Assertions.assertThrows(TierSnapshotUnexpectedFileInSnapshotsDirException.class, () -> MetadataSnapshotTask$.MODULE$.deleteMostRecentSnapshotAndCleanSnapshotsDir(mostRecentSnapshotPath));
        Assertions.assertFalse((boolean)Files.exists(mostRecentSnapshotPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(nonSnapshotFile, new LinkOption[0]));
    }

    @Test
    public void testMetadataSnapshotGarbageCollectionState() {
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        this.mockTime().setCurrentTimeMs(System.currentTimeMillis() - 172800000L);
        UUID snapshot1Id = UUID.randomUUID();
        FileTierPartitionStateSnapshotObject snapshot1Info = this.testUtils().createAndUploadSnapshotFile(snapshot1Id, Algorithm.ADLER);
        this.mockTime().setCurrentTimeMs(System.currentTimeMillis() - 86400000L);
        UUID snapshot2Id = UUID.randomUUID();
        this.testUtils().createAndUploadSnapshotFile(snapshot2Id, Algorithm.ADLER);
        long lastSnapshotTimestampMs = System.currentTimeMillis();
        this.mockTime().setCurrentTimeMs(lastSnapshotTimestampMs);
        UUID snapshot3Id = UUID.randomUUID();
        FileTierPartitionStateSnapshotObject snapshot3Info = this.testUtils().createAndUploadSnapshotFile(snapshot3Id, Algorithm.ADLER);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Left().apply((Object)Errors.KAFKA_STORAGE_ERROR));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id, (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(90).append("Unexpected transition to next state ").append(nextState.toString()).append(". State must not transition when partition is in error").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierSnapshotFencedException.class, ex.getClass(), (String)"Unexpected exception");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)None$.MODULE$);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id, (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex2 = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(55).append("Unexpected exception when log instance is not present. ").append(ex2.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState.class, nextState.getClass(), (String)new StringBuilder(96).append("Unexpected transition to next state ").append(nextState.toString()).append(". State must not transition when log instance is not present").toString());
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id, (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(83).append("Unexpected transition to next state ").append(nextState2.toString()).append(". State must not transition when log is deleted").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
        }
        if (!(try_3 instanceof Failure)) {
            throw new MatchError((Object)try_3);
        }
        Throwable ex3 = ((Failure)try_3).exception();
        Assertions.assertEquals(NotTierablePartitionException.class, ex3.getClass(), (String)"Unexpected exception");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ERROR);
        Try try_4 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id, (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (try_4 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState3 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_4).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(108).append("Unexpected transition to next state ").append(nextState3.toString()).append(". State must not transition when tier partition state is in error status").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        }
        if (!(try_4 instanceof Failure)) {
            throw new MatchError((Object)try_4);
        }
        Throwable ex4 = ((Failure)try_4).exception();
        Assertions.assertEquals(TierSnapshotFailedException.class, ex4.getClass(), (String)"Unexpected exception");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Try try_5 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs + 1L, UUID.randomUUID(), (Option)new Some((Object)UUID.randomUUID())), (Duration)this.defaultAwaitTime()));
        if (try_5 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState4 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_5).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(66).append("Unexpected state transition to ").append(nextState4).append(" when committed snapshot is missing").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
        }
        if (!(try_5 instanceof Failure)) {
            throw new MatchError((Object)try_5);
        }
        Throwable ex5 = ((Failure)try_5).exception();
        Assertions.assertEquals(TierSnapshotMostRecentSnapshotNotYetCommitted.class, ex5.getClass());
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Try try_6 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs + 1L, UUID.randomUUID(), (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (try_6 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState5 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_6).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(66).append("Unexpected state transition to ").append(nextState5).append(" when committed snapshot is missing").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        }
        if (!(try_6 instanceof Failure)) {
            throw new MatchError((Object)try_6);
        }
        Throwable ex6 = ((Failure)try_6).exception();
        Assertions.assertEquals(TierSnapshotLastTakenSnapshotNotPresentAtObjectStoreException.class, ex6.getClass());
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Try try_7 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(snapshot1Info.snapshotTimestampMs(), snapshot1Info.snapshotId(), (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (!(try_7 instanceof Success)) {
            if (try_7 instanceof Failure) {
                Throwable ex7 = ((Failure)try_7).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex7.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
            }
            throw new MatchError((Object)try_7);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState6 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_7).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState6.getClass(), (String)"Unexpected state transition");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Try try_8 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(snapshot3Info.snapshotTimestampMs(), snapshot3Info.snapshotId(), (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (!(try_8 instanceof Success)) {
            if (try_8 instanceof Failure) {
                Throwable ex8 = ((Failure)try_8).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex8.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            throw new MatchError((Object)try_8);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState7 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_8).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState7.getClass(), (String)"Unexpected state transition");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$), (List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)Nil$.MODULE$)));
        this.mockTime().setCurrentTimeMs(System.currentTimeMillis() + 604800000L);
        Try try_9 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(snapshot3Info.snapshotTimestampMs(), snapshot3Info.snapshotId(), (Option)None$.MODULE$), (Duration)this.defaultAwaitTime()));
        if (!(try_9 instanceof Success)) {
            if (try_9 instanceof Failure) {
                Throwable ex9 = ((Failure)try_9).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex9.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
            }
            throw new MatchError((Object)try_9);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState8 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_9).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState8.getClass(), (String)"Unexpected state transition");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$), (List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @EnumSource(value=Algorithm.class, names={"ADLER", "NO_CHECKSUM"})
    public void testSnapshotUuidSearch(Algorithm algo) {
        void var15_15;
        void var12_12;
        void var9_9;
        void var6_6;
        String baseNameStr = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        UUID snapshotId = UUID.randomUUID();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()));
        FileTierPartitionStateSnapshotObject utils1 = new FileTierPartitionStateSnapshotObject(snapshotId, 123L, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils1.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple2 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata1 = (FileTierPartitionStateSnapshotObject)tuple2._2();
        Assertions.assertEquals((long)123L, (long)var6_6.snapshotTimestampMs());
        FileTierPartitionStateSnapshotObject utils2 = new FileTierPartitionStateSnapshotObject(snapshotId, 45L, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils2.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple22 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata2 = (FileTierPartitionStateSnapshotObject)tuple22._2();
        Assertions.assertEquals((long)45L, (long)var9_9.snapshotTimestampMs());
        FileTierPartitionStateSnapshotObject utils3 = new FileTierPartitionStateSnapshotObject(snapshotId, 678L, new OffsetAndEpoch(12L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils3.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple23 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata3 = (FileTierPartitionStateSnapshotObject)tuple23._2();
        Assertions.assertEquals((long)45L, (long)var12_12.snapshotTimestampMs());
        FileTierPartitionStateSnapshotObject utils4 = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), 10L, new OffsetAndEpoch(15L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils4.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple24 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata4 = (FileTierPartitionStateSnapshotObject)tuple24._2();
        Assertions.assertEquals((long)45L, (long)var15_15.snapshotTimestampMs());
        Utils.delete((File)this.logDir(), (boolean)false);
        Assertions.assertThrows(NoSuchFileException.class, () -> MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @EnumSource(value=Algorithm.class, names={"ADLER", "NO_CHECKSUM"})
    public void testParseSnapshotPath(Algorithm algo) {
        void var7_7;
        String baseName = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        UUID snapshotId = UUID.randomUUID();
        FileTierPartitionStateSnapshotObject utils = new FileTierPartitionStateSnapshotObject(snapshotId, 123L, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(-1))), 0, baseName, algo);
        Path localPath = this.snapshotsDir().resolve(utils.encodeSnapshotName());
        Files.write(localPath, "".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Tuple2 tuple2 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject snapshotMetadata = (FileTierPartitionStateSnapshotObject)tuple2._2();
        TierPartitionStateSnapshotMetadata objectMetadata = new TierPartitionStateSnapshotMetadata(this.topicIdPartition(), (FileTierPartitionStateSnapshotObject)var7_7);
        String remotePath = ((FragmentLocation)objectMetadata.toFragmentLocation("bar", FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).get()).objectPath();
        Assertions.assertEquals((Object)snapshotId, (Object)objectMetadata.snapshotObject().snapshotId());
        Assertions.assertEquals((long)123L, (long)objectMetadata.snapshotObject().snapshotTimestampMs());
        Assertions.assertEquals((long)10L, (long)objectMetadata.snapshotObject().lastMaterializedEventOffsetAndEpoch().offset());
        Assertions.assertEquals(Optional.empty(), (Object)objectMetadata.snapshotObject().lastMaterializedEventOffsetAndEpoch().epoch());
        Assertions.assertEquals((int)0, (int)objectMetadata.snapshotObject().tierEpoch());
        Assertions.assertEquals((Object)algo, (Object)objectMetadata.snapshotObject().checksumAlgorithm());
        Assertions.assertTrue((boolean)((Object)localPath).toString().endsWith(algo.suffix));
        Assertions.assertTrue((boolean)remotePath.contains(((Object)localPath.getFileName()).toString()));
    }

    private final Future taskTransitionHelper$1(boolean uncleanLeader, boolean metadataRecovering) {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeader));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isTierMetadataStateRecovering())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)metadataRecovering));
        return new MetadataSnapshotTask.BeforeLeaderSnapshotState(this.leaderEpoch()).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
    }

    private static final boolean taskTransitionHelper$default$1$1() {
        return false;
    }

    private static final boolean taskTransitionHelper$default$2$1() {
        return false;
    }

    private final Future taskTransitionHelper$2(long lastSnapshotTimestampMs) {
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)lastSnapshotTimestampMs));
        return new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch()).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
    }

    public static final /* synthetic */ void $anonfun$testTaskCancellationAndConfigUpdate$1(MetadataSnapshotTaskTest $this, MetadataSnapshotTask.MetadataSnapshotTaskState state) {
        CancellationContext tmpCtx = CancellationContext.newContext();
        MetadataSnapshotTask task = new MetadataSnapshotTask(tmpCtx, $this.topicIdPartition(), state, $this.snapshotMetrics(), $this.brokerId());
        tmpCtx.cancel();
        Assertions.assertEquals((Object)((MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)$this.mockTime(), (TierTopicAppender)$this.tierTopicManager(), $this.tierObjectStore(), $this.replicaManager(), $this.tierTasksConfig(), (Option)None$.MODULE$, $this.ec()), (Duration)$this.defaultAwaitTime())).state(), (Object)state, (String)new StringBuilder(27).append("expected task to remain in ").append(state).toString());
    }

    private final void cancelledTasksDoNotProgress$1(List states) {
        states.foreach((Function1 & Serializable)state -> {
            MetadataSnapshotTaskTest.$anonfun$testTaskCancellationAndConfigUpdate$1(this, state);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testTaskCancellationAndConfigUpdate$2(MetadataSnapshotTaskTest $this, TierTasksConfig newTierTasksConfig$1, MetadataSnapshotTask.MetadataSnapshotTaskState state) {
        MetadataSnapshotTask task = new MetadataSnapshotTask($this.ctx(), $this.topicIdPartition(), state, $this.snapshotMetrics(), $this.brokerId());
        Assertions.assertEquals((Object)((MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)$this.mockTime(), (TierTopicAppender)$this.tierTopicManager(), $this.tierObjectStore(), $this.replicaManager(), newTierTasksConfig$1, (Option)None$.MODULE$, $this.ec()), (Duration)$this.defaultAwaitTime())).state(), (Object)state, (String)new StringBuilder(27).append("expected task to remain in ").append(state).toString());
    }

    private final void disabledConfigCancelsProgress$1(List states, TierTasksConfig newTierTasksConfig) {
        states.foreach((Function1 & Serializable)state -> {
            MetadataSnapshotTaskTest.$anonfun$testTaskCancellationAndConfigUpdate$2(this, newTierTasksConfig, state);
            return BoxedUnit.UNIT;
        });
    }

    private final Future taskTransitionHelper$3(long lastSnapshotTimestampMs, UUID lastCommittedSnapshotId, Option lastSnapshotId) {
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)lastSnapshotTimestampMs));
        Mockito.when((Object)this.tierPartitionState().lastCommittedSnapshotId()).thenReturn((Object)lastCommittedSnapshotId);
        Mockito.when((Object)this.tierPartitionState().lastSnapshotId()).thenReturn(lastSnapshotId.getOrElse((Function0 & Serializable)() -> lastCommittedSnapshotId));
        return new MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState(this.leaderEpoch()).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.inMemTierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
    }

    private static final Option taskTransitionHelper$default$3$1() {
        return None$.MODULE$;
    }

    public MetadataSnapshotTaskTest() {
        this.brokerId = 0;
        this.snapshotThreads = 1;
        int x$3 = this.snapshotThreads();
        int x$4 = this.brokerId();
        Option<SnapshotTasksConfig> x$5 = this.snapshotTaskConfig();
        long x$6 = 600000L;
        long x$7 = 500L;
        int x$8 = 50;
        int x$9 = 300000;
        boolean x$10 = false;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        this.tierTasksConfig = new TierTasksConfig(1, 1, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$12, x$5);
        this.snapshotMetrics = new MetadataSnapshotMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        this.leaderEpoch = 0;
        this.defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
    }
}

