/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.utils.CoreUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileTierPartitionStateUploadObjectTest {
    @Test
    public void testTierPartitionStateUploadPathEncodeDecode() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        Path basePath = Paths.get("00000000000000000000.tierstate", new String[0]).toAbsolutePath();
        String baseName = basePath.getFileName().toString();
        Algorithm algorithm = Algorithm.ADLER;
        String identifier = "rcca-1234";
        Integer broker = 0;
        String keyPrefix = "bar";
        ObjectType objectType = ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD;
        FileTierPartitionStateUploadObject uploadObject = new FileTierPartitionStateUploadObject(baseName, algorithm);
        FileTierPartitionStateRecoveryUploadMetadata metadata = new FileTierPartitionStateRecoveryUploadMetadata(identifier, broker, topicIdPartition, uploadObject);
        String expectedFilePath = String.format("%s/%s.recovery-upload%s", basePath.getParent().toString(), basePath.getFileName(), algorithm.suffix);
        Path actualFilePath = uploadObject.getRecoveryUploadPath(basePath.getParent().toString());
        Assertions.assertEquals((Object)expectedFilePath, (Object)actualFilePath.toString());
        Assertions.assertTrue((boolean)FileTierPartitionStateUploadObject.isRecoveryUploadFile((String)actualFilePath.toString()));
        String expectedObjectStorePath = String.format("%s%s/recovery-%s/%d/ftps/%s/%s/%s_v%d.%s", keyPrefix, TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), identifier, broker, topicIdPartition.topicIdAsBase64(), topicIdPartition.topicPartition().toString(), uploadObject.encodeRecoveryUploadName(), 0, objectType.suffix());
        Assertions.assertEquals((Object)expectedObjectStorePath, (Object)((FragmentLocation)metadata.toFragmentLocation(keyPrefix, FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath());
        FileTierPartitionStateUploadObject decodedObject = FileTierPartitionStateUploadObject.decodeUploadName((String)actualFilePath.getFileName().toString());
        Assertions.assertEquals((Object)uploadObject, (Object)decodedObject);
    }

    @Test
    public void testObjectStoreFromPath() {
        FileTierPartitionStateUploadObject uploadObject = new FileTierPartitionStateUploadObject("00000000000000000000.tierstate", Algorithm.ADLER);
        FileTierPartitionStateRecoveryUploadMetadata metadata = new FileTierPartitionStateRecoveryUploadMetadata("rcca-1234", Integer.valueOf(0), new TopicIdPartition("foo", UUID.randomUUID(), 0), uploadObject);
        FileTierPartitionStateRecoveryUploadMetadata decodedMetadata = FileTierPartitionStateRecoveryUploadMetadata.fromPath((String)((FragmentLocation)metadata.toFragmentLocation("bar", FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath());
        Assertions.assertEquals((Object)metadata, (Object)decodedMetadata);
    }

    @Test
    public void testVersionMismatchObjectStoreFromPath() {
        String keyPrefix = "foo";
        String identifier = "rcca-1234";
        String topicId = CoreUtils.uuidToBase64((UUID)UUID.randomUUID());
        String topic = "topic";
        int partition = 0;
        Integer broker = 5;
        Integer invalidVersion = 10;
        String objectPath = String.format("%s%s/recovery-%s/%d/ftps/%s/%s-%d/%s.recovery-upload.adler_v%d.%s", keyPrefix, TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), identifier, broker, topicId, topic, partition, "00000000000000000000.tierstate", invalidVersion, ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD.suffix());
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileTierPartitionStateRecoveryUploadMetadata.fromPath((String)objectPath));
    }
}

