/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.common.RestoreRemoteURIInfo;

public class RecoveryTestUtils {
    public static void writeFencingFile(File file, Map<TopicIdPartition, Boolean> tpIdsToBeFenced) throws FileNotFoundException {
        try (PrintWriter pw = new PrintWriter(file);){
            tpIdsToBeFenced.forEach((tpId, freezeMergedLogStartOffset) -> {
                pw.write(String.format("%s:%s-%d %s", tpId.topicIdAsBase64(), tpId.topic(), tpId.partition(), freezeMergedLogStartOffset));
                pw.println();
            });
        }
    }

    public static void writeRemoteURIInfoFile(File file, Map<TopicIdPartition, Boolean> tpIdsToBeFenced) throws IOException {
        ArrayList remoteUriInfoList = new ArrayList();
        tpIdsToBeFenced.forEach((tpId, freezeMergedLogStartOffset) -> {
            String identifier = "rcca-1234";
            UUID topicId = tpId.topicId();
            String topic = tpId.topic();
            int partition = tpId.partition();
            TopicIdPartition topicIdPartition = new TopicIdPartition(topic, topicId, partition);
            Integer broker = 0;
            FileTierPartitionStateUploadObject fileTierPartitionStateUploadObject = new FileTierPartitionStateUploadObject(MergedLog.tierStateFileName((long)0L, (String)""), Algorithm.NO_CHECKSUM);
            FileTierPartitionStateRecoveryUploadMetadata fileTierPartitionStateRecoveryUploadMetadata = new FileTierPartitionStateRecoveryUploadMetadata(identifier, broker, topicIdPartition, fileTierPartitionStateUploadObject);
            String remoteURI = fileTierPartitionStateRecoveryUploadMetadata.toPath(TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD);
            RestoreRemoteURIInfo remoteURIInfo = new RestoreRemoteURIInfo(topicIdPartition, remoteURI);
            remoteUriInfoList.add(remoteURIInfo);
        });
        ObjectMapper mapper = new ObjectMapper();
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            mapper.writeValue(out, remoteUriInfoList);
        }
    }

    public static void executeFencingTool(String propertiesConfFile, String topicIdPartitionsFile, String outputJsonFile) throws Exception {
        TierPartitionStateFencingTrigger.main((String[])new String[]{"fence-user-topic-partitions", RecoveryUtils.makeArgument((String)"tier.config"), propertiesConfFile, RecoveryUtils.makeArgument((String)"file-fence-target-user-partitions"), topicIdPartitionsFile, RecoveryUtils.makeArgument((String)"output.json"), outputJsonFile});
    }

    public static void executeFencingTool(String propertiesConfFile, String topicIdPartitionsFile, String outputJsonFile, int eventCount) throws Exception {
        TierPartitionStateFencingTrigger.main((String[])new String[]{"fence-user-topic-partitions", RecoveryUtils.makeArgument((String)"tier.config"), propertiesConfFile, RecoveryUtils.makeArgument((String)"file-fence-target-user-partitions"), topicIdPartitionsFile, RecoveryUtils.makeArgument((String)"output.json"), outputJsonFile, RecoveryUtils.makeArgument((String)"fence-event-count"), String.valueOf(eventCount)});
    }

    public static void executeFencingToolDummyEvents(String propertiesConfFile, String tierTopicPartitionTargetInputFile) throws Exception {
        TierPartitionStateFencingTrigger.main((String[])new String[]{"inject-dummy-tier-topic-fence-events", RecoveryUtils.makeArgument((String)"tier.config"), propertiesConfFile, RecoveryUtils.makeArgument((String)"file-fence-target-tier-topic-partitions"), tierTopicPartitionTargetInputFile});
    }
}

