/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a4A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C)A!)q\u0005\u0001C\u0001Q!)a\u000b\u0001C\u0001/\")A\f\u0001C\u0001;\")A\r\u0001C\u0001;\")a\r\u0001C\u0001;\")\u0001\u000e\u0001C\u0001;\")!\u000e\u0001C\u0001W\")\u0001\u000f\u0001C\u0001c\")a\u000f\u0001C\u0001;\n\t\"+Z2pm\u0016\u0014\u00180\u0016;jYN$Vm\u001d;\u000b\u00059y\u0011!\u0002;p_2\u001c(B\u0001\t\u0012\u0003\u0011!\u0018.\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\u0011\u0001$E\u0001\u0004CBL\u0017B\u0001\u000e\u0018\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u000e\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u00121!\u00138u\u0003\u001d\"Xm\u001d;J]*,7\r\u001e+jKJ$v\u000e]5d\u000bZ,g\u000e^(o\u000bbL7\u000f^5oOR{\u0007/[2\u0015\u0005%b\u0003C\u0001\u0012+\u0013\tY3E\u0001\u0003V]&$\b\"B\u0017\u0004\u0001\u0004q\u0013AB9v_J,X\u000e\u0005\u00020m9\u0011\u0001\u0007\u000e\t\u0003c\rj\u0011A\r\u0006\u0003gM\ta\u0001\u0010:p_Rt\u0014BA\u001b$\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u001a\u0003\u0006B\u0002;\r\u001e\u0003\"a\u000f#\u000e\u0003qR!!\u0010 \u0002\rA\f'/Y7t\u0015\ty\u0004)A\u0004kkBLG/\u001a:\u000b\u0005\u0005\u0013\u0015!\u00026v]&$(\"A\"\u0002\u0007=\u0014x-\u0003\u0002Fy\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u0011\u0006\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDCa\u0001&Q#B\u00111JT\u0007\u0002\u0019*\u0011Q\nP\u0001\taJ|g/\u001b3fe&\u0011q\n\u0014\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005I#\u0016%A*\u0002\u0005i\\\u0017%A+\u0002\u000b-\u0014\u0018M\u001a;\u0002UQ,7\u000f^%oU\u0016\u001cG\u000fV5feR{\u0007/[2Fm\u0016tGo\u00148O_:,\u00050[:uS:<Gk\u001c9jGR\u0011\u0011\u0006\u0017\u0005\u0006[\u0011\u0001\rA\f\u0015\u0005\ti2u\t\u000b\u0003\u0005\u0015B[FF\u0001*U\u0003%\"Xm\u001d;U_R{\u0007/[2JIB\u000b'\u000f^5uS>t7oV5uQ\u0016k\u0007\u000f^=U_BL7MT1nKR\t\u0011\u0006\u000b\u0002\u0006?B\u0011\u0001MY\u0007\u0002C*\u0011\u0001DP\u0005\u0003G\u0006\u0014A\u0001V3ti\u0006)C/Z:u)>$v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gn],ji\"\u0014\u0015\r\u001a+pa&\u001c\u0017\n\u001a\u0015\u0003\r}\u000bQ\u0006^3tiR{Gk\u001c9jG&#\u0007+\u0019:uSRLwN\\:XSRD')\u00193QCJ$\u0018\u000e^5p]:+XNY3sQ\t9q,A\u0012uKN$Hk\u001c+pa&\u001c\u0017\n\u001a)beRLG/[8og^KG\u000f[$p_\u0012\f%oZ:)\u0005!y\u0016\u0001\n;fgR4\u0016\r\\5eCR,\u0007+\u0019:uSRLwN\\:XSRDg+\u00197jIR{\u0007/[2\u0015\u0005%b\u0007\"B\u0017\n\u0001\u0004q\u0003\u0006B\u0005;\r\u001eCC!\u0003&Q_2\u0012!\u000bV\u0001(i\u0016\u001cHOV1mS\u0012\fG/\u001a)beRLG/[8og^KG\u000f[%om\u0006d\u0017\u000eZ%oaV$8\u000f\u0006\u0002*e\")QF\u0003a\u0001]!\"!B\u000f$HQ\u0011Q!\nU;-\u0005I#\u0016!\n;fgR\u0014\u0016M\u001c3p[N#(/\u001b8h\u001f:d\u0017pQ8oi\u0006Lgn]!ma\"\f'-\u001a;tQ\tYq\f")
public class RecoveryUtilsTest
extends IntegrationTestHarness {
    @Override
    public int brokerCount() {
        return 3;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInjectTierTopicEventOnExistingTopic(String quorum) {
        Some mayBeMetadata;
        String tierTopicName = TierTopic.topicName((String)"");
        int numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("dummy", UUID.fromString("021516db-7a5f-40ef-adda-b6e2b21a3e83"), 123);
        this.createTopic(tierTopicName, numTierTopicPartitions, tierTopicReplicationFactor, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        int leaderEpoch = 1000;
        UUID messageId = UUID.randomUUID();
        int brokerId = 1;
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(tieredTopicIdPartition, leaderEpoch, messageId, brokerId);
        None$ mayBeProducer = None$.MODULE$;
        try {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
            mayBeProducer = new Some((Object)RecoveryUtils.createTierTopicProducer((Properties)properties, (String)"test"));
            Assertions.assertEquals((int)numTierTopicPartitions, (int)RecoveryUtils.getNumPartitions((Producer)((Producer)mayBeProducer.get()), (String)tierTopicName));
            mayBeMetadata = new Some((Object)RecoveryUtils.injectTierTopicEvent((Producer)((Producer)mayBeProducer.get()), (AbstractTierMetadata)initLeaderEvent, (String)tierTopicName, (int)numTierTopicPartitions));
        }
        finally {
            mayBeProducer.foreach((Function1 & Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
        mayBeMetadata.foreach((Function1 & Serializable)metadata -> {
            RecoveryUtilsTest.$anonfun$testInjectTierTopicEventOnExistingTopic$2(metadata);
            return BoxedUnit.UNIT;
        });
        ObjectRef consumer = ObjectRef.create(null);
        try {
            Properties consumerProps = new Properties();
            consumerProps.put("auto.offset.reset", "earliest");
            consumerProps.put("enable.auto.commit", "false");
            consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
            consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            consumer.elem = new KafkaConsumer(consumerProps);
            Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopicName, (int)numTierTopicPartitions);
            ((KafkaConsumer)consumer.elem).assign((Collection)tierTopicPartitions);
            tierTopicPartitions.forEach(tp -> ((KafkaConsumer)consumer$1.elem).seekToBeginning(Collections.singletonList(tp)));
            ConsumerRecords records = ((KafkaConsumer)consumer.elem).poll(Duration.ofMillis(100L));
            Assertions.assertEquals((int)1, (int)records.count());
            ConsumerRecord record = (ConsumerRecord)records.iterator().next();
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            TierTopicInitLeader retrievedEvent = (TierTopicInitLeader)eventOpt.get();
            Assertions.assertEquals((Object)initLeaderEvent, (Object)retrievedEvent);
        }
        finally {
            ((KafkaConsumer)consumer.elem).close();
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInjectTierTopicEventOnNonExistingTopic(String quorum) {
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(new TopicIdPartition("dummy", UUID.fromString("021516db-7a5f-40ef-adda-b6e2b21a3e83"), 123), 1000, UUID.randomUUID(), 1);
        short numTierTopicPartitions = 1;
        ObjectRef mayBeProducer = ObjectRef.create((Object)None$.MODULE$);
        try {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
            mayBeProducer.elem = new Some((Object)RecoveryUtils.createTierTopicProducer((Properties)properties, (String)"test"));
            boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> RecoveryUtils.injectTierTopicEvent((Producer)((Producer)((Option)mayBeProducer$1.elem).get()), (AbstractTierMetadata)initLeaderEvent, (String)"", (int)numTierTopicPartitions), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))).getCause() instanceof UnknownTopicOrPartitionException;
        }
        finally {
            ((Option)mayBeProducer.elem).foreach((Function1 & Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testToTopicIdPartitionsWithEmptyTopicName() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "", "23", "false"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "   ", "23", "false"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
    }

    @Test
    public void testToTopicIdPartitionsWithBadTopicId() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"", "foo", "23", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"  ", "foo", "23", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        String badUuid = "badUuid";
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{badUuid, "foo", "23", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
    }

    @Test
    public void testToTopicIdPartitionsWithBadPartitionNumber() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "  ", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "abc", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
    }

    @Test
    public void testToTopicIdPartitionsWithGoodArgs() {
        TopicIdPartition topicIdPartition1 = new TopicIdPartition("foo", UUID.randomUUID(), 23);
        TopicIdPartition topicIdPartition2 = new TopicIdPartition("bar", UUID.randomUUID(), 97);
        Map result = RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%d %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.uuidToBase64(topicIdPartition1.topicId()), topicIdPartition1.topic(), BoxesRunTime.boxToInteger((int)topicIdPartition1.partition()), "true"})), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%d %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.uuidToBase64(topicIdPartition2.topicId()), topicIdPartition2.topic(), BoxesRunTime.boxToInteger((int)topicIdPartition2.partition()), "true"}))));
        HashMap<TopicIdPartition, Boolean> expected = new HashMap<TopicIdPartition, Boolean>();
        expected.put(topicIdPartition1, BoxesRunTime.boxToBoolean((boolean)true));
        expected.put(topicIdPartition2, BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertEquals(expected, (Object)result);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidatePartitionsWithValidTopic(String quorum) {
        TopicPartition utp = new TopicPartition("foo", 3);
        this.createTopic(utp.topic(), 5, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        Option topicId = this.getTopicIds((Seq<String>)new .colon.colon((Object)utp.topic(), (List)Nil$.MODULE$)).get((Object)utp.topic());
        TopicPartition utp2 = new TopicPartition("bar", 4);
        this.createTopic(utp2.topic(), 7, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        Option topicId2 = this.getTopicIds((Seq<String>)new .colon.colon((Object)utp2.topic(), (List)Nil$.MODULE$)).get((Object)utp2.topic());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        RecoveryUtils.validatePartitions((Properties)properties, new HashSet<TopicIdPartition>(Arrays.asList(new TopicIdPartition(utp.topic(), CoreUtils$.MODULE$.toJavaUUID((Uuid)topicId.get()), utp.partition()), new TopicIdPartition(utp.topic(), CoreUtils$.MODULE$.toJavaUUID((Uuid)topicId.get()), 0), new TopicIdPartition(utp2.topic(), CoreUtils$.MODULE$.toJavaUUID((Uuid)topicId2.get()), utp2.partition()))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidatePartitionsWithInvalidInputs(String quorum) {
        TopicPartition utp = new TopicPartition("foo", 3);
        this.createTopic(utp.topic(), 5, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        UUID topicId = CoreUtils$.MODULE$.toJavaUUID((Uuid)this.getTopicIds((Seq<String>)new .colon.colon((Object)utp.topic(), (List)Nil$.MODULE$)).apply((Object)utp.topic()));
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, new HashSet<TopicIdPartition>(Collections.singletonList(new TopicIdPartition("dummy", topicId, 2)))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, new HashSet<TopicIdPartition>(Collections.singletonList(new TopicIdPartition(utp.topic(), topicId, 13)))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        ObjectRef invalidTopicId = ObjectRef.create((Object)UUID.randomUUID());
        while (true) {
            UUID uUID = (UUID)invalidTopicId.elem;
            if (uUID != null ? !((Object)uUID).equals(topicId) : topicId != null) break;
            invalidTopicId.elem = UUID.randomUUID();
        }
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, new HashSet<TopicIdPartition>(Collections.singletonList(new TopicIdPartition(utp.topic(), (UUID)invalidTopicId$1.elem, 2)))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, new HashSet<TopicIdPartition>(Arrays.asList(new TopicIdPartition(utp.topic(), topicId, 2), new TopicIdPartition(utp.topic(), topicId, 13)))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
    }

    @Test
    public void testRandomStringOnlyContainsAlphabets() {
        String randStr = RecoveryUtils.randomString((int)5);
        Assertions.assertEquals((int)5, (int)randStr.length());
        Assertions.assertTrue((boolean)randStr.matches("[a-zA-Z]+"));
    }

    public static final /* synthetic */ void $anonfun$testInjectTierTopicEventOnExistingTopic$2(RecordMetadata metadata) {
        Assertions.assertTrue((boolean)metadata.hasOffset());
        Assertions.assertEquals((long)0L, (long)metadata.offset());
        Assertions.assertTrue((metadata.serializedKeySize() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((metadata.serializedValueSize() > 0 ? 1 : 0) != 0);
    }
}

