/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.SelectFileTierPartitionStatePolicyUtils;
import kafka.tier.tools.TierMetadataRecoveryUtilsTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SelectFileTierPartitionStatePolicyUtilsTest {
    SelectFileTierPartitionStatePolicyUtilsTest() {
    }

    @Test
    void testGetAffectedTopicPartitions() throws Exception {
        Map.Entry<File, Set<TopicIdPartition>> reconciledDlvOutput = TierMetadataRecoveryUtilsTest.generateReconciledDLVOutputFile();
        Map.Entry<File, Set<TopicIdPartition>> nonReconciledDlvOutput = TierMetadataRecoveryUtilsTest.generateNonReconciledDLVOutputFile();
        Map.Entry<File, Set<TopicIdPartition>> affectedTopicPartitionsFile = TierMetadataRecoveryUtilsTest.generateAffectedTopicPartitionsFile();
        Set actualTopicPartitions = SelectFileTierPartitionStatePolicyUtils.getAffectedTopicPartitions((String)reconciledDlvOutput.getKey().getAbsolutePath(), null, null);
        Assertions.assertEquals(reconciledDlvOutput.getValue(), (Object)actualTopicPartitions);
        actualTopicPartitions = SelectFileTierPartitionStatePolicyUtils.getAffectedTopicPartitions(null, (String)nonReconciledDlvOutput.getKey().getAbsolutePath(), null);
        Assertions.assertEquals(nonReconciledDlvOutput.getValue(), (Object)actualTopicPartitions);
        actualTopicPartitions = SelectFileTierPartitionStatePolicyUtils.getAffectedTopicPartitions((String)reconciledDlvOutput.getKey().getAbsolutePath(), null, null);
        Assertions.assertEquals(reconciledDlvOutput.getValue(), (Object)actualTopicPartitions);
        actualTopicPartitions = SelectFileTierPartitionStatePolicyUtils.getAffectedTopicPartitions(null, null, (String)affectedTopicPartitionsFile.getKey().getAbsolutePath());
        Assertions.assertEquals(affectedTopicPartitionsFile.getValue(), (Object)actualTopicPartitions);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SelectFileTierPartitionStatePolicyUtils.getAffectedTopicPartitions((String)((File)reconciledDlvOutput.getKey()).getAbsolutePath(), (String)((File)nonReconciledDlvOutput.getKey()).getAbsolutePath(), null));
    }

    @Test
    void testValidateNumOfFTPSObjects() {
        String uploadPath0 = "prefix//remoteURI0";
        String uploadPath1 = "prefix//remoteURI1";
        String uploadPath2 = "prefix//remoteURI2";
        ArrayList<PartitionUploadInfo> uploadInfos = new ArrayList<PartitionUploadInfo>();
        uploadInfos.add(new PartitionUploadInfo(uploadPath0, true));
        uploadInfos.add(new PartitionUploadInfo(uploadPath1, false));
        uploadInfos.add(new PartitionUploadInfo(uploadPath2, false));
        int ftpsCount = uploadInfos.size();
        Assertions.assertDoesNotThrow(() -> SelectFileTierPartitionStatePolicyUtils.validateNumOfFTPSObjects((boolean)false, (int)ftpsCount, (List)uploadInfos));
        Assertions.assertDoesNotThrow(() -> SelectFileTierPartitionStatePolicyUtils.validateNumOfFTPSObjects((boolean)true, (int)(ftpsCount - 1), (List)uploadInfos));
        int replicationFactorOverride = ftpsCount + 1;
        try {
            SelectFileTierPartitionStatePolicyUtils.validateNumOfFTPSObjects((boolean)false, (int)replicationFactorOverride, uploadInfos);
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)String.format("Replication factor: %d is not equal to number of FTPS objects uploaded: %d. List of FTPS object store paths: %s", replicationFactorOverride, ftpsCount, uploadInfos.stream().map(uploadInfo -> uploadInfo.objectStorePath).collect(Collectors.toSet())), (Object)e.getMessage());
        }
    }
}

