/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.PathAndHeader;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.SelectRemoteFurthestFileTierPartitionStatePolicy;
import kafka.utils.TestUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SelectRemoteFurthestFileTierPartitionStateTest {
    private final TopicIdPartition tp = new TopicIdPartition("topic", UUID.randomUUID(), 0);
    private final File parentDir = TestUtils.tempDir();
    private final File dir = TestUtils.randomPartitionLogDir(this.parentDir);
    private FileTierPartitionState ftps;
    private MockInMemoryTierObjectStore objectStore;
    private final PrintStream standardOut = System.out;
    private final ByteArrayOutputStream outputStreamCaptor = new ByteArrayOutputStream();

    SelectRemoteFurthestFileTierPartitionStateTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        System.setOut(new PrintStream(this.outputStreamCaptor));
        MockTime time = new MockTime();
        this.ftps = new FileTierPartitionState(this.dir, null, this.tp.topicPartition(), true, (Scheduler)time.scheduler, true, false, (Time)time, new TierPartitionStateCleanupConfig(false, 0L, 0L), false, 0);
        this.ftps.setTopicId(this.tp.topicId());
        this.ftps.beginCatchup();
        this.ftps.onCatchUpComplete();
        this.objectStore = new MockInMemoryTierObjectStore((Time)time, new MockInMemoryTierObjectStoreConfig());
        this.objectStore.clearForClusterId();
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.ftps.close();
        this.objectStore.clearForClusterId();
        this.objectStore.close();
        this.dir.delete();
        this.parentDir.delete();
        System.setOut(this.standardOut);
    }

    void uploadInitiateAndComplete(FileTierPartitionState ftps, int epoch, UUID objectId, int startOffset, int endOffset, int size) {
        OffsetAndEpoch stateOffset = ftps.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)ftps.append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tp, epoch, objectId, (long)startOffset, (long)endOffset, 100L, 101L, size, true, false, true, TierUploadType.Archive, stateOffset, OpaqueData.ZEROED), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)ftps.append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tp, epoch, objectId, stateOffset), TierTestUtils.nextTierTopicOffsetAndEpoch()));
    }

    @Test
    void getFurthestFTPSTest() throws IOException, InterruptedException {
        Path flushedPath = Paths.get(this.ftps.flushedPath(), new String[0]);
        Path basePath = MergedLog.tierStateFile((File)this.dir, (long)0L, (String)"").getAbsoluteFile().toPath();
        String baseName = basePath.getFileName().toString();
        FileTierPartitionStateUploadObject uploadObject0 = new FileTierPartitionStateUploadObject(baseName, Algorithm.ADLER);
        String identifier = "rcca-1234";
        this.ftps.append((AbstractTierMetadata)new TierTopicInitLeader(this.tp, 0, UUID.randomUUID(), 2), TierTestUtils.nextTierTopicOffsetAndEpoch());
        this.uploadInitiateAndComplete(this.ftps, 0, UUID.randomUUID(), 0, 50, 0);
        Assertions.assertTrue((boolean)this.ftps.flush());
        FileTierPartitionStateRecoveryUploadMetadata metadata0 = new FileTierPartitionStateRecoveryUploadMetadata(identifier, Integer.valueOf(0), this.tp, uploadObject0);
        this.objectStore.putObject((ObjectStoreMetadata)metadata0, flushedPath.toFile(), ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD);
        this.uploadInitiateAndComplete(this.ftps, 0, UUID.randomUUID(), 25, 150, 0);
        Assertions.assertTrue((boolean)this.ftps.flush());
        FileTierPartitionStateRecoveryUploadMetadata metadata1 = new FileTierPartitionStateRecoveryUploadMetadata(identifier, Integer.valueOf(1), this.tp, uploadObject0);
        this.objectStore.putObject((ObjectStoreMetadata)metadata1, flushedPath.toFile(), ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD);
        this.uploadInitiateAndComplete(this.ftps, 0, UUID.randomUUID(), 125, 250, 0);
        Assertions.assertTrue((boolean)this.ftps.flush());
        FileTierPartitionStateRecoveryUploadMetadata metadata2 = new FileTierPartitionStateRecoveryUploadMetadata(identifier, Integer.valueOf(2), this.tp, uploadObject0);
        this.objectStore.putObject((ObjectStoreMetadata)metadata2, flushedPath.toFile(), ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD);
        String uploadPath0 = ((FragmentLocation)metadata0.toFragmentLocation(this.objectStore.keyPrefix(), FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath();
        String uploadPath1 = ((FragmentLocation)metadata1.toFragmentLocation(this.objectStore.keyPrefix(), FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath();
        String uploadPath2 = ((FragmentLocation)metadata2.toFragmentLocation(this.objectStore.keyPrefix(), FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath();
        ArrayList<PartitionUploadInfo> uploadInfos = new ArrayList<PartitionUploadInfo>();
        uploadInfos.add(new PartitionUploadInfo(uploadPath0, true));
        uploadInfos.add(new PartitionUploadInfo(uploadPath1, false));
        uploadInfos.add(new PartitionUploadInfo(uploadPath2, false));
        PathAndHeader furthestHeader = new PathAndHeader(uploadPath2, ChecksumUtils.readRemoteHeader((Algorithm)ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath), (InputStream)Files.newInputStream(flushedPath, new OpenOption[0])));
        Optional actualFurthestHeader = SelectRemoteFurthestFileTierPartitionStatePolicy.getFurthestFTPSForTopicPartition((TierObjectStore)this.objectStore, uploadInfos, (TopicIdPartition)this.tp);
        Assertions.assertTrue((boolean)actualFurthestHeader.isPresent());
        Assertions.assertEquals((Object)furthestHeader.path(), (Object)((PathAndHeader)actualFurthestHeader.get()).path());
        Assertions.assertEquals((Object)furthestHeader.header(), (Object)((PathAndHeader)actualFurthestHeader.get()).header());
    }
}

