/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tools.TierMetadataComparator;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.tier.tools.common.ComparatorInfo;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TierMetadataComparatorTest {
    private Time time = new MockTime();
    private List<FenceEventInfo> inputList;
    private final TopicIdPartition idPartitionA = new TopicIdPartition("test-topic", CoreUtils.uuidFromBase64((String)"0SoOrPUfRgaP7dExQdzWAg"), 0);
    private final TopicIdPartition idPartitionB = new TopicIdPartition("test-topic", CoreUtils.uuidFromBase64((String)"0SoOrPUfRgaP7dExQdzWAg"), 42);
    private final Set<TopicIdPartition> idPartitionSet = new HashSet<TopicIdPartition>(){
        {
            this.add(TierMetadataComparatorTest.this.idPartitionA);
            this.add(TierMetadataComparatorTest.this.idPartitionB);
        }
    };
    private final Function<TopicPartition, Long> constantStartOffsetProducer = topic -> 0L;
    private final CancellationContext cancellationContext = CancellationContext.newContext();
    private final TierObjectStore.Backend backend = TierObjectStore.Backend.Mock;
    private Optional<TierObjectStore> objStoreOpt;
    private Scheduler scheduler;
    private final String tierStateFileName;
    private static final String REPLICA_ID_A = "hostA";
    private static final String REPLICA_ID_B = "hostB";
    @TempDir
    public Path tempFolder;
    private AtomicLong revolvingOffset;

    public TierMetadataComparatorTest() {
        this.tierStateFileName = "00000000000000000000.tierstate" + (this.checksumEnabled() ? Algorithm.ADLER.suffix : Algorithm.NO_CHECKSUM.suffix);
    }

    boolean checksumEnabled() {
        return false;
    }

    private Path newTempFolder(String name) throws IOException {
        return Files.createDirectory(this.tempFolder.resolve(name), new FileAttribute[0]);
    }

    private Path newTempFile(String name) throws IOException {
        return Files.createFile(this.tempFolder.resolve(name), new FileAttribute[0]);
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.revolvingOffset = new AtomicLong(-1L);
        this.inputList = new ArrayList<FenceEventInfo>();
        this.inputList.add(new FenceEventInfo("test-topic", "0SoOrPUfRgaP7dExQdzWAg", 0, CoreUtils.uuidToBase64((UUID)UUID.randomUUID()), Boolean.valueOf(false), 201L, 1, 1598576601L));
        this.inputList.add(new FenceEventInfo("test-topic", "0SoOrPUfRgaP7dExQdzWAg", 42, CoreUtils.uuidToBase64((UUID)UUID.randomUUID()), Boolean.valueOf(false), 101L, 2, 1598576602L));
        this.scheduler = new KafkaScheduler(1, true, "test-scheduler-", false);
        this.scheduler.startup();
        this.initializeObjectStore(this.time);
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        this.scheduler.shutdown();
        TierObjectStoreFactory.closeBackendInstance((TierObjectStore.Backend)this.backend);
    }

    private void initializeObjectStore(Time time) {
        Properties props = new Properties();
        props.setProperty("confluent.tier.recovery.validate", "true");
        props.setProperty(KafkaConfig.TierBackendProp(), this.backend.getName());
        this.objStoreOpt = TierMetadataComparator.getObjectStoreMaybe((Time)time, (Properties)props);
    }

    @Test
    public void testTierFolderMapMap() throws IOException {
        ArrayList<Path> hostDirList = new ArrayList<Path>(){
            {
                this.add(TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
                this.add(TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_B));
            }
        };
        Properties props = new Properties();
        props.setProperty("confluent.tier.recovery.broker.workdir.list", hostDirList.stream().map(Path::toString).collect(Collectors.joining(",")));
        Map hostPathMap = TierMetadataComparator.getVerifiedTierFolderMap((Properties)props);
        Assertions.assertEquals((int)2, (int)hostPathMap.size(), (String)"Unexpected hostPathMap length!");
        Assertions.assertEquals(hostDirList.get(0), hostPathMap.get(REPLICA_ID_A), (String)"Incorrect hostA Path");
        Assertions.assertEquals(hostDirList.get(1), hostPathMap.get(REPLICA_ID_B), (String)"Incorrect hostA Path");
    }

    @Test
    public void testTierFolderMapThrowsOnNonExistentFolder() throws IOException {
        Properties props = new Properties();
        props.setProperty("confluent.tier.recovery.broker.workdir.list", "/path/to/hostA");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> TierMetadataComparator.getVerifiedTierFolderMap((Properties)props));
        Assertions.assertEquals((Object)"Incorrect workdir: /path/to/hostA", (Object)exception.getMessage(), (String)"Incorrect exception message");
    }

    @Test
    public void testTierFolderMapThrowsOnRematerializedKey() throws IOException {
        Path workdir = this.newTempFolder("rematerialized");
        Properties props = new Properties();
        props.setProperty("confluent.tier.recovery.broker.workdir.list", workdir.toString());
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> TierMetadataComparator.getVerifiedTierFolderMap((Properties)props));
        Assertions.assertEquals((Object)"replicaId can't be: rematerialized", (Object)exception.getMessage(), (String)"Incorrect exception message");
    }

    @Test
    public void testTierFolderMapThrowsOnDuplicateKey() throws IOException {
        Path workdir = this.newTempFolder(REPLICA_ID_A);
        Properties props = new Properties();
        props.setProperty("confluent.tier.recovery.broker.workdir.list", workdir.toString() + "," + workdir.toString());
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> TierMetadataComparator.getVerifiedTierFolderMap((Properties)props));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Found duplicate replicaId hostA"), (String)"Incorrect exception message");
    }

    @Test
    public void testComparatorInputGeneration() throws IOException {
        Path tempInputJsonFile = this.newTempFile("input.json");
        ObjectMapper mapper = new ObjectMapper();
        try (OutputStream out = Files.newOutputStream(tempInputJsonFile, new OpenOption[0]);){
            mapper.writeValue(out, this.inputList);
        }
        List receivedInputList = FenceEventInfo.jsonToList((Path)tempInputJsonFile);
        Assertions.assertEquals((int)this.inputList.size(), (int)receivedInputList.size(), (String)"Unexpected receivedInputList length!");
        Assertions.assertEquals((Object)this.inputList.get(0).toJson(), (Object)((FenceEventInfo)receivedInputList.get(0)).toJson(), (String)"Incorrect idPartitionA");
        Assertions.assertEquals((Object)this.inputList.get(1).toJson(), (Object)((FenceEventInfo)receivedInputList.get(1)).toJson(), (String)"Incorrect idPartitionB");
    }

    @Test
    public void testTopicIdPartitionFromInput() {
        Assertions.assertEquals((Object)this.idPartitionA, (Object)TierMetadataComparator.getTopicIdPartitionFromInput((FenceEventInfo)this.inputList.get(0)), (String)"Incorrect idPartitionA");
        Assertions.assertEquals((Object)this.idPartitionB, (Object)TierMetadataComparator.getTopicIdPartitionFromInput((FenceEventInfo)this.inputList.get(1)), (String)"Incorrect idPartitionB");
    }

    @Test
    public void testOffsetMapGeneration() {
        Map offsetMap = TierMetadataComparator.generateOffsetMapFromInput(this.inputList);
        Assertions.assertEquals((int)2, (int)offsetMap.size(), (String)"Unexpected offsetMap length!");
        Assertions.assertEquals((long)201L, (long)((Long)offsetMap.get(this.idPartitionA)), (String)"Incorrect idPartitionA offset");
        Assertions.assertEquals((long)101L, (long)((Long)offsetMap.get(this.idPartitionB)), (String)"Incorrect idPartitionA offset");
    }

    @Test
    public void testReplicaGenerationFromInput() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
                this.put(TierMetadataComparatorTest.REPLICA_ID_B, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_B));
            }
        };
        List<ComparatorInfo.ComparatorReplicaInfo> replicaList = this.generateReplicaInfo((Map<String, Path>)tierStateFolderMap);
        List replicaJsonList = replicaList.stream().map(ComparatorInfo.ComparatorReplicaInfo::toJson).collect(Collectors.toList());
        Assertions.assertEquals((int)(2 * this.inputList.size()), (int)replicaList.size(), (String)"Incorrect replicaList size");
        Path hostAidPartitionAFile = TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()).resolve(this.tierStateFileName);
        Path hostAidPartitionBFile = TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionB.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()).resolve(this.tierStateFileName);
        Assertions.assertTrue((boolean)replicaJsonList.contains(new ComparatorInfo.ComparatorReplicaInfo(REPLICA_ID_A, hostAidPartitionAFile, this.idPartitionA).toJson()), (String)("hostA:9092 didn't contain replica for: " + this.idPartitionA));
        Assertions.assertTrue((boolean)replicaJsonList.contains(new ComparatorInfo.ComparatorReplicaInfo(REPLICA_ID_A, hostAidPartitionBFile, this.idPartitionB).toJson()), (String)("hostA:9092 didn't contain replica for: " + this.idPartitionB));
        Path hostBidPartitionAFile = TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()).resolve(this.tierStateFileName);
        Path hostBidPartitionBFile = TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionB.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()).resolve(this.tierStateFileName);
        Assertions.assertTrue((boolean)replicaJsonList.contains(new ComparatorInfo.ComparatorReplicaInfo(REPLICA_ID_B, hostBidPartitionAFile, this.idPartitionA).toJson()), (String)("hostB:9092 didn't contain replica for: " + this.idPartitionA));
        Assertions.assertTrue((boolean)replicaJsonList.contains(new ComparatorInfo.ComparatorReplicaInfo(REPLICA_ID_B, hostBidPartitionBFile, this.idPartitionB).toJson()), (String)("hostB:9092 didn't contain replica for: " + this.idPartitionB));
    }

    @Test
    public void testSimpleTierStateFileValidation() throws IOException {
        Path workdir = this.newTempFolder(REPLICA_ID_A);
        Path idPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)workdir.toString()), new FileAttribute[0]);
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(2), idPartitionADir);
        TierMetadataValidator.TierMetadataValidatorResult result = TierMetadataValidator.validateStandaloneTierStateFile((Path)idPartitionADir.resolve(this.tierStateFileName), (TopicIdPartition)this.idPartitionA, Optional.empty(), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer);
        Assertions.assertTrue((boolean)result.headerOpt.isPresent());
        Assertions.assertTrue((boolean)result.valid);
        Assertions.assertEquals((Object)this.idPartitionA.topicId(), (Object)((Header)result.headerOpt.get()).topicId());
        Assertions.assertEquals((long)4L, (long)((Header)result.headerOpt.get()).localMaterializedOffsetAndEpoch().offset());
    }

    @Test
    public void testSimpleOffsetInconsistencies() throws IOException {
        ArrayList<AbstractMap.SimpleImmutableEntry<Long, Long>> inconsistentOffsetList = new ArrayList<AbstractMap.SimpleImmutableEntry<Long, Long>>(){
            {
                this.add(new AbstractMap.SimpleImmutableEntry<Long, Long>(0L, 100L));
                this.add(new AbstractMap.SimpleImmutableEntry<Long, Long>(102L, 200L));
            }
        };
        Path workdir = this.newTempFolder(REPLICA_ID_A);
        Path idPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)workdir.toString()), new FileAttribute[0]);
        this.generateTierStateFile(this.idPartitionA, (List<AbstractMap.SimpleImmutableEntry<Long, Long>>)inconsistentOffsetList, idPartitionADir);
        TierMetadataValidator.TierMetadataValidatorResult result = TierMetadataValidator.validateStandaloneTierStateFile((Path)idPartitionADir.resolve(this.tierStateFileName), (TopicIdPartition)this.idPartitionA, this.objStoreOpt, (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer);
        Assertions.assertTrue((boolean)result.headerOpt.isPresent());
        Assertions.assertFalse((boolean)result.valid);
    }

    @Test
    public void testInfoIsUpdatedOnValidation() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
            }
        };
        List<ComparatorInfo.ComparatorReplicaInfo> replicaList = this.generateReplicaInfo((Map<String, Path>)tierStateFolderMap);
        Assertions.assertEquals((int)2, (int)replicaList.size());
        replicaList.forEach(replicaInfo -> {
            TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE);
            if (this.idPartitionA.equals((Object)replicaInfo.topicIdPartition())) {
                Assertions.assertEquals((Object)this.idPartitionA.topicId(), (Object)replicaInfo.header.topicId());
                Assertions.assertEquals((long)4L, (long)replicaInfo.header.localMaterializedOffsetAndEpoch().offset());
            } else if (this.idPartitionB.equals((Object)replicaInfo.topicIdPartition())) {
                Assertions.assertEquals((Object)this.idPartitionB.topicId(), (Object)replicaInfo.header.topicId());
                Assertions.assertEquals((long)2L, (long)replicaInfo.header.localMaterializedOffsetAndEpoch().offset());
            }
            Assertions.assertEquals((Object)REPLICA_ID_A, (Object)replicaInfo.getReplica());
        });
    }

    @Test
    public void testValidationFailsOnOffsetScanEnable() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
            }
        };
        List<ComparatorInfo.ComparatorReplicaInfo> replicaList = this.generateReplicaInfo((Map<String, Path>)tierStateFolderMap);
        Assertions.assertEquals((int)2, (int)replicaList.size());
        replicaList.forEach(replicaInfo -> {
            TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)true, (TierPartitionStatus)TierPartitionStatus.ONLINE);
            Assertions.assertFalse((boolean)replicaInfo.isValidationSuccess());
            Assertions.assertNotNull((Object)replicaInfo.header);
            Assertions.assertEquals((Object)REPLICA_ID_A, (Object)replicaInfo.getReplica());
        });
    }

    @Test
    public void testChoiceRespectsHigherEndOffset() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
                this.put(TierMetadataComparatorTest.REPLICA_ID_B, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_B));
            }
        };
        Map<TopicIdPartition, Long> offsetMap = this.inputList.stream().collect(Collectors.toMap(TierMetadataComparator::getTopicIdPartitionFromInput, FenceEventInfo::recordOffset));
        Path hostAidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()), new FileAttribute[0]);
        Path hostAidPartitionBDir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionB.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()), new FileAttribute[0]);
        Path hostBidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()), new FileAttribute[0]);
        Path hostBidPartitionBDir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionB.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()), new FileAttribute[0]);
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(2), hostAidPartitionADir);
        this.resetOffset();
        FileTierPartitionState hostAidPartitionBFile = this.generateTierStateFile(this.idPartitionB, TierMetadataComparatorTest.generateOffsetList(1), hostAidPartitionBDir);
        this.resetOffset();
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(1), hostBidPartitionADir);
        this.resetOffset();
        this.generateTierStateFile(this.idPartitionB, TierMetadataComparatorTest.generateOffsetList(3), hostBidPartitionBDir);
        List validatedReplicaList = TierMetadataComparator.getReplicas(this.idPartitionSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)validatedReplicaList.size());
        Map choiceMap = TierMetadataComparator.generateChoices(validatedReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)choiceMap.size());
        Assertions.assertTrue((boolean)((Optional)choiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_A, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)4L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).lastOffset());
        Assertions.assertTrue((boolean)((Optional)choiceMap.get(this.idPartitionB)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_B, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionB)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionB)).get()).isValidationSuccess());
        Assertions.assertEquals((long)6L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionB)).get()).lastOffset());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)hostAidPartitionBFile.append((AbstractTierMetadata)new TierTopicInitLeader(this.idPartitionB, 1, UUID.randomUUID(), 0), new OffsetAndEpoch(42L, Optional.of(1))));
        hostAidPartitionBFile.flush();
        List updatedReplicaList = TierMetadataComparator.getReplicas(this.idPartitionSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)updatedReplicaList.size());
        Map updatedChoiceMap = TierMetadataComparator.generateChoices(updatedReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)updatedChoiceMap.size());
        Assertions.assertTrue((boolean)((Optional)updatedChoiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_A, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)4L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).lastOffset());
        Assertions.assertTrue((boolean)((Optional)updatedChoiceMap.get(this.idPartitionB)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_A, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionB)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionB)).get()).isValidationSuccess());
        Assertions.assertEquals((long)42L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionB)).get()).lastOffset());
    }

    @Test
    public void testChoiceRespectsValidatorResult() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
                this.put(TierMetadataComparatorTest.REPLICA_ID_B, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_B));
            }
        };
        Map<TopicIdPartition, Long> offsetMap = this.inputList.stream().collect(Collectors.toMap(TierMetadataComparator::getTopicIdPartitionFromInput, FenceEventInfo::recordOffset));
        Path hostAidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()), new FileAttribute[0]);
        Path hostBidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()), new FileAttribute[0]);
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(2), hostAidPartitionADir);
        this.resetOffset();
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(1), hostBidPartitionADir);
        Set<TopicIdPartition> singletonSet = Collections.singleton(this.idPartitionA);
        List validatedReplicaList = TierMetadataComparator.getReplicas(singletonSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Map choiceMap = TierMetadataComparator.generateChoices(validatedReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)validatedReplicaList.size());
        Assertions.assertTrue((boolean)((Optional)choiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_A, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)4L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).lastOffset());
        List failingReplicaList = validatedReplicaList.stream().peek(info -> {
            if (REPLICA_ID_A.equals(info.getReplica())) {
                info.setValidationSuccess(false);
            }
        }).collect(Collectors.toList());
        Map updatedChoiceMap = TierMetadataComparator.generateChoices(failingReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)failingReplicaList.size());
        Assertions.assertTrue((boolean)((Optional)updatedChoiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_B, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)2L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).lastOffset());
    }

    @Test
    public void testChoiceRespectsMetadataValidatorResult() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
                this.put(TierMetadataComparatorTest.REPLICA_ID_B, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_B));
            }
        };
        Map<TopicIdPartition, Long> offsetMap = this.inputList.stream().collect(Collectors.toMap(TierMetadataComparator::getTopicIdPartitionFromInput, FenceEventInfo::recordOffset));
        Path hostAidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()), new FileAttribute[0]);
        Path hostBidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()), new FileAttribute[0]);
        List<AbstractMap.SimpleImmutableEntry<Long, Long>> hostAOffsetList = TierMetadataComparatorTest.generateOffsetList(3);
        FileTierPartitionState hostATierStateFile = this.generateTierStateFile(this.idPartitionA, hostAOffsetList.subList(0, hostAOffsetList.size() - 1), hostAidPartitionADir);
        this.resetOffset();
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(1), hostBidPartitionADir);
        Set<TopicIdPartition> singletonSet = Collections.singleton(this.idPartitionA);
        List validatedReplicaList = TierMetadataComparator.getReplicas(singletonSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Map choiceMap = TierMetadataComparator.generateChoices(validatedReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)validatedReplicaList.size());
        Assertions.assertTrue((boolean)((Optional)choiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_A, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)4L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).lastOffset());
        this.revolvingOffset.set(hostATierStateFile.endOffset());
        AbstractMap.SimpleImmutableEntry<Long, Long> entry = hostAOffsetList.get(hostAOffsetList.size() - 1);
        TierSegmentUploadInitiate uploadInit = new TierSegmentUploadInitiate(this.idPartitionA, 0, UUID.randomUUID(), entry.getKey().longValue(), entry.getValue().longValue(), 1L, 100L, 100, false, false, false, TierUploadType.Archive, this.getNextOffset(), OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)hostATierStateFile.append((AbstractTierMetadata)uploadInit, uploadInit.stateOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)hostATierStateFile.append((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInit), this.getNextOffset()));
        hostATierStateFile.flush();
        List failingReplicaList = TierMetadataComparator.getReplicas(singletonSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Map updatedChoiceMap = TierMetadataComparator.generateChoices(failingReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)failingReplicaList.size());
        Assertions.assertTrue((boolean)((Optional)updatedChoiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_B, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)2L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).lastOffset());
    }

    @Test
    public void testChoiceRespectsFencedOffsetInput() throws IOException {
        HashMap<String, Path> tierStateFolderMap = new HashMap<String, Path>(){
            {
                this.put(TierMetadataComparatorTest.REPLICA_ID_A, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_A));
                this.put(TierMetadataComparatorTest.REPLICA_ID_B, TierMetadataComparatorTest.this.newTempFolder(TierMetadataComparatorTest.REPLICA_ID_B));
            }
        };
        Map<TopicIdPartition, Long> offsetMap = this.inputList.stream().collect(Collectors.toMap(TierMetadataComparator::getTopicIdPartitionFromInput, FenceEventInfo::recordOffset));
        Path hostAidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_A)).toString()), new FileAttribute[0]);
        Path hostBidPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)((Path)tierStateFolderMap.get(REPLICA_ID_B)).toString()), new FileAttribute[0]);
        FileTierPartitionState hostAFile = this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(2), hostAidPartitionADir);
        this.resetOffset();
        this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(1), hostBidPartitionADir);
        Set<TopicIdPartition> singletonSet = Collections.singleton(this.idPartitionA);
        List validatedReplicaList = TierMetadataComparator.getReplicas(singletonSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Map choiceMap = TierMetadataComparator.generateChoices(validatedReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)validatedReplicaList.size());
        Assertions.assertTrue((boolean)((Optional)choiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_A, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)4L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)choiceMap.get(this.idPartitionA)).get()).lastOffset());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)hostAFile.append((AbstractTierMetadata)new TierTopicInitLeader(this.idPartitionA, 1, UUID.randomUUID(), 0), new OffsetAndEpoch(offsetMap.get(this.idPartitionA) + 1L, Optional.of(1))));
        hostAFile.flush();
        List updatedReplicaList = TierMetadataComparator.getReplicas(singletonSet, (Map)tierStateFolderMap).stream().peek(replicaInfo -> TierMetadataComparator.validateTierStateAndUpdateInfo((ComparatorInfo.ComparatorReplicaInfo)replicaInfo, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, this.objStoreOpt, (boolean)false, (TierPartitionStatus)TierPartitionStatus.ONLINE)).collect(Collectors.toList());
        Map updatedChoiceMap = TierMetadataComparator.generateChoices(updatedReplicaList, offsetMap);
        Assertions.assertEquals((int)2, (int)updatedReplicaList.size());
        Assertions.assertTrue((boolean)((Optional)updatedChoiceMap.get(this.idPartitionA)).isPresent());
        Assertions.assertEquals((Object)REPLICA_ID_B, (Object)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).getReplica());
        Assertions.assertTrue((boolean)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).isValidationSuccess());
        Assertions.assertEquals((long)2L, (long)((ComparatorInfo.ComparatorReplicaInfo)((Optional)updatedChoiceMap.get(this.idPartitionA)).get()).lastOffset());
    }

    private static List<AbstractMap.SimpleImmutableEntry<Long, Long>> generateOffsetList(int size) {
        int segmentSize = 100;
        return LongStream.iterate(0L, offset -> offset + (long)segmentSize).limit(size).mapToObj(offset -> new AbstractMap.SimpleImmutableEntry<Long, Long>(offset, offset + (long)segmentSize - 1L)).collect(Collectors.toList());
    }

    private List<ComparatorInfo.ComparatorReplicaInfo> generateReplicaInfo(Map<String, Path> tierStateFolderMap) throws IOException {
        for (Path tempDir : tierStateFolderMap.values()) {
            Path idPartitionADir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionA.topicPartition(), (String)tempDir.toString()), new FileAttribute[0]);
            Path idPartitionBDir = Files.createDirectory(TierMetadataValidator.getSnapshotFilePath((TopicPartition)this.idPartitionB.topicPartition(), (String)tempDir.toString()), new FileAttribute[0]);
            this.generateTierStateFile(this.idPartitionA, TierMetadataComparatorTest.generateOffsetList(2), idPartitionADir);
            this.resetOffset();
            this.generateTierStateFile(this.idPartitionB, TierMetadataComparatorTest.generateOffsetList(1), idPartitionBDir);
        }
        return TierMetadataComparator.getReplicas(this.idPartitionSet, tierStateFolderMap);
    }

    private FileTierPartitionState generateTierStateFile(TopicIdPartition idPartition, List<AbstractMap.SimpleImmutableEntry<Long, Long>> startAndEndOffsets, Path tierStateFolder) throws IOException {
        FileTierPartitionState fileTierPartition = new FileTierPartitionState(tierStateFolder.toFile(), new LogDirFailureChannel(1), idPartition.topicPartition(), true, this.scheduler, this.checksumEnabled(), false, this.time, TierPartitionStateCleanupConfig.EMPTY, false, -1);
        fileTierPartition.setTopicId(idPartition.topicId());
        fileTierPartition.onCatchUpComplete();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)fileTierPartition.append((AbstractTierMetadata)new TierTopicInitLeader(idPartition, 0, UUID.randomUUID(), 0), this.getNextOffset()));
        startAndEndOffsets.forEach(entry -> {
            TierSegmentUploadInitiate uploadInit = new TierSegmentUploadInitiate(idPartition, 0, UUID.randomUUID(), ((Long)entry.getKey()).longValue(), ((Long)entry.getValue()).longValue(), 1L, 100L, 100, false, false, false, TierUploadType.Archive, this.getNextOffset(), OpaqueData.ZEROED);
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)fileTierPartition.append((AbstractTierMetadata)uploadInit, uploadInit.stateOffsetAndEpoch()));
            try {
                if (this.writeDummySegmentFile(uploadInit)) {
                    Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)fileTierPartition.append((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInit), this.getNextOffset()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        fileTierPartition.flush();
        Path generatedTierStateFile = tierStateFolder.resolve(this.tierStateFileName);
        Assertions.assertTrue((boolean)Files.isRegularFile(generatedTierStateFile, new LinkOption[0]));
        Assertions.assertTrue((Files.size(generatedTierStateFile) > 0L ? 1 : 0) != 0);
        return fileTierPartition;
    }

    private boolean writeDummySegmentFile(TierSegmentUploadInitiate uploadInitiate) throws IOException {
        if (this.objStoreOpt.isPresent()) {
            File segmentFile = TierMetadataValidatorTest.generateDummyTempFiles(uploadInitiate.objectIdAsBase64(), ObjectType.SEGMENT, uploadInitiate.size());
            File offsetIndexFile = TierMetadataValidatorTest.generateDummyTempFiles(uploadInitiate.objectIdAsBase64(), ObjectType.OFFSET_INDEX, uploadInitiate.size());
            File timestampIndexFile = TierMetadataValidatorTest.generateDummyTempFiles(uploadInitiate.objectIdAsBase64(), ObjectType.TIMESTAMP_INDEX, uploadInitiate.size());
            ObjectMetadata metadata = new ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.hasEpochState(), OpaqueData.ZEROED, (SegmentAndMetadataLayout)uploadInitiate.segmentAndMetadataLayout().orElse(null));
            this.objStoreOpt.get().putSegment(metadata, segmentFile, offsetIndexFile, timestampIndexFile, Optional.empty(), Optional.empty(), Optional.empty());
            return true;
        }
        return false;
    }

    private synchronized OffsetAndEpoch getNextOffset() {
        return new OffsetAndEpoch(this.revolvingOffset.incrementAndGet(), Optional.of(0));
    }

    private synchronized void resetOffset() {
        this.revolvingOffset.set(-1L);
    }
}

