/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.topic.TierTopicHeadDataLossReportReconciler;
import kafka.tier.topic.recovery.AffectedTierTopicPartitionInfo;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.ReconciledTierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TierMetadataRecoveryUtilsTest {
    TierMetadataRecoveryUtilsTest() {
    }

    @Test
    void testGetAffectedTopicPartitionsFromNonReconciledDLVOutput() throws Exception {
        Map.Entry<File, Set<TopicIdPartition>> dlvOutput = TierMetadataRecoveryUtilsTest.generateNonReconciledDLVOutputFile();
        Set actualTopicPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromNonReconciledDLVOutput((String)dlvOutput.getKey().getAbsolutePath());
        Assertions.assertEquals(dlvOutput.getValue(), (Object)actualTopicPartitions);
    }

    @Test
    void testGetAffectedTopicPartitionsFromReconciledDLVOutput() throws Exception {
        Map.Entry<File, Set<TopicIdPartition>> dlvOutput = TierMetadataRecoveryUtilsTest.generateReconciledDLVOutputFile();
        Set actualTopicPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromReconciledDLVOutput((String)dlvOutput.getKey().getAbsolutePath());
        Assertions.assertEquals(dlvOutput.getValue(), (Object)actualTopicPartitions);
    }

    @Test
    void testGetAffectedTopicPartitionsFromTopicPartitionsFile() throws Exception {
        Map.Entry<File, Set<TopicIdPartition>> affectedTopicPartitionsFile = TierMetadataRecoveryUtilsTest.generateAffectedTopicPartitionsFile();
        Set actualTopicPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromTargetTopicPartitionsFile((String)affectedTopicPartitionsFile.getKey().getAbsolutePath());
        Assertions.assertEquals(affectedTopicPartitionsFile.getValue(), (Object)actualTopicPartitions);
    }

    @Test
    void getIdentifierFromRecoveryDirTest() {
        String identifier = "rcca-1234";
        String recoveryDir = "prefix//recovery-rcca-1123/" + TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix() + "/" + "recovery-" + identifier;
        Assertions.assertEquals((Object)identifier, (Object)TierMetadataRecoveryUtils.getIdentifierFromRecoveryDir((String)recoveryDir));
        recoveryDir = "prefix//csafsdfsd";
        try {
            TierMetadataRecoveryUtils.getIdentifierFromRecoveryDir((String)recoveryDir);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)("Invalid recovery directory path: " + recoveryDir), (Object)e.getMessage());
        }
    }

    private static TierTopicHeadDataLossReport generateNonReconciledDLVReport() {
        final TopicIdPartition utp = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        final OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(1L, Optional.of(2));
        final int replicaId = 3;
        HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUtps = new HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo>(){
            {
                this.put(utp, new AffectedUserTopicPartitionInfo(4, offsetAndEpoch, TierPartitionStatus.ONLINE, false));
            }
        };
        final TopicPartition ttp = new TopicPartition("_confluent-tier-state", 0);
        HashMap<TopicPartition, AffectedTierTopicPartitionInfo> affectedTtps = new HashMap<TopicPartition, AffectedTierTopicPartitionInfo>(){
            {
                this.put(ttp, new AffectedTierTopicPartitionInfo(offsetAndEpoch, utp, TierPartitionStatus.ONLINE, false, replicaId, new OffsetAndEpoch(1L, Optional.of(1))));
            }
        };
        long timeMs = System.currentTimeMillis();
        return TierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, (int)replicaId, (ValidationSource)ValidationSource.ON_DEMAND_VALIDATION, (long)timeMs, (long)(timeMs + 1L), (Map)affectedUtps, (Map)affectedTtps, new HashSet(), new HashSet(), Collections.emptyList());
    }

    static Map.Entry<File, Set<TopicIdPartition>> generateNonReconciledDLVOutputFile() throws IOException {
        TierTopicHeadDataLossReport report = TierMetadataRecoveryUtilsTest.generateNonReconciledDLVReport();
        File dlvOutput = TestUtils.tempFile((String)"test", (String)".json");
        TierTopicHeadDataLossReport.writeJsonToFile((TierTopicHeadDataLossReport)report, (OutputStream)Files.newOutputStream(dlvOutput.toPath(), new OpenOption[0]));
        return new AbstractMap.SimpleEntry<File, Set<TopicIdPartition>>(dlvOutput, report.affectedUserTopicPartitions().keySet());
    }

    static Map.Entry<File, Set<TopicIdPartition>> generateReconciledDLVOutputFile() throws IOException {
        TierTopicHeadDataLossReport report = TierMetadataRecoveryUtilsTest.generateNonReconciledDLVReport();
        ReconciledTierTopicHeadDataLossReport reconciledDlvReport = ReconciledTierTopicHeadDataLossReport.createEmptyReport();
        reconciledDlvReport = TierTopicHeadDataLossReportReconciler.reconcileReportIncrementally((TierTopicHeadDataLossReport)report, (ReconciledTierTopicHeadDataLossReport)reconciledDlvReport);
        File reconciledDlvOutput = TestUtils.tempFile((String)"test", (String)".json");
        ReconciledTierTopicHeadDataLossReport.writeJsonToFile((ReconciledTierTopicHeadDataLossReport)reconciledDlvReport, (OutputStream)Files.newOutputStream(reconciledDlvOutput.toPath(), new OpenOption[0]));
        return new AbstractMap.SimpleEntry<File, Set<TopicIdPartition>>(reconciledDlvOutput, reconciledDlvReport.affectedUserTopicPartitions().keySet());
    }

    static Map.Entry<File, Set<TopicIdPartition>> generateAffectedTopicPartitionsFile() throws IOException {
        HashSet<TopicIdPartition> topicIdPartitions = new HashSet<TopicIdPartition>(){
            {
                this.add(new TopicIdPartition("topic", UUID.randomUUID(), 0));
                this.add(new TopicIdPartition("topic", UUID.randomUUID(), 1));
                this.add(new TopicIdPartition("topic2", UUID.randomUUID(), 2));
            }
        };
        String fileContent = topicIdPartitions.stream().map(TopicIdPartition::toString).collect(Collectors.joining("\n"));
        File testFile = TestUtils.tempFile((String)fileContent);
        return new AbstractMap.SimpleEntry<File, Set<TopicIdPartition>>(testFile, topicIdPartitions);
    }
}

