/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.tools.TierObjectStoreFactory;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierObjectStoreFactoryTest {
    MockTime time = new MockTime();

    @Test
    public void testObjectStoreInstanceReference() {
        Properties props = new Properties();
        props.setProperty("cluster-id", "mock-cluster");
        props.put(KafkaConfig.BrokerIdProp(), (Object)42);
        TierObjectStoreConfig mockConfig = TierObjectStoreUtils.generateBackendConfig((TierObjectStore.Backend)TierObjectStore.Backend.Mock, (Properties)props);
        TierObjectStore objectStore = TierObjectStoreFactory.getObjectStoreInstance((Time)this.time, (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)mockConfig);
        TierObjectStore secondInstance = TierObjectStoreFactory.getObjectStoreInstance((Time)this.time, (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)mockConfig);
        Assertions.assertEquals((Object)objectStore, (Object)secondInstance);
        TierObjectStoreFactory.closeBackendInstance((TierObjectStore.Backend)TierObjectStore.Backend.Mock);
        TierObjectStoreFactory.closeBackendInstance((TierObjectStore.Backend)TierObjectStore.Backend.Mock);
    }

    @Test
    public void testObjectStoreWithEmptyConfig() {
        Properties props = new Properties();
        TierObjectStoreConfig mockConfig = TierObjectStoreUtils.generateBackendConfig((TierObjectStore.Backend)TierObjectStore.Backend.Mock, (Properties)props);
        TierObjectStore objectStore = TierObjectStoreFactory.getObjectStoreInstance((Time)this.time, (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)mockConfig);
        TierObjectStore secondInstance = TierObjectStoreFactory.getObjectStoreInstance((Time)this.time, (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)mockConfig);
        Assertions.assertEquals((Object)objectStore, (Object)secondInstance);
        TierObjectStoreFactory.closeBackendInstance((TierObjectStore.Backend)TierObjectStore.Backend.Mock);
        TierObjectStoreFactory.closeBackendInstance((TierObjectStore.Backend)TierObjectStore.Backend.Mock);
    }
}

