/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierOffsetsRecoveryUploadMetadata;
import kafka.utils.CoreUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierOffsetsRecoveryUploadMetadataTest {
    @Test
    public void testObjectStoreFromPath() {
        String keyPrefix = "foo";
        String logDir = "log_00002";
        String identifier = "rcca-1234";
        Integer broker = 5;
        TierOffsetsRecoveryUploadMetadata metadata = new TierOffsetsRecoveryUploadMetadata(logDir, identifier, broker);
        String objectPath = ((FragmentLocation)metadata.toFragmentLocation(keyPrefix, FragmentType.TIER_OFFSETS_UPLOAD).get()).objectPath();
        String expectedObjectPath = String.format("%s%s/recovery-%s/%d/tier-offsets/%s/tier.offsets.%s", keyPrefix, TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), identifier, broker, CoreUtils.toBase64((byte[])logDir.getBytes()), ObjectType.TIER_OFFSETS_UPLOAD.suffix());
        Assertions.assertEquals((Object)objectPath, (Object)expectedObjectPath);
        TierOffsetsRecoveryUploadMetadata decodedMetadata = TierOffsetsRecoveryUploadMetadata.fromPath((String)objectPath);
        Assertions.assertEquals((Object)metadata, (Object)decodedMetadata);
    }
}

