/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.tools.RecoveryTestUtils;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="bazel:shard_count:2")
@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\u0007\u000e\u0001QAQa\u0007\u0001\u0005\u0002qAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004(\u0001\u0001\u0006I!\t\u0005\bQ\u0001\u0011\r\u0011\"\u0001*\u0011\u0019i\u0003\u0001)A\u0005U!9a\u0006\u0001b\u0001\n\u0003y\u0003B\u0002\u001d\u0001A\u0003%\u0001\u0007C\u0003:\u0001\u0011\u0005#\bC\u0004H\u0001\t\u0007I\u0011\u0002%\t\ru\u0003\u0001\u0015!\u0003J\u0011\u0015q\u0006\u0001\"\u0001`\u0005e\"\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3Ck2\\WI^3oiN4UM\\2j]\u001e$&/[4hKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\b\u0010\u0003\u0015!xn\u001c7t\u0015\t\u0001\u0012#\u0001\u0003uS\u0016\u0014(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00031E\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011!d\u0006\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011!D\u0001\u000b]Vl'I]8lKJ\u001cX#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u0007%sG/A\u0006ok6\u0014%o\\6feN\u0004\u0013A\u0006;jKJlU\r^1eCR\f\u0007+\u0019:uSRLwN\\:\u0016\u0003)\u0002\"AI\u0016\n\u00051\u001a#!B*i_J$\u0018a\u0006;jKJlU\r^1eCR\f\u0007+\u0019:uSRLwN\\:!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001B;uS2T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028e\tQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003m\u00022\u0001P B\u001b\u0005i$B\u0001 $\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0001v\u00121aU3r!\t\u0011U)D\u0001D\u0015\t!\u0015#\u0001\u0004tKJ4XM]\u0005\u0003\r\u000e\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006aA\u000f\u001d+p\u0005\u00164UM\\2fIV\t\u0011\n\u0005\u0003K\u001b>SV\"A&\u000b\u00051k\u0014!C5n[V$\u0018M\u00197f\u0013\tq5JA\u0002NCB\u0004\"\u0001\u0015-\u000e\u0003ES!AU*\u0002\r\r|W.\\8o\u0015\t\u0011BK\u0003\u0002V-\u00061\u0011\r]1dQ\u0016T\u0011aV\u0001\u0004_J<\u0017BA-R\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"AI.\n\u0005q\u001b#a\u0002\"p_2,\u0017M\\\u0001\u000eiB$vNQ3GK:\u001cW\r\u001a\u0011\u00027Q,7\u000f\u001e\"vY.4UM\\2j]\u001e,e/\u001a8ug&s'.Z2u)\t\u00017\r\u0005\u0002#C&\u0011!m\t\u0002\u0005+:LG\u000fC\u0003e\u0017\u0001\u0007Q-\u0001\u0004rk>\u0014X/\u001c\t\u0003M6t!aZ6\u0011\u0005!\u001cS\"A5\u000b\u0005)\u001c\u0012A\u0002\u001fs_>$h(\u0003\u0002mG\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta7\u0005\u000b\u0003\fcnd\bC\u0001:z\u001b\u0005\u0019(B\u0001;v\u0003\u0019\u0001\u0018M]1ng*\u0011ao^\u0001\bUV\u0004\u0018\u000e^3s\u0015\tAh+A\u0003kk:LG/\u0003\u0002{g\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002{\u0006\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDcaC@\u0002\f\u00055\u0001\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u00151/\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\tI!a\u0001\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ty!a\u0005\"\u0005\u0005E\u0011A\u0001>lC\t\t)\"A\u0003le\u00064G\u000fK\u0004\u0001\u00033\t)#a\n\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bv\u0003\r\t\u0007/[\u0005\u0005\u0003G\tiBA\u0002UC\u001e\fQA^1mk\u0016\f#!!\u000b\u0002'\t\f'0\u001a7;g\"\f'\u000fZ0d_VtGO\u000f\u001a")
public class TierPartitionStateBulkEventsFencingTriggerIntegrationTest
extends KafkaServerTestHarness {
    private final int numBrokers;
    private final short tierMetadataPartitions = (short)50;
    private final Properties overridingProps = new Properties();
    private final scala.collection.immutable.Map<TopicPartition, Object> tpToBeFenced;

    public int numBrokers() {
        return this.numBrokers;
    }

    public short tierMetadataPartitions() {
        return this.tierMetadataPartitions;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    private scala.collection.immutable.Map<TopicPartition, Object> tpToBeFenced() {
        return this.tpToBeFenced;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBulkFencingEventsInject(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierPartitionStateBulkEventsFencingTriggerIntegrationTest.$anonfun$testBulkFencingEventsInject$1(broker);
            return BoxedUnit.UNIT;
        });
        File propertiesConfFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        File workingDir = TestUtils.tempDirectory(null, null);
        Utils.mkProperties((java.util.Map)new HashMap<String, String>(this, workingDir){
            {
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put(KafkaConfig$.MODULE$.TierMetadataBootstrapServersProp(), "brokerList");
                this.put(KafkaConfig$.MODULE$.TierMetadataNamespaceProp(), "");
                this.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), Short.toString($outer.tierMetadataPartitions()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
            }
        }).store(new PrintWriter(propertiesConfFile), "");
        HashMap<TopicIdPartition, Boolean> tpIdToBeFenced = new HashMap<TopicIdPartition, Boolean>();
        this.tpToBeFenced().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateBulkEventsFencingTriggerIntegrationTest.$anonfun$testBulkFencingEventsInject$4(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            if (x$2 != null) {
                TopicPartition tp = (TopicPartition)x$2._1();
                boolean freezeFlag = x$2._2$mcZ$sp();
                this.createTopic(tp.topic(), 10, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
                UUID topicId = CoreUtils$.MODULE$.toJavaUUID((Uuid)this.getTopicIds((Seq<String>)new .colon.colon((Object)tp.topic(), (List)Nil$.MODULE$)).apply((Object)tp.topic()));
                return tpIdToBeFenced.put(new TopicIdPartition(tp.topic(), topicId, tp.partition()), Predef$.MODULE$.boolean2Boolean(freezeFlag));
            }
            throw new MatchError(null);
        });
        File topicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        RecoveryTestUtils.writeFencingFile(topicIdPartitionsFile, tpIdToBeFenced);
        File outputDir = TestUtils.tempDirectory(null, null);
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        int eventCount = 4123;
        RecoveryTestUtils.executeFencingTool(propertiesConfFile.getAbsolutePath(), topicIdPartitionsFile.getAbsolutePath(), fenceOutFile, eventCount);
        ListBuffer<ConsumerRecord<byte[], byte[]>> records = TierTestUtils$.MODULE$.readTierTopicRecords(this.bootstrapServers(this.bootstrapServers$default$1()), this.tierMetadataPartitions());
        HashMap partitionFenceCountMap = new HashMap();
        records.foreach((Function1 & Serializable)record -> {
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            if (TierRecordType.PartitionFence.equals(((AbstractTierMetadata)eventOpt.get()).type())) {
                TopicIdPartition key = ((AbstractTierMetadata)eventOpt.get()).topicIdPartition();
                return partitionFenceCountMap.put(key, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(partitionFenceCountMap.getOrDefault(key, Predef$.MODULE$.int2Integer(0))) + 1));
            }
            return BoxedUnit.UNIT;
        });
        tpIdToBeFenced.forEach((tpId, x$3) -> Assertions.assertEquals((int)eventCount, (Integer)((Integer)partitionFenceCountMap.get(tpId))));
    }

    public static final /* synthetic */ boolean $anonfun$testBulkFencingEventsInject$2(TierTopicManager eta$0$1$1) {
        return eta$0$1$1.isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$testBulkFencingEventsInject$3() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBulkFencingEventsInject$1(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testBulkFencingEventsInject$4(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public TierPartitionStateBulkEventsFencingTriggerIntegrationTest() {
        this.numBrokers = 3;
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), Short.toString(this.tierMetadataPartitions()));
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierTopicFencingDuringDataLossEnableProp(), "true");
        this.tpToBeFenced = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("the_dark_knight", 2)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("mummy_returns", 3)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("mission_impossible", 5)), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    }
}

