/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.tools.RecoveryTestUtils;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q4AAC\u0006\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002BB\u0013\u0001A\u0003%q\u0004C\u0004'\u0001\t\u0007I\u0011A\u0014\t\r-\u0002\u0001\u0015!\u0003)\u0011\u001da\u0003A1A\u0005\u00025BaA\u000e\u0001!\u0002\u0013q\u0003\"B\u001c\u0001\t\u0003B\u0004\"B#\u0001\t\u00031%A\u000f+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$U/\\7z\u000bZ,g\u000e^:GK:\u001c\u0017N\\4Ue&<w-\u001a:J]R,wM]1uS>tG+Z:u\u0015\taQ\"A\u0003u_>d7O\u0003\u0002\u000f\u001f\u0005!A/[3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!AF\b\u0002\u0017%tG/Z4sCRLwN\\\u0005\u00031U\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003-\t!B\\;n\u0005J|7.\u001a:t+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#aA%oi\u0006Ya.^7Ce>\\WM]:!\u0003Y!\u0018.\u001a:NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cX#\u0001\u0015\u0011\u0005\u0001J\u0013B\u0001\u0016\"\u0005\u0015\u0019\u0006n\u001c:u\u0003]!\u0018.\u001a:NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001c\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u001d\u0011\u0007ijt(D\u0001<\u0015\ta\u0014%\u0001\u0006d_2dWm\u0019;j_:L!AP\u001e\u0003\u0007M+\u0017\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u001f\u000511/\u001a:wKJL!\u0001R!\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001(i\u0016\u001cH\u000fV5feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0012+X.\\=Fm\u0016tGo]%oU\u0016\u001cG\u000f\u0006\u0002H\u0015B\u0011\u0001\u0005S\u0005\u0003\u0013\u0006\u0012A!\u00168ji\")1*\u0003a\u0001\u0019\u00061\u0011/^8sk6\u0004\"!\u0014+\u000f\u00059\u0013\u0006CA(\"\u001b\u0005\u0001&BA)\u0012\u0003\u0019a$o\\8u}%\u00111+I\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002TC!\"\u0011\u0002\u00173f!\tI&-D\u0001[\u0015\tYF,\u0001\u0004qCJ\fWn\u001d\u0006\u0003;z\u000bqA[;qSR,'O\u0003\u0002`A\u0006)!.\u001e8ji*\t\u0011-A\u0002pe\u001eL!a\u0019.\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u00014\u0002Em$\u0017n\u001d9mCft\u0015-\\3~]m\f'oZ;nK:$8oV5uQ:\u000bW.Z:~Q\u0011I\u0001N\\8\u0011\u0005%dW\"\u00016\u000b\u0005-T\u0016\u0001\u00039s_ZLG-\u001a:\n\u00055T'a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002qe\u0006\n\u0011/\u0001\u0002{W\u0006\n1/A\u0003le\u00064G\u000f")
public class TierPartitionStateDummyEventsFencingTriggerIntegrationTest
extends KafkaServerTestHarness {
    private final int numBrokers;
    private final short tierMetadataPartitions = (short)50;
    private final Properties overridingProps = new Properties();

    public int numBrokers() {
        return this.numBrokers;
    }

    public short tierMetadataPartitions() {
        return this.tierMetadataPartitions;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierTopicPartitionDummyEventsInject(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierPartitionStateDummyEventsFencingTriggerIntegrationTest.$anonfun$testTierTopicPartitionDummyEventsInject$1(broker);
            return BoxedUnit.UNIT;
        });
        File propertiesConfFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        File workingDir = TestUtils.tempDirectory(null, null);
        Utils.mkProperties((java.util.Map)new HashMap<String, String>(this, workingDir){
            {
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put(KafkaConfig$.MODULE$.TierMetadataBootstrapServersProp(), "brokerList");
                this.put(KafkaConfig$.MODULE$.TierMetadataNamespaceProp(), "");
                this.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), Short.toString($outer.tierMetadataPartitions()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
            }
        }).store(new PrintWriter(propertiesConfFile), "");
        File ttpTargetOffsetsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        PrintWriter pw = new PrintWriter(ttpTargetOffsetsFile);
        int partition0 = 0;
        int targetOffset0 = 5;
        int partition1 = 1;
        int targetOffset1 = 3;
        pw.write(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition0), BoxesRunTime.boxToInteger((int)targetOffset0)})));
        pw.println();
        pw.write(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition1), BoxesRunTime.boxToInteger((int)targetOffset1)})));
        pw.println();
        pw.close();
        RecoveryTestUtils.executeFencingToolDummyEvents(propertiesConfFile.getPath(), ttpTargetOffsetsFile.getAbsolutePath());
        ListBuffer<ConsumerRecord<byte[], byte[]>> records = TierTestUtils$.MODULE$.readTierTopicRecords(this.bootstrapServers(this.bootstrapServers$default$1()), this.tierMetadataPartitions());
        IntRef numFencingEvents0 = IntRef.create((int)0);
        IntRef numFencingEvents1 = IntRef.create((int)0);
        records.foreach((Function1 & Serializable)record -> {
            TierPartitionStateDummyEventsFencingTriggerIntegrationTest.$anonfun$testTierTopicPartitionDummyEventsInject$4(partition0, numFencingEvents0, partition1, numFencingEvents1, record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(targetOffset0 + 2), (int)numFencingEvents0.elem);
        Assertions.assertEquals((int)(targetOffset1 + 2), (int)numFencingEvents1.elem);
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicPartitionDummyEventsInject$2(TierTopicManager eta$0$1$1) {
        return eta$0$1$1.isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$testTierTopicPartitionDummyEventsInject$3() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicPartitionDummyEventsInject$1(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testTierTopicPartitionDummyEventsInject$4(int partition0$1, IntRef numFencingEvents0$1, int partition1$1, IntRef numFencingEvents1$1, ConsumerRecord record) {
        Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
        Assertions.assertTrue((boolean)eventOpt.isPresent());
        if (TierRecordType.PartitionFence.equals(((AbstractTierMetadata)eventOpt.get()).type()) && ((AbstractTierMetadata)eventOpt.get()).topicIdPartition().topic().contains("admin_fencing_topic_")) {
            int n = record.partition();
            if (partition0$1 == n) {
                ++numFencingEvents0$1.elem;
                return;
            }
            if (partition1$1 == n) {
                ++numFencingEvents1$1.elem;
                return;
            }
            throw new IllegalStateException("Unexpected partition");
        }
    }

    public TierPartitionStateDummyEventsFencingTriggerIntegrationTest() {
        this.numBrokers = 3;
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), Short.toString(this.tierMetadataPartitions()));
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierTopicFencingDuringDataLossEnableProp(), "true");
    }
}

