/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.server.KafkaConfig;
import kafka.tier.tools.RecoveryTestUtils;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierPartitionStateDummyEventsFencingTriggerTest {
    @Test
    public void testParseTierTopicPartitionTargetOffsetsInput() {
        int p1 = 1;
        long o1 = 234L;
        int p2 = 5;
        long o2 = 6789L;
        List<String> inputStr = Arrays.asList(String.format("%d %d", p1, o1), String.format("%d %d", p2, o2));
        UUID topicId = UUID.randomUUID();
        String topicName = "dummy-topic";
        Map offsetMap = TierPartitionStateFencingTrigger.parseTierTopicPartitionTargetOffset((UUID)topicId, (String)topicName, (int)1000, inputStr, (int)50);
        Assertions.assertEquals((int)2, (int)offsetMap.size());
        Assertions.assertTrue((boolean)offsetMap.values().containsAll(Arrays.asList(o1, o2)));
    }

    @Test
    public void testDummyEventsFencingWithInvalidInputs() throws Exception {
        File propertiesFile = TestUtils.tempFile();
        File workingDir = TestUtils.tempDirectory();
        Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bootstrap.servers", (Object)"brokerList"), Utils.mkEntry((Object)KafkaConfig.TierMetadataBootstrapServersProp(), (Object)"brokerList"), Utils.mkEntry((Object)KafkaConfig.TierMetadataNamespaceProp(), (Object)""), Utils.mkEntry((Object)"confluent.tier.recovery.working.dir", (Object)workingDir.getAbsolutePath())})).store(new PrintWriter(propertiesFile), "");
        File targetOffsetsFile = TestUtils.tempFile();
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingToolDummyEvents(propertiesFile.getPath(), targetOffsetsFile.getPath()));
        try (PrintWriter pw = new PrintWriter(targetOffsetsFile);){
            pw.write(String.format("%d %d", 1, 234));
            pw.println();
            pw.write(String.format("%d", 5));
        }
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingToolDummyEvents(propertiesFile.getPath(), targetOffsetsFile.getPath()));
        pw = new PrintWriter(targetOffsetsFile);
        var5_5 = null;
        try {
            pw.write(String.format("%s %d", "abc", 234));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (pw != null) {
                if (var5_5 != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    pw.close();
                }
            }
        }
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingToolDummyEvents(propertiesFile.getPath(), targetOffsetsFile.getPath()));
    }

    @Test
    public void testDummyEventsFencingWithInvalidPropertiesFiles() throws IOException {
        File targetOffsetsFile = TestUtils.tempFile();
        try (PrintWriter pw = new PrintWriter(targetOffsetsFile);){
            pw.write(String.format("%d %d", 1, 234));
        }
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingToolDummyEvents("non-existing-file", targetOffsetsFile.getPath()));
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingToolDummyEvents(TestUtils.tempFile().getPath(), targetOffsetsFile.getPath()));
    }
}

