/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kafka.api.IntegrationTestHarness;
import kafka.log.LocalLog$;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierRecordType;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils;
import kafka.tier.tools.TierPartitionStateFencingIntegrationTriggerTest$;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:3")})
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\u0014(\u00019BQ!\u000e\u0001\u0005\u0002YBQ!\u000f\u0001\u0005RiBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004S\u0001\u0001\u0006Ia\u0011\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019i\u0006\u0001)A\u0005+\"9a\f\u0001a\u0001\n\u0013y\u0006bB5\u0001\u0001\u0004%IA\u001b\u0005\u0007a\u0002\u0001\u000b\u0015\u00021\t\u000fE\u0004!\u0019!C\u0005e\"9\u0011\u0011\u0002\u0001!\u0002\u0013\u0019\b\"CA\u0006\u0001\t\u0007I\u0011BA\u0007\u0011!\t)\u0003\u0001Q\u0001\n\u0005=\u0001bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003SA1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:!Y\u0011Q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0016\u0011-\ty\u0004\u0001a\u0001\u0002\u0004%I!!\u000b\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111\t\u0005\f\u0003\u000f\u0002\u0001\u0019!A!B\u0013\tY\u0003C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002L!A\u00111\f\u0001!\u0002\u0013\ti\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`!A\u0011q\r\u0001!\u0002\u0013\t\t\u0007\u0003\u0005\u0002j\u0001\u0011\r\u0011\"\u0003;\u0011\u001d\tY\u0007\u0001Q\u0001\nmB1\"!\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002p!Y\u00111\u0011\u0001A\u0002\u0003\u0007I\u0011BAC\u0011-\tI\t\u0001a\u0001\u0002\u0003\u0006K!!\u001d\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011q\u0016\u0001\u0005B\u0005E\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u000b\u0004A\u0011IAd\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'<qA!\u000b(\u0011\u0003\u0011YC\u0002\u0004'O!\u0005!Q\u0006\u0005\u0007k\r\"\tA!\u000e\t\u000f\tU1\u0005\"\u0001\u00038\tyC+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r\u0016t7-\u001b8h\u0013:$Xm\u001a:bi&|g\u000e\u0016:jO\u001e,'\u000fV3ti*\u0011\u0001&K\u0001\u0006i>|Gn\u001d\u0006\u0003U-\nA\u0001^5fe*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00194\u001b\u0005\t$B\u0001\u001a,\u0003\r\t\u0007/[\u0005\u0003iE\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003\u001d\n1B\u0019:pW\u0016\u00148i\\;oiV\t1\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0002J]R\fA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dW#A\"\u0011\u0005\u0011\u0003V\"A#\u000b\u0005\u0019;\u0015a\u00017pO*\u0011\u0001*S\u0001\nS:$XM\u001d8bYNT!AS&\u0002\u000fM$xN]1hK*\u0011A\u0006\u0014\u0006\u0003\u001b:\u000ba!\u00199bG\",'\"A(\u0002\u0007=\u0014x-\u0003\u0002R\u000b\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0005Y\u0006twMC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q;&AB*ue&tw-A\u0004m_\u001e$\u0015N\u001d\u0011\u0002/QLWM\u001d)beRLG/[8o'R\fG/\u001a$jY\u0016\u001cX#\u00011\u0011\u0007q\n7-\u0003\u0002c{\t)\u0011I\u001d:bsB\u0011AmZ\u0007\u0002K*\u0011a-K\u0001\u0006gR\fG/Z\u0005\u0003Q\u0016\u0014aCR5mKRKWM\u001d)beRLG/[8o'R\fG/Z\u0001\u001ci&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR5mKN|F%Z9\u0015\u0005-t\u0007C\u0001\u001fm\u0013\tiWH\u0001\u0003V]&$\bbB8\t\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\n\u0014\u0001\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015\u000e\\3tA\u0005aA\u000f\u001d+p\u0005\u00164UM\\2fIV\t1\u000fE\u0003usn\f\u0019!D\u0001v\u0015\t1x/A\u0005j[6,H/\u00192mK*\u0011\u00010P\u0001\u000bG>dG.Z2uS>t\u0017B\u0001>v\u0005\ri\u0015\r\u001d\t\u0003y~l\u0011! \u0006\u0003}.\u000baaY8n[>t\u0017bAA\u0001{\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007c\u0001\u001f\u0002\u0006%\u0019\u0011qA\u001f\u0003\u000f\t{w\u000e\\3b]\u0006iA\u000f\u001d+p\u0005\u00164UM\\2fI\u0002\na\u0002\u001e9JIR{')\u001a$f]\u000e,G-\u0006\u0002\u0002\u0010AA\u0011\u0011CA\f\u00033\t\t#\u0004\u0002\u0002\u0014)\u0019\u0011QC-\u0002\tU$\u0018\u000e\\\u0005\u0004u\u0006M\u0001\u0003BA\u000e\u0003;i\u0011!K\u0005\u0004\u0003?I#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\r1\u00161E\u0005\u0004\u0003\u000f9\u0016a\u0004;q\u0013\u0012$vNQ3GK:\u001cW\r\u001a\u0011\u0002+Q|\u0007/[2JIB\u000b'\u000f^5uS>t7OR5mKV\u0011\u00111\u0006\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011G-\u0002\u0005%|\u0017\u0002BA\u001b\u0003_\u0011AAR5mK\u0006IBo\u001c9jG&#\u0007+\u0019:uSRLwN\\:GS2,w\fJ3r)\rY\u00171\b\u0005\t_>\t\t\u00111\u0001\u0002,\u00051Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\:GS2,\u0007%\u0001\nqe>\u0004XM\u001d;jKN\u001cuN\u001c4GS2,\u0017A\u00069s_B,'\u000f^5fg\u000e{gN\u001a$jY\u0016|F%Z9\u0015\u0007-\f)\u0005\u0003\u0005p%\u0005\u0005\t\u0019AA\u0016\u0003M\u0001(o\u001c9feRLWm]\"p]\u001a4\u0015\u000e\\3!\u0003!iwnY6US6,WCAA'!\u0011\ty%a\u0016\u000e\u0005\u0005E#\u0002BA\u000b\u0003'R1!!\u0016L\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011LA)\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u00039\u0019G.Z1okB$U\r\\1z\u001bN,\"!!\u0019\u0011\u0007q\n\u0019'C\u0002\u0002fu\u0012A\u0001T8oO\u0006y1\r\\3b]V\u0004H)\u001a7bs6\u001b\b%A\tdY\u0016\fg.\u001e9J]R,'O^1m\u001bN\f!c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'tA\u0005AA/Z:u\u0013:4w.\u0006\u0002\u0002rA!\u00111OA@\u001b\t\t)HC\u00023\u0003oRA!!\u001f\u0002|\u00059!.\u001e9ji\u0016\u0014(bAA?\u001d\u0006)!.\u001e8ji&!\u0011\u0011QA;\u0005!!Vm\u001d;J]\u001a|\u0017\u0001\u0004;fgRLeNZ8`I\u0015\fHcA6\u0002\b\"AqnGA\u0001\u0002\u0004\t\t(A\u0005uKN$\u0018J\u001c4pA\u0005Q\u0011\r\u001a3SKBd\u0017nY1\u0015\u0017-\fy)a%\u0002$\u0006\u001d\u00161\u0016\u0005\b\u0003#k\u0002\u0019AA\r\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0016v\u0001\r!a&\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti*K\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003C\u000bYJA\tUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJDq!!*\u001e\u0001\u0004\t\u0019!\u0001\bd_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3\t\u000f\u0005%V\u00041\u0001\u0002\u0004\u0005\tC/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f':\f\u0007o\u001d5pi\u0016s\u0017M\u00197fI\"1\u0011QV\u000fA\u0002m\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004W\u0006M\u0006bBA7=\u0001\u0007\u0011\u0011\u000f\u0015\u0004=\u0005]\u0006\u0003BA:\u0003sKA!a/\u0002v\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002CM,Go\u00158baNDw\u000e^\"p]\u001aLw-\u00118e\u0007>l\u0007\u000f\\3uKN+G/\u001e9\u0015\u0007-\f\t\rC\u0004\u0002D~\u0001\r!a\u0001\u0002UQLWM\u001d+pa&\u001cW*\u0019;fe&\fG.\u001b>bi&|gN\u0012:p[Ns\u0017\r]:i_R,e.\u00192mK\u0006AA/Z1s\t><h\u000eF\u0001lQ\r\u0001\u00131\u001a\t\u0005\u0003g\ni-\u0003\u0003\u0002P\u0006U$!C!gi\u0016\u0014X)Y2i\u0003)\"Xm\u001d;QCJ$\u0018\u000e^5p]\u001a+gnY3Fm\u0016tG/\u00138kK\u000e$\u0018n\u001c8B]\u00124UM\\2j]\u001e$\u0012b[Ak\u0003/\fI.a7\t\u000f\u0005\u0015\u0016\u00051\u0001\u0002\u0004!9\u0011\u0011V\u0011A\u0002\u0005\r\u0001bBAbC\u0001\u0007\u00111\u0001\u0005\b\u0003;\f\u0003\u0019AAp\u0003\u0019\tXo\u001c:v[B!\u0011\u0011]Ax\u001d\u0011\t\u0019/a;\u0011\u0007\u0005\u0015X(\u0004\u0002\u0002h*\u0019\u0011\u0011^\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\ti/P\u0001\u0007!J,G-\u001a4\n\u0007q\u000b\tPC\u0002\u0002nvB3!IA{!\u0011\t90!@\u000e\u0005\u0005e(\u0002BA~\u0003o\na\u0001]1sC6\u001c\u0018\u0002BA\u0000\u0003s\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d\t#1\u0001B\b\u0005#\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0005\u0005\u0013\tI0\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\u0011iAa\u0002\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\tM\u0011E\u0001B\u000b\u0003\u0019:WM\\3sCR,'i\\8mK\u0006t7i\\7cS:\fG/[8ogN:\u0016\u000e\u001e5Rk>\u0014X/\u001c\u0015\b\u0001\te!q\u0002B\u0010!\u0011\t\u0019Ha\u0007\n\t\tu\u0011Q\u000f\u0002\u0004)\u0006<\u0017E\u0001B\u0011\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8)\u000f\u0001\u0011IBa\u0004\u0003&\u0005\u0012!qE\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(hM\u00010)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR3oG&tw-\u00138uK\u001e\u0014\u0018\r^5p]R\u0013\u0018nZ4feR+7\u000f\u001e\t\u0003q\r\u001a2a\tB\u0018!\ra$\u0011G\u0005\u0004\u0005gi$AB!osJ+g\r\u0006\u0002\u0003,U\u0011!\u0011\b\t\u0007\u0005w\u0011\tE!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0003'\taa\u001d;sK\u0006l\u0017\u0002\u0002B\"\u0005{\u0011aa\u0015;sK\u0006l\u0007\u0003\u0002B\u0003\u0005\u000fJAA!\u0013\u0003\b\tI\u0011I]4v[\u0016tGo\u001d")
public class TierPartitionStateFencingIntegrationTriggerTest
extends IntegrationTestHarness {
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final String logDir = TestUtils.tempDirectory(null, null).getAbsolutePath();
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final scala.collection.immutable.Map<TopicPartition, Object> tpToBeFenced = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("the_dark_knight", 2)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("mummy_returns", 3)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("mission_impossible", 5)), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    private final Map<TopicIdPartition, Boolean> tpIdToBeFenced = new HashMap<TopicIdPartition, Boolean>();
    private File topicIdPartitionsFile;
    private File propertiesConfFile;
    private final MockTime mockTime = new MockTime();
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private TestInfo testInfo;

    public static Stream<Arguments> generateBooleanCombinations3WithQuorum() {
        return TierPartitionStateFencingIntegrationTriggerTest$.MODULE$.generateBooleanCombinations3WithQuorum();
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    private LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private String logDir() {
        return this.logDir;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> tpToBeFenced() {
        return this.tpToBeFenced;
    }

    private Map<TopicIdPartition, Boolean> tpIdToBeFenced() {
        return this.tpIdToBeFenced;
    }

    private File topicIdPartitionsFile() {
        return this.topicIdPartitionsFile;
    }

    private void topicIdPartitionsFile_$eq(File x$1) {
        this.topicIdPartitionsFile = x$1;
    }

    private File propertiesConfFile() {
        return this.propertiesConfFile;
    }

    private void propertiesConfFile_$eq(File x$1) {
        this.propertiesConfFile = x$1;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    private int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, boolean compactEnabled, boolean tierPartitionStateSnapshotEnabled, int brokerId) {
        boolean checksumEnabled = true;
        boolean cleanupEnabled = true;
        TopicPartition logDirName_topicPartition = topicIdPartition.topicPartition();
        Object var10_8 = null;
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, this.logDirFailureChannel(), topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler, checksumEnabled, compactEnabled, (Time)this.mockTime(), new TierPartitionStateCleanupConfig(cleanupEnabled, this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), tierPartitionStateSnapshotEnabled, brokerId);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        tierPartitionState.setTieredPartitionRecoveryWorkflowCb(op -> System.out.println(new StringBuilder(14).append("Received ").append(op.toString()).append(" for ").append(topicIdPartition).toString()));
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(48).append("TierPartitionStateFencingIntegrationTriggerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus targetStatus, OffsetAndEpoch sourceOffsetAndEpoch, Optional<ByteBuffer> targetStateOpt) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, targetStateOpt, targetStatus, sourceOffsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer snapshotBuffer, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.processSnapshotMaterializationEvent(metadata, snapshotBuffer, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public long localMaterializedOffset() {
                return this.tierPartitionState$1.lastLocalMaterializedSrcOffsetAndEpoch().offset();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }

            public void beginDiscover() {
                this.tierPartitionState$1.beginDiscover();
            }

            public void completeDiscover() {
                this.tierPartitionState$1.onDiscoverComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
    }

    public void setSnapshotConfigAndCompleteSetup(boolean tierTopicMaterializationFromSnapshotEnable) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicMaterializationFromSnapshotEnableProp(), Boolean.toString(tierTopicMaterializationFromSnapshotEnable));
        super.setUp(this.testInfo());
        this.topicIdPartitionsFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.tpToBeFenced().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$setSnapshotConfigAndCompleteSetup$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
            if (x$4 != null) {
                TopicPartition tpid = (TopicPartition)x$4._1();
                boolean freezeFlag = x$4._2$mcZ$sp();
                this.createTopic(tpid.topic(), 10, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
                UUID topicId = CoreUtils$.MODULE$.toJavaUUID((Uuid)this.getTopicIds((Seq<String>)new .colon.colon((Object)tpid.topic(), (List)Nil$.MODULE$)).apply((Object)tpid.topic()));
                return this.tpIdToBeFenced().put(new TopicIdPartition(tpid.topic(), topicId, tpid.partition()), Predef$.MODULE$.boolean2Boolean(freezeFlag));
            }
            throw new MatchError(null);
        });
        RecoveryTestUtils.writeFencingFile(this.topicIdPartitionsFile(), this.tpIdToBeFenced());
        this.propertiesConfFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Function1 & Serializable)tierPartitionState -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$tearDown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations3WithQuorum"})
    public void testPartitionFenceEventInjectionAndFencing(boolean compactEnabled, boolean tierPartitionStateSnapshotEnabled, boolean tierTopicMaterializationFromSnapshotEnable, String quorum) {
        this.setSnapshotConfigAndCompleteSetup(tierTopicMaterializationFromSnapshotEnable);
        int brokerId = 0;
        String tierTopicNamespace = "";
        short numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        this.createTopic(TierTopic.topicName((String)tierTopicNamespace), numTierTopicPartitions, tierTopicReplicationFactor, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        TierTopic tierTopic = new TierTopic(tierTopicNamespace);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.eq((Object)tierTopic.topicName()), ArgumentMatchers.eq((int)numTierTopicPartitions), ArgumentMatchers.eq((short)Defaults$.MODULE$.TierMetadataReplicationFactor()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)numTierTopicPartitions));
        tierTopic.initialize(internalAdmin, (int)numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor());
        File workingDir = TestUtils.tempDirectory(null, null);
        Utils.mkProperties((Map)new HashMap<String, String>(this, workingDir, numTierTopicPartitions){
            {
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
                this.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), Short.toString(numTierTopicPartitions$1));
            }
        }).store(new PrintWriter(this.propertiesConfFile()), "");
        String tempFileName = "working-file";
        Path tempFilePath = Paths.get(workingDir.getAbsolutePath(), tempFileName);
        Files.createFile(tempFilePath, new FileAttribute[0]);
        File tempFile = new File(tempFilePath.toFile().getAbsolutePath());
        Assertions.assertTrue((tempFile.exists() && tempFile.isFile() ? 1 : 0) != 0);
        File outputDir = TestUtils.tempDirectory(null, null);
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        RecoveryTestUtils.executeFencingTool(this.propertiesConfFile().getPath(), this.topicIdPartitionsFile().getPath(), fenceOutFile);
        Assertions.assertTrue((!tempFile.exists() ? 1 : 0) != 0);
        Buffer fenceEvents = CollectionConverters$.MODULE$.ListHasAsScala(FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]))).asScala();
        Assertions.assertEquals((int)this.tpIdToBeFenced().size(), (int)fenceEvents.size());
        scala.collection.mutable.Map partitionToFenceEventInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        fenceEvents.foreach((Function1 & Serializable)output -> {
            TopicIdPartition outputTpid = new TopicIdPartition(output.topic, CoreUtils$.MODULE$.uuidFromBase64(output.topicIdBase64), output.partition);
            Assertions.assertDoesNotThrow(() -> this.tpIdToBeFenced().get(outputTpid));
            Assertions.assertTrue((BoxesRunTime.equals((Object)this.tpIdToBeFenced().get(outputTpid), (Object)output.freezeMergedLogStartOffset) ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordOffset >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordTimestamp >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordPartition >= 0 ? 1 : 0) != 0);
            CoreUtils$.MODULE$.uuidFromBase64(output.recordMessageIdBase64);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)output.partition)), output));
        });
        TierTopicManagerConfig config = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1())), tierTopicNamespace, numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor(), -1, "unknown", Predef$.MODULE$.long2Long(Defaults$.MODULE$.TierMetadataMaxPollMs()), Predef$.MODULE$.int2Integer(Defaults$.MODULE$.TierMetadataRequestTimeoutMs()), Defaults$.MODULE$.TierPartitionStateCommitInterval(), Predef$.MODULE$.long2Long(-1L), Collections.singletonList(this.logDir()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(tierTopicMaterializationFromSnapshotEnable));
        TierTopicConsumerSupplier primaryConsumerSupplier = new TierTopicConsumerSupplier(config, "primary");
        Consumer verificationConsumer = primaryConsumerSupplier.get();
        Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopic.topicName(), (int)tierTopic.numPartitions().getAsInt());
        verificationConsumer.assign((Collection)tierTopicPartitions);
        tierTopicPartitions.forEach(tp -> verificationConsumer.seekToBeginning(Collections.singletonList(tp)));
        ListBuffer records = new ListBuffer();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$5(this, verificationConsumer, config, records)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to fetch TierTopic records");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set<TopicIdPartition> allFencedTpids = this.tpIdToBeFenced().keySet();
        records.foreach((Function1 & Serializable)record -> {
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            Assertions.assertEquals((Object)TierRecordType.PartitionFence, (Object)((AbstractTierMetadata)eventOpt.get()).type());
            TierPartitionFence fenceEvent = (TierPartitionFence)eventOpt.get();
            Assertions.assertTrue((boolean)allFencedTpids.contains(fenceEvent.topicIdPartition()));
            Assertions.assertTrue((BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)fenceEvent.freezeLogStartOffset()), (Object)this.tpIdToBeFenced().get(fenceEvent.topicIdPartition())) ? 1 : 0) != 0);
            allFencedTpids.remove(fenceEvent.topicIdPartition());
            int userPartition = fenceEvent.topicIdPartition().partition();
            Assertions.assertTrue((boolean)partitionToFenceEventInfoMap.contains((Object)BoxesRunTime.boxToInteger((int)userPartition)));
            FenceEventInfo fenceEventInfo = (FenceEventInfo)partitionToFenceEventInfoMap.apply((Object)BoxesRunTime.boxToInteger((int)userPartition));
            Assertions.assertEquals((Object)fenceEvent.messageId(), (Object)CoreUtils$.MODULE$.uuidFromBase64(fenceEventInfo.recordMessageIdBase64));
            Assertions.assertEquals((long)record.offset(), (long)fenceEventInfo.recordOffset);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$minus$eq((Object)BoxesRunTime.boxToInteger((int)userPartition));
        });
        Assertions.assertTrue((boolean)allFencedTpids.isEmpty());
        verificationConsumer.close();
        TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(config, (Supplier)primaryConsumerSupplier, (Supplier)new TierTopicConsumerSupplier(config, "catchup"), (Supplier)new TierTopicConsumerSupplier(config, "discover"), new TierTopicManagerCommitter(config, this.logDirFailureChannel()), tierStateFetcher, Optional.empty(), (Time)new org.apache.kafka.common.utils.MockTime());
        tierTopicConsumer.setupMetrics();
        this.tpIdToBeFenced().forEach((x0$1, x1$1) -> this.addReplica((TopicIdPartition)x0$1, tierTopicConsumer, compactEnabled, tierPartitionStateSnapshotEnabled, brokerId));
        tierTopicConsumer.initialize((InitializedTierTopic)tierTopic);
        tierTopicConsumer.start();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Function1 & Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$10($this, state)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for fencing");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        tierTopicConsumer.shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$setSnapshotConfigAndCompleteSetup$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$5(TierPartitionStateFencingIntegrationTriggerTest $this, Consumer verificationConsumer$1, TierTopicManagerConfig config$1, ListBuffer records$1) {
        Iterator batchIterator = verificationConsumer$1.poll(config$1.pollDuration).iterator();
        while (batchIterator.hasNext()) {
            records$1.$plus$eq(batchIterator.next());
        }
        return records$1.size() == $this.tpIdToBeFenced().size();
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$6() {
        return "Timed out trying to fetch TierTopic records";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$10(TierPartitionStateFencingIntegrationTriggerTest $this, FileTierPartitionState state) {
        if (Predef$.MODULE$.Boolean2boolean($this.tpIdToBeFenced().get(state.topicIdPartition().get()))) {
            TierPartitionStatus tierPartitionStatus = state.status();
            TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
            return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
        }
        TierPartitionStatus tierPartitionStatus = state.status();
        TierPartitionStatus tierPartitionStatus3 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus3) : tierPartitionStatus3 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$11() {
        return "Timed out waiting for fencing";
    }

    public TierPartitionStateFencingIntegrationTriggerTest() {
        this.cleanupIntervalMs = 0;
    }
}

