/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.RecoveryTestUtils;
import kafka.utils.TestUtils;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TierPartitionStateFencingTriggerTest {
    private final Map<TopicIdPartition, Boolean> tpIdsToBeFenced = new HashMap<TopicIdPartition, Boolean>(){
        {
            this.put(new TopicIdPartition("the_dark_knight", UUID.randomUUID(), 2), false);
            this.put(new TopicIdPartition("mummy_returns", UUID.randomUUID(), 3), false);
            this.put(new TopicIdPartition("mission_impossible", UUID.randomUUID(), 5), true);
        }
    };
    private File topicIdPartitionsFile;
    private File outputJsonFile;
    private File propertiesConfFile;

    @BeforeEach
    void setUp() throws IOException {
        this.topicIdPartitionsFile = TestUtils.tempFile();
        RecoveryTestUtils.writeFencingFile(this.topicIdPartitionsFile, this.tpIdsToBeFenced);
        this.propertiesConfFile = TestUtils.tempFile();
        final File workingDir = TestUtils.tempDir();
        Utils.mkProperties((Map)new HashMap<String, String>(){
            {
                this.put("bootstrap.servers", "brokerList");
                this.put(KafkaConfig.TierMetadataBootstrapServersProp(), "brokerList");
                this.put(KafkaConfig.TierMetadataNamespaceProp(), "");
                this.put("confluent.tier.recovery.working.dir", workingDir.getAbsolutePath());
            }
        }).store(new PrintWriter(this.propertiesConfFile), "");
        this.outputJsonFile = TestUtils.tempFile();
    }

    @Test
    void testFencingWithEmptyTopicIdPartitionFile() {
        File emptyTopicIdPartitionsFile = TestUtils.tempFile();
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingTool(this.propertiesConfFile.getPath(), emptyTopicIdPartitionsFile.getPath(), this.outputJsonFile.getPath()));
    }

    @Test
    void testFencingWithBadlyFormattedTopicIdPartitionFile() throws FileNotFoundException {
        File badTopicIdPartitionsFile = TestUtils.tempFile();
        try (PrintWriter pw = new PrintWriter(badTopicIdPartitionsFile);){
            pw.write(String.format("%s,%s", "abc", "def"));
            pw.println();
        }
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingTool(this.propertiesConfFile.getPath(), badTopicIdPartitionsFile.getPath(), this.outputJsonFile.getPath()));
    }

    @Test
    void testFencingWithoutSpecifyingFreezeFlag() throws FileNotFoundException {
        File incompleteFencingTriggerInputFile = TestUtils.tempFile();
        TopicIdPartition partitionToBeFenced = this.tpIdsToBeFenced.entrySet().iterator().next().getKey();
        try (PrintWriter pw = new PrintWriter(incompleteFencingTriggerInputFile);){
            pw.write(String.format("%s:%s-%s", partitionToBeFenced.topicId().toString(), partitionToBeFenced.topic(), partitionToBeFenced.partition()));
            pw.println();
        }
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingTool(this.propertiesConfFile.getPath(), incompleteFencingTriggerInputFile.getPath(), this.outputJsonFile.getPath()));
        File invalidFencingTriggerInputFile = TestUtils.tempFile();
        try (PrintWriter pw = new PrintWriter(invalidFencingTriggerInputFile);){
            pw.write(String.format("%s:%s-%s %s", partitionToBeFenced.topicId().toString(), partitionToBeFenced.topic(), partitionToBeFenced.partition(), "blah"));
            pw.println();
        }
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingTool(this.propertiesConfFile.getPath(), invalidFencingTriggerInputFile.getPath(), this.outputJsonFile.getPath()));
    }

    @Test
    void testFencingWithBadPropertiesFile() {
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingTool("non-existing-file", this.topicIdPartitionsFile.getPath(), this.outputJsonFile.getPath()));
        this.propertiesConfFile = TestUtils.tempFile();
        Assertions.assertThrows(ArgumentParserException.class, () -> RecoveryTestUtils.executeFencingTool(this.propertiesConfFile.getPath(), this.topicIdPartitionsFile.getPath(), this.outputJsonFile.getPath()));
    }
}

