/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.server.Defaults;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.tools.TierPartitionStateJsonConvert;
import kafka.tier.tools.TierPartitionStateJsonWrapper;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TierPartitionStateJsonConvertTest {
    File parentDir;
    File dir;
    TopicPartition tp;
    TopicIdPartition tpid;
    LogDirFailureChannel logDirFailureChannel;
    MockTime time;
    FileTierPartitionState state;
    private String testInputFtpsFile;
    private Header ftpsHeader;
    private List<TierObjectMetadata> ftpsEntries;
    private Header jsonHeader;
    private List<TierObjectMetadata> jsonEntries;
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @BeforeEach
    public void setup() throws IOException {
        this.parentDir = TestUtils.tempDir();
        this.dir = TestUtils.randomPartitionLogDir(this.parentDir);
        this.tp = MergedLog.parseTopicPartitionName((File)this.dir);
        this.tpid = new TopicIdPartition(this.tp.topic(), UUID.randomUUID(), this.tp.partition());
        this.logDirFailureChannel = new LogDirFailureChannel(5);
        this.time = new MockTime();
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.state != null) {
            this.state.close();
        }
        this.dir.delete();
        this.parentDir.delete();
    }

    public void prepareFtps(boolean compactionFeatureFlag) throws IOException {
        boolean checksumEnabled = false;
        boolean cleanupEnabled = false;
        long cleanupDelayMs = Defaults.TierPartitionStateCleanupDelayMs();
        long cleanupIntervalMs = 0L;
        TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(cleanupEnabled, cleanupDelayMs, cleanupIntervalMs);
        boolean tierPartitionStateSnapshotEnabled = false;
        int brokerId = 0;
        this.state = new FileTierPartitionState(this.dir, this.logDirFailureChannel, this.tp, true, (Scheduler)this.time.scheduler, checksumEnabled, compactionFeatureFlag, (Time)this.time, cleanupConfig, tierPartitionStateSnapshotEnabled, brokerId);
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        this.state.setTopicId(this.tpid.topicId());
        this.state.setTieredPartitionRecoveryWorkflowCb(op -> System.out.println("Received RecoveryOp: " + op + " for " + this.state.topicIdPartition().get()));
        this.state.beginCatchup();
        this.state.onCatchUpComplete();
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)confluentLogConfig.tierEnable()).thenReturn((Object)true);
        TierTestUtils.initTierTopicOffset();
        int epoch = 0;
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, epoch, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        OffsetAndEpoch stateOffset = this.state.lastLocalMaterializedSrcOffsetAndEpoch();
        UUID objectId1 = UUID.randomUUID();
        List segmentDataDetailsList = FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)this.tpid, (int)100, (long)200L, (long)300L, (int)400, (int)500, (long)600L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid, 0, objectId1, Optional.empty(), 0L, 1L, 100L, 101L, 20, true, false, true, TierUploadType.Archive, stateOffset, OpaqueData.ZEROED, Optional.of(segmentDataDetailsList)), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state.append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid, 0, objectId1, stateOffset), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid, 0, objectId1, this.state.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state.append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid, 0, objectId1, this.state.lastLocalMaterializedSrcOffsetAndEpoch(), this.time.milliseconds()), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        int numSegments = 10;
        for (int i = 0; i < numSegments; ++i) {
            UUID objectId = UUID.randomUUID();
            OffsetAndEpoch uploadStateOffset = this.state.lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid, epoch, objectId, 2L + (long)i * 2L, 2L + (long)i * 2L + 1L, 100L, 100L, i, false, false, false, TierUploadType.Archive, uploadStateOffset, OpaqueData.ZEROED), TierTestUtils.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state.append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid, epoch, objectId, uploadStateOffset), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        }
        Assertions.assertTrue((boolean)this.state.flush());
        this.testInputFtpsFile = this.state.flushedPath();
    }

    public void readFtpsFile(String testInputFtps) throws IOException {
        CheckedFileIO checkedFileIO = CheckedFileIO.open((Path)Paths.get(testInputFtps, new String[0]), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        this.ftpsHeader = (Header)FileTierPartitionState.readHeader((CheckedFileIO)checkedFileIO).get();
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(this.tpid, checkedFileIO, this.ftpsHeader.size(), false);
        this.ftpsEntries = new ArrayList<TierObjectMetadata>();
        while (iterator.hasNext()) {
            TierObjectMetadata entry = (TierObjectMetadata)iterator.next();
            this.ftpsEntries.add(entry);
        }
    }

    public void readJsonFile(String testInputJson) throws IOException {
        Path pathToJson = Paths.get(testInputJson, new String[0]);
        TierPartitionStateJsonWrapper wrapper = TierPartitionStateJsonWrapper.readFromJson((Path)pathToJson);
        this.jsonHeader = wrapper.header();
        this.jsonEntries = wrapper.entries();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTierPartitionStateJsonConvert(boolean compactionFeatureFlag) throws IOException {
        this.prepareFtps(compactionFeatureFlag);
        this.readFtpsFile(this.testInputFtpsFile);
        String testOutputJson = this.dir + File.separator + "test_output_json.json";
        File outputJsonFile = TierPartitionStateJsonConvert.convertFtpsToJson((String)this.testInputFtpsFile, (String)testOutputJson);
        this.readJsonFile(outputJsonFile.toString());
        Assertions.assertEquals((Object)this.ftpsHeader, (Object)this.jsonHeader);
        Assertions.assertEquals(this.ftpsEntries, this.jsonEntries);
        this.ftpsEntries.clear();
        this.jsonEntries.clear();
        this.readJsonFile(testOutputJson);
        String testOutputFtps = this.dir + File.separator + "test_output_ftps.adler";
        File outputFtpsFile = TierPartitionStateJsonConvert.convertJsonToFtps((String)testOutputJson, (String)testOutputFtps);
        this.readFtpsFile(outputFtpsFile.toString());
        Assertions.assertEquals((Object)this.jsonHeader, (Object)this.ftpsHeader);
        Assertions.assertEquals(this.jsonEntries, this.ftpsEntries);
        this.ftpsEntries.clear();
        this.jsonEntries.clear();
    }

    @Test
    public void testCompactStatsFields() throws JsonProcessingException {
        OffsetAndEpoch offsetAndEpoch1 = new OffsetAndEpoch(100L, Optional.of(10));
        String jsonOffsetAndEpoch1 = JSON_MAPPER.writeValueAsString((Object)offsetAndEpoch1);
        OffsetAndEpoch deserializedOffsetAndEpoch1 = (OffsetAndEpoch)JSON_MAPPER.readValue(jsonOffsetAndEpoch1, OffsetAndEpoch.class);
        Assertions.assertEquals((Object)offsetAndEpoch1.epoch(), (Object)deserializedOffsetAndEpoch1.epoch());
        Assertions.assertEquals((long)offsetAndEpoch1.offset(), (long)deserializedOffsetAndEpoch1.offset());
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(200L, Optional.empty());
        String jsonOffsetAndEpoch2 = JSON_MAPPER.writeValueAsString((Object)offsetAndEpoch2);
        OffsetAndEpoch deserializedOffsetAndEpoch2 = (OffsetAndEpoch)JSON_MAPPER.readValue(jsonOffsetAndEpoch2, OffsetAndEpoch.class);
        Assertions.assertEquals((Object)offsetAndEpoch2.epoch(), (Object)deserializedOffsetAndEpoch2.epoch());
        Assertions.assertEquals((long)offsetAndEpoch2.offset(), (long)deserializedOffsetAndEpoch2.offset());
    }

    static {
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        JSON_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

