/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonParseException;
import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import kafka.log.MergedLog$;
import kafka.restore.ResetTierPartitionState;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateRestoreRawInputGenerator;
import kafka.tier.tools.TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreRawInputInfoLocal;
import kafka.tier.tools.common.RestoreRawInputInfoRemoteURI;
import kafka.tier.tools.common.RestoreRemoteURIInfo;
import kafka.utils.CoreUtils$;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001\u0002\u0016,\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\nyBQa\u0016\u0001\u0005\naCQa\u0017\u0001\u0005\nqCQa\u0018\u0001\u0005\n\u0001DQA\u001b\u0001\u0005\n-4Qa \u0001A\u0003\u0003A!\"!\t\b\u0005+\u0007I\u0011AA\u0012\u0011%\t)c\u0002B\tB\u0003%q\b\u0003\u0006\u0002(\u001d\u0011)\u001a!C\u0001\u0003SA!\"a\r\b\u0005#\u0005\u000b\u0011BA\u0016\u0011\u0019It\u0001\"\u0001\u00026!I\u0011qH\u0004\u0002\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u000f:\u0011\u0013!C\u0001\u0003\u0013B\u0011\"a\u0018\b#\u0003%\t!!\u0019\t\u0013\u0005\u0015t!!A\u0005B\u0005\u001d\u0004\"CA;\u000f\u0005\u0005I\u0011AA<\u0011%\tyhBA\u0001\n\u0003\t\t\tC\u0005\u0002\u000e\u001e\t\t\u0011\"\u0011\u0002\u0010\"I\u0011QT\u0004\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003G;\u0011\u0011!C!\u0003KC\u0011\"!+\b\u0003\u0003%\t%a+\t\u0013\u00055v!!A\u0005B\u0005=\u0006\"CAY\u000f\u0005\u0005I\u0011IAZ\u000f%\t9\fAA\u0001\u0012\u0003\tIL\u0002\u0005\u0000\u0001\u0005\u0005\t\u0012AA^\u0011\u0019I$\u0004\"\u0001\u0002N\"I\u0011Q\u0016\u000e\u0002\u0002\u0013\u0015\u0013q\u0016\u0005\n\u0003\u001fT\u0012\u0011!CA\u0003#D\u0011\"a6\u001b\u0003\u0003%\t)!7\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u0011q\u001d\u0001\u0005\n\u0005]\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005O\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005\u000bAqAa\f\u0001\t\u0003\u0011)\u0001C\u0004\u00034\u0001!\tA!\u0002\t\u000f\t]\u0002\u0001\"\u0001\u0003\u0006!9!1\b\u0001\u0005\u0002\t\u0015\u0001b\u0002B \u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u0007\u0002A\u0011\u0001B\u0003\u00059\"\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3SKN$xN]3SC^Le\u000e];u\u000f\u0016tWM]1u_J$Vm\u001d;\u000b\u00051j\u0013!\u0002;p_2\u001c(B\u0001\u00180\u0003\u0011!\u0018.\u001a:\u000b\u0003A\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001e\u0011\u0005q\u0002Q\"A\u0016\u00023\r\u0014X-\u0019;f\u001d>tW)\u001c9us\u001acWo\u001d5fI\u001aKG.\u001a\u000b\u0004\u007f\u001dK\u0005C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\tIwNC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%\u0001\u0002$jY\u0016DQ\u0001\u0013\u0002A\u0002}\nA\u0002]1si&$\u0018n\u001c8ESJDQA\u0013\u0002A\u0002-\u000b\u0011\"\u00197h_JLG\u000f[7\u0011\u00051+V\"A'\u000b\u00059{\u0015\u0001C2iK\u000e\\7/^7\u000b\u0005A\u000b\u0016aB:u_J\fw-\u001a\u0006\u0003aIS!a\u0015+\u0002\u0013\r|gN\u001a7vK:$(\"\u0001\"\n\u0005Yk%!C!mO>\u0014\u0018\u000e\u001e5n\u0003e\u0019'/Z1uK:{g.R7qiflU\u000f^1cY\u00164\u0015\u000e\\3\u0015\u0007}J&\fC\u0003I\u0007\u0001\u0007q\bC\u0003K\u0007\u0001\u00071*\u0001\u0010de\u0016\fG/\u001a(p]\u0016k\u0007\u000f^=SKN,GO\u00127vg\",GMR5mKR\u0019q(\u00180\t\u000b!#\u0001\u0019A \t\u000b)#\u0001\u0019A&\u0002%\r\u0014X-\u0019;f\u001d>tW)\u001c9us\u001aKG.\u001a\u000b\u0006\u007f\u0005\u00147\r\u001b\u0005\u0006\u0011\u0016\u0001\ra\u0010\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0005\u0006I\u0016\u0001\r!Z\u0001\u000eSNlU\u000f^1cY\u00164\u0015\u000e\\3\u0011\u0005Q2\u0017BA46\u0005\u001d\u0011un\u001c7fC:DQ![\u0003A\u0002\u0015\f1\"[:SKN,GOR5mK\u0006\u0019!/\u001e8\u0015\u00071DX\u0010E\u0002naJl\u0011A\u001c\u0006\u0003_\u000e\u000bA!\u001e;jY&\u0011\u0011O\u001c\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002tm6\tAO\u0003\u0002vW\u000511m\\7n_:L!a\u001e;\u00031I+7\u000f^8sKJ\u000bw/\u00138qkRLeNZ8M_\u000e\fG\u000eC\u0003z\r\u0001\u0007!0A\bgK:\u001cWmT;uaV$h)\u001b7f!\r!4pP\u0005\u0003yV\u0012aa\u00149uS>t\u0007\"\u0002@\u0007\u0001\u0004Q\u0018a\u0002:p_R$\u0015N\u001d\u0002\f\r\u0016t7-Z(viB,Ho\u0005\u0004\bg\u0005\r\u0011\u0011\u0002\t\u0004i\u0005\u0015\u0011bAA\u0004k\t9\u0001K]8ek\u000e$\b\u0003BA\u0006\u00037qA!!\u0004\u0002\u00189!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014E\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0007\u0005eQ'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0011q\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u00033)\u0014\u0001\u00024jY\u0016,\u0012aP\u0001\u0006M&dW\rI\u0001\u0007KZ,g\u000e^:\u0016\u0005\u0005-\u0002\u0003B7q\u0003[\u00012a]A\u0018\u0013\r\t\t\u0004\u001e\u0002\u000f\r\u0016t7-Z#wK:$\u0018J\u001c4p\u0003\u001d)g/\u001a8ug\u0002\"b!a\u000e\u0002<\u0005u\u0002cAA\u001d\u000f5\t\u0001\u0001\u0003\u0004\u0002\"1\u0001\ra\u0010\u0005\b\u0003Oa\u0001\u0019AA\u0016\u0003\u0011\u0019w\u000e]=\u0015\r\u0005]\u00121IA#\u0011!\t\t#\u0004I\u0001\u0002\u0004y\u0004\"CA\u0014\u001bA\u0005\t\u0019AA\u0016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0013+\u0007}\nie\u000b\u0002\u0002PA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!C;oG\",7m[3e\u0015\r\tI&N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA/\u0003'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0019+\t\u0005-\u0012QJ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=4)\u0001\u0003mC:<\u0017\u0002BA:\u0003[\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA=!\r!\u00141P\u0005\u0004\u0003{*$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAB\u0003\u0013\u00032\u0001NAC\u0013\r\t9)\u000e\u0002\u0004\u0003:L\b\"CAF%\u0005\u0005\t\u0019AA=\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0013\t\u0007\u0003'\u000bI*a!\u000e\u0005\u0005U%bAALk\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002f\u0003CC\u0011\"a#\u0015\u0003\u0003\u0005\r!a!\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003S\n9\u000bC\u0005\u0002\fV\t\t\u00111\u0001\u0002z\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002z\u0005AAo\\*ue&tw\r\u0006\u0002\u0002j\u00051Q-];bYN$2!ZA[\u0011%\tY\tGA\u0001\u0002\u0004\t\u0019)A\u0006GK:\u001cWmT;uaV$\bcAA\u001d5M)!$!0\u0002JBI\u0011qXAc\u007f\u0005-\u0012qG\u0007\u0003\u0003\u0003T1!a16\u0003\u001d\u0011XO\u001c;j[\u0016LA!a2\u0002B\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\u0007\u0001\u000bY-C\u0002\u0002\u001e\u0005#\"!!/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005]\u00121[Ak\u0011\u0019\t\t#\ba\u0001\u007f!9\u0011qE\u000fA\u0002\u0005-\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u00037\f\u0019\u000f\u0005\u00035w\u0006u\u0007C\u0002\u001b\u0002`~\nY#C\u0002\u0002bV\u0012a\u0001V;qY\u0016\u0014\u0004\"CAs=\u0005\u0005\t\u0019AA\u001c\u0003\rAH\u0005M\u0001\u0006M\u0016t7-\u001a\u000b\u0005\u0003o\tY\u000fC\u0004\u0002n~\u0001\r!a<\u0002\tQ\u0004\u0018\n\u001a\t\u0005\u0003c\f\u00190D\u0001.\u0013\r\t)0\f\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:$B!a\u000e\u0002z\"9\u00111 \u0011A\u0002\u0005u\u0018!\u0002;q\u0013\u0012\u001c\bCBA\u0006\u0003\u007f\fy/\u0003\u0003\u0003\u0002\u0005}!aA*fc\u0006YB/Z:u\r\u0006LG.\u001e:f\tV,Gk\\'jgNLgnZ!sON$\"Aa\u0002\u0011\u0007Q\u0012I!C\u0002\u0003\fU\u0012A!\u00168ji\"\u001a\u0011Ea\u0004\u0011\t\tE!1E\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005\u0019\u0011\r]5\u000b\t\te!1D\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011iBa\b\u0002\u000b),h.\u001b;\u000b\u0005\t\u0005\u0012aA8sO&!!Q\u0005B\n\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f\u001e$bS2,(/\u001a#vKR{W*[:tS:<\u0007+\u0019:uSRLwN\u001c#je\"\u001a!Ea\u0004\u0002WQ,7\u000f\u001e$bS2,(/\u001a#vKR{W*[:tS:<wJ]#naRLH+[3s'R\fG/\u001a$jY\u0016D3a\tB\b\u0003\u0011\"Xm\u001d;GC&dWO]3Ek\u0016$v.T;uC\ndW\rV5feN#\u0018\r^3GS2,\u0007f\u0001\u0013\u0003\u0010\u0005QC/Z:u\r\u0006LG.\u001e:f\tV,Gk\\'vYRL\u0007\u000f\\3WC2LG\rV5feN#\u0018\r^3GS2,\u0007fA\u0013\u0003\u0010\u0005\u0011C/Z:u'V\u001c7-Z:t\tV,Gk\u001c,bY&$G+[3s'R\fG/\u001a$jY\u0016D3A\nB\b\u00035\"Xm\u001d;Nk2$\u0018\u000e\u001d7f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i-\u0006d\u0017\u000e\u001a+jKJ\u001cF/\u0019;f\r&dWm\u001d\u0015\u0004O\t=\u0011a\f;fgRlU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:XSRD\u0017J\u001c<bY&$G+[3s'R\fG/\u001a$jY\u0016\u001c\bf\u0001\u0015\u0003\u0010\u0005\u0011C/Z:u%\u0006<\u0018J\u001c9vi\u001e+g.\u001a:bi>\u0014x+\u001b;i%\u0016lw\u000e^3V%&C3!\u000bB\b\u0001")
public class TierPartitionStateRestoreRawInputGeneratorTest {
    private volatile TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$ FenceOutput$module;

    public TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$ FenceOutput() {
        if (this.FenceOutput$module == null) {
            this.FenceOutput$lzycompute$1();
        }
        return this.FenceOutput$module;
    }

    private File createNonEmptyFlushedFile(File partitionDir, Algorithm algorithm) {
        return this.createNonEmptyFile(partitionDir, algorithm, false, false);
    }

    private File createNonEmptyMutableFile(File partitionDir, Algorithm algorithm) {
        return this.createNonEmptyFile(partitionDir, algorithm, true, false);
    }

    private File createNonEmptyResetFlushedFile(File partitionDir, Algorithm algorithm) {
        return this.createNonEmptyFile(partitionDir, algorithm, false, true);
    }

    private File createNonEmptyFile(File partitionDir, Algorithm algorithm, boolean isMutableFile, boolean isResetFile) {
        File file;
        File tierStateFile = MergedLog$.MODULE$.tierStateFile(partitionDir, 0L, "");
        Assertions.assertFalse((boolean)tierStateFile.exists());
        if (isMutableFile) {
            file = FileTierPartitionState.mutableFilePath((String)tierStateFile.getAbsolutePath(), (Algorithm)algorithm).toFile();
        } else {
            File flushedFile = FileTierPartitionState.flushedFilePath((String)tierStateFile.getAbsolutePath(), (Algorithm)algorithm).toFile();
            file = isResetFile ? new File(ResetTierPartitionState.outputFilePath((String)flushedFile.getAbsolutePath())) : flushedFile;
        }
        File file2 = file;
        Assertions.assertTrue((boolean)file2.createNewFile());
        PrintWriter pw = new PrintWriter(file2);
        pw.print("test");
        pw.close();
        return file2;
    }

    private java.util.List<RestoreRawInputInfoLocal> run(Option<File> fenceOutputFile, Option<File> rootDir2) {
        File outputFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        ArrayBuffer args = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        fenceOutputFile.foreach((Function1 & Serializable)file -> (ArrayBuffer)args.appendAll((IterableOnce)new .colon.colon((Object)RecoveryUtils.makeArgument((String)"fence.json"), (List)new .colon.colon((Object)file.getAbsolutePath(), (List)Nil$.MODULE$))));
        rootDir2.foreach((Function1 & Serializable)rootDir -> (ArrayBuffer)args.appendAll((IterableOnce)new .colon.colon((Object)RecoveryUtils.makeArgument((String)"restore.tier.state.root.dir"), (List)new .colon.colon((Object)rootDir.getAbsolutePath(), (List)Nil$.MODULE$))));
        args.appendAll((IterableOnce)new .colon.colon((Object)RecoveryUtils.makeArgument((String)"output.json"), (List)new .colon.colon((Object)outputFile.getAbsolutePath(), (List)Nil$.MODULE$)));
        TierPartitionStateRestoreRawInputGenerator.main((String[])((String[])args.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertTrue((boolean)outputFile.exists());
        Assertions.assertTrue((outputFile.length() > 0L ? 1 : 0) != 0);
        return RestoreRawInputInfoLocal.readJsonFromFile((Path)outputFile.toPath());
    }

    private FenceOutput fence(TopicIdPartition tpId) {
        return this.fence((scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)tpId, (List)Nil$.MODULE$));
    }

    private FenceOutput fence(scala.collection.immutable.Seq<TopicIdPartition> tpIds) {
        IntRef partition = IntRef.create((int)-1);
        java.util.List events = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tpIds.map((Function1 & Serializable)tpId -> {
            ++partition$1.elem;
            return new FenceEventInfo(tpId.topic(), tpId.topicIdAsBase64(), tpId.partition(), CoreUtils$.MODULE$.uuidToBase64(UUID.randomUUID()), Predef$.MODULE$.boolean2Boolean(false), 0L, partition$1.elem, System.currentTimeMillis());
        })).asJava();
        File fenceResultJsonFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        String json = FenceEventInfo.listToJson((java.util.List)events);
        try (PrintWriter pw = new PrintWriter(fenceResultJsonFile);){
            pw.write(json);
        }
        return new FenceOutput(this, fenceResultJsonFile, events);
    }

    @Test
    public void testFailureDueToMissingArgs() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        Assertions.assertTrue((boolean)Paths.get(rootDir.getAbsolutePath(), tpId.topicPartition().toString()).toFile().mkdirs());
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> this.run((Option<File>)Option$.MODULE$.empty(), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)new File("/path/to/nonexisting/file")), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)Option$.MODULE$.empty()), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        Assertions.assertFalse((boolean)(((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)new File("/path/to/non_existing_dir"))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))).getCause() instanceof TierPartitionStateRestoreRawInputGenerator.InvalidInputException));
        new PrintWriter(null, fenceOutput){
            {
                try {
                    this.write("invalid-json");
                }
                finally {
                    this.close();
                }
            }
        };
        Assertions.assertTrue((boolean)(((IllegalStateException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148))).getCause() instanceof JsonParseException));
    }

    @Test
    public void testFailureDueToMissingPartitionDir() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithMissingDirs.size());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.contains(tpId.topicPartition()));
    }

    @Test
    public void testFailureDueToMissingOrEmptyTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        TopicPartition tp = tpId.topicPartition();
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tp.toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        this.runTest$1(fenceOutput, rootDir, tp);
        Assertions.assertTrue((boolean)MergedLog$.MODULE$.tierStateFile(partitionDir, 0L, "").createNewFile());
        this.runTest$1(fenceOutput, rootDir, tp);
    }

    @Test
    public void testFailureDueToMutableTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        TopicPartition tp = tpId.topicPartition();
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tp.toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        ObjectRef previousMutableFile = ObjectRef.create((Object)Option$.MODULE$.empty());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Algorithm.values()), (Function1 & Serializable)algorithm -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testFailureDueToMutableTierStateFile$1(this, previousMutableFile, partitionDir, fenceOutput, rootDir, tp, algorithm);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFailureDueToMultipleValidTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        TopicPartition tp = tpId.topicPartition();
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tp.toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Algorithm.values()), (Function1 & Serializable)algorithm -> this.createNonEmptyFlushedFile(partitionDir, (Algorithm)algorithm));
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(tp));
    }

    @Test
    public void testSuccessDueToValidTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tpId.topicPartition().toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        ObjectRef previousValidTierStateFile = ObjectRef.create((Object)Option$.MODULE$.empty());
        Object[] combinations = (Tuple2[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])Algorithm.values()), (Function1 & Serializable)algorithm -> new .colon.colon((Object)new Tuple2(algorithm, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2(algorithm, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Tuple2.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(combinations), (Function1 & Serializable)item -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testSuccessDueToValidTierStateFile$2(this, previousValidTierStateFile, partitionDir, fenceOutput, rootDir, item);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMultiplePartitionsWithValidTierStateFiles() {
        .colon.colon tpIds = new .colon.colon((Object)new TopicIdPartition("foo", UUID.randomUUID(), 27), (List)new .colon.colon((Object)new TopicIdPartition("bar", UUID.randomUUID(), 345), (List)Nil$.MODULE$));
        FenceOutput fenceOutput = this.fence((scala.collection.immutable.Seq<TopicIdPartition>)tpIds);
        File rootDir = TestUtils.tempDirectory(null, null);
        java.util.List flushedFiles = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)tpIds.map((Function1 & Serializable)tpId -> {
            File partitionDir = Paths.get(rootDir.getAbsolutePath(), tpId.topicPartition().toString()).toFile();
            Assertions.assertTrue((boolean)partitionDir.mkdirs());
            return this.createNonEmptyFlushedFile(partitionDir, Algorithm.ADLER);
        })).toList()).asJava();
        java.util.List<RestoreRawInputInfoLocal> rawInputs = this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir));
        Assertions.assertFalse((boolean)rawInputs.isEmpty());
        Assertions.assertEquals((int)2, (int)rawInputs.size());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            RestoreRawInputInfoLocal rawInput = (RestoreRawInputInfoLocal)rawInputs.get(index);
            FenceEventInfo fenceEvent = fenceOutput.events().get(index);
            File flushedFile = (File)flushedFiles.get(index);
            Assertions.assertEquals((Object)rawInput.fenceEventInfo(), (Object)fenceEvent);
            Assertions.assertEquals((Object)flushedFile, (Object)rawInput.path().toFile());
        });
    }

    @Test
    public void testMultiplePartitionsWithInvalidTierStateFiles() {
        .colon.colon tpIds = new .colon.colon((Object)new TopicIdPartition("valid", UUID.randomUUID(), 27), (List)new .colon.colon((Object)new TopicIdPartition("invalid1", UUID.randomUUID(), 345), (List)new .colon.colon((Object)new TopicIdPartition("invalid2", UUID.randomUUID(), 4214), (List)Nil$.MODULE$)));
        FenceOutput fenceOutput = this.fence((scala.collection.immutable.Seq<TopicIdPartition>)tpIds);
        File rootDir = TestUtils.tempDirectory(null, null);
        TopicIdPartition validTpId = (TopicIdPartition)tpIds.apply(0);
        File validTpIdPartitionDir = Paths.get(rootDir.getAbsolutePath(), validTpId.topicPartition().toString()).toFile();
        Assertions.assertTrue((boolean)validTpIdPartitionDir.mkdirs());
        this.createNonEmptyFlushedFile(validTpIdPartitionDir, Algorithm.ADLER);
        TopicIdPartition invalidTpId1 = (TopicIdPartition)tpIds.apply(1);
        TopicIdPartition invalidTpId2 = (TopicIdPartition)tpIds.apply(2);
        File invalidTpIdPartitionDir2 = Paths.get(rootDir.getAbsolutePath(), invalidTpId2.topicPartition().toString()).toFile();
        Assertions.assertTrue((boolean)invalidTpIdPartitionDir2.mkdirs());
        this.createNonEmptyFlushedFile(invalidTpIdPartitionDir2, Algorithm.ADLER);
        this.createNonEmptyFlushedFile(invalidTpIdPartitionDir2, Algorithm.NO_CHECKSUM);
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithMissingDirs.size());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.contains(invalidTpId1.topicPartition()));
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(invalidTpId2.topicPartition()));
    }

    @Test
    public void testRawInputGeneratorWithRemoteURI() {
        java.util.List<FenceEventInfo> fencingEvents = Arrays.asList(new FenceEventInfo("test-topic-1", "0SoOrPUfRgaP7dExQdzWAg", 1, CoreUtils$.MODULE$.uuidToBase64(UUID.randomUUID()), Predef$.MODULE$.boolean2Boolean(false), 201L, 1, 1598576601L), new FenceEventInfo("test-topic-2", "0SoOrPUfRgaP7dExQdzWAg", 3, CoreUtils$.MODULE$.uuidToBase64(UUID.randomUUID()), Predef$.MODULE$.boolean2Boolean(false), 101L, 2, 1598576602L));
        java.util.List<RestoreRemoteURIInfo> remoteURIsInfo = Arrays.asList(new RestoreRemoteURIInfo(new TopicIdPartition("test-topic-1", UUID.randomUUID(), 1), "8/recovery-rcca-1234/0/ftps/bEhlkQKgQAudEpH74a1bQg/test_topic-0/00000000000000000000.tierstate.recovery-upload.adler_v0.tier-partition-state-upload"), new RestoreRemoteURIInfo(new TopicIdPartition("test-topic-2", UUID.randomUUID(), 3), "8/recovery-rcca-1234/0/ftps/bEhlkQKgQAudEpH74a1bQg/test_topic-0/00000000000000000000.tierstate.recovery-upload.adler_v0.tier-partition-state-upload"));
        java.util.List rawInputGeneratorResult = TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInputRemoteURI(fencingEvents, remoteURIsInfo);
        Assertions.assertEquals((int)2, (int)rawInputGeneratorResult.size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rawInputGeneratorResult.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((Object)((FenceEventInfo)fencingEvents.get(i)).topic(), (Object)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).fenceEventInfo().topic());
            Assertions.assertEquals((Object)((RestoreRemoteURIInfo)remoteURIsInfo.get(i)).topicIdPartition().topic(), (Object)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).fenceEventInfo().topic());
            Assertions.assertEquals((Object)((FenceEventInfo)fencingEvents.get(i)).topicIdBase64(), (Object)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).fenceEventInfo().topicIdBase64());
            Assertions.assertEquals((Object)((RestoreRemoteURIInfo)remoteURIsInfo.get(i)).topicIdPartition().topicIdAsBase64(), (Object)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).restoreRemoteURIInfo().topicIdPartition().topicIdAsBase64());
            Assertions.assertEquals((int)((FenceEventInfo)fencingEvents.get(i)).partition(), (int)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).fenceEventInfo().partition());
            Assertions.assertEquals((int)((RestoreRemoteURIInfo)remoteURIsInfo.get(i)).topicIdPartition().partition(), (int)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).restoreRemoteURIInfo().topicIdPartition().partition());
            Assertions.assertEquals((Object)((RestoreRemoteURIInfo)remoteURIsInfo.get(i)).remoteUrl(), (Object)((RestoreRawInputInfoRemoteURI)rawInputGeneratorResult.get(i)).restoreRemoteURIInfo().remoteUrl());
        });
    }

    private final void FenceOutput$lzycompute$1() {
        synchronized (this) {
            if (this.FenceOutput$module == null) {
                this.FenceOutput$module = new TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$(this);
            }
            return;
        }
    }

    private final void runTest$1(FenceOutput fenceOutput$3, File rootDir$3, TopicPartition tp$1) {
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput$3.file()), (Option<File>)new Some((Object)rootDir$3)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(tp$1));
    }

    public static final /* synthetic */ void $anonfun$testFailureDueToMutableTierStateFile$2(File file) {
        Assertions.assertTrue((boolean)Files.deleteIfExists(file.toPath()));
    }

    public static final /* synthetic */ void $anonfun$testFailureDueToMutableTierStateFile$1(TierPartitionStateRestoreRawInputGeneratorTest $this, ObjectRef previousMutableFile$1, File partitionDir$1, FenceOutput fenceOutput$4, File rootDir$4, TopicPartition tp$2, Algorithm algorithm) {
        ((Option)previousMutableFile$1.elem).foreach((Function1 & Serializable)file -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testFailureDueToMutableTierStateFile$2(file);
            return BoxedUnit.UNIT;
        });
        File mutableTierStateFile = $this.createNonEmptyMutableFile(partitionDir$1, algorithm);
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> $this.run((Option<File>)new Some((Object)fenceOutput$4.file()), (Option<File>)new Some((Object)rootDir$4)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(tp$2));
        previousMutableFile$1.elem = new Some((Object)mutableTierStateFile);
    }

    public static final /* synthetic */ void $anonfun$testSuccessDueToValidTierStateFile$3(File file) {
        Assertions.assertTrue((boolean)Files.deleteIfExists(file.toPath()));
    }

    public static final /* synthetic */ void $anonfun$testSuccessDueToValidTierStateFile$2(TierPartitionStateRestoreRawInputGeneratorTest $this, ObjectRef previousValidTierStateFile$1, File partitionDir$3, FenceOutput fenceOutput$6, File rootDir$6, Tuple2 item) {
        Algorithm algorithm = (Algorithm)item._1();
        boolean shouldResetTierState = item._2$mcZ$sp();
        ((Option)previousValidTierStateFile$1.elem).foreach((Function1 & Serializable)file -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testSuccessDueToValidTierStateFile$3(file);
            return BoxedUnit.UNIT;
        });
        File flushedFile = shouldResetTierState ? $this.createNonEmptyResetFlushedFile(partitionDir$3, algorithm) : $this.createNonEmptyFlushedFile(partitionDir$3, algorithm);
        java.util.List<RestoreRawInputInfoLocal> rawInputs = $this.run((Option<File>)new Some((Object)fenceOutput$6.file()), (Option<File>)new Some((Object)rootDir$6));
        Assertions.assertFalse((boolean)rawInputs.isEmpty());
        Assertions.assertEquals((int)1, (int)rawInputs.size());
        RestoreRawInputInfoLocal rawInput = rawInputs.get(0);
        FenceEventInfo fenceEvent = fenceOutput$6.events().get(0);
        Assertions.assertEquals((Object)rawInput.fenceEventInfo(), (Object)fenceEvent);
        Assertions.assertEquals((Object)flushedFile, (Object)rawInput.path().toFile());
        previousValidTierStateFile$1.elem = new Some((Object)flushedFile);
    }

    public class FenceOutput
    implements Product,
    Serializable {
        private final File file;
        private final java.util.List<FenceEventInfo> events;
        public final /* synthetic */ TierPartitionStateRestoreRawInputGeneratorTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public File file() {
            return this.file;
        }

        public java.util.List<FenceEventInfo> events() {
            return this.events;
        }

        public FenceOutput copy(File file, java.util.List<FenceEventInfo> events) {
            return new FenceOutput(this.kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer(), file, events);
        }

        public File copy$default$1() {
            return this.file();
        }

        public java.util.List<FenceEventInfo> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FenceOutput";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.file();
                }
                case 1: {
                    return this.events();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FenceOutput;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "file";
                }
                case 1: {
                    return "events";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FenceOutput && ((FenceOutput)x$1).kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer() == this.kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer())) break block3;
                    FenceOutput fenceOutput = (FenceOutput)x$1;
                    File file = this.file();
                    File file2 = fenceOutput.file();
                    if (file != null ? !((Object)file).equals(file2) : file2 != null) break block3;
                    java.util.List<FenceEventInfo> list = this.events();
                    java.util.List<FenceEventInfo> list2 = fenceOutput.events();
                    if ((list != null ? !((Object)list).equals(list2) : list2 != null) || !fenceOutput.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ TierPartitionStateRestoreRawInputGeneratorTest kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer() {
            return this.$outer;
        }

        public FenceOutput(TierPartitionStateRestoreRawInputGeneratorTest $outer, File file, java.util.List<FenceEventInfo> events) {
            this.file = file;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

