/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tools.TierPartitionStateUploadResult;
import kafka.tier.tools.TierPartitionStateUploadTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Option;
import scala.collection.JavaConverters;

public class TierPartitionStateUploadTaskTest {
    private final TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
    private final List<TopicIdPartition> topicIdPartitions = Arrays.asList(new TopicIdPartition("topic1", UUID.randomUUID(), 0), new TopicIdPartition("topic1", UUID.randomUUID(), 1), new TopicIdPartition("topic2", UUID.randomUUID(), 0));
    private final Map<TopicIdPartition, String> topicIdPartitionToCopyPath = new HashMap<TopicIdPartition, String>();
    private final Map<String, String> localUploadToRemoteUploadPaths = new HashMap<String, String>();
    private final KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
    private final KafkaConfig.ConfluentConfig confluentConfig = (KafkaConfig.ConfluentConfig)Mockito.mock(KafkaConfig.ConfluentConfig.class);
    private final String identifier = "rcca";
    private final int broker = 5;

    public void setupMocks(boolean checksumEnabled) throws IOException {
        Mockito.when((Object)this.config.brokerId()).thenReturn((Object)5);
        Mockito.when((Object)this.config.confluentConfig()).thenReturn((Object)this.confluentConfig);
        Mockito.when((Object)this.confluentConfig.tierChecksumFeatureEnabled()).thenReturn((Object)checksumEnabled);
        List<AbstractLog> logs = Arrays.asList((AbstractLog)Mockito.mock(MergedLog.class), (AbstractLog)Mockito.mock(MergedLog.class), (AbstractLog)Mockito.mock(MergedLog.class));
        List<TierPartitionState> tierPartitionStates = Arrays.asList((TierPartitionState)Mockito.mock(TierPartitionState.class), (TierPartitionState)Mockito.mock(TierPartitionState.class), (TierPartitionState)Mockito.mock(TierPartitionState.class));
        Mockito.when((Object)this.logManager.allLogs()).thenReturn((Object)JavaConverters.collectionAsScalaIterable(logs));
        for (int i = 0; i < logs.size(); ++i) {
            AbstractLog log = logs.get(i);
            TierPartitionState tierPartitionState = tierPartitionStates.get(i);
            final TopicIdPartition topicIdPartition = this.topicIdPartitions.get(i);
            String algorithmSuffix = checksumEnabled ? ".adler" : "";
            String copyPathStr = String.format("recovery-uploads/%s/%s_%d/00000000000000000000.tierstate.recoveryupload%s", topicIdPartition.topicIdAsBase64(), topicIdPartition.topic(), topicIdPartition.partition(), algorithmSuffix);
            final Path copyPath = Paths.get(copyPathStr, new String[0]).toAbsolutePath();
            Mockito.when((Object)log.topicIdPartition()).thenReturn((Object)Option.apply((Object)topicIdPartition));
            Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
            Mockito.when((Object)tierPartitionState.backupStateForRecovery()).thenAnswer((Answer)new Answer<Path>(){

                public Path answer(InvocationOnMock invocation) throws Throwable {
                    TierPartitionStateUploadTaskTest.this.topicIdPartitionToCopyPath.put(topicIdPartition, copyPath.toString());
                    return copyPath;
                }
            });
        }
        ((TierObjectStore)Mockito.doAnswer(invocation -> {
            ObjectStoreMetadata metadata = (ObjectStoreMetadata)invocation.getArgument(0);
            File file = (File)invocation.getArgument(1);
            ObjectType objectType = (ObjectType)invocation.getArgument(2);
            Assertions.assertEquals((Object)ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD, (Object)objectType);
            String uploadPath = ((FragmentLocation)metadata.toFragmentLocation("", FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD).get()).objectPath();
            this.localUploadToRemoteUploadPaths.put(file.toPath().toString(), uploadPath);
            return uploadPath;
        }).when((Object)this.tierObjectStore)).putObject((ObjectStoreMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (ObjectType)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUploadFtps(boolean checksumEnabled) throws Exception {
        this.setupMocks(checksumEnabled);
        TierPartitionStateUploadTask task = new TierPartitionStateUploadTask(new HashSet<TopicIdPartition>(this.topicIdPartitions), this.tierObjectStore, this.logManager, "rcca", this.config);
        Map result = task.call();
        for (TopicIdPartition topicIdPartition : this.topicIdPartitions) {
            Assertions.assertNotNull(result.get(topicIdPartition));
            Assertions.assertNotNull((Object)((TierPartitionStateUploadResult)result.get(topicIdPartition)).uploadPath());
            Assertions.assertNull((Object)((TierPartitionStateUploadResult)result.get(topicIdPartition)).exceptionType());
            Assertions.assertTrue((boolean)this.topicIdPartitionToCopyPath.containsKey(topicIdPartition));
            String localUploadPath = this.topicIdPartitionToCopyPath.get(topicIdPartition);
            Assertions.assertTrue((boolean)this.localUploadToRemoteUploadPaths.containsKey(localUploadPath));
            String remoteUploadPath = this.localUploadToRemoteUploadPaths.get(localUploadPath);
            Assertions.assertTrue((boolean)remoteUploadPath.contains("rcca"));
            Assertions.assertTrue((boolean)remoteUploadPath.contains(String.valueOf(5)));
            Assertions.assertTrue((boolean)remoteUploadPath.contains(topicIdPartition.topicIdAsBase64()));
            Assertions.assertTrue((boolean)remoteUploadPath.contains(String.format("%s-%d", topicIdPartition.topic(), topicIdPartition.partition())));
            Assertions.assertTrue((boolean)remoteUploadPath.contains("00000000000000000000.tierstate"));
            if (checksumEnabled) {
                Assertions.assertTrue((boolean)remoteUploadPath.contains(".adler"));
                continue;
            }
            Assertions.assertFalse((boolean)remoteUploadPath.contains(".adler"));
        }
    }
}

