/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierRecoveryUploadMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierRecoveryUploadMetadataTest {
    @Test
    public void testObjectStoreFromPath() {
        String keyPrefix = "foo";
        String identifier = "rcca-1234";
        Integer broker = 5;
        TierRecoveryUploadMetadata metadata = new TierRecoveryUploadMetadata(identifier, broker);
        String objectPath = ((FragmentLocation)metadata.toFragmentLocation(keyPrefix, FragmentType.TIER_RECOVERY_METADATA_UPLOAD).get()).objectPath();
        String expectedObjectPath = String.format("%s%s/recovery-%s/%d/upload-metadata/tier-recovery-upload-metadata_v%d.%s", keyPrefix, TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), identifier, broker, TierRecoveryUploadMetadata.CURRENT_METADATA_VERSION, ObjectType.TIER_RECOVERY_METADATA_UPLOAD.suffix());
        Assertions.assertEquals((Object)objectPath, (Object)expectedObjectPath);
        TierRecoveryUploadMetadata decodedMetadata = TierRecoveryUploadMetadata.fromPath((String)objectPath);
        Assertions.assertEquals((Object)metadata, (Object)decodedMetadata);
    }

    @Test
    public void testVersionMismatchObjectStoreFromPath() {
        String keyPrefix = "foo";
        String identifier = "rcca-1234";
        Integer broker = 5;
        Integer invalidVersion = 10;
        String objectPath = String.format("%s%s/recovery-%s/%d/upload-metadata/tier-recovery-upload-metadata_v%d.%s", keyPrefix, TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), identifier, broker, invalidVersion, ObjectType.TIER_RECOVERY_METADATA_UPLOAD.suffix());
        Assertions.assertThrows(IllegalArgumentException.class, () -> TierRecoveryUploadMetadata.fromPath((String)objectPath));
    }
}

