/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.tools.TierTopicConsumerRewindCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicConsumerRewindCommandTest {
    private File createTempFile(String contents) throws IOException {
        File file = File.createTempFile("TierTopicConsumerRewindCommandTest", ".tmp");
        file.deleteOnExit();
        Files.write(file.toPath(), contents.getBytes(), new OpenOption[0]);
        return file;
    }

    @Test
    public void testReadPartitionToPosition() throws IOException {
        File partitionToPositionFile = this.createTempFile("0 12345 7\n1 777 8\n2 5 -1\n3 3000 -1");
        Map partitionToPosition = TierTopicConsumerRewindCommand.parsePartitionToPositionFile((String)partitionToPositionFile.toPath().toString());
        HashMap<Integer, Map<Long, Optional<Integer>>> expectedPartitionToPosition = new HashMap<Integer, Map<Long, Optional<Integer>>>();
        expectedPartitionToPosition.put(0, Collections.singletonMap(12345L, Optional.of(7)));
        expectedPartitionToPosition.put(1, Collections.singletonMap(777L, Optional.of(8)));
        expectedPartitionToPosition.put(2, Collections.singletonMap(5L, Optional.empty()));
        expectedPartitionToPosition.put(3, Collections.singletonMap(3000L, Optional.empty()));
        Assertions.assertEquals(expectedPartitionToPosition, (Object)partitionToPosition);
    }
}

