/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import kafka.tier.tools.TierTopicHeadDataLossDetectionCommand;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicHeadDataLossDetectionCommandTest {
    private File createTempFile(String contents) throws IOException {
        File file = File.createTempFile("TierTopicConsumerRewindCommandTest", ".tmp");
        file.deleteOnExit();
        Files.write(file.toPath(), contents.getBytes(), new OpenOption[0]);
        return file;
    }

    @Test
    public void testReadTierTopicPartitionAllowList() throws IOException {
        File tierTopicPartitionAllowListFile = this.createTempFile("_confluent-tier-state-0\n_confluent-tier-state-1\n_confluent-tier-state-2\n_confluent-tier-state-1");
        Set tierTopicPartitionAllowList = TierTopicHeadDataLossDetectionCommand.parseTierTopicPartitionAllowList((String)tierTopicPartitionAllowListFile.toPath().toString());
        HashSet<TopicPartition> expectedTierTopicPartitionAllowList = new HashSet<TopicPartition>(){
            {
                this.add(new TopicPartition("_confluent-tier-state", 0));
                this.add(new TopicPartition("_confluent-tier-state", 1));
                this.add(new TopicPartition("_confluent-tier-state", 2));
                this.add(new TopicPartition("_confluent-tier-state", 1));
            }
        };
        Assertions.assertEquals((Object)expectedTierTopicPartitionAllowList, (Object)tierTopicPartitionAllowList);
    }

    @Test
    public void testThrowsExceptionForInvalidTierTopicPartitionAllowList() throws IOException {
        File tierTopicPartitionAllowListFile = this.createTempFile("topic-0\ntopic-1\ntopic-2\ntopic3-1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> TierTopicHeadDataLossDetectionCommand.parseTierTopicPartitionAllowList((String)tierTopicPartitionAllowListFile.toPath().toString()));
    }
}

