/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.ReconciledTierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ReconciledTierTopicPartitionInfo;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReconciledTierTopicHeadDataLossReportTest {
    @Test
    public void deSerializeTestWithFailureCompletionStatus() throws IOException {
        TierTopicHeadDataLossReport.CompletionStatus completionStatus = TierTopicHeadDataLossReport.CompletionStatus.FAILURE;
        final TopicIdPartition utp0 = new TopicIdPartition("test-topic-0", UUID.randomUUID(), 0);
        final int broker0 = 0;
        OffsetAndEpoch utp0maxLastMaterializedOffsetAndEpoch = new OffsetAndEpoch(10L, Optional.of(5));
        final AffectedUserTopicPartitionInfo broker0AffectedUtp0 = new AffectedUserTopicPartitionInfo(0, utp0maxLastMaterializedOffsetAndEpoch, TierPartitionStatus.ONLINE, true);
        final int broker1 = 1;
        OffsetAndEpoch utp0Broker1MinTierTopicEndOffsetAndEpoch = new OffsetAndEpoch(5L, Optional.of(3));
        final AffectedUserTopicPartitionInfo broker1AffectedUtp0 = new AffectedUserTopicPartitionInfo(0, new OffsetAndEpoch(9L, Optional.of(4)), TierPartitionStatus.ONLINE, true);
        final TopicIdPartition utp1 = new TopicIdPartition("test-topic-1", UUID.randomUUID(), 1);
        final int broker2 = 2;
        OffsetAndEpoch utp1Broker2MinTierTopicEndOffsetAndEpoch = new OffsetAndEpoch(8L, Optional.of(6));
        final AffectedUserTopicPartitionInfo broker2AffectedUtp1 = new AffectedUserTopicPartitionInfo(1, new OffsetAndEpoch(11L, Optional.of(7)), TierPartitionStatus.ONLINE, true);
        final int broker3 = 3;
        OffsetAndEpoch utp1maxLastMaterializedOffsetAndEpoch = new OffsetAndEpoch(13L, Optional.of(8));
        final AffectedUserTopicPartitionInfo broker3AffectedUtp1 = new AffectedUserTopicPartitionInfo(1, utp1maxLastMaterializedOffsetAndEpoch, TierPartitionStatus.ONLINE, true);
        HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUserTopicPartitions = new HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>>(){
            {
                this.put(utp0, new HashMap<Integer, AffectedUserTopicPartitionInfo>(){
                    {
                        this.put(broker0, broker0AffectedUtp0);
                        this.put(broker1, broker1AffectedUtp0);
                    }
                });
                this.put(utp1, new HashMap<Integer, AffectedUserTopicPartitionInfo>(){
                    {
                        this.put(broker2, broker2AffectedUtp1);
                        this.put(broker3, broker3AffectedUtp1);
                    }
                });
            }
        };
        final TopicPartition ttp0 = new TopicPartition("_confluent-tier-state", 0);
        final ReconciledTierTopicPartitionInfo ttp0reconciledInfo = new ReconciledTierTopicPartitionInfo(utp0maxLastMaterializedOffsetAndEpoch.offset(), utp0, broker0, utp0Broker1MinTierTopicEndOffsetAndEpoch, utp0, broker0);
        final TopicPartition ttp1 = new TopicPartition("_confluent-tier-state", 1);
        final ReconciledTierTopicPartitionInfo ttp1reconciledInfo = new ReconciledTierTopicPartitionInfo(utp1maxLastMaterializedOffsetAndEpoch.offset(), utp1, broker3, utp1Broker2MinTierTopicEndOffsetAndEpoch, utp1, broker3);
        HashMap<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTierTopicPartitions = new HashMap<TopicPartition, ReconciledTierTopicPartitionInfo>(){
            {
                this.put(ttp0, ttp0reconciledInfo);
                this.put(ttp1, ttp1reconciledInfo);
            }
        };
        final TopicPartition failedTtp2 = new TopicPartition("_confluent-tier-state", 2);
        final int failedBroker4 = 4;
        final int failedBroker6 = 6;
        final TopicPartition failedTtp3 = new TopicPartition("_confluent-tier-state", 3);
        final int failedBroker5 = 5;
        final int failedBroker7 = 7;
        HashMap<TopicPartition, Set<Integer>> failedTierTopicPartitions = new HashMap<TopicPartition, Set<Integer>>(){
            {
                this.put(failedTtp2, new HashSet<Integer>(Arrays.asList(failedBroker4, failedBroker6)));
                this.put(failedTtp3, new HashSet<Integer>(Arrays.asList(failedBroker5, failedBroker7)));
            }
        };
        final TopicIdPartition fencingFailedUtp0 = new TopicIdPartition("fencing-failed-test-topic-0", UUID.randomUUID(), 0);
        final TopicIdPartition fencingFailedUtp1 = new TopicIdPartition("fencing-failed-test-topic-1", UUID.randomUUID(), 1);
        HashMap<TopicIdPartition, Set<Integer>> userPartitionsWithFencingFailures = new HashMap<TopicIdPartition, Set<Integer>>(){
            {
                this.put(fencingFailedUtp0, new HashSet<Integer>(Arrays.asList(failedBroker4, failedBroker6)));
                this.put(fencingFailedUtp1, new HashSet<Integer>(Arrays.asList(failedBroker5, failedBroker7)));
            }
        };
        final String errorMsg0 = "error_msg_0";
        final String errorMsg1 = "error_msg_1";
        final String errorMsg2 = "error_msg_2";
        final String errorMsg3 = "error_msg_3";
        HashMap<Integer, List<String>> errorMessages = new HashMap<Integer, List<String>>(){
            {
                this.put(failedBroker4, Arrays.asList(errorMsg0, errorMsg1));
                this.put(failedBroker5, Arrays.asList(errorMsg2, errorMsg3));
            }
        };
        final long broker0duration = 1000L;
        final long broker1duration = 1001L;
        final long broker2duration = 1002L;
        final long broker3duration = 1003L;
        final long broker4duration = 1004L;
        final long broker5duration = 1005L;
        HashMap<Integer, Long> durationMs = new HashMap<Integer, Long>(){
            {
                this.put(broker0, broker0duration);
                this.put(broker1, broker1duration);
                this.put(broker2, broker2duration);
                this.put(broker3, broker3duration);
                this.put(failedBroker4, broker4duration);
                this.put(failedBroker5, broker5duration);
            }
        };
        ReconciledTierTopicHeadDataLossReport expectedReport = ReconciledTierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)completionStatus, (Map)affectedUserTopicPartitions, (Map)affectedTierTopicPartitions, (Map)failedTierTopicPartitions, (Map)userPartitionsWithFencingFailures, (Map)errorMessages, (Map)durationMs);
        File testFile = TestUtils.tempFile((String)"test", (String)".json");
        ReconciledTierTopicHeadDataLossReport.writeJsonToFile((ReconciledTierTopicHeadDataLossReport)expectedReport, (OutputStream)Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        ReconciledTierTopicHeadDataLossReport receivedReport = ReconciledTierTopicHeadDataLossReport.readJsonFromFile((Path)testFile.toPath());
        Assertions.assertEquals((Object)expectedReport, (Object)receivedReport);
        System.out.println(receivedReport);
    }

    public void deSerializeTestWithSuccessCompletionStatus() throws IOException {
        TierTopicHeadDataLossReport.CompletionStatus completionStatus = TierTopicHeadDataLossReport.CompletionStatus.SUCCESS;
        final TopicIdPartition utp0 = new TopicIdPartition("test-topic-0", UUID.randomUUID(), 0);
        final int broker0 = 0;
        OffsetAndEpoch utp0maxLastMaterializedOffsetAndEpoch = new OffsetAndEpoch(10L, Optional.of(5));
        final AffectedUserTopicPartitionInfo broker0AffectedUtp0 = new AffectedUserTopicPartitionInfo(0, utp0maxLastMaterializedOffsetAndEpoch, TierPartitionStatus.ONLINE, true);
        final int broker1 = 1;
        OffsetAndEpoch utp0Broker1MinTierTopicEndOffsetAndEpoch = new OffsetAndEpoch(5L, Optional.of(3));
        final AffectedUserTopicPartitionInfo broker1AffectedUtp0 = new AffectedUserTopicPartitionInfo(0, new OffsetAndEpoch(9L, Optional.of(4)), TierPartitionStatus.ONLINE, true);
        final TopicIdPartition utp1 = new TopicIdPartition("test-topic-1", UUID.randomUUID(), 1);
        final int broker2 = 2;
        OffsetAndEpoch utp1Broker2MinTierTopicEndOffsetAndEpoch = new OffsetAndEpoch(8L, Optional.of(6));
        final AffectedUserTopicPartitionInfo broker2AffectedUtp1 = new AffectedUserTopicPartitionInfo(1, new OffsetAndEpoch(11L, Optional.of(7)), TierPartitionStatus.ONLINE, true);
        final int broker3 = 3;
        OffsetAndEpoch utp1maxLastMaterializedOffsetAndEpoch = new OffsetAndEpoch(13L, Optional.of(8));
        final AffectedUserTopicPartitionInfo broker3AffectedUtp1 = new AffectedUserTopicPartitionInfo(1, utp1maxLastMaterializedOffsetAndEpoch, TierPartitionStatus.ONLINE, true);
        HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUserTopicPartitions = new HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>>(){
            {
                this.put(utp0, new HashMap<Integer, AffectedUserTopicPartitionInfo>(){
                    {
                        this.put(broker0, broker0AffectedUtp0);
                        this.put(broker1, broker1AffectedUtp0);
                    }
                });
                this.put(utp1, new HashMap<Integer, AffectedUserTopicPartitionInfo>(){
                    {
                        this.put(broker2, broker2AffectedUtp1);
                        this.put(broker3, broker3AffectedUtp1);
                    }
                });
            }
        };
        final TopicPartition ttp0 = new TopicPartition("_confluent-tier-state", 0);
        final ReconciledTierTopicPartitionInfo ttp0reconciledInfo = new ReconciledTierTopicPartitionInfo(utp0maxLastMaterializedOffsetAndEpoch.offset(), utp0, broker0, utp0Broker1MinTierTopicEndOffsetAndEpoch, utp0, broker0);
        final TopicPartition ttp1 = new TopicPartition("_confluent-tier-state", 1);
        final ReconciledTierTopicPartitionInfo ttp1reconciledInfo = new ReconciledTierTopicPartitionInfo(utp1maxLastMaterializedOffsetAndEpoch.offset(), utp1, broker3, utp1Broker2MinTierTopicEndOffsetAndEpoch, utp1, broker3);
        HashMap<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTierTopicPartitions = new HashMap<TopicPartition, ReconciledTierTopicPartitionInfo>(){
            {
                this.put(ttp0, ttp0reconciledInfo);
                this.put(ttp1, ttp1reconciledInfo);
            }
        };
        final long broker0duration = 1000L;
        final long broker1duration = 1001L;
        final long broker2duration = 1002L;
        final long broker3duration = 1003L;
        HashMap<Integer, Long> durationMs = new HashMap<Integer, Long>(){
            {
                this.put(broker0, broker0duration);
                this.put(broker1, broker1duration);
                this.put(broker2, broker2duration);
                this.put(broker3, broker3duration);
            }
        };
        ReconciledTierTopicHeadDataLossReport expectedReport = ReconciledTierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)completionStatus, (Map)affectedUserTopicPartitions, (Map)affectedTierTopicPartitions, new HashMap(), new HashMap(), new HashMap(), (Map)durationMs);
        File testFile = TestUtils.tempFile((String)"test", (String)".json");
        ReconciledTierTopicHeadDataLossReport.writeJsonToFile((ReconciledTierTopicHeadDataLossReport)expectedReport, (OutputStream)Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        ReconciledTierTopicHeadDataLossReport receivedReport = ReconciledTierTopicHeadDataLossReport.readJsonFromFile((Path)testFile.toPath());
        Assertions.assertEquals((Object)expectedReport, (Object)receivedReport);
        System.out.println(receivedReport);
    }
}

