/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.topic.recovery.SelectRemoteFileTierPartitionStateOutput;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SelectRemoteFileTierPartitionStateOutputTest {
    SelectRemoteFileTierPartitionStateOutputTest() {
    }

    @Test
    void serializeDeserializeTest() throws IOException {
        TopicIdPartition tp1 = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicIdPartition tp2 = new TopicIdPartition("topic", UUID.randomUUID(), 2);
        String path1 = "prefix//remoteURI";
        String path2 = "prefix//remoteURI2";
        LinkedHashMap<TopicIdPartition, String> selectedFTPS = new LinkedHashMap<TopicIdPartition, String>();
        selectedFTPS.put(tp1, path1);
        selectedFTPS.put(tp2, path2);
        SelectRemoteFileTierPartitionStateOutput output = new SelectRemoteFileTierPartitionStateOutput(1, selectedFTPS);
        File testFile = TestUtils.tempFile((String)"test", (String)".json");
        output.writeJsonToFile(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        SelectRemoteFileTierPartitionStateOutput readJsonFromFileOutput = SelectRemoteFileTierPartitionStateOutput.readJsonFromFile((Path)testFile.toPath());
        Assertions.assertEquals((Object)output, (Object)readJsonFromFileOutput);
        String outputStr = String.format("{\"version\":1,\"selected_ftps\":{\"%s\":\"%s\",\"%s\":\"%s\"}}", tp1, path1, tp2, path2);
        SelectRemoteFileTierPartitionStateOutput readJsonFromStringOutput = SelectRemoteFileTierPartitionStateOutput.readJsonFromString((String)outputStr);
        Assertions.assertEquals((Object)output, (Object)readJsonFromStringOutput);
        String writtenJson = Utils.readFileAsString((String)testFile.toPath().toString());
        Assertions.assertEquals((Object)outputStr, (Object)writtenJson);
    }

    @Test
    void invalidVersionTest() throws IOException {
        TopicIdPartition tp1 = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicIdPartition tp2 = new TopicIdPartition("topic", UUID.randomUUID(), 2);
        String path1 = "prefix//remoteURI";
        String path2 = "prefix//remoteURI2";
        LinkedHashMap<TopicIdPartition, String> selectedFTPS = new LinkedHashMap<TopicIdPartition, String>();
        selectedFTPS.put(tp1, path1);
        selectedFTPS.put(tp2, path2);
        short invalidVersion = 2;
        String outputStr = String.format("{\"version\":" + invalidVersion + ",\"selected_ftps\":{\"%s\":\"%s\",\"%s\":\"%s\"}}", tp1, path1, tp2, path2);
        try {
            SelectRemoteFileTierPartitionStateOutput.readJsonFromString((String)outputStr);
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)String.format("Invalid version in select-remote-ftps output. Expected: %s but found: %s", (short)1, invalidVersion), (Object)e.getMessage());
        }
        SelectRemoteFileTierPartitionStateOutput output = new SelectRemoteFileTierPartitionStateOutput(invalidVersion, selectedFTPS);
        File testFile = TestUtils.tempFile((String)"test-invalid-version", (String)".json");
        output.writeJsonToFile(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        try {
            SelectRemoteFileTierPartitionStateOutput.readJsonFromFile((Path)testFile.toPath());
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)String.format("Invalid version in select-remote-ftps output. Expected: %s but found: %s", (short)1, invalidVersion), (Object)e.getMessage());
        }
    }

    @Test
    void invalidJsonTest() throws IOException {
        TopicIdPartition tp1 = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicIdPartition tp2 = new TopicIdPartition("topic", UUID.randomUUID(), 2);
        String path1 = "prefix//remoteURI";
        String path2 = "prefix//remoteURI2";
        String noVersionStr = String.format("{\"selected_ftps\":{\"%s\":\"%s\",\"%s\":\"%s\"}}", tp1, path1, tp2, path2);
        String noSelectedFTPSStr = "{\"version\":1}";
        String invalidJsonStr = "invalidJson";
        Assertions.assertThrows(IOException.class, () -> SelectRemoteFileTierPartitionStateOutput.readJsonFromString((String)noVersionStr));
        Assertions.assertThrows(IOException.class, () -> SelectRemoteFileTierPartitionStateOutput.readJsonFromString((String)noSelectedFTPSStr));
        Assertions.assertThrows(IOException.class, () -> SelectRemoteFileTierPartitionStateOutput.readJsonFromString((String)invalidJsonStr));
        File noVersionFile = TestUtils.tempFile((String)noVersionStr);
        File noSelectedFTPSFile = TestUtils.tempFile((String)noSelectedFTPSStr);
        File invalidJsonFile = TestUtils.tempFile((String)invalidJsonStr);
        Assertions.assertThrows(IOException.class, () -> SelectRemoteFileTierPartitionStateOutput.readJsonFromFile((Path)noVersionFile.toPath()));
        Assertions.assertThrows(IOException.class, () -> SelectRemoteFileTierPartitionStateOutput.readJsonFromFile((Path)noSelectedFTPSFile.toPath()));
        Assertions.assertThrows(IOException.class, () -> SelectRemoteFileTierPartitionStateOutput.readJsonFromFile((Path)invalidJsonFile.toPath()));
    }
}

