/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000514A!\u0005\n\u00013!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E!)\u0011\u0006\u0001C!U!9a\u0006\u0001b\u0001\n\u0013y\u0003B\u0002\u001b\u0001A\u0003%\u0001\u0007C\u00046\u0001\t\u0007I\u0011\u0002\u001c\t\r\u001d\u0003\u0001\u0015!\u00038\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015Q\u0006\u0001\"\u0011J\u0011\u0015y\u0006\u0001\"\u0011J\u0011\u0015\t\u0007\u0001\"\u0001J\u0011\u0015\u0019\u0007\u0001\"\u0001J\u0011\u0015)\u0007\u0001\"\u0011J\u0011\u00159\u0007\u0001\"\u0001J\u0011\u0015I\u0007\u0001\"\u0001J\u0011\u0015Y\u0007\u0001\"\u0003J\u00051\"\u0016.\u001a:U_BL7mQ8ogVlWM]*oCB\u001c\bn\u001c;NCR,'/[1mSj\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005)Ao\u001c9jG*\u0011QCF\u0001\u0005i&,'OC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\n\n\u0005u\u0011\"!\u0006+jKJ$v\u000e]5d\u0007>t7/^7feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002OQLWM\u001d+pa&\u001cW*\u0019;fe&\fG.\u001b>f\rJ|Wn\u00158baNDw\u000e^#oC\ndW\rZ\u000b\u0002GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t9!i\\8mK\u0006t\u0017AG7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8US6,'+\u00198hK6\u001bX#A\u0016\u0011\u0005\u0011b\u0013BA\u0017&\u0005\u0011auN\\4\u0002#Q\u0004x\fZ5tG>4XM]0feJ|'/F\u00011!\t\t$'D\u0001\u0015\u0013\t\u0019DC\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006\u0011B\u000f]0eSN\u001cwN^3s?\u0016\u0014(o\u001c:!\u0003I\u0019G\u000f_0eSN\u001cwN^3s?\u0016\u0014(o\u001c:\u0016\u0003]\u0002\"\u0001\u000f#\u000f\u0005e\u0012eB\u0001\u001eB\u001d\tY\u0004I\u0004\u0002=\u007f5\tQH\u0003\u0002?1\u00051AH]8pizJ\u0011aF\u0005\u0003+YI!a\u0005\u000b\n\u0005\r\u0013\u0012!\u0005+jKJ$v\u000e]5d\u0007>t7/^7fe&\u0011QI\u0012\u0002\n\u00072LWM\u001c;DibT!a\u0011\n\u0002'\r$\bp\u00183jg\u000e|g/\u001a:`KJ\u0014xN\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003)\u0003\"\u0001J&\n\u00051+#\u0001B+oSRD#\u0001\u0003(\u0011\u0005=CV\"\u0001)\u000b\u0005E\u0013\u0016aA1qS*\u00111\u000bV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)f+A\u0003kk:LGOC\u0001X\u0003\ry'oZ\u0005\u00033B\u0013!BQ3g_J,W)Y2i\u0003E!Xm\u001d;Q_2dG)\u001e:bi&|gn\u001d\u0015\u0003\u0013q\u0003\"aT/\n\u0005y\u0003&\u0001\u0002+fgR\fa\u0003^3tiJ+w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003\u0015q\u000ba\t^3tiB\u0013\u0018.\\1ss\u000e{gn];nKJ\u001cV-Z6t)>\u0014UmZ5o]&twmQ8n[&$H/\u001a3PM\u001a\u001cX\r^(o\u0007>lW.\u001b;uK\u0012|eMZ:fi2\u000bw\r\u000b\u0002\f9\u00069C/Z:u%\u0016<\u0017n\u001d;feB\u000b'\u000f^5uS>t7OU3rk&\u0014XMU3eSN\u001cwN^3sQ\taA,A\nuKN$8)\u0019;dQV\u00048i\\7qY\u0016$X\r\u000b\u0002\u000e9\u0006\tB/Z:u\u0005\u0016<\u0017N\u001c#jg\u000e|g/\u001a:)\u00059a\u0016A\t;fgR\u0004&o\\2fgN\u001cf.\u00199tQ>$X*\u0019;fe&\fG.\u001b>bi&|g\u000e\u000b\u0002\u00109\u0006!B/Z:u\t&\u001c8m\u001c<fe\u000e{W\u000e\u001d7fi\u0016\u0004")
public class TierTopicConsumerSnapshotMaterializationTest
extends TierTopicConsumerTest {
    private final TopicIdPartition tp_discover_error = new TopicIdPartition("tp_discover_error", UUID.fromString("76081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_discover_error = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);

    @Override
    public boolean tierTopicMaterializeFromSnapshotEnabled() {
        return true;
    }

    @Override
    public long materializationTimeRangeMs() {
        return 604800000L;
    }

    private TopicIdPartition tp_discover_error() {
        return this.tp_discover_error;
    }

    private TierTopicConsumer.ClientCtx ctx_discover_error() {
        return this.ctx_discover_error;
    }

    @Override
    @BeforeEach
    public void setup() {
        super.setup();
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)this.ctx_discover_error().status()).thenReturn((Object)TierPartitionStatus.DISCOVER_ERROR);
    }

    @Override
    @Test
    public void testPollDurations() {
        Consumer primary = (Consumer)Mockito.mock(Consumer.class);
        Consumer catchup = (Consumer)Mockito.mock(Consumer.class);
        Consumer discover = (Consumer)Mockito.mock(Consumer.class);
        TierTopicInitLeader testEvent = new TierTopicInitLeader(this.tp_init(), 0, UUID.randomUUID(), 0);
        ConsumerRecord testRecord = new ConsumerRecord(this.tp_init().topic(), 0, 0L, (Object)testEvent.serializeKey(), (Object)testEvent.serializeValue());
        ConsumerRecords testRecords = new ConsumerRecords(Collections.singletonMap(this.tp_init().topicPartition(), Collections.singletonList(testRecord)));
        TierTopicConsumer tierTopicConsumerWithMock = this.createTierTopicConsumerAndRegisterPartitions((Consumer<byte[], byte[]>)primary, (Consumer<byte[], byte[]>)catchup, (Consumer<byte[], byte[]>)discover, (scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_online()), (Object)this.ctx_online()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_init()), (Object)this.ctx_init())}))));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)primary.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)catchup.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)catchup.assignment()).thenReturn((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.tierTopicName(), 0)}))).asJava());
        Mockito.when((Object)discover.endOffsets((Collection)ArgumentMatchers.any())).thenReturn(Collections.singletonMap(new TopicPartition(this.tierTopicName(), 0), 100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)discover.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)discover.assignment()).thenReturn((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.tierTopicName(), 0)}))).asJava());
        tierTopicConsumerWithMock.initialize(this.tierTopic());
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover)).poll(Duration.ZERO);
        Mockito.when((Object)primary.poll((Duration)ArgumentMatchers.any())).thenReturn((Object)testRecords);
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ofMillis(this.pollDurationMs()));
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)2))).poll(Duration.ZERO);
        Mockito.when((Object)primary.poll((Duration)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)discover.poll((Duration)ArgumentMatchers.any())).thenReturn((Object)testRecords);
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)3))).poll(Duration.ZERO);
        Mockito.when((Object)primary.poll((Duration)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)discover.poll((Duration)ArgumentMatchers.any())).thenReturn(null);
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)3))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)4))).poll(Duration.ZERO);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)discover.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)catchup.poll((Duration)ArgumentMatchers.any())).thenReturn((Object)testRecords);
        Mockito.when((Object)discover.poll((Duration)ArgumentMatchers.any())).thenReturn((Object)testRecords);
        tierTopicConsumerWithMock.register(this.tp_discover(), this.ctx_discover());
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ofMillis(this.pollDurationMs()));
        ((Consumer)Mockito.verify((Object)catchup)).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)5))).poll(Duration.ZERO);
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)4))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)2))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)6))).poll(Duration.ZERO);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)catchup.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)5))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)2))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)7))).poll(Duration.ZERO);
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)6))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)3))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)7))).poll(Duration.ZERO);
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_online(), this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)3))).poll(Duration.ofMillis(this.pollDurationMs()));
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)3))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)discover, (VerificationMode)Mockito.times((int)7))).poll(Duration.ZERO);
    }

    @Override
    @Test
    public void testRegisterPartitions() {
        scala.collection.immutable.Map topicPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_online()), (Object)this.ctx_online()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_init()), (Object)this.ctx_init()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover()), (Object)this.ctx_discover()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_catchup()), (Object)this.ctx_catchup()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_error()), (Object)this.ctx_error()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover_error()), (Object)this.ctx_discover_error()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_frozen()), (Object)this.ctx_frozen())}));
        this.registerPartitionsAndVerify((scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx>)topicPartitions, (scala.collection.immutable.Set<TopicIdPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()}));
            scala.collection.mutable.Set set = CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala();
            return !(object != null ? !object.equals(set) : set != null);
        }, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup(), this.tp_error(), this.tp_discover_error(), this.tp_frozen()}));
            scala.collection.mutable.Set set = CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala();
            return !(object != null ? !object.equals(set) : set != null);
        });
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_online(), (VerificationMode)Mockito.times((int)3))).status();
        ((MapOps)topicPartitions.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TierTopicConsumerSnapshotMaterializationTest.$anonfun$testRegisterPartitions$3(this, x$1)))).values().foreach((Function1 & Serializable)ctx -> ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx, (VerificationMode)Mockito.times((int)4))).status());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_online(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_error(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover_error(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_frozen(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        topicPartitions.values().foreach((Function1 & Serializable)ctx -> {
            TierTopicConsumerSnapshotMaterializationTest.$anonfun$testRegisterPartitions$5(ctx);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup(), this.tp_error(), this.tp_discover_error(), this.tp_frozen()}))).asJava()), (Object)this.discoverConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testPrimaryConsumerSeeksToBeginningCommittedOffsetOnCommittedOffsetLag() {
        scala.collection.immutable.Map committedOffsetMap = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch((long)tierTopicPartition.partition() + 100L, Optional.of(Predef$.MODULE$.int2Integer(3)))))).dropRight(2)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map beginningOffsetMap = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)((long)tierTopicPartition.partition() + 200L)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        committedOffsetMap.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        Consumer<byte[], byte[]> mockPrimaryConsumer = this.primaryConsumerSupplier().get();
        ((MockConsumer)mockPrimaryConsumer).updateBeginningOffsets(CollectionConverters$.MODULE$.MapHasAsJava((Map)beginningOffsetMap).asJava());
        TierTopicConsumer tierTopicConsumerWithMock = new TierTopicConsumer(this.tierTopicManagerConfig(), (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, mockPrimaryConsumer){
            private final Consumer mockPrimaryConsumer$1;

            public Consumer<byte[], byte[]> get() {
                return this.mockPrimaryConsumer$1;
            }
            {
                this.mockPrimaryConsumer$1 = mockPrimaryConsumer$1;
            }
        }, this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        tierTopicConsumerWithMock.setupMetrics();
        tierTopicConsumerWithMock.initialize(this.tierTopic());
        Assertions.assertNotNull((Object)tierTopicConsumerWithMock.tierTopic());
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)mockPrimaryConsumer.assignment());
        beginningOffsetMap.foreach((Function1 & Serializable)x0$2 -> {
            TierTopicConsumerSnapshotMaterializationTest.$anonfun$testPrimaryConsumerSeeksToBeginningCommittedOffsetOnCommittedOffsetLag$4(mockPrimaryConsumer, x0$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)this.tierTopicPartitions().size(), (int)tierTopicConsumerWithMock.requireRediscoverTTPs.size());
        Assertions.assertTrue((boolean)tierTopicConsumerWithMock.status().isInitialized());
    }

    @Test
    public void testRegisterPartitionsRequireRediscover() {
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn(null);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_online().localMaterializedOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        scala.collection.immutable.Map topicPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_online()), (Object)this.ctx_online()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_init()), (Object)this.ctx_init()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover()), (Object)this.ctx_discover()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_catchup()), (Object)this.ctx_catchup()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_error()), (Object)this.ctx_error()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover_error()), (Object)this.ctx_discover_error()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_frozen()), (Object)this.ctx_frozen())}));
        this.registerPartitionsAndVerify((scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx>)topicPartitions, (scala.collection.immutable.Set<TopicIdPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            Object object = Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Set set = CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala();
            return !(object != null ? !object.equals(set) : set != null);
        }, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online(), this.tp_init(), this.tp_discover(), this.tp_catchup(), this.tp_error(), this.tp_discover_error(), this.tp_frozen()}));
            scala.collection.mutable.Set set = CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala();
            return !(object != null ? !object.equals(set) : set != null);
        });
        topicPartitions.values().foreach((Function1 & Serializable)ctx -> ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx, (VerificationMode)Mockito.times((int)4))).status());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_online(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_error(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover_error(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_frozen(), (VerificationMode)Mockito.times((int)0))).beginDiscover();
        Assertions.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online(), this.tp_init(), this.tp_discover(), this.tp_catchup(), this.tp_error(), this.tp_discover_error(), this.tp_frozen()}))).asJava()), (Object)this.discoverConsumerSupplier().consumers().get(0).assignment());
    }

    @Override
    @Test
    public void testCatchupComplete() {
        Mockito.when((Object)this.ctx_catchup().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-online");
        Mockito.when((Object)this.ctx_discover().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-discover");
        Mockito.when((Object)this.ctx_init().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-init");
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_catchup().localMaterializedOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)10L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_discover().localMaterializedOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)1L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_init().localMaterializedOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(this.tp_init(), this.ctx_init());
        this.tierTopicConsumer().register(this.tp_discover(), this.ctx_discover());
        this.tierTopicConsumer().register(this.tp_catchup(), this.ctx_catchup());
        this.tierTopicConsumer().doWork();
        this.testDiscoverComplete();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala(), (String)"Expected all partitions to be registered with the catchup consumer.");
        Consumer<byte[], byte[]> catchupConsumer = this.catchupConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment = CollectionConverters$.MODULE$.SetHasAsScala(catchupConsumer.assignment()).asScala();
        Assertions.assertEquals((int)3, (int)assignment.size(), (String)"Expected 2 partitions to be assigned to catchup consumer.");
        Assertions.assertEquals((long)1L, (long)catchupConsumer.position(this.tierTopicConsumer().tierTopic().toTierTopicPartition(this.tp_discover())), (String)"Expected catchup consumer to be at position of the materialized offset for the partition.");
        Assertions.assertEquals((long)10L, (long)catchupConsumer.position(this.tierTopicConsumer().tierTopic().toTierTopicPartition(this.tp_catchup())), (String)"Expected catchup consumer to be at position of the materialized offset for the partition.");
        Assertions.assertTrue((catchupConsumer.position(this.tierTopicConsumer().tierTopic().toTierTopicPartition(this.tp_catchup())) > 0L ? 1 : 0) != 0, (String)"Expected catchup consumer to be at lower bound when materialized offset is empty.");
        assignment.foreach((Function1 & Serializable)assignedPartition -> {
            catchupConsumer.seek(assignedPartition, 50L);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala(), (String)"None of the TTPs caught up with primary consumer, expected all partitions to be registered with the catchup consumer.");
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala(), (String)"Only one of the TTPs caught up with primary consumer, expected all partitions to be registered with the catchup consumer.");
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)0))).completeCatchup();
        assignment.foreach((Function1 & Serializable)assignedPartition -> {
            catchupConsumer.seek(assignedPartition, 150L);
            return BoxedUnit.UNIT;
        });
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala(), (String)"All TTPs caught up with primary consumer, expected no partitions to be registered with the catchup consumer.");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala(), (String)"All TTPs caught up with primary consumer, expected all partitions to be registered with the primary consumer.");
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).completeCatchup();
    }

    @Test
    public void testBeginDiscover() {
        Consumer discoverConsumer = (Consumer)Mockito.mock(Consumer.class);
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, discoverConsumer){
            private final Consumer discoverConsumer$1;

            public Consumer<byte[], byte[]> get() {
                return this.discoverConsumer$1;
            }
            {
                this.discoverConsumer$1 = discoverConsumer$1;
            }
        }, this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        tierTopicConsumer.setupMetrics();
        tierTopicConsumer.initialize(this.tierTopic());
        tierTopicConsumer.doWork();
        tierTopicConsumer.register(this.tp_init(), this.ctx_init());
        Mockito.when((Object)discoverConsumer.offsetsForTimes((java.util.Map)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TimeoutException()}).thenReturn(new HashMap());
        tierTopicConsumer.doWork();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginDiscover();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumer.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertTrue((!tierTopicConsumer.discoverConsumer.active() ? 1 : 0) != 0);
        tierTopicConsumer.doWork();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)2))).beginDiscover();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumer.discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertTrue((boolean)tierTopicConsumer.discoverConsumer.active());
    }

    @Test
    public void testProcessSnapshotMaterialization() {
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)new OffsetAndEpoch(-1L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_online().localMaterializedOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(this.tp_init(), this.ctx_init());
        this.tierTopicConsumer().register(this.tp_online(), this.ctx_online());
        this.tierTopicConsumer().register(this.tp_discover(), this.ctx_discover());
        this.tierTopicConsumer().register(this.tp_catchup(), this.ctx_catchup());
        this.tierTopicConsumer().register(this.tp_error(), this.ctx_error());
        this.tierTopicConsumer().register(this.tp_discover_error(), this.ctx_discover_error());
        this.tierTopicConsumer().register(this.tp_frozen(), this.ctx_frozen());
        this.tierTopicConsumer().doWork();
        scala.collection.immutable.Map allowedPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover()), (Object)this.ctx_discover()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_error()), (Object)this.ctx_error()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover_error()), (Object)this.ctx_discover_error())}));
        scala.collection.immutable.Map disallowedPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_init()), (Object)this.ctx_init()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_online()), (Object)this.ctx_online()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_catchup()), (Object)this.ctx_catchup()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_frozen()), (Object)this.ctx_frozen())}));
        Assertions.assertEquals((Object)allowedPartitions.keySet().$plus$plus((IterableOnce)disallowedPartitions.keySet()), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        allowedPartitions.foreach((Function1 & Serializable)entry -> {
            TierMetadataSnapshotUploadComplete snapshotUploadComplete = new TierMetadataSnapshotUploadComplete((TopicIdPartition)entry._1(), 0, UUID.randomUUID(), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 9999L, Predef$.MODULE$.Byte2byte(Algorithm.ADLER.id), Optional.empty());
            this.tierTopicConsumer().processEntry((AbstractTierMetadata)snapshotUploadComplete, snapshotUploadComplete.stateOffsetAndEpoch(), TierPartitionStatus.DISCOVER);
            return ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)entry._2(), (VerificationMode)Mockito.times((int)1))).processSnapshotMaterializationEvent(snapshotUploadComplete, null, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        });
        allowedPartitions.foreach((Function1 & Serializable)entry -> {
            TierMetadataSnapshotUploadComplete snapshotUploadComplete = new TierMetadataSnapshotUploadComplete((TopicIdPartition)entry._1(), 0, UUID.randomUUID(), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 9999L, Predef$.MODULE$.Byte2byte(Algorithm.ADLER.id), Optional.empty());
            this.tierTopicConsumer().processEntry((AbstractTierMetadata)snapshotUploadComplete, snapshotUploadComplete.stateOffsetAndEpoch(), TierPartitionStatus.CATCHUP);
            return ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)entry._2(), (VerificationMode)Mockito.times((int)0))).processSnapshotMaterializationEvent(snapshotUploadComplete, null, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        });
        disallowedPartitions.foreach((Function1 & Serializable)entry -> {
            TierMetadataSnapshotUploadComplete snapshotUploadComplete = new TierMetadataSnapshotUploadComplete((TopicIdPartition)entry._1(), 0, UUID.randomUUID(), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 9999L, Predef$.MODULE$.Byte2byte(Algorithm.ADLER.id), Optional.empty());
            this.tierTopicConsumer().processEntry((AbstractTierMetadata)snapshotUploadComplete, snapshotUploadComplete.stateOffsetAndEpoch(), TierPartitionStatus.DISCOVER);
            return ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)entry._2(), (VerificationMode)Mockito.times((int)0))).processSnapshotMaterializationEvent((TierMetadataSnapshotUploadComplete)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any(), (OffsetAndEpoch)ArgumentMatchers.any());
        });
    }

    private void testDiscoverComplete() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        Consumer<byte[], byte[]> discoverConsumer = this.discoverConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment = CollectionConverters$.MODULE$.SetHasAsScala(discoverConsumer.assignment()).asScala();
        Assertions.assertEquals((int)3, (int)assignment.size());
        assignment.foreach((Function1 & Serializable)assignedPartition -> {
            discoverConsumer.seek(assignedPartition, this.mockEndOffset() - 50L);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        discoverConsumer.seek((TopicPartition)assignment.head(), this.mockEndOffset());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)0))).completeDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)0))).completeDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)0))).completeDiscover();
        assignment.foreach((Function1 & Serializable)assignedPartition -> {
            discoverConsumer.seek(assignedPartition, this.mockEndOffset() + 50L);
            return BoxedUnit.UNIT;
        });
        discoverConsumer.seek((TopicPartition)assignment.head(), this.mockEndOffset());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).completeDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)1))).completeDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).completeDiscover();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
    }

    public static final /* synthetic */ boolean $anonfun$testRegisterPartitions$3(TierTopicConsumerSnapshotMaterializationTest $this, Tuple2 x$1) {
        Object object = x$1._2();
        TierTopicConsumer.ClientCtx clientCtx = $this.ctx_online();
        return object == null ? clientCtx != null : !object.equals(clientCtx);
    }

    public static final /* synthetic */ void $anonfun$testRegisterPartitions$5(TierTopicConsumer.ClientCtx ctx) {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx});
    }

    public static final /* synthetic */ void $anonfun$testPrimaryConsumerSeeksToBeginningCommittedOffsetOnCommittedOffsetLag$4(Consumer mockPrimaryConsumer$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tierTopicPartition = (TopicPartition)x0$2._1();
            Long offset = (Long)x0$2._2();
            Assertions.assertEquals((long)(Predef$.MODULE$.Long2long(offset) + 5L), (long)mockPrimaryConsumer$1.position(tierTopicPartition));
            return;
        }
        throw new MatchError(null);
    }
}

