/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.log.LocalLog$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierMetadataDeserializationException;
import kafka.tier.exceptions.TierTopicConsumerRewindException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicConsumerRewindPolicy;
import kafka.tier.topic.TierTopicConsumerStatus;
import kafka.tier.topic.TierTopicConsumerTest$;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.TierTopicPartitioner;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rug\u0001\u0002/^\u0001\u0011DQa\u001b\u0001\u0005\u00021,Aa\u001c\u0001\u0001a\u0016!A\u0010\u0001\u0001~\u0011)\t\t\u0001\u0001b\u0001\n\u0003i\u00161\u0001\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u0006!Q\u0011q\u0003\u0001C\u0002\u0013\u0005Q,!\u0007\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u00037A!\"!\u000b\u0001\u0005\u0004%\t!XA\u0002\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u0015\u0001BCA\u0017\u0001\t\u0007I\u0011A/\u00020!A\u0011Q\b\u0001!\u0002\u0013\t\t\u0004\u0003\u0006\u0002@\u0001\u0011\r\u0011\"\u0001^\u0003\u0003B\u0001\"!\u0013\u0001A\u0003%\u00111\t\u0005\u000b\u0003\u0017\u0002!\u0019!C\u0001;\u0006\u0005\u0003\u0002CA'\u0001\u0001\u0006I!a\u0011\t\u0015\u0005=\u0003A1A\u0005\u0002u\u000b\t\u0006\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA*\u0011)\tY\u0006\u0001b\u0001\n\u0003i\u0016Q\f\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002`!Q\u0011q\r\u0001C\u0002\u0013\u0005Q,!\u001b\t\u0011\u0005E\u0004\u0001)A\u0005\u0003WB!\"a\u001d\u0001\u0005\u0004%\t!XA\u0002\u0011!\t)\b\u0001Q\u0001\n\u0005\u0015\u0001BCA<\u0001\t\u0007I\u0011A/\u0002z!A\u0011q\u0013\u0001!\u0002\u0013\tY\b\u0003\u0006\u0002\u001a\u0002\u0011\r\u0011\"\u0001^\u00037C\u0001\"a)\u0001A\u0003%\u0011Q\u0014\u0005\u000b\u0003K\u0003!\u0019!C\u0001;\u0006\u001d\u0006\u0002CA[\u0001\u0001\u0006I!!+\t\u0015\u0005]\u0006A1A\u0005\u0002u\u000bI\fC\u0004\u0002<\u0002\u0001\u000b\u0011B?\t\u0015\u0005u\u0006A1A\u0005\u0002u\u000by\fC\u0004\u0002B\u0002\u0001\u000b\u0011\u00029\t\u0015\u0005\r\u0007A1A\u0005\u0002u\u000by\fC\u0004\u0002F\u0002\u0001\u000b\u0011\u00029\t\u0015\u0005\u001d\u0007A1A\u0005\u0002u\u000by\fC\u0004\u0002J\u0002\u0001\u000b\u0011\u00029\t\u0015\u0005-\u0007A1A\u0005\u0002u\u000bi\r\u0003\u0005\u0002X\u0002\u0001\u000b\u0011BAh\u0011)\tI\u000e\u0001b\u0001\n\u0003i\u00161\u001c\u0005\t\u0003O\u0004\u0001\u0015!\u0003\u0002^\"Q\u0011\u0011\u001e\u0001C\u0002\u0013\u0005Q,a;\t\u0011\u0005M\b\u0001)A\u0005\u0003[D!\"!>\u0001\u0005\u0004%\t!XA|\u0011!\ty\u0010\u0001Q\u0001\n\u0005e\bB\u0003B\u0001\u0001\t\u0007I\u0011A/\u0003\u0004!A!Q\u0005\u0001!\u0002\u0013\u0011)\u0001\u0003\u0006\u0003(\u0001\u0011\r\u0011\"\u0001^\u0003oD\u0001B!\u000b\u0001A\u0003%\u0011\u0011 \u0005\u000b\u0005W\u0001!\u0019!C\u0001;\n\r\u0001\u0002\u0003B\u0017\u0001\u0001\u0006IA!\u0002\t\u0015\t=\u0002A1A\u0005\u0002u\u000b9\u0010\u0003\u0005\u00032\u0001\u0001\u000b\u0011BA}\u0011)\u0011\u0019\u0004\u0001b\u0001\n\u0003i&1\u0001\u0005\t\u0005k\u0001\u0001\u0015!\u0003\u0003\u0006!Q!q\u0007\u0001C\u0002\u0013\u0005Q,a>\t\u0011\te\u0002\u0001)A\u0005\u0003sD!Ba\u000f\u0001\u0005\u0004%\t!\u0018B\u0002\u0011!\u0011i\u0004\u0001Q\u0001\n\t\u0015\u0001B\u0003B \u0001\t\u0007I\u0011A/\u0002x\"A!\u0011\t\u0001!\u0002\u0013\tI\u0010\u0003\u0006\u0003D\u0001\u0011\r\u0011\"\u0001^\u0005\u0007A\u0001B!\u0012\u0001A\u0003%!Q\u0001\u0005\u000b\u0005\u000f\u0002!\u0019!C\u0001;\u0006]\b\u0002\u0003B%\u0001\u0001\u0006I!!?\t\u0015\t-\u0003A1A\u0005\u0002u\u0013\u0019\u0001\u0003\u0005\u0003N\u0001\u0001\u000b\u0011\u0002B\u0003\u0011!\u0011y\u0005\u0001C\u0001;\nE\u0003\u0002\u0003B-\u0001\u0011\u0005Q,!\u0011\t\u000f\tm\u0003\u0001\"\u0001\u0003^!9!1\u0010\u0001\u0005\u0002\tu\u0003\u0002\u0003BC\u0001\u0011\u0005QLa\"\t\u000f\te\u0006\u0001\"\u0001\u0003^!A!1\u0019\u0001\u0005\u0002u\u0013)\rC\u0004\u0003b\u0002!\tA!\u0018\t\u000f\t\u0015\b\u0001\"\u0001\u0003^!9!\u0011\u001e\u0001\u0005\u0002\tu\u0003b\u0002Bw\u0001\u0011\u0005!Q\f\u0005\b\u0005c\u0004A\u0011\u0001B/\u0011\u001d\u0011)\u0010\u0001C\u0001\u0005oDqa!\t\u0001\t\u0003\u0011i\u0006C\u0004\u0004&\u0001!\tA!\u0018\t\u000f\r%\u0002\u0001\"\u0003\u0004,!91q\u000b\u0001\u0005\n\re\u0003\"CB:\u0001E\u0005I\u0011BB;\u0011\u001d\u0019Y\t\u0001C\u0001\u0005;Bqaa$\u0001\t\u0003\u0011i\u0006C\u0004\u0004\u0014\u0002!\tA!\u0018\t\u000f\r]\u0005\u0001\"\u0001\u0003^!911\u0014\u0001\u0005\u0002\tu\u0003bBBP\u0001\u0011%1\u0011\u0015\u0002\u0016)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\tqv,A\u0003u_BL7M\u0003\u0002aC\u0006!A/[3s\u0015\u0005\u0011\u0017!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0004\"AZ5\u000e\u0003\u001dT\u0011\u0001[\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001e\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001n!\tq\u0007!D\u0001^\u0005A\u0019uN\\:v[\u0016\u00148+\u001e9qY&,'\u000f\u0005\u0003riZ4X\"\u0001:\u000b\u0005M|\u0016AB2mS\u0016tG/\u0003\u0002ve\n!Rj\\2l\u0007>t7/^7feN+\b\u000f\u001d7jKJ\u00042AZ<z\u0013\tAxMA\u0003BeJ\f\u0017\u0010\u0005\u0002gu&\u00111p\u001a\u0002\u0005\u0005f$XM\u0001\tQe>$WoY3s'V\u0004\b\u000f\\5feB!\u0011O <w\u0013\ty(O\u0001\u000bN_\u000e\\\u0007K]8ek\u000e,'oU;qa2LWM]\u0001\nG2,8\u000f^3s\u0013\u0012,\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!A.\u00198h\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u0013\u0011aa\u0015;sS:<\u0017AC2mkN$XM]%eA\u00059A/Z7q\t&\u0014XCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!\u0002BA\u0011\u0003\u001b\t!![8\n\t\u0005\u0015\u0012q\u0004\u0002\u0005\r&dW-\u0001\u0005uK6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013a\u00027pO\u0012K'o]\u000b\u0003\u0003c\u0001b!a\r\u0002:\u0005\u0015QBAA\u001b\u0015\u0011\t9$!\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\t)DA\u0005BeJ\f\u0017\u0010T5ti\u0006AAn\\4ESJ\u001c\b%\u0001\bq_2dG)\u001e:bi&|g.T:\u0016\u0005\u0005\r\u0003c\u00014\u0002F%\u0019\u0011qI4\u0003\t1{gnZ\u0001\u0010a>dG\u000eR;sCRLwN\\'tA\u0005iQn\\2l\u000b:$wJ\u001a4tKR\fa\"\\8dW\u0016sGm\u00144gg\u0016$\b%\u0001\fuS\u0016\u0014Hk\u001c9jG:+X\u000eU1si&$\u0018n\u001c8t+\t\t\u0019\u0006E\u0002g\u0003+J1!a\u0016h\u0005\u0015\u0019\u0006n\u001c:u\u0003]!\u0018.\u001a:U_BL7MT;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u000buS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tWM]\u000b\u0003\u0003?\u00022A\\A1\u0013\r\t\u0019'\u0018\u0002\u0015)&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u001a:\u0002+QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\3sA\u00051B/[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw-\u0006\u0002\u0002lA\u0019a.!\u001c\n\u0007\u0005=TL\u0001\fUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h\u0003]!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0007%A\u0007uS\u0016\u0014Hk\u001c9jG:\u000bW.Z\u0001\u000fi&,'\u000fV8qS\u000et\u0015-\\3!\u0003M!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8t+\t\tY\b\u0005\u0004\u00024\u0005u\u0014\u0011Q\u0005\u0005\u0003\u007f\n)DA\u0002TKR\u0004B!a!\u0002\u00146\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0004d_6lwN\u001c\u0006\u0004E\u0006-%\u0002BAG\u0003\u001f\u000ba!\u00199bG\",'BAAI\u0003\ry'oZ\u0005\u0005\u0003+\u000b)I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002)QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003%!\u0018.\u001a:U_BL7-\u0006\u0002\u0002\u001eB\u0019a.a(\n\u0007\u0005\u0005VL\u0001\u000bJ]&$\u0018.\u00197ju\u0016$G+[3s)>\u0004\u0018nY\u0001\u000bi&,'\u000fV8qS\u000e\u0004\u0013\u0001\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3s+\t\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\tykX\u0001\bM\u0016$8\r[3s\u0013\u0011\t\u0019,!,\u0003!QKWM]*uCR,g)\u001a;dQ\u0016\u0014\u0018!\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3sA\u0005\u0001\u0002O]8ek\u000e,'oU;qa2LWM]\u000b\u0002{\u0006\t\u0002O]8ek\u000e,'oU;qa2LWM\u001d\u0011\u0002/A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014X#\u00019\u00021A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\fdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006A2-\u0019;dQV\u00048i\u001c8tk6,'oU;qa2LWM\u001d\u0011\u00021\u0011L7oY8wKJ\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'/A\reSN\u001cwN^3s\u0007>t7/^7feN+\b\u000f\u001d7jKJ\u0004\u0013!\u0007;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>lW.\u001b;uKJ,\"!a4\u0011\t\u0005E\u00171[\u0007\u0002?&\u0019\u0011Q[0\u00033QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\\7nSR$XM]\u0001\u001bi&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cu.\\7jiR,'\u000fI\u0001\b[\u0016$(/[2t+\t\ti\u000e\u0005\u0003\u0002`\u0006\rXBAAq\u0015\u0011\tI.!\"\n\t\u0005\u0015\u0018\u0011\u001d\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\u0011\u0011Q\u001e\t\u0004]\u0006=\u0018bAAy;\n\tB+[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0002%QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000fI\u0001\niB|vN\u001c7j]\u0016,\"!!?\u0011\t\u0005E\u00171`\u0005\u0004\u0003{|&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003)!\boX8oY&tW\rI\u0001\u000bGRDxl\u001c8mS:,WC\u0001B\u0003!\u0011\u00119Aa\b\u000f\t\t%!1\u0004\b\u0005\u0005\u0017\u0011IB\u0004\u0003\u0003\u000e\t]a\u0002\u0002B\b\u0005+i!A!\u0005\u000b\u0007\tM1-\u0001\u0004=e>|GOP\u0005\u0002E&\u0011\u0001-Y\u0005\u0003=~K1A!\b^\u0003E!\u0016.\u001a:U_BL7mQ8ogVlWM]\u0005\u0005\u0005C\u0011\u0019CA\u0005DY&,g\u000e^\"uq*\u0019!QD/\u0002\u0017\r$\bpX8oY&tW\rI\u0001\fiB|F-[:d_Z,'/\u0001\u0007ua~#\u0017n]2pm\u0016\u0014\b%\u0001\u0007dib|F-[:d_Z,'/A\u0007dib|F-[:d_Z,'\u000fI\u0001\biB|\u0016N\\5u\u0003!!\boX5oSR\u0004\u0013\u0001C2uq~Kg.\u001b;\u0002\u0013\r$\bpX5oSR\u0004\u0013A\u0003;q?\u000e\fGo\u00195va\u0006YA\u000f]0dCR\u001c\u0007.\u001e9!\u0003-\u0019G\u000f_0dCR\u001c\u0007.\u001e9\u0002\u0019\r$\bpX2bi\u000eDW\u000f\u001d\u0011\u0002\u0011Q\u0004x,\u001a:s_J\f\u0011\u0002\u001e9`KJ\u0014xN\u001d\u0011\u0002\u0013\r$\bpX3se>\u0014\u0018AC2uq~+'O]8sA\u0005IA\u000f]0ge>TXM\\\u0001\u000biB|fM]8{K:\u0004\u0013AC2uq~3'o\u001c>f]\u0006Y1\r\u001e=`MJ|'0\u001a8!\u0003\u001d\"\u0018.\u001a:U_BL7-T1uKJL\u0017\r\\5{K\u001a\u0013x.\\*oCB\u001c\bn\u001c;F]\u0006\u0014G.\u001a3\u0016\u0005\tM\u0003c\u00014\u0003V%\u0019!qK4\u0003\u000f\t{w\u000e\\3b]\u0006QR.\u0019;fe&\fG.\u001b>bi&|g\u000eV5nKJ\u000bgnZ3Ng\u0006)1/\u001a;vaR\u0011!q\f\t\u0004M\n\u0005\u0014b\u0001B2O\n!QK\\5uQ\r1%q\r\t\u0005\u0005S\u00129(\u0004\u0002\u0003l)!!Q\u000eB8\u0003\r\t\u0007/\u001b\u0006\u0005\u0005c\u0012\u0019(A\u0004kkBLG/\u001a:\u000b\t\tU\u0014qR\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005s\u0012YG\u0001\u0006CK\u001a|'/Z#bG\"\fab\u00197fC:,\b/T8dW&$x\u000eK\u0002H\u0005\u007f\u0002BA!\u001b\u0003\u0002&!!1\u0011B6\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0017de\u0016\fG/\u001a+jKJ$v\u000e]5d\u0007>t7/^7fe\u0006sGMU3hSN$XM\u001d)beRLG/[8ogRQ\u0011Q\u001eBE\u0005;\u0013\tK!*\t\u000f\t-\u0005\n1\u0001\u0003\u000e\u0006y\u0001O]5nCJL8i\u001c8tk6,'\u000f\u0005\u0004\u0003\u0010\neeO^\u0007\u0003\u0005#SAAa%\u0003\u0016\u0006A1m\u001c8tk6,'O\u0003\u0003\u0003\u0018\u0006%\u0015aB2mS\u0016tGo]\u0005\u0005\u00057\u0013\tJ\u0001\u0005D_:\u001cX/\\3s\u0011\u001d\u0011y\n\u0013a\u0001\u0005\u001b\u000bqbY1uG\",\boQ8ogVlWM\u001d\u0005\b\u0005GC\u0005\u0019\u0001BG\u0003A!\u0017n]2pm\u0016\u00148i\u001c8tk6,'\u000fC\u0004\u0003(\"\u0003\rA!+\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0005\u0003,\nM\u0016\u0011 B\u0003\u001d\u0011\u0011iKa,\u0011\u0007\t=q-C\u0002\u00032\u001e\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B[\u0005o\u00131!T1q\u0015\r\u0011\tlZ\u0001\u0012i\u0016\u001cH\u000fU8mY\u0012+(/\u0019;j_:\u001c\bfA%\u0003>B!!\u0011\u000eB`\u0013\u0011\u0011\tMa\u001b\u0003\tQ+7\u000f^\u0001\u001ce\u0016<\u0017n\u001d;feB\u000b'\u000f^5uS>t7/\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015\t}#q\u0019Bf\u0005'\u0014i\u000eC\u0004\u0003J*\u0003\rA!+\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]NDqA!4K\u0001\u0004\u0011y-A\ffqB,7\r^3e\u000bJ\u0014xN\u001d)beRLG/[8ogB1!1\u0016Bi\u0003sLA!a \u00038\"9!Q\u001b&A\u0002\t]\u0017!\t9sS6\f'/_\"p]N,X.\u001a:QCJ$\u0018\u000e^5p]N4VM]5gS\u0016\u0014\b#\u00024\u0003Z\nM\u0013b\u0001BnO\nIa)\u001e8di&|g\u000e\r\u0005\b\u0005?T\u0005\u0019\u0001Bl\u0003\u0011rwN\u001c)sS6\f'/_\"p]N,X.\u001a:QCJ$\u0018\u000e^5p]N4VM]5gS\u0016\u0014\u0018A\u0006;fgR\u0014VmZ5ti\u0016\u0014\b+\u0019:uSRLwN\\:)\u0007-\u0013i,A\u0010uKN$H)\u001e9mS\u000e\fG/\u001a*fO&\u001cH/\u001a:QCJ$\u0018\u000e^5p]ND3\u0001\u0014B_\u0003Y\"Xm\u001d;Qe&l\u0017M]=D_:\u001cX/\\3s'\u0016,7n\u001d+p\u0019\u0006\u001cHoQ8n[&$H/\u001a3PM\u001a\u001cX\r^(o'R\f'\u000f^;qQ\ri%QX\u0001\u0017i\u0016\u001cH/T1uKJL\u0017\r\\5{CRLwN\u001c'bO\"\u001aaJ!0\u0002'Q,7\u000f^\"bi\u000eDW\u000f]\"p[BdW\r^3)\u0007=\u0013i,A\u000buKN$X*\u0019=NCR,'/[1mSj,G*Y4\u0015\t\t}#\u0011 \u0005\b\u0005w\u0004\u0006\u0019\u0001B*\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$\u0007f\u0001)\u0003\u0000B!1\u0011AB\u0004\u001b\t\u0019\u0019A\u0003\u0003\u0004\u0006\t=\u0014A\u00029be\u0006l7/\u0003\u0003\u0004\n\r\r!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":\u0001k!\u0004\u0004\u001a\rm\u0001\u0003BB\b\u0007+i!a!\u0005\u000b\t\rM11A\u0001\taJ|g/\u001b3fe&!1qCB\t\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCa!\b\u0004 e\t\u0011!G\u0001\u0001\u0003M!Xm\u001d;HCJ\u0014\u0017mZ3IC:$G.\u001b8hQ\r\t&QX\u0001(i\u0016\u001cHOU3d_:4\u0017nZ;sK6\u000bG/\u001a:jC2L'0\u0019;j_:$\u0016.\\3SC:<W\rK\u0002S\u0005{\u000b\u0001c]3ukB\u0014Vm^5oI6{7m[:\u0015\r\t}3QFB\"\u0011\u001d\u0019yc\u0015a\u0001\u0007c\ta\u0002];u\u0013:|eMZ:fi6\u000b\u0007\u000fE\u0005g\u0007g\t\tia\u000e\u0003`%\u00191QG4\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BB\u001d\u0007\u007fi!aa\u000f\u000b\u0007\rur,A\u0003ti\u0006$X-\u0003\u0003\u0004B\rm\"AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0007\u000b\u001a\u0006\u0019AB$\u000319W\r^(gMN,G/T1q!\u00151'\u0011\\B%!!\u0019Ye!\u0016\u0002\u0002\u000e]RBAB'\u0015\u0011\u0019ye!\u0015\u0002\u000f5,H/\u00192mK*\u001911K4\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00036\u000e5\u0013\u0001H5oSRL\u0017\r\\5{K\u0006sGMV3sS\u001aL\bk\\:ji&|gn\u001d\u000b\u000b\u0005\u001b\u001bYfa\u0018\u0004f\r=\u0004bBB/)\u0002\u0007\u00111I\u0001\u000fKb\u0004Xm\u0019;fI>3gm]3u\u0011\u001d\u0019\t\u0007\u0016a\u0001\u0007G\n1cY8n[&$H/\u001a3QCJ$\u0018\u000e^5p]N\u0004bAa+\u0003R\u0006\u0005\u0005bBB4)\u0002\u00071\u0011N\u0001\u0011O\u0016$hI]8n\u001f\u001a47/\u001a;NCB\u0004rAZB6\u0003\u0003\u001b9$C\u0002\u0004n\u001d\u0014\u0011BR;oGRLwN\\\u0019\t\u0013\rED\u000b%AA\u0002\tM\u0013\u0001H:lSB\u001cu.\\7jiR,G\rU1si&$\u0018n\u001c8t\u0007\",7m[\u0001'S:LG/[1mSj,\u0017I\u001c3WKJLg-\u001f)pg&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\"TCAB<U\u0011\u0011\u0019f!\u001f,\u0005\rm\u0004\u0003BB?\u0007\u000fk!aa \u000b\t\r\u000551Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\"h\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0013\u001byHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\u0003^3tiN#\u0018\r^3Ue\u0006t7/\u001b;j_:\u001c\bf\u0001,\u0003>\u0006\tB/Z:u%\u0016<\u0018N\u001c3GC&dWO]3)\u0007]\u0013i,\u0001\nuKN$(+Z<j]\u0012$vn\u00144gg\u0016$\bf\u0001-\u0003>\u00069B/Z:u%\u0016<\u0018N\u001c3U_N#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0015\u00043\nu\u0016!\n:fo&tGmV5uQN[\u0017\u000e]'jgNLgn\u001a)beRLG/[8ogB{G.[2zQ\rQ&QX\u0001\tO\u0016$8\u000b^1uKRq11UBU\u0007[\u001byk!/\u0004L\u000e5\u0007\u0003BB\u001d\u0007KKAaa*\u0004<\t1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0004,n\u0003\r!!?\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBAu7\u0002\u0007\u0011Q\u001e\u0005\b\u0007c[\u0006\u0019ABZ\u0003%\u0019G\u000f_*uCR,8\u000f\u0005\u0003\u0004:\rU\u0016\u0002BB\\\u0007w\u00111\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1ukNDqaa/\\\u0001\u0004\u0019i,A\u0005tG\",G-\u001e7feB!1qXBd\u001b\t\u0019\tM\u0003\u0003\u00028\r\r'\u0002BBc\u0003\u0013\u000baa]3sm\u0016\u0014\u0018\u0002BBe\u0007\u0003\u0014\u0011bU2iK\u0012,H.\u001a:\t\u000f\tm8\f1\u0001\u0003T!91qZ.A\u0002\rE\u0017\u0001\u0002;j[\u0016\u0004Baa5\u0004Z6\u00111Q\u001b\u0006\u0005\u0007/\f))A\u0003vi&d7/\u0003\u0003\u0004\\\u000eU'\u0001\u0002+j[\u0016\u0004")
public class TierTopicConsumerTest {
    private final String clusterId;
    private final File tempDir = TestUtils.tempDirectory(null, null);
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final long pollDurationMs;
    private final long mockEndOffset;
    private final short tierTopicNumPartitions = (short)10;
    private final TierTopicPartitioner tierTopicPartitioner = new TierTopicPartitioner((int)this.tierTopicNumPartitions());
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(this.pollDurationMs()), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(this.materializationTimeRangeMs()), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(this.tierTopicMaterializeFromSnapshotEnabled()));
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final InitializedTierTopic tierTopic = (InitializedTierTopic)Mockito.mock(InitializedTierTopic.class);
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("discover", this.tierTopicPartitions(), this.producerSupplier().producer(), this.mockEndOffset());
    private final TierTopicManagerCommitter tierTopicManagerCommitter = (TierTopicManagerCommitter)Mockito.mock(TierTopicManagerCommitter.class);
    private final Metrics metrics = new Metrics();
    private final TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.of(this.metrics()), (Time)new org.apache.kafka.common.utils.MockTime());
    private final TopicIdPartition tp_online = new TopicIdPartition("tp_online", UUID.fromString("16081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_online = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
    private final TopicIdPartition tp_discover = new TopicIdPartition("tp_discover", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_discover = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
    private final TopicIdPartition tp_init = new TopicIdPartition("tp_init", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_init = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
    private final TopicIdPartition tp_catchup = new TopicIdPartition("tp_catchup", UUID.fromString("46081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_catchup = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
    private final TopicIdPartition tp_error = new TopicIdPartition("tp_error", UUID.fromString("56081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_error = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
    private final TopicIdPartition tp_frozen = new TopicIdPartition("tp_frozen", UUID.fromString("66081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
    private final TierTopicConsumer.ClientCtx ctx_frozen = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);

    public String clusterId() {
        return this.clusterId;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public String logDir() {
        return this.logDir;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public long pollDurationMs() {
        return this.pollDurationMs;
    }

    public long mockEndOffset() {
        return this.mockEndOffset;
    }

    public short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public TierTopicPartitioner tierTopicPartitioner() {
        return this.tierTopicPartitioner;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public String tierTopicName() {
        return this.tierTopicName;
    }

    public java.util.Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    public InitializedTierTopic tierTopic() {
        return this.tierTopic;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    public MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    public MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    public MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier() {
        return this.discoverConsumerSupplier;
    }

    public TierTopicManagerCommitter tierTopicManagerCommitter() {
        return this.tierTopicManagerCommitter;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public TopicIdPartition tp_online() {
        return this.tp_online;
    }

    public TierTopicConsumer.ClientCtx ctx_online() {
        return this.ctx_online;
    }

    public TopicIdPartition tp_discover() {
        return this.tp_discover;
    }

    public TierTopicConsumer.ClientCtx ctx_discover() {
        return this.ctx_discover;
    }

    public TopicIdPartition tp_init() {
        return this.tp_init;
    }

    public TierTopicConsumer.ClientCtx ctx_init() {
        return this.ctx_init;
    }

    public TopicIdPartition tp_catchup() {
        return this.tp_catchup;
    }

    public TierTopicConsumer.ClientCtx ctx_catchup() {
        return this.ctx_catchup;
    }

    public TopicIdPartition tp_error() {
        return this.tp_error;
    }

    public TierTopicConsumer.ClientCtx ctx_error() {
        return this.ctx_error;
    }

    public TopicIdPartition tp_frozen() {
        return this.tp_frozen;
    }

    public TierTopicConsumer.ClientCtx ctx_frozen() {
        return this.ctx_frozen;
    }

    public boolean tierTopicMaterializeFromSnapshotEnabled() {
        return false;
    }

    public long materializationTimeRangeMs() {
        return -1L;
    }

    @BeforeEach
    public void setup() {
        this.tierTopicConsumer().setupMetrics();
        Mockito.when((Object)this.tierTopic().numPartitions()).thenReturn((Object)OptionalInt.of(this.tierTopicNumPartitions()));
        Mockito.when((Object)this.tierTopic().topicName()).thenReturn((Object)this.tierTopicName());
        Mockito.when((Object)this.tierTopic().toTierTopicPartition((TopicIdPartition)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TopicPartition>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public TopicPartition answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartition((TopicIdPartition)((TopicIdPartition)invocation.getArgument(0)), (String)this.$outer.tierTopicName(), (TierTopicPartitioner)this.$outer.tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopic().toTierTopicPartitions((Collection)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<java.util.Set<TopicPartition>>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public java.util.Set<TopicPartition> answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartitions((Collection)((Collection)invocation.getArgument(0)), (String)this.$outer.tierTopicName(), (TierTopicPartitioner)this.$outer.tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn(null);
        Mockito.when((Object)this.ctx_online().status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)this.ctx_discover().status()).thenReturn((Object)TierPartitionStatus.DISCOVER);
        Mockito.when((Object)this.ctx_init().status()).thenReturn((Object)TierPartitionStatus.INIT);
        Mockito.when((Object)this.ctx_catchup().status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Mockito.when((Object)this.ctx_error().status()).thenReturn((Object)TierPartitionStatus.ERROR);
        Mockito.when((Object)this.ctx_frozen().status()).thenReturn((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET);
    }

    @AfterEach
    public void cleanupMockito() {
        Mockito.framework().clearInlineMocks();
    }

    public TierTopicConsumer createTierTopicConsumerAndRegisterPartitions(Consumer<byte[], byte[]> primaryConsumer, Consumer<byte[], byte[]> catchupConsumer, Consumer<byte[], byte[]> discoverConsumer, scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx> partitions) {
        java.util.Set tierPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
        java.util.Map beginningOffsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(tierPartitions).asScala().map((Function1 & Serializable)tp -> new Tuple2(tp, (Object)0L))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        Mockito.when((Object)primaryConsumer.beginningOffsets((Collection)tierPartitions)).thenReturn((Object)beginningOffsets);
        java.util.Map offsetsAndTimestamp = CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(beginningOffsets).asScala().map((Function1 & Serializable)entry -> new Tuple2(entry._1(), (Object)new OffsetAndTimestamp(Predef$.MODULE$.Long2long((Long)entry._2()), 0L))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        Mockito.when((Object)primaryConsumer.offsetsForTimes((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)offsetsAndTimestamp);
        TierTopicConsumer tierTopicConsumerWithMock = new TierTopicConsumer(this.tierTopicManagerConfig(), (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, primaryConsumer){
            private final Consumer primaryConsumer$1;

            public Consumer<byte[], byte[]> get() {
                return this.primaryConsumer$1;
            }
            {
                this.primaryConsumer$1 = primaryConsumer$1;
            }
        }, (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, catchupConsumer){
            private final Consumer catchupConsumer$1;

            public Consumer<byte[], byte[]> get() {
                return this.catchupConsumer$1;
            }
            {
                this.catchupConsumer$1 = catchupConsumer$1;
            }
        }, (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, discoverConsumer){
            private final Consumer discoverConsumer$1;

            public Consumer<byte[], byte[]> get() {
                return this.discoverConsumer$1;
            }
            {
                this.discoverConsumer$1 = discoverConsumer$1;
            }
        }, this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.empty(), Time.SYSTEM);
        tierTopicConsumerWithMock.register(CollectionConverters$.MODULE$.MapHasAsJava(partitions).asJava());
        Assertions.assertEquals((Object)partitions.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.immigratingPartitions().keySet()).asScala());
        return tierTopicConsumerWithMock;
    }

    @Test
    public void testPollDurations() {
        Consumer primary = (Consumer)Mockito.mock(Consumer.class);
        Consumer catchup = (Consumer)Mockito.mock(Consumer.class);
        Consumer discover = (Consumer)Mockito.mock(Consumer.class);
        TierTopicInitLeader testEvent = new TierTopicInitLeader(this.tp_init(), 0, UUID.randomUUID(), 0);
        ConsumerRecord testRecord = new ConsumerRecord(this.tp_init().topic(), 0, 0L, (Object)testEvent.serializeKey(), (Object)testEvent.serializeValue());
        ConsumerRecords testRecords = new ConsumerRecords(Collections.singletonMap(this.tp_init().topicPartition(), Collections.singletonList(testRecord)));
        TierTopicConsumer tierTopicConsumerWithMock = this.createTierTopicConsumerAndRegisterPartitions((Consumer<byte[], byte[]>)primary, (Consumer<byte[], byte[]>)catchup, (Consumer<byte[], byte[]>)discover, (scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_online()), (Object)this.ctx_online()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_init()), (Object)this.ctx_init())}))));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)primary.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)catchup.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)catchup.assignment()).thenReturn((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.tierTopicName(), 0)}))).asJava());
        tierTopicConsumerWithMock.initialize(this.tierTopic());
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)catchup)).poll(Duration.ZERO);
        Mockito.when((Object)primary.poll((Duration)ArgumentMatchers.any())).thenReturn((Object)testRecords);
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ofMillis(this.pollDurationMs()));
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)2))).poll(Duration.ZERO);
        Mockito.when((Object)primary.poll((Duration)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)catchup.poll((Duration)ArgumentMatchers.any())).thenReturn((Object)testRecords);
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)3))).poll(Duration.ZERO);
        Mockito.when((Object)primary.poll((Duration)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)catchup.poll((Duration)ArgumentMatchers.any())).thenReturn(null);
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)3))).poll(Duration.ZERO);
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)4))).poll(Duration.ZERO);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)catchup.position((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online(), this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ofMillis(this.pollDurationMs()));
        ((Consumer)Mockito.verify((Object)catchup, (VerificationMode)Mockito.times((int)4))).poll(Duration.ZERO);
    }

    public void registerPartitionsAndVerify(scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx> topicPartitions, scala.collection.immutable.Set<TopicIdPartition> expectedErrorPartitions, Function0<Object> primaryConsumerPartitionsVerifier, Function0<Object> nonPrimaryConsumerPartitionsVerifier) {
        topicPartitions.foreach((Function1 & Serializable)entry -> {
            TierTopicConsumerTest.$anonfun$registerPartitionsAndVerify$1(this, entry);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)topicPartitions.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals(expectedErrorPartitions, (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertTrue((boolean)primaryConsumerPartitionsVerifier.apply$mcZ$sp());
        Assertions.assertTrue((boolean)nonPrimaryConsumerPartitionsVerifier.apply$mcZ$sp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals(expectedErrorPartitions, (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)this.primaryConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testRegisterPartitions() {
        scala.collection.immutable.Map topicPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_online()), (Object)this.ctx_online()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_init()), (Object)this.ctx_init()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_discover()), (Object)this.ctx_discover()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_catchup()), (Object)this.ctx_catchup()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_error()), (Object)this.ctx_error()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_frozen()), (Object)this.ctx_frozen())}));
        this.registerPartitionsAndVerify((scala.collection.immutable.Map<TopicIdPartition, TierTopicConsumer.ClientCtx>)topicPartitions, (scala.collection.immutable.Set<TopicIdPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_error(), this.tp_frozen()}))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()}));
            scala.collection.mutable.Set set = CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala();
            return !(object != null ? !object.equals(set) : set != null);
        }, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup(), this.tp_error(), this.tp_frozen()}));
            scala.collection.mutable.Set set = CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala();
            return !(object != null ? !object.equals(set) : set != null);
        });
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_online(), (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_error(), (VerificationMode)Mockito.times((int)5))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_frozen(), (VerificationMode)Mockito.times((int)5))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_discover(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_error(), (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_frozen(), (VerificationMode)Mockito.times((int)0))).beginCatchup();
        topicPartitions.values().foreach((Function1 & Serializable)ctx -> {
            TierTopicConsumerTest.$anonfun$testRegisterPartitions$3(ctx);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_discover(), this.tp_catchup(), this.tp_error(), this.tp_frozen()}))).asJava()), (Object)this.catchupConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testDuplicateRegisterPartitions() {
        Mockito.when((Object)this.ctx_online().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-online");
        Mockito.when((Object)this.ctx_catchup().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-catchup");
        Mockito.when((Object)this.ctx_discover().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-discover");
        Mockito.when((Object)this.ctx_init().id()).thenReturn((Object)"TierTopicConsumerTest.ctx-init");
        TierTopicConsumer.ClientCtx ctx_new = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_new.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-new");
        Mockito.when((Object)ctx_new.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        this.tierTopicConsumer().register(this.tp_online(), this.ctx_online());
        this.tierTopicConsumer().register(this.tp_catchup(), this.ctx_catchup());
        this.tierTopicConsumer().register(this.tp_discover(), this.ctx_discover());
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(this.tp_online()));
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(this.tp_catchup()));
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(this.tp_discover()));
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(this.tp_init(), this.ctx_init());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        if (this.tierTopicMaterializeFromSnapshotEnabled()) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_catchup(), this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        } else {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_catchup(), this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        }
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        this.tierTopicConsumer().register(this.tp_online(), this.ctx_online());
        this.tierTopicConsumer().register(this.tp_catchup(), this.ctx_catchup());
        this.tierTopicConsumer().register(this.tp_discover(), this.ctx_discover());
        this.tierTopicConsumer().register(this.tp_init(), this.ctx_init());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_online()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        if (this.tierTopicMaterializeFromSnapshotEnabled()) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_catchup(), this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().discoverConsumerPartitions().keySet()).asScala());
        } else {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_catchup(), this.tp_discover()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        }
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(this.tp_online(), ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(this.tp_catchup(), ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(this.tp_discover(), ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(this.tp_init(), ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
    }

    @Test
    public void testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup() {
        scala.collection.mutable.Set committedOffsetMap = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch((long)tierTopicPartition.partition() + 100L, Optional.of(Predef$.MODULE$.int2Integer(3)))));
        committedOffsetMap.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assertions.assertNotNull((Object)this.tierTopicConsumer().tierTopic());
        Consumer<byte[], byte[]> primaryConsumer = this.primaryConsumerSupplier().consumers().get(0);
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)primaryConsumer.assignment());
        committedOffsetMap.foreach((Function1 & Serializable)x0$2 -> {
            TierTopicConsumerTest.$anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(primaryConsumer, x0$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().requireRediscoverTTPs.size());
        Assertions.assertTrue((boolean)this.tierTopicConsumer().status().isInitialized());
        this.tierTopicConsumer().shutdown();
    }

    @Test
    public void testMaterializationLag() {
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_init().materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)30L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.ctx_catchup().materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(this.tp_init(), this.ctx_init());
        this.tierTopicConsumer().register(this.tp_catchup(), this.ctx_catchup());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.metrics().metric(this.tierTopicConsumer().maxTierLagMetricName).metricValue());
    }

    @Test
    public void testCatchupComplete() {
        ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(this.tp_init(), this.ctx_init());
        this.tierTopicConsumer().register(this.tp_catchup(), this.ctx_catchup());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Consumer<byte[], byte[]> catchupConsumer = this.catchupConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment = CollectionConverters$.MODULE$.SetHasAsScala(catchupConsumer.assignment()).asScala();
        Assertions.assertEquals((int)2, (int)assignment.size());
        assignment.foreach((Function1 & Serializable)assignedPartition -> {
            catchupConsumer.seek(assignedPartition, 50L);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)0))).completeCatchup();
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        catchupConsumer.seek((TopicPartition)assignment.last(), 150L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp_init(), this.tp_catchup()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_init(), (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)this.ctx_catchup(), (VerificationMode)Mockito.times((int)1))).completeCatchup();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMaxMaterializeLag(boolean checksumEnabled) {
        MockTime time = new MockTime();
        TopicIdPartition tp_1 = new TopicIdPartition("lag_test", UUID.randomUUID(), 0);
        FileTierPartitionState state_1 = this.getState(tp_1, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, (Scheduler)time.scheduler, checksumEnabled, (Time)time);
        TopicIdPartition tp_2 = new TopicIdPartition("lag_test2", UUID.randomUUID(), 0);
        FileTierPartitionState state_2 = this.getState(tp_2, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, (Scheduler)time.scheduler, checksumEnabled, (Time)time);
        TopicIdPartition tp_3 = new TopicIdPartition("lag_test3", UUID.randomUUID(), 0);
        FileTierPartitionState state_3 = this.getState(tp_3, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, (Scheduler)time.scheduler, checksumEnabled, (Time)time);
        TopicIdPartition tp_4 = new TopicIdPartition("lag_test4", UUID.randomUUID(), 0);
        FileTierPartitionState state_4 = this.getState(tp_4, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, (Scheduler)time.scheduler, checksumEnabled, (Time)time);
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((long)0L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.materializeUptoOffset(100L);
        state_2.materializeUptoOffset(101L);
        state_3.materializeUptoOffset(102L);
        state_4.materializeUptoOffset(103L);
        Assertions.assertEquals((long)103L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.close();
        state_2.close();
        state_3.close();
        state_4.close();
    }

    @Test
    public void testGarbageHandling() {
        ConsumerRecord garbageRecord = new ConsumerRecord("foo-1", 0, 1L, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> AbstractTierMetadata.deserialize((byte[])((byte[])garbageRecord.key()), (byte[])((byte[])garbageRecord.value()), (long)garbageRecord.timestamp()), ClassTag$.MODULE$.apply(TierMetadataDeserializationException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
    }

    @Test
    public void testReconfigureMaterializationTimeRange() {
        Long oldMaterializationTimeMs = this.tierTopicConsumer().config.materializationTimeRangeMs;
        Integer oldRequestTimeOutMs = this.tierTopicConsumer().config.requestTimeoutMs;
        int snapshotRetentionDays = 365;
        Properties oldProps = new Properties();
        Properties newProps = new Properties();
        oldProps.put(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsRetentionDaysProp(), "7");
        oldProps.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        newProps.put(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsRetentionDaysProp(), Integer.toString(snapshotRetentionDays));
        newProps.put(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), Integer.toString(Predef$.MODULE$.Integer2int(oldRequestTimeOutMs) + 1000));
        newProps.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        boolean apply_doLog = true;
        boolean apply_doLog2 = true;
        this.tierTopicConsumer().reconfigure(new KafkaConfig((java.util.Map)oldProps, apply_doLog), new KafkaConfig((java.util.Map)newProps, apply_doLog2));
        Long l = this.tierTopicConsumer().config.materializationTimeRangeMs;
        Assertions.assertTrue(((l == null ? oldMaterializationTimeMs != null : !((Object)l).equals(oldMaterializationTimeMs)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equalsNumObject((Number)this.tierTopicConsumer().config.materializationTimeRangeMs, (Object)BoxesRunTime.boxToLong((long)(TimeUnit.DAYS.toMillis(snapshotRetentionDays) - 86400000L))) ? 1 : 0) != 0);
        Integer n = this.tierTopicConsumer().config.requestTimeoutMs;
        Assertions.assertTrue((!(n != null ? !((Object)n).equals(oldRequestTimeOutMs) : oldRequestTimeOutMs != null) ? 1 : 0) != 0);
    }

    private void setupRewindMocks(Function2<TopicPartition, OffsetAndEpoch, BoxedUnit> putInOffsetMap, Function0<scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch>> getOffsetMap) {
        Mockito.when((Object)this.tierTopicManagerCommitter().readOffsetsForLogDirs()).thenAnswer((Answer)new Answer<java.util.Map<String, java.util.Map<Integer, OffsetAndEpoch>>>(this, getOffsetMap){
            private final /* synthetic */ TierTopicConsumerTest $outer;
            private final Function0 getOffsetMap$1;

            public java.util.Map<String, java.util.Map<Integer, OffsetAndEpoch>> answer(InvocationOnMock invocation) {
                HashMap<String, java.util.Map<Integer, OffsetAndEpoch>> logDirMap = new HashMap<String, java.util.Map<Integer, OffsetAndEpoch>>();
                logDirMap.put(this.$outer.logDir(), CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)((MapOps)this.getOffsetMap$1.apply()).map((Function1 & Serializable)entry -> new Tuple2((Object)((TopicPartition)entry._1()).partition(), entry._2()))).asJava());
                return logDirMap;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.getOffsetMap$1 = getOffsetMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1(scala.Tuple2 )}, serializedLambda);
            }
        });
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(ArgumentMatchers.anyInt())).thenAnswer((Answer)new Answer<OffsetAndEpoch>(this, getOffsetMap){
            private final /* synthetic */ TierTopicConsumerTest $outer;
            private final Function0 getOffsetMap$1;

            public OffsetAndEpoch answer(InvocationOnMock invocation) {
                return (OffsetAndEpoch)((MapOps)this.getOffsetMap$1.apply()).getOrElse((Object)new TopicPartition(this.$outer.tierTopicName(), BoxesRunTime.unboxToInt((Object)invocation.getArgument(0))), (Function0 & Serializable)() -> OffsetAndEpoch.EMPTY);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.getOffsetMap$1 = getOffsetMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$2()}, serializedLambda);
            }
        });
        this.tierTopicManagerCommitter().replacePositions((java.util.Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this, putInOffsetMap){
            private final /* synthetic */ TierTopicConsumerTest $outer;
            private final Function2 putInOffsetMap$1;

            public void answer(InvocationOnMock invocation) {
                java.util.Map replacePartitionToPosition = (java.util.Map)((java.util.Map)invocation.getArgument(0)).get(this.$outer.logDir());
                CollectionConverters$.MODULE$.MapHasAsScala(replacePartitionToPosition).asScala().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$8.$anonfun$answer$3(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$answer$3($anon$8 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    Integer partition = (Integer)x0$1._1();
                    OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)x0$1._2();
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.putInOffsetMap$1.apply((Object)new TopicPartition($this.$outer.tierTopicName(), Predef$.MODULE$.Integer2int(partition)), (Object)offsetAndEpoch);
                    return;
                }
                throw new MatchError(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.putInOffsetMap$1 = putInOffsetMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$3$adapted(kafka.tier.topic.TierTopicConsumerTest$$anon$8 scala.Tuple2 )}, serializedLambda);
            }
        });
    }

    private Consumer<byte[], byte[]> initializeAndVerifyPositions(long expectedOffset, scala.collection.immutable.Set<TopicPartition> committedPartitions, Function1<TopicPartition, OffsetAndEpoch> getFromOffsetMap, boolean skipCommittedPartitionsCheck) {
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().start();
        Assertions.assertNotNull((Object)this.tierTopicConsumer().tierTopic());
        Consumer<byte[], byte[]> primaryConsumer = this.primaryConsumerSupplier().consumers().get(0);
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)primaryConsumer.assignment());
        if (!skipCommittedPartitionsCheck) {
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().toSet(), committedPartitions);
        }
        committedPartitions.foreach((Function1 & Serializable)x0$1 -> {
            TierTopicConsumerTest.$anonfun$initializeAndVerifyPositions$1(getFromOffsetMap, expectedOffset, primaryConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
        return primaryConsumer;
    }

    private boolean initializeAndVerifyPositions$default$4() {
        return false;
    }

    @Test
    public void testStateTransitions() {
        Assertions.assertEquals((Object)TierTopicConsumerStatus.NOT_INITIALIZED, (Object)this.tierTopicConsumer().status());
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assertions.assertEquals((Object)TierTopicConsumerStatus.INITIALIZED, (Object)this.tierTopicConsumer().status());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().stop(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        this.tierTopicConsumer().start();
        Assertions.assertEquals((Object)TierTopicConsumerStatus.RUNNING, (Object)this.tierTopicConsumer().status());
        this.tierTopicConsumer().stop();
        Assertions.assertEquals((Object)TierTopicConsumerStatus.STOPPED, (Object)this.tierTopicConsumer().status());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().start(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assertions.assertEquals((Object)TierTopicConsumerStatus.INITIALIZED, (Object)this.tierTopicConsumer().status());
        this.tierTopicConsumer().start();
        Assertions.assertEquals((Object)TierTopicConsumerStatus.RUNNING, (Object)this.tierTopicConsumer().status());
        this.tierTopicConsumer().shutdown();
        Assertions.assertEquals((Object)TierTopicConsumerStatus.CLOSED, (Object)this.tierTopicConsumer().status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRewindFailure() {
        void setupRewindMocks_getOffsetMap;
        scala.collection.mutable.Map committedOffsetMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tierTopicPartitions().forEach(tierTopicPartition -> committedOffsetMap.update((Object)new TopicPartition(this.tierTopicName(), tierTopicPartition.partition()), (Object)new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(0)))));
        Function0 & Serializable intersect = (Function0 & Serializable)() -> committedOffsetMap;
        Function2 & Serializable setupRewindMocks_putInOffsetMap = (Function2 & Serializable)(key, value) -> {
            committedOffsetMap.put((Object)key, (Object)value);
            return BoxedUnit.UNIT;
        };
        Mockito.when((Object)this.tierTopicManagerCommitter().readOffsetsForLogDirs()).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(ArgumentMatchers.anyInt())).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        this.tierTopicManagerCommitter().replacePositions((java.util.Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Object var5_3 = null;
        intersect = null;
        this.initializeAndVerifyPositions(50L, (scala.collection.immutable.Set<TopicPartition>)committedOffsetMap.keySet().toSet(), (Function1<TopicPartition, OffsetAndEpoch>)(Function1 & Serializable)x$1 -> (OffsetAndEpoch)committedOffsetMap.getOrElse(x$1, (Function0 & Serializable)() -> OffsetAndEpoch.EMPTY), false);
        scala.collection.mutable.Set affectedPartitions = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().take(5);
        HashMap affectedPartitionPositionMap = new HashMap();
        affectedPartitions.foreach((Function1 & Serializable)tierTopicPartition -> affectedPartitionPositionMap.put(Predef$.MODULE$.int2Integer(tierTopicPartition.partition()), new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0)))));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.tierTopicConsumer().rewind((java.util.Map)affectedPartitionPositionMap, false, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        HashMap<Integer, OffsetAndEpoch> invalidPartitionPositionMap = new HashMap<Integer, OffsetAndEpoch>();
        invalidPartitionPositionMap.put(Predef$.MODULE$.int2Integer(this.tierTopicPartitions().size() * 2), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.tierTopicConsumer().rewind((java.util.Map)invalidPartitionPositionMap, false, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
        this.tierTopicConsumer().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRewindToOffset() {
        void setupRewindMocks_getOffsetMap;
        scala.collection.mutable.Map committedOffsetMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tierTopicPartitions().forEach(tierTopicPartition -> committedOffsetMap.update((Object)new TopicPartition(this.tierTopicName(), tierTopicPartition.partition()), (Object)new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(0)))));
        Function0 & Serializable intersect = (Function0 & Serializable)() -> committedOffsetMap;
        Function2 & Serializable setupRewindMocks_putInOffsetMap = (Function2 & Serializable)(key, value) -> {
            committedOffsetMap.put((Object)key, (Object)value);
            return BoxedUnit.UNIT;
        };
        Mockito.when((Object)this.tierTopicManagerCommitter().readOffsetsForLogDirs()).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(ArgumentMatchers.anyInt())).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        this.tierTopicManagerCommitter().replacePositions((java.util.Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Object var9_3 = null;
        intersect = null;
        this.initializeAndVerifyPositions(50L, (scala.collection.immutable.Set<TopicPartition>)committedOffsetMap.keySet().toSet(), (Function1<TopicPartition, OffsetAndEpoch>)(Function1 & Serializable)x$2 -> (OffsetAndEpoch)committedOffsetMap.getOrElse(x$2, (Function0 & Serializable)() -> OffsetAndEpoch.EMPTY), false);
        scala.collection.mutable.Set affectedPartitions = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().take(5);
        HashMap affectedPartitionPositionMap = new HashMap();
        affectedPartitions.foreach((Function1 & Serializable)tierTopicPartition -> affectedPartitionPositionMap.put(Predef$.MODULE$.int2Integer(tierTopicPartition.partition()), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0)))));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.tierTopicConsumer().rewind((java.util.Map)affectedPartitionPositionMap, false, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
        TierTopicConsumerStatus tierTopicConsumerStatus = this.tierTopicConsumer().status();
        TierTopicConsumerStatus tierTopicConsumerStatus2 = TierTopicConsumerStatus.RUNNING;
        Assertions.assertTrue((!(tierTopicConsumerStatus != null ? !tierTopicConsumerStatus.equals(tierTopicConsumerStatus2) : tierTopicConsumerStatus2 != null) ? 1 : 0) != 0);
        Thread oldConsumerThread = this.tierTopicConsumer().getConsumerThread();
        java.util.Map rewindRes = this.tierTopicConsumer().rewind(affectedPartitionPositionMap, true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
        Assertions.assertTrue((this.tierTopicConsumer().getConsumerThread() != null ? 1 : 0) != 0);
        Thread thread = oldConsumerThread;
        Thread thread2 = this.tierTopicConsumer().getConsumerThread();
        Assertions.assertTrue(((thread == null ? thread2 != null : !thread.equals(thread2)) ? 1 : 0) != 0);
        TierTopicConsumerStatus tierTopicConsumerStatus3 = this.tierTopicConsumer().status();
        TierTopicConsumerStatus tierTopicConsumerStatus4 = TierTopicConsumerStatus.RUNNING;
        Assertions.assertTrue((!(tierTopicConsumerStatus3 != null ? !tierTopicConsumerStatus3.equals(tierTopicConsumerStatus4) : tierTopicConsumerStatus4 != null) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)rewindRes.isEmpty());
        this.tierTopicConsumer().doWork();
        this.primaryConsumerSupplier().consumers().get(1);
        committedOffsetMap.foreach((Function1 & Serializable)x0$1 -> {
            TierTopicConsumerTest.$anonfun$testRewindToOffset$8(affectedPartitions, x0$1);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRewindToStartOffset() {
        void setupRewindMocks_getOffsetMap;
        scala.collection.mutable.Map committedOffsetMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tierTopicPartitions().forEach(tierTopicPartition -> committedOffsetMap.update((Object)new TopicPartition(this.tierTopicName(), tierTopicPartition.partition()), (Object)new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(0)))));
        Function0 & Serializable intersect = (Function0 & Serializable)() -> committedOffsetMap;
        Function2 & Serializable setupRewindMocks_putInOffsetMap = (Function2 & Serializable)(key, value) -> {
            committedOffsetMap.put((Object)key, (Object)value);
            return BoxedUnit.UNIT;
        };
        Mockito.when((Object)this.tierTopicManagerCommitter().readOffsetsForLogDirs()).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(ArgumentMatchers.anyInt())).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        this.tierTopicManagerCommitter().replacePositions((java.util.Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Object var7_3 = null;
        intersect = null;
        this.initializeAndVerifyPositions(50L, (scala.collection.immutable.Set<TopicPartition>)committedOffsetMap.keySet().toSet(), (Function1<TopicPartition, OffsetAndEpoch>)(Function1 & Serializable)x$3 -> (OffsetAndEpoch)committedOffsetMap.getOrElse(x$3, (Function0 & Serializable)() -> OffsetAndEpoch.EMPTY), false);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.tierTopicConsumer().rewindToStart(false, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        TierTopicConsumerStatus tierTopicConsumerStatus = this.tierTopicConsumer().status();
        TierTopicConsumerStatus tierTopicConsumerStatus2 = TierTopicConsumerStatus.RUNNING;
        Assertions.assertTrue((!(tierTopicConsumerStatus != null ? !tierTopicConsumerStatus.equals(tierTopicConsumerStatus2) : tierTopicConsumerStatus2 != null) ? 1 : 0) != 0);
        Thread oldConsumerThread = this.tierTopicConsumer().getConsumerThread();
        java.util.Map rewindRes = this.tierTopicConsumer().rewindToStart(true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
        Assertions.assertTrue((this.tierTopicConsumer().getConsumerThread() != null ? 1 : 0) != 0);
        Thread thread = oldConsumerThread;
        Thread thread2 = this.tierTopicConsumer().getConsumerThread();
        Assertions.assertTrue(((thread == null ? thread2 != null : !thread.equals(thread2)) ? 1 : 0) != 0);
        TierTopicConsumerStatus tierTopicConsumerStatus3 = this.tierTopicConsumer().status();
        TierTopicConsumerStatus tierTopicConsumerStatus4 = TierTopicConsumerStatus.RUNNING;
        Assertions.assertTrue((!(tierTopicConsumerStatus3 != null ? !tierTopicConsumerStatus3.equals(tierTopicConsumerStatus4) : tierTopicConsumerStatus4 != null) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)rewindRes.isEmpty());
        this.tierTopicConsumer().doWork();
        this.primaryConsumerSupplier().consumers().get(1);
        committedOffsetMap.foreach((Function1 & Serializable)x0$1 -> {
            TierTopicConsumerTest.$anonfun$testRewindToStartOffset$7(x0$1);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void rewindWithSkipMissingPartitionsPolicy() {
        void setupRewindMocks_getOffsetMap;
        scala.collection.mutable.Map committedOffsetMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set changedTtps = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().take(this.tierTopicPartitions().size() / 2);
        changedTtps.foreach((Function1 & Serializable)tierTopicPartition -> {
            committedOffsetMap.update((Object)new TopicPartition(this.tierTopicName(), tierTopicPartition.partition()), (Object)new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(0))));
            return BoxedUnit.UNIT;
        });
        Function0 & Serializable intersect = (Function0 & Serializable)() -> committedOffsetMap;
        Function2 & Serializable setupRewindMocks_putInOffsetMap = (Function2 & Serializable)(key, value) -> {
            committedOffsetMap.put((Object)key, (Object)value);
            return BoxedUnit.UNIT;
        };
        Mockito.when((Object)this.tierTopicManagerCommitter().readOffsetsForLogDirs()).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(ArgumentMatchers.anyInt())).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        this.tierTopicManagerCommitter().replacePositions((java.util.Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new /* invalid duplicate definition of identical inner class */);
        Object var8_4 = null;
        intersect = null;
        this.initializeAndVerifyPositions(50L, (scala.collection.immutable.Set<TopicPartition>)committedOffsetMap.keySet().toSet(), (Function1<TopicPartition, OffsetAndEpoch>)(Function1 & Serializable)x$4 -> (OffsetAndEpoch)committedOffsetMap.getOrElse(x$4, (Function0 & Serializable)() -> OffsetAndEpoch.EMPTY), true);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.tierTopicConsumer().rewindToStart(true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
        TierTopicConsumerStatus tierTopicConsumerStatus = this.tierTopicConsumer().status();
        TierTopicConsumerStatus tierTopicConsumerStatus2 = TierTopicConsumerStatus.RUNNING;
        Assertions.assertTrue((!(tierTopicConsumerStatus != null ? !tierTopicConsumerStatus.equals(tierTopicConsumerStatus2) : tierTopicConsumerStatus2 != null) ? 1 : 0) != 0);
        Thread oldConsumerThread = this.tierTopicConsumer().getConsumerThread();
        java.util.Map rewindRes = this.tierTopicConsumer().rewindToStart(true, TierTopicConsumerRewindPolicy.SKIP_MISSING_PARTITIONS);
        Assertions.assertTrue((this.tierTopicConsumer().getConsumerThread() != null ? 1 : 0) != 0);
        Thread thread = oldConsumerThread;
        Thread thread2 = this.tierTopicConsumer().getConsumerThread();
        Assertions.assertTrue(((thread == null ? thread2 != null : !thread.equals(thread2)) ? 1 : 0) != 0);
        TierTopicConsumerStatus tierTopicConsumerStatus3 = this.tierTopicConsumer().status();
        TierTopicConsumerStatus tierTopicConsumerStatus4 = TierTopicConsumerStatus.RUNNING;
        Assertions.assertTrue((!(tierTopicConsumerStatus3 != null ? !tierTopicConsumerStatus3.equals(tierTopicConsumerStatus4) : tierTopicConsumerStatus4 != null) ? 1 : 0) != 0);
        Assertions.assertEquals((Object)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().diff((Set)changedTtps).map((Function1 & Serializable)tp -> BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)rewindRes.get(this.logDir())).asScala());
        this.tierTopicConsumer().doWork();
        this.primaryConsumerSupplier().consumers().get(1);
        committedOffsetMap.foreach((Function1 & Serializable)x0$1 -> {
            TierTopicConsumerTest.$anonfun$rewindWithSkipMissingPartitionsPolicy$8(x0$1);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().shutdown();
    }

    private FileTierPartitionState getState(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, TierPartitionStatus ctxStatus, Scheduler scheduler, boolean checksumEnabled, Time time) {
        TopicPartition logDirName_topicPartition = topicIdPartition.topicPartition();
        Object var10_7 = null;
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, scheduler, checksumEnabled, false, time, TierPartitionStateCleanupConfig.EMPTY, false, -1);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        TierTopicConsumer.ClientCtx clientCtx = new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState, ctxStatus){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;
            private final TierPartitionStatus ctxStatus$1;

            public String id() {
                return new StringBuilder(22).append("TierTopicConsumerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.ctxStatus$1;
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer snapshotBuffer, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.processSnapshotMaterializationEvent(metadata, snapshotBuffer, offsetAndEpoch);
            }

            public long localMaterializedOffset() {
                return this.tierPartitionState$1.lastLocalMaterializedSrcOffsetAndEpoch().offset();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }

            public void beginDiscover() {
                this.tierPartitionState$1.beginDiscover();
            }

            public void completeDiscover() {
                this.tierPartitionState$1.onDiscoverComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
                this.ctxStatus$1 = ctxStatus$1;
            }
        };
        tierTopicConsumer.register(topicIdPartition, clientCtx);
        return tierPartitionState;
    }

    public static final /* synthetic */ void $anonfun$registerPartitionsAndVerify$1(TierTopicConsumerTest $this, Tuple2 entry) {
        $this.tierTopicConsumer().register((TopicIdPartition)entry._1(), (TierTopicConsumer.ClientCtx)entry._2());
    }

    public static final /* synthetic */ void $anonfun$testRegisterPartitions$3(TierTopicConsumer.ClientCtx ctx) {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx});
    }

    public static final /* synthetic */ void $anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(Consumer primaryConsumer$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tierTopicPartition = (TopicPartition)x0$2._1();
            Assertions.assertEquals((long)((OffsetAndEpoch)x0$2._2()).offset(), (long)primaryConsumer$2.position(tierTopicPartition));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$initializeAndVerifyPositions$1(Function1 getFromOffsetMap$1, long expectedOffset$1, Consumer primaryConsumer$3, TopicPartition x0$1) {
        OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)getFromOffsetMap$1.apply((Object)x0$1);
        Assertions.assertEquals((long)expectedOffset$1, (long)offsetAndEpoch.offset());
        Assertions.assertEquals((long)offsetAndEpoch.offset(), (long)primaryConsumer$3.position(x0$1));
    }

    public static final /* synthetic */ void $anonfun$testRewindToOffset$8(scala.collection.mutable.Set affectedPartitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)x0$1._2();
            if (affectedPartitions$1.contains((Object)topicPartition)) {
                Assertions.assertEquals((long)10L, (long)offsetAndEpoch.offset());
                return;
            }
            Assertions.assertEquals((long)50L, (long)offsetAndEpoch.offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testRewindToStartOffset$7(Tuple2 x0$1) {
        if (x0$1 != null) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)x0$1._2();
            Assertions.assertEquals((long)0L, (long)offsetAndEpoch.offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$rewindWithSkipMissingPartitionsPolicy$8(Tuple2 x0$1) {
        if (x0$1 != null) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)x0$1._2();
            Assertions.assertEquals((long)0L, (long)offsetAndEpoch.offset());
            return;
        }
        throw new MatchError(null);
    }

    public TierTopicConsumerTest() {
        this.clusterId = "mycluster";
        this.pollDurationMs = 5L;
        this.mockEndOffset = 100L;
    }
}

