/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.HashMap;
import java.util.Map;
import kafka.tier.TierTestUtils;
import kafka.tier.topic.TierTopicDataLossValidatorMetrics;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TierTopicDataLossValidatorMetricsTest {
    private Metrics metrics;
    private TierTopicDataLossValidatorMetrics dataLossValidatorMetrics;
    private static final Map<ValidationSource, ValidationSource> OTHER_VALIDATION_SOURCE_MAP = new HashMap<ValidationSource, ValidationSource>(){
        {
            this.put(ValidationSource.ON_DEMAND_VALIDATION, ValidationSource.UNCLEAN_RESTART_VALIDATION);
            this.put(ValidationSource.UNCLEAN_RESTART_VALIDATION, ValidationSource.ON_DEMAND_VALIDATION);
        }
    };

    @BeforeEach
    void setup() {
        this.metrics = new Metrics();
        this.dataLossValidatorMetrics = new TierTopicDataLossValidatorMetrics(this.metrics);
    }

    private ValidationSource getOtherSource(ValidationSource source) {
        return OTHER_VALIDATION_SOURCE_MAP.get(source);
    }

    private Object getMetricValue(ValidationSource source, String name) {
        return TierTestUtils.getMetricValue(this.metrics, "TierTopicDataLossValidator", TierTopicDataLossValidatorMetrics.DataLossDetectionMetricGroup.metricName((ValidationSource)source, (String)name)).metricValue();
    }

    @ParameterizedTest
    @EnumSource(value=ValidationSource.class)
    void testRecordDataLossReport(ValidationSource source) {
        this.recordDataLossReportMetricsAndCheck(source, true, true, 8, 1, 0, 0, 2);
        this.checkZeroDataLossReportMetrics(this.getOtherSource(source));
    }

    @ParameterizedTest
    @EnumSource(value=ValidationSource.class)
    void testRecordDataLossReportUploadStatus(ValidationSource source) {
        this.dataLossValidatorMetrics.recordDataLossReportUploadStatus(source, false);
        Assertions.assertEquals((Object)1, (Object)this.getMetricValue(source, "DataLossReportUploadFailure"));
        Assertions.assertEquals((Object)0, (Object)this.getMetricValue(this.getOtherSource(source), "DataLossReportUploadFailure"));
    }

    @ParameterizedTest
    @EnumSource(value=ValidationSource.class)
    void testRecordDataLossDetectionStatus(ValidationSource source) {
        this.dataLossValidatorMetrics.recordDataLossDetectionFailure(source, true);
        Assertions.assertEquals((Object)1, (Object)this.getMetricValue(source, "DataLossDetectionFailure"));
        Assertions.assertEquals((Object)0, (Object)this.getMetricValue(this.getOtherSource(source), "DataLossDetectionFailure"));
    }

    @ParameterizedTest
    @EnumSource(value=ValidationSource.class)
    void testClear(ValidationSource source) {
        this.dataLossValidatorMetrics.recordDataLossDetectionFailure(source, true);
        this.dataLossValidatorMetrics.recordDataLossReportUploadStatus(source, false);
        this.recordDataLossReportMetricsAndCheck(source, true, true, 8, 1, 0, 0, 2);
        this.dataLossValidatorMetrics.clearValidationSource(source);
        for (ValidationSource item : new ValidationSource[]{source, this.getOtherSource(source)}) {
            Assertions.assertEquals((Object)0, (Object)this.getMetricValue(this.getOtherSource(item), "DataLossDetectionFailure"));
            Assertions.assertEquals((Object)0, (Object)this.getMetricValue(this.getOtherSource(item), "DataLossReportUploadFailure"));
            this.checkZeroDataLossReportMetrics(this.getOtherSource(item));
        }
    }

    private void recordDataLossReportMetricsAndCheck(ValidationSource source, boolean dataLossDetected, boolean dataLossDetectionFailed, int affectedUserPartitionReplicaCount, int affectedUserPartitionLeaderCount, int failedFencingUserPartitionCount, int failedTierTopicPartitionCount, int affectedTierTopicPartitionCount) {
        this.dataLossValidatorMetrics.recordDataLossReport(source, dataLossDetected, dataLossDetectionFailed, affectedUserPartitionReplicaCount, affectedUserPartitionLeaderCount, failedFencingUserPartitionCount, failedTierTopicPartitionCount, affectedTierTopicPartitionCount);
        this.checkDataLossReportMetrics(source, dataLossDetected, dataLossDetectionFailed, affectedUserPartitionReplicaCount, affectedUserPartitionLeaderCount, failedFencingUserPartitionCount, failedTierTopicPartitionCount, affectedTierTopicPartitionCount);
    }

    private void checkZeroDataLossReportMetrics(ValidationSource source) {
        this.checkDataLossReportMetrics(source, false, false, 0, 0, 0, 0, 0);
    }

    private void checkDataLossReportMetrics(ValidationSource source, boolean dataLossDetected, boolean dataLossDetectionFailed, int affectedUserPartitionReplicaCount, int affectedUserPartitionLeaderCount, int failedFencingUserPartitionCount, int failedTierTopicPartitionCount, int affectedTierTopicPartitionCount) {
        Assertions.assertEquals((Object)(dataLossDetected ? 1 : 0), (Object)this.getMetricValue(source, "DataLossDetected"));
        Assertions.assertEquals((Object)(dataLossDetectionFailed ? 1 : 0), (Object)this.getMetricValue(source, "DataLossDetectionFailure"));
        Assertions.assertEquals((Object)affectedUserPartitionReplicaCount, (Object)this.getMetricValue(source, "AffectedUserPartitionReplicaCount"));
        Assertions.assertEquals((Object)affectedUserPartitionLeaderCount, (Object)this.getMetricValue(source, "AffectedUserPartitionLeaderCount"));
        Assertions.assertEquals((Object)failedFencingUserPartitionCount, (Object)this.getMetricValue(source, "FailedFencingUserPartitionCount"));
        Assertions.assertEquals((Object)failedTierTopicPartitionCount, (Object)this.getMetricValue(source, "FailedTierTopicPartitionCount"));
        Assertions.assertEquals((Object)affectedTierTopicPartitionCount, (Object)this.getMetricValue(source, "AffectedTierTopicPartitionCount"));
    }
}

