/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicHeadDataLossReportReconciler;
import kafka.tier.topic.recovery.AffectedTierTopicPartitionInfo;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.ReconciledTierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ReconciledTierTopicPartitionInfo;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicHeadDataLossReportReconcilerTest {
    private Time time = new MockTime();
    private static final String TEST_TOPIC_1 = "test_topic_1";
    private static final String TEST_TOPIC_2 = "test_topic_2";
    private static final TopicPartition TTP_0 = new TopicPartition("_confluent-tier-state", 0);
    private static final TopicPartition TTP_1 = new TopicPartition("_confluent-tier-state", 1);
    private static final TopicPartition TTP_2 = new TopicPartition("_confluent-tier-state", 2);
    private static final TopicPartition TTP_3 = new TopicPartition("_confluent-tier-state", 3);
    private static final TopicPartition TTP_4 = new TopicPartition("_confluent-tier-state", 4);
    private static final TopicPartition TTP_5 = new TopicPartition("_confluent-tier-state", 5);
    private static final int BROKER_0 = 0;
    private static final int BROKER_1 = 1;
    private static final int BROKER_2 = 2;

    private static Map<TopicIdPartition, AffectedUserTopicPartitionInfo> makeAffectedUtps(final UserTopicPartitionGroup ... utps) {
        return new HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo>(){
            {
                for (UserTopicPartitionGroup utp : utps) {
                    this.put(utp.utp, utp.affectedUserTopicPartitionInfo);
                }
            }
        };
    }

    private static Map<TopicPartition, AffectedTierTopicPartitionInfo> makeAffectedTtps(final TierTopicPartitionGroup ... ttps) {
        return new HashMap<TopicPartition, AffectedTierTopicPartitionInfo>(){
            {
                for (TierTopicPartitionGroup ttp : ttps) {
                    this.put(ttp.tierTopicPartition, ttp.affectedTierTopicPartitionInfo);
                }
            }
        };
    }

    private static ReconciledTierTopicPartitionInfo makeReconciledTtpInfo(UserTopicPartitionGroup maxLastMaterializedOffsetEpochUtp, int maxLastMaterializedOffsetEpochBroker, TierTopicPartitionGroup minTierTopicEndOffsetAndEpochTtp, UserTopicPartitionGroup minTierTopicEndOffsetAndEpochUtp, int minTierTopicEndOffsetAndEpochBroker) {
        return new ReconciledTierTopicPartitionInfo(maxLastMaterializedOffsetEpochUtp.ftpsLastMaterializedOffsetEpoch.offset(), maxLastMaterializedOffsetEpochUtp.utp, maxLastMaterializedOffsetEpochBroker, minTierTopicEndOffsetAndEpochTtp.tierTopicMinEndOffsetAndEpoch, minTierTopicEndOffsetAndEpochUtp.utp, minTierTopicEndOffsetAndEpochBroker);
    }

    private static Map<Integer, Long> makeDurationsMap(final Integer ... brokers) {
        return new HashMap<Integer, Long>(){
            {
                Integer[] integerArray2 = brokers;
                int n = integerArray2.length;
                for (int i = 0; i < n; ++i) {
                    int broker = integerArray2[i];
                    this.put(broker, 1L);
                }
            }
        };
    }

    private static void insertReconciledAffectedUtpEntry(Map<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUtps, final UserTopicPartitionGroup utp, final Set<Integer> brokers) {
        affectedUtps.put(utp.utp, (Map<Integer, AffectedUserTopicPartitionInfo>)new HashMap<Integer, AffectedUserTopicPartitionInfo>(){
            {
                Iterator iterator = brokers.iterator();
                while (iterator.hasNext()) {
                    int broker = (Integer)iterator.next();
                    this.put(broker, utp.affectedUserTopicPartitionInfo);
                }
            }
        });
    }

    @Test
    public void testReconcileReportIncrementally() throws Exception {
        ReconciledTierTopicHeadDataLossReport reconciledReport = ReconciledTierTopicHeadDataLossReport.createEmptyReport();
        UserTopicPartitionGroup utp0 = new UserTopicPartitionGroup(TEST_TOPIC_1, 0, 10, 50, TierPartitionStatus.ONLINE, TTP_0, true);
        UserTopicPartitionGroup utp1 = new UserTopicPartitionGroup(TEST_TOPIC_2, 1, 15, 70, TierPartitionStatus.ERROR, TTP_1, false);
        TierTopicPartitionGroup broker0ttp0Group = new TierTopicPartitionGroup(TTP_0, utp0, 0, new OffsetAndEpoch(40L, Optional.of(8)));
        TierTopicPartitionGroup broker0ttp1Group = new TierTopicPartitionGroup(TTP_1, utp1, 0, new OffsetAndEpoch(60L, Optional.of(13)));
        TierTopicHeadDataLossReport broker0report = TierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, (int)0, (ValidationSource)ValidationSource.UNCLEAN_RESTART_VALIDATION, (long)this.time.milliseconds(), (long)this.time.milliseconds(), TierTopicHeadDataLossReportReconcilerTest.makeAffectedUtps(utp0, utp1), TierTopicHeadDataLossReportReconcilerTest.makeAffectedTtps(broker0ttp0Group, broker0ttp1Group), new HashSet(), new HashSet(), Collections.emptyList());
        HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUtpsAfterReconcilingBroker0 = new HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>>();
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker0, utp0, new HashSet<Integer>(Collections.singletonList(0)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker0, utp1, new HashSet<Integer>(Collections.singletonList(0)));
        final ReconciledTierTopicPartitionInfo reconciledTtp0AfterReconcilingBroker0 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp0, 0, broker0ttp0Group, utp0, 0);
        final ReconciledTierTopicPartitionInfo reconciledTtp1AfterReconcilingBroker0 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp1, 0, broker0ttp1Group, utp1, 0);
        HashMap<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTtpsAfterReconcilingBroker0 = new HashMap<TopicPartition, ReconciledTierTopicPartitionInfo>(){
            {
                this.put(TTP_0, reconciledTtp0AfterReconcilingBroker0);
                this.put(TTP_1, reconciledTtp1AfterReconcilingBroker0);
            }
        };
        ReconciledTierTopicHeadDataLossReport expectedReport = ReconciledTierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, affectedUtpsAfterReconcilingBroker0, (Map)affectedTtpsAfterReconcilingBroker0, new HashMap(), new HashMap(), new HashMap(), TierTopicHeadDataLossReportReconcilerTest.makeDurationsMap(0));
        ReconciledTierTopicHeadDataLossReport receivedReport = TierTopicHeadDataLossReportReconciler.reconcileReportIncrementally((TierTopicHeadDataLossReport)broker0report, (ReconciledTierTopicHeadDataLossReport)reconciledReport);
        Assertions.assertTrue((boolean)expectedReport.checkEqualityExcludingCreationTime(receivedReport));
        UserTopicPartitionGroup utp2 = new UserTopicPartitionGroup(TEST_TOPIC_1, 2, 11, 60, TierPartitionStatus.ONLINE, TTP_0, true);
        UserTopicPartitionGroup utp3 = new UserTopicPartitionGroup(TEST_TOPIC_2, 3, 14, 80, TierPartitionStatus.ERROR, TTP_1, false);
        UserTopicPartitionGroup utp4 = new UserTopicPartitionGroup(TEST_TOPIC_1, 4, 20, 100, TierPartitionStatus.ERROR, TTP_2, true);
        TierTopicPartitionGroup broker1ttp0Group = new TierTopicPartitionGroup(TTP_0, utp2, 1, new OffsetAndEpoch(45L, Optional.of(9)));
        TierTopicPartitionGroup broker1ttp1Group = new TierTopicPartitionGroup(TTP_1, utp3, 1, new OffsetAndEpoch(65L, Optional.of(14)));
        TierTopicPartitionGroup broker1ttp2Group = new TierTopicPartitionGroup(TTP_2, utp4, 1, new OffsetAndEpoch(95L, Optional.of(19)));
        final UserTopicPartitionGroup failedUtp5 = new UserTopicPartitionGroup(TEST_TOPIC_2, 5, 30, 150, TierPartitionStatus.ONLINE, TTP_0, true);
        final List<String> broker1errors = Arrays.asList("broker1_error0", "broker1_error1");
        TierTopicHeadDataLossReport broker1report = TierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.FAILURE, (int)1, (ValidationSource)ValidationSource.ON_DEMAND_VALIDATION, (long)this.time.milliseconds(), (long)this.time.milliseconds(), TierTopicHeadDataLossReportReconcilerTest.makeAffectedUtps(utp0, utp2, utp3, utp4), TierTopicHeadDataLossReportReconcilerTest.makeAffectedTtps(broker1ttp0Group, broker1ttp1Group, broker1ttp2Group), new HashSet<TopicPartition>(Arrays.asList(TTP_3, TTP_4)), new HashSet<TopicIdPartition>(Collections.singletonList(failedUtp5.utp)), broker1errors);
        HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUtpsAfterReconcilingBroker1 = new HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>>();
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker1, utp0, new HashSet<Integer>(Arrays.asList(0, 1)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker1, utp1, new HashSet<Integer>(Arrays.asList(0)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker1, utp2, new HashSet<Integer>(Arrays.asList(1)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker1, utp3, new HashSet<Integer>(Arrays.asList(1)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker1, utp4, new HashSet<Integer>(Arrays.asList(1)));
        final ReconciledTierTopicPartitionInfo reconciledTtp0AfterReconcilingBroker1 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp2, 1, broker0ttp0Group, utp0, 0);
        final ReconciledTierTopicPartitionInfo reconciledTtp1AfterReconcilingBroker1 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp3, 1, broker0ttp1Group, utp1, 0);
        final ReconciledTierTopicPartitionInfo reconciledTtp2AfterReconcilingBroker1 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp4, 1, broker1ttp2Group, utp4, 1);
        HashMap<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTtpsAfterReconcilingBroker1 = new HashMap<TopicPartition, ReconciledTierTopicPartitionInfo>(){
            {
                this.put(TTP_0, reconciledTtp0AfterReconcilingBroker1);
                this.put(TTP_1, reconciledTtp1AfterReconcilingBroker1);
                this.put(TTP_2, reconciledTtp2AfterReconcilingBroker1);
            }
        };
        HashMap<TopicPartition, Set<Integer>> failedTtpsAfterReconcilingBroker1 = new HashMap<TopicPartition, Set<Integer>>(){
            {
                this.put(TTP_3, new HashSet<Integer>(Collections.singletonList(1)));
                this.put(TTP_4, new HashSet<Integer>(Collections.singletonList(1)));
            }
        };
        HashMap<TopicIdPartition, Set<Integer>> fencingFailedUtpsAfterReconcilingBroker1 = new HashMap<TopicIdPartition, Set<Integer>>(){
            {
                this.put(failedUtp5.utp, new HashSet<Integer>(Collections.singletonList(1)));
            }
        };
        HashMap<Integer, List<String>> errorsAfterReconcilingBroker1 = new HashMap<Integer, List<String>>(){
            {
                this.put(1, broker1errors);
            }
        };
        expectedReport = ReconciledTierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.FAILURE, affectedUtpsAfterReconcilingBroker1, (Map)affectedTtpsAfterReconcilingBroker1, (Map)failedTtpsAfterReconcilingBroker1, (Map)fencingFailedUtpsAfterReconcilingBroker1, (Map)errorsAfterReconcilingBroker1, TierTopicHeadDataLossReportReconcilerTest.makeDurationsMap(0, 1));
        receivedReport = TierTopicHeadDataLossReportReconciler.reconcileReportIncrementally((TierTopicHeadDataLossReport)broker1report, (ReconciledTierTopicHeadDataLossReport)reconciledReport);
        Assertions.assertTrue((boolean)expectedReport.checkEqualityExcludingCreationTime(receivedReport));
        UserTopicPartitionGroup utp6 = new UserTopicPartitionGroup(TEST_TOPIC_1, 5, 12, 70, TierPartitionStatus.ONLINE, TTP_0, true);
        UserTopicPartitionGroup utp7 = new UserTopicPartitionGroup(TEST_TOPIC_2, 6, 17, 90, TierPartitionStatus.ERROR, TTP_1, false);
        UserTopicPartitionGroup utp8 = new UserTopicPartitionGroup(TEST_TOPIC_1, 7, 21, 110, TierPartitionStatus.ONLINE, TTP_2, true);
        TierTopicPartitionGroup broker2ttp0Group = new TierTopicPartitionGroup(TTP_0, utp6, 2, new OffsetAndEpoch(35L, Optional.of(7)));
        TierTopicPartitionGroup broker2ttp1Group = new TierTopicPartitionGroup(TTP_1, utp7, 2, new OffsetAndEpoch(55L, Optional.of(12)));
        TierTopicPartitionGroup broker2ttp2Group = new TierTopicPartitionGroup(TTP_2, utp8, 2, new OffsetAndEpoch(90L, Optional.of(18)));
        final UserTopicPartitionGroup failedUtp9 = new UserTopicPartitionGroup(TEST_TOPIC_1, 8, 28, 200, TierPartitionStatus.ONLINE, TTP_0, false);
        final List<String> broker2errors = Arrays.asList("broker2_error0", "broker2_error1");
        TierTopicHeadDataLossReport broker2report = TierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.FAILURE, (int)2, (ValidationSource)ValidationSource.UNCLEAN_RESTART_VALIDATION, (long)this.time.milliseconds(), (long)this.time.milliseconds(), TierTopicHeadDataLossReportReconcilerTest.makeAffectedUtps(utp3, utp6, utp7, utp8), TierTopicHeadDataLossReportReconcilerTest.makeAffectedTtps(broker2ttp0Group, broker2ttp1Group, broker2ttp2Group), new HashSet<TopicPartition>(Arrays.asList(TTP_4, TTP_5)), new HashSet<TopicIdPartition>(Arrays.asList(failedUtp5.utp, failedUtp9.utp)), broker2errors);
        HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUtpsAfterReconcilingBroker2 = new HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>>();
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp0, new HashSet<Integer>(Arrays.asList(0, 1)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp1, new HashSet<Integer>(Collections.singletonList(0)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp2, new HashSet<Integer>(Collections.singletonList(1)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp3, new HashSet<Integer>(Arrays.asList(1, 2)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp4, new HashSet<Integer>(Collections.singletonList(1)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp6, new HashSet<Integer>(Collections.singletonList(2)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp7, new HashSet<Integer>(Collections.singletonList(2)));
        TierTopicHeadDataLossReportReconcilerTest.insertReconciledAffectedUtpEntry(affectedUtpsAfterReconcilingBroker2, utp8, new HashSet<Integer>(Collections.singletonList(2)));
        final ReconciledTierTopicPartitionInfo reconciledTtp0AfterReconcilingBroker2 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp6, 2, broker2ttp0Group, utp6, 2);
        final ReconciledTierTopicPartitionInfo reconciledTtp1AfterReconcilingBroker2 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp7, 2, broker2ttp1Group, utp7, 2);
        final ReconciledTierTopicPartitionInfo reconciledTtp2AfterReconcilingBroker2 = TierTopicHeadDataLossReportReconcilerTest.makeReconciledTtpInfo(utp8, 2, broker2ttp2Group, utp8, 2);
        HashMap<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTtpsAfterReconcilingBroker2 = new HashMap<TopicPartition, ReconciledTierTopicPartitionInfo>(){
            {
                this.put(TTP_0, reconciledTtp0AfterReconcilingBroker2);
                this.put(TTP_1, reconciledTtp1AfterReconcilingBroker2);
                this.put(TTP_2, reconciledTtp2AfterReconcilingBroker2);
            }
        };
        HashMap<TopicPartition, Set<Integer>> failedTtpsAfterReconcilingBroker2 = new HashMap<TopicPartition, Set<Integer>>(){
            {
                this.put(TTP_3, new HashSet<Integer>(Collections.singletonList(1)));
                this.put(TTP_4, new HashSet<Integer>(Arrays.asList(1, 2)));
                this.put(TTP_5, new HashSet<Integer>(Collections.singletonList(2)));
            }
        };
        HashMap<TopicIdPartition, Set<Integer>> fencingFailedUtpsAfterReconcilingBroker2 = new HashMap<TopicIdPartition, Set<Integer>>(){
            {
                this.put(failedUtp5.utp, new HashSet<Integer>(Arrays.asList(1, 2)));
                this.put(failedUtp9.utp, new HashSet<Integer>(Collections.singletonList(2)));
            }
        };
        HashMap<Integer, List<String>> errorsAfterReconcilingBroker2 = new HashMap<Integer, List<String>>(){
            {
                this.put(1, broker1errors);
                this.put(2, broker2errors);
            }
        };
        expectedReport = ReconciledTierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.FAILURE, affectedUtpsAfterReconcilingBroker2, (Map)affectedTtpsAfterReconcilingBroker2, (Map)failedTtpsAfterReconcilingBroker2, (Map)fencingFailedUtpsAfterReconcilingBroker2, (Map)errorsAfterReconcilingBroker2, TierTopicHeadDataLossReportReconcilerTest.makeDurationsMap(0, 1, 2));
        receivedReport = TierTopicHeadDataLossReportReconciler.reconcileReportIncrementally((TierTopicHeadDataLossReport)broker2report, (ReconciledTierTopicHeadDataLossReport)reconciledReport);
        Assertions.assertTrue((boolean)expectedReport.checkEqualityExcludingCreationTime(receivedReport));
    }

    private static class TierTopicPartitionGroup {
        final TopicPartition tierTopicPartition;
        final UserTopicPartitionGroup utpGroup;
        final int brokerId;
        final OffsetAndEpoch tierTopicMinEndOffsetAndEpoch;
        final AffectedTierTopicPartitionInfo affectedTierTopicPartitionInfo;

        public TierTopicPartitionGroup(TopicPartition tierTopicPartition, UserTopicPartitionGroup utpGroup, int brokerId, OffsetAndEpoch tierTopicMinEndOffsetAndEpoch) {
            this.tierTopicPartition = tierTopicPartition;
            this.utpGroup = utpGroup;
            this.brokerId = brokerId;
            this.tierTopicMinEndOffsetAndEpoch = tierTopicMinEndOffsetAndEpoch;
            this.affectedTierTopicPartitionInfo = new AffectedTierTopicPartitionInfo(utpGroup.ftpsLastMaterializedOffsetEpoch, utpGroup.utp, utpGroup.ftpsStatus, utpGroup.affectedUserTopicPartitionInfo.isLeader(), brokerId, tierTopicMinEndOffsetAndEpoch);
        }
    }

    private static class UserTopicPartitionGroup {
        final TopicIdPartition utp;
        final OffsetAndEpoch ftpsLastMaterializedOffsetEpoch;
        final TierPartitionStatus ftpsStatus;
        final TopicPartition tierTopicPartition;
        final AffectedUserTopicPartitionInfo affectedUserTopicPartitionInfo;

        UserTopicPartitionGroup(String topic, int partition, int lastMaterializedEpoch, int lastMaterializedOffset, TierPartitionStatus ftpsStatus, TopicPartition tierTopicPartition, boolean isLeader) {
            this.utp = new TopicIdPartition(topic, UUID.randomUUID(), partition);
            this.ftpsLastMaterializedOffsetEpoch = lastMaterializedEpoch >= 0 ? new OffsetAndEpoch((long)lastMaterializedOffset, Optional.of(lastMaterializedEpoch)) : new OffsetAndEpoch((long)lastMaterializedOffset, Optional.empty());
            this.ftpsStatus = ftpsStatus;
            this.tierTopicPartition = tierTopicPartition;
            this.affectedUserTopicPartitionInfo = new AffectedUserTopicPartitionInfo(tierTopicPartition.partition(), this.ftpsLastMaterializedOffsetEpoch, ftpsStatus, isLeader);
        }
    }
}

