/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.recovery.AffectedTierTopicPartitionInfo;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicHeadDataLossReportTest {
    @Test
    public void deSerializeTest() throws IOException {
        int version = 1;
        int brokerId = 3;
        long startTimestampMs = 1L;
        long endTimestampMs = 2L;
        ValidationSource validationSource = ValidationSource.ON_DEMAND_VALIDATION;
        TopicPartition ttp = new TopicPartition("_confluent-tier-state", 4);
        TopicIdPartition utp = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUserTopicPartitions = new HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo>();
        long ftpsLastMaterializedOffset = 1L;
        int ftpsLastMaterializedEpoch = 2;
        OffsetAndEpoch ftpsLastMaterializedOffsetAndEpoch = new OffsetAndEpoch(ftpsLastMaterializedOffset, Optional.of(ftpsLastMaterializedEpoch));
        TierPartitionStatus ftpsStatus = TierPartitionStatus.ONLINE;
        AffectedUserTopicPartitionInfo affectedUserTopicPartition = new AffectedUserTopicPartitionInfo(ttp.partition(), ftpsLastMaterializedOffsetAndEpoch, ftpsStatus, true);
        affectedUserTopicPartitions.put(utp, affectedUserTopicPartition);
        HashMap<TopicPartition, AffectedTierTopicPartitionInfo> affectedTierTopicPartitionsInfo = new HashMap<TopicPartition, AffectedTierTopicPartitionInfo>();
        long ttpEndOffset = 5L;
        int ttpEndEpoch = 6;
        OffsetAndEpoch ttpEndOffsetAndEpoch = new OffsetAndEpoch(ttpEndOffset, Optional.of(ttpEndEpoch));
        affectedTierTopicPartitionsInfo.put(ttp, new AffectedTierTopicPartitionInfo(ftpsLastMaterializedOffsetAndEpoch, utp, ftpsStatus, true, brokerId, ttpEndOffsetAndEpoch));
        TierTopicHeadDataLossReport info = TierTopicHeadDataLossReport.createReport((TierTopicHeadDataLossReport.CompletionStatus)TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, (int)brokerId, (ValidationSource)validationSource, (long)startTimestampMs, (long)endTimestampMs, affectedUserTopicPartitions, affectedTierTopicPartitionsInfo, new HashSet(), new HashSet(), new ArrayList());
        File testFile = TestUtils.tempFile((String)"test", (String)".json");
        TierTopicHeadDataLossReport.writeJsonToFile((TierTopicHeadDataLossReport)info, (OutputStream)Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        TierTopicHeadDataLossReport readInfo = TierTopicHeadDataLossReport.readJsonFromFile((Path)testFile.toPath());
        Assertions.assertEquals((Object)info, (Object)readInfo);
        String expectedOutputJson = "{\"completion_status\":\"" + TierTopicHeadDataLossReport.CompletionStatus.SUCCESS + "\",\"version\":" + version + ",\"broker_id\":" + brokerId + ",\"source\":\"" + validationSource + "\",\"start_timestamp_ms\":" + startTimestampMs + ",\"end_timestamp_ms\":" + endTimestampMs + ",\"affected_user_topic_partitions\":{\"" + utp + "\":{\"tier_topic_partition\":" + ttp.partition() + ",\"last_materialized_offset_and_epoch\":{\"offset\":" + ftpsLastMaterializedOffset + ",\"epoch\":" + ftpsLastMaterializedEpoch + "},\"ftps_status\":\"" + ftpsStatus + "\",\"is_leader\":true}},\"affected_tier_topic_partitions\":{\"" + ttp + "\":{\"max_last_materialized_offset_and_epoch\":{\"offset\":" + ftpsLastMaterializedOffset + ",\"epoch\":" + ftpsLastMaterializedEpoch + "},\"max_last_materialized_partition\":\"" + utp + "\",\"ftps_status\":\"" + ftpsStatus + "\",\"is_leader\":true,\"max_last_materialized_replica\":" + brokerId + ",\"tier_topic_end_offset_and_epoch\":{\"offset\":" + ttpEndOffset + ",\"epoch\":" + ttpEndEpoch + "}}},\"failed_tier_topic_partitions\":[],\"user_partitions_with_fencing_failures\":[],\"error_messages\":[],\"creation_timestamp\":\"" + info.creationTimestamp() + "\"}";
        TierTopicHeadDataLossReport.readJsonFromString((String)expectedOutputJson);
        String writtenJson = Utils.readFileAsString((String)testFile.toPath().toString());
        Assertions.assertEquals((Object)expectedOutputJson, (Object)writtenJson);
    }
}

