/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import kafka.log.LocalLog$;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndpointSupplier;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.TierStateRestoreSnapshotMetadata;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicDataLossValidator;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CheckedFileIOTestUtils$;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Short$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001\u0002+V\u0001qCQa\u0019\u0001\u0005\u0002\u0011,Aa\u001a\u0001\u0001Q\u0016!A\u000f\u0001\u0001v\u0011\u001dA\bA1A\u0005\neDq!!\u0002\u0001A\u0003%!\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011q\u0003\u0001!\u0002\u0013\tY\u0001\u0003\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003z\u0011\u001d\tY\u0002\u0001Q\u0001\niD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005}\u0002\u0001)A\u0005\u0003gA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u000bB\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005u\u0003\u0001)A\u0005\u0003/B\u0011\"a\u0018\u0001\u0005\u0004%\t!!\u0019\t\u0011\u0005%\u0004\u0001)A\u0005\u0003GB\u0011\"a\u001b\u0001\u0005\u0004%I!!\u001c\t\u0011\u0005U\u0004\u0001)A\u0005\u0003_B\u0001\"a\u001e\u0001\u0005\u0004%I!\u001f\u0005\b\u0003s\u0002\u0001\u0015!\u0003{\u0011%\tY\b\u0001b\u0001\n\u0013\ti\b\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BA@\u0011%\ti\n\u0001b\u0001\n\u0013\ty\nC\u0004\u0002\"\u0002\u0001\u000b\u0011B;\t\u0013\u0005\r\u0006A1A\u0005\n\u0005\u0015\u0006bBAT\u0001\u0001\u0006I\u0001\u001b\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003KCq!a+\u0001A\u0003%\u0001\u000eC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u0002&\"9\u0011q\u0016\u0001!\u0002\u0013A\u0007\"CAY\u0001\t\u0007I\u0011BAZ\u0011!\t\t\r\u0001Q\u0001\n\u0005U\u0006\"CAb\u0001\t\u0007I\u0011BAc\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005\u001d\u0007\"CAk\u0001\t\u0007I\u0011BAl\u0011!\ty\u000e\u0001Q\u0001\n\u0005e\u0007\"CAq\u0001\u0001\u0007I\u0011BAr\u0011%\t\u0019\u0010\u0001a\u0001\n\u0013\t)\u0010\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0015BAs\u0011%\u0011\u0019\u0001\u0001b\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\u0014\u0001\u0001\u000b\u0011\u0002B\u0004\u0011%\u0011)\u0002\u0001b\u0001\n\u0013\u00119\u0002\u0003\u0005\u0003 \u0001\u0001\u000b\u0011\u0002B\r\u0011%\u0011\t\u0003\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0003$\u0001\u0001\u000b\u0011BA2\u0011%\u0011)\u0003\u0001a\u0001\n\u0003\u00119\u0003C\u0005\u00034\u0001\u0001\r\u0011\"\u0001\u00036!A!\u0011\b\u0001!B\u0013\u0011I\u0003C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003>!9!q\t\u0001\u0005\u0002\tu\u0002b\u0002B%\u0001\u0011\u0005!Q\b\u0005\b\u0005\u0017\u0002A\u0011\u0001B\u001f\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001fBqAa\u001a\u0001\t\u0003\u0011y\u0005C\u0004\u0003r\u0001!\tAa\u0014\t\u000f\tU\u0004\u0001\"\u0001\u0003P!9!\u0011\u0010\u0001\u0005\u0002\t=\u0003b\u0002B?\u0001\u0011\u0005!q\n\u0005\b\u0005\u0003\u0003A\u0011\u0001B(\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u001fBqA!#\u0001\t\u0003\u0011y\u0005C\u0004\u0003\u000e\u0002!\tAa\u0014\t\u000f\tE\u0005\u0001\"\u0001\u0003P!9!Q\u0013\u0001\u0005\u0002\t=\u0003b\u0002BM\u0001\u0011\u0005!q\n\u0005\b\u0005;\u0003A\u0011\u0001B(\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0005\u001fBqA!*\u0001\t\u0003\u0011y\u0005C\u0004\u0003*\u0002!\tAa\u0014\t\u000f\t5\u0006\u0001\"\u0003\u00030\"9!q\u0019\u0001\u0005\n\t%\u0007\"\u0003B\u007f\u0001E\u0005I\u0011\u0002B\u0000\u0011%\u0019)\u0002AI\u0001\n\u0013\u00199\u0002C\u0005\u0004\u001c\u0001\t\n\u0011\"\u0003\u0004\u001e!I1\u0011\u0005\u0001\u0012\u0002\u0013%11\u0005\u0005\n\u0007O\u0001\u0011\u0013!C\u0005\u0007SAqa!\f\u0001\t\u0013\u0011y\u0005C\u0004\u00040\u0001!IAa\u0014\t\u000f\rE\u0002\u0001\"\u0003\u00044\t!B+[3s)>\u0004\u0018nY'b]\u0006<WM\u001d+fgRT!AV,\u0002\u000bQ|\u0007/[2\u000b\u0005aK\u0016\u0001\u0002;jKJT\u0011AW\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\f\u0005\u0002_C6\tqLC\u0001a\u0003\u0015\u00198-\u00197b\u0013\t\u0011wL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0004\"A\u001a\u0001\u000e\u0003U\u0013\u0001cQ8ogVlWM]*vaBd\u0017.\u001a:\u0011\t%dgN\\\u0007\u0002U*\u00111nV\u0001\u0007G2LWM\u001c;\n\u00055T'\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0002__FL!\u0001]0\u0003\u000b\u0005\u0013(/Y=\u0011\u0005y\u0013\u0018BA:`\u0005\u0011\u0011\u0015\u0010^3\u0003!A\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003B5w]:L!a\u001e6\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s\u0003%\u0019G.^:uKJLE-F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0005Y\u0006twMC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAP\u0001\u0004TiJLgnZ\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0013a\u0002;f[B$\u0015N]\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#q\u0018AA5p\u0013\u0011\t)\"a\u0004\u0003\t\u0019KG.Z\u0001\ti\u0016l\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%A\u0004m_\u001e$\u0015N]:\u0016\u0005\u0005\u0005\u0002#BA\u0012\u0003SQXBAA\u0013\u0015\r\t9C`\u0001\u0005kRLG.\u0003\u0003\u0002,\u0005\u0015\"!C!se\u0006LH*[:u\u0003!awn\u001a#jeN\u0004\u0013\u0001\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3s+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tIdV\u0001\bM\u0016$8\r[3s\u0013\u0011\ti$a\u000e\u0003!QKWM]*uCR,g)\u001a;dQ\u0016\u0014\u0018!\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3sA\u0005yA/[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0006\u0002\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L]\u000bQa\u001d;pe\u0016LA!a\u0014\u0002J\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\tuS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:fA\u00051B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7/\u0006\u0002\u0002XA\u0019a,!\u0017\n\u0007\u0005msLA\u0003TQ>\u0014H/A\fuS\u0016\u0014Hk\u001c9jG:+X\u000eU1si&$\u0018n\u001c8tA\u0005A!M]8lKJLE-\u0006\u0002\u0002dA\u0019a,!\u001a\n\u0007\u0005\u001dtLA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002-QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e,\"!a\u001c\u0011\u0007\u0019\f\t(C\u0002\u0002tU\u0013a\u0003V5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017nZ\u0001\u0018i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jO\u0002\nQ\u0002^5feR{\u0007/[2OC6,\u0017A\u0004;jKJ$v\u000e]5d\u001d\u0006lW\rI\u0001\u0014i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u007f\u0002b!a\t\u0002\u0002\u0006\u0015\u0015\u0002BAB\u0003K\u00111aU3u!\u0011\t9)a&\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000baaY8n[>t'b\u0001.\u0002\u0010*!\u0011\u0011SAJ\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QS\u0001\u0004_J<\u0017\u0002BAM\u0003\u0013\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u000buS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\u0011aJ|G-^2feN+\b\u000f\u001d7jKJ,\u0012!^\u0001\u0012aJ|G-^2feN+\b\u000f\u001d7jKJ\u0004\u0013a\u00069sS6\f'/_\"p]N,X.\u001a:TkB\u0004H.[3s+\u0005A\u0017\u0001\u00079sS6\f'/_\"p]N,X.\u001a:TkB\u0004H.[3sA\u000592-\u0019;dQV\u00048i\u001c8tk6,'oU;qa2LWM]\u0001\u0019G\u0006$8\r[;q\u0007>t7/^7feN+\b\u000f\u001d7jKJ\u0004\u0013\u0001\u00073jg\u000e|g/\u001a:D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006IB-[:d_Z,'oQ8ogVlWM]*vaBd\u0017.\u001a:!\u00035Ig\u000e^3s]\u0006d\u0017\tZ7j]V\u0011\u0011Q\u0017\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111X-\u0002\rM,'O^3s\u0013\u0011\ty,!/\u0003\u001b%sG/\u001a:oC2\fE-\\5o\u00039Ig\u000e^3s]\u0006d\u0017\tZ7j]\u0002\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\t\t9\r\u0005\u0003\u0002J\u0006=WBAAf\u0015\r\ti-W\u0001\u0004Y><\u0017\u0002BAi\u0003\u0017\u0014!\u0002T8h\u001b\u0006t\u0017mZ3s\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011\u0011\u001c\t\u0005\u0003o\u000bY.\u0003\u0003\u0002^\u0006e&A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u00059B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dWm]\u000b\u0003\u0003K\u0004BAX8\u0002hB!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002n^\u000bQa\u001d;bi\u0016LA!!=\u0002l\n1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-A\u000euS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)\u001b7fg~#S-\u001d\u000b\u0005\u0003o\fi\u0010E\u0002_\u0003sL1!a?`\u0005\u0011)f.\u001b;\t\u0013\u0005}\u0018&!AA\u0002\u0005\u0015\u0018a\u0001=%c\u0005AB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dWm\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0005\u000f\u0001BA!\u0003\u0003\u00105\u0011!1\u0002\u0006\u0005\u0003O\u0011iA\u0003\u0003\u0002<\u00065\u0015\u0002\u0002B\t\u0005\u0017\u0011\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u000fG2,\u0017M\\;q\t\u0016d\u0017-_'t+\t\u0011I\u0002E\u0002_\u00057I1A!\b`\u0005\u0011auN\\4\u0002\u001f\rdW-\u00198va\u0012+G.Y=Ng\u0002\n\u0011c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'t\u0003I\u0019G.Z1okBLe\u000e^3sm\u0006dWj\u001d\u0011\u0002\u000f5,GO]5dgV\u0011!\u0011\u0006\t\u0005\u0005W\u0011y#\u0004\u0002\u0003.)!!QEAE\u0013\u0011\u0011\tD!\f\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\u0011\t9Pa\u000e\t\u0013\u0005}('!AA\u0002\t%\u0012\u0001C7fiJL7m\u001d\u0011\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\"Aa\u0010\u0011\u0007y\u0013\t%C\u0002\u0003D}\u0013qAQ8pY\u0016\fg.\u0001\bd_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3\u0002\u001d\rdW-\u00198va\u0016s\u0017M\u00197fI\u0006\tC/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f':\f\u0007o\u001d5pi\u0016s\u0017M\u00197fI\u0006QC/[3s)>\u0004\u0018nY'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8Ge>l7K\\1qg\"|G/\u00128bE2,\u0017\u0001\u0003;fCJ$wn\u001e8\u0015\u0005\u0005]\bfA\u001d\u0003TA!!Q\u000bB2\u001b\t\u00119F\u0003\u0003\u0003Z\tm\u0013aA1qS*!!Q\fB0\u0003\u001dQW\u000f]5uKJTAA!\u0019\u0002\u0014\u0006)!.\u001e8ji&!!Q\rB,\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0011uKN$HK]=CK\u000e|W.\u001a*fC\u0012L\b*\u00198eY\u0016,\u0005pY3qi&|g\u000eK\u0002;\u0005W\u0002BA!\u0016\u0003n%!!q\u000eB,\u0005\u0011!Vm\u001d;\u0002\u0013R,7\u000f\u001e*fa\u0016\fG/\u001a3Uef\u0014UmY8nKJ+\u0017\rZ=DC2d7oV5mY:{Go\u0011:fCR,G)\u001e9mS\u000e\fG/\u001a3Qe>$WoY3s\u0003:$7i\u001c8tk6,'\u000fK\u0002<\u0005W\n!\u0004^3ti\u0006#G-T3uC\u0012\fG/\u0019\"fM>\u0014XMU3bIfD3\u0001\u0010B6\u0003}!Xm\u001d;EkBd\u0017nY1uKJ+\u0017/^3ti\n+gm\u001c:f%\u0016\fG-\u001f\u0015\u0004{\t-\u0014A\f;fgR\u0014V\r\u001e:z\u001f:,fn\u001b8po:,\u0005pY3qi&|g\u000eR;sS:<Gk\u001c9jG\u000e\u0013X-\u0019;j_:D3A\u0010B6\u0003\r\"Xm\u001d;QCJ$\u0018\u000e^5p]\u0016\u00148+\u001a;va^CWM\u001c+pa&\u001cW\t_5tiND3a\u0010B6\u0003M!Xm\u001d;SKR\u0014\u0018.\u001a3NKN\u001c\u0018mZ3tQ\r\u0001%1N\u0001;i\u0016\u001cHOR3oG&twMV5b!\u0006\u0014H/\u001b;j_:4UM\\2f\u000bZ,g\u000e^(o\u000b6\u0004H/\u001f+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D3!\u0011B6\u0003u\"Xm\u001d;GK:\u001c\u0017N\\4WS\u0006\u0004\u0016M\u001d;ji&|gNR3oG\u0016,e/\u001a8u\u001f:tuN\\#naRLH+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fQ\r\u0011%1N\u00017i\u0016\u001cHOR;ukJ,W*Z:tC\u001e,g)\u001a8dK\u0012\fe\r^3s!\u0006\u0014H/\u001b;j_:$U\r\\3uKB\u0013X-\u00138ji&\fG/\u001a\u0015\u0004\u0007\n-\u0014a\t;fgR\u001cV\r^#se>\u0014\b+\u0019:uSRLwN\\:EkJLgn\u001a$f]\u000eLgn\u001a\u0015\u0004\t\n-\u0014a\b;fgR\u0014VmY8wKJ<\u0006.\u001b7f\u0007\u0006$8\r[;q\u0007>t7/^7fe\"\u001aQIa\u001b\u0002MQ,7\u000f\u001e%b]\u0012d\u0017N\\4G_J\u0014Vm\u001d;pe\u0016|eNT8o\u000bJ\u0014xN]*uCR,8\u000fK\u0002G\u0005W\nA\u0007^3tiB\u0013xnY3tg6+7o]1hKN\u0004vn\u001d;Ti\u0006$XMR3oG&tw\rR;sS:<wJ\u001c7j]\u0016\u001cF/\u0019;fQ\r9%1N\u0001Ki\u0016\u001cH\u000f\u0016:b]NLG/[8o\rJ|WnQ1uG\",\boQ8ogVlWM\u001d+p!JLW.\u0019:z\u0007>t7/^7fe&sWI\u001d:peN#\u0018\r^3UQ\u0016t'+Z2pm\u0016\u0014\u0018\u0010K\u0002I\u0005W\n1\t^3ti\u0016s\u0017M\u00197f':\f\u0007o\u001d5pi\n\u000b7/\u001a3NCR,'/[1mSj\fG/[8o\u001f:d\u0017p\u00165f]\u001a#\u0006kU*oCB\u001c\bn\u001c;Jg\u0016s\u0017M\u00197fI\"\u001a\u0011Ja\u001b\u0002\u0015\u0005$GMU3qY&\u001c\u0017\r\u0006\u0004\u0002x\nE&Q\u0018\u0005\b\u0005gS\u0005\u0019\u0001B[\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u00038\neV\"A,\n\u0007\tmvK\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9!q\u0018&A\u0002\t\u0005\u0017!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feB\u0019aMa1\n\u0007\t\u0015WKA\tUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\f1c]3ukB$\u0016.\u001a:D_6\u0004xN\\3oiN$bBa3\u0003^\n}'1\u001dBz\u0005k\u0014Y\u0010E\u0005_\u0005\u001b\u0014\tM!5\u0003X&\u0019!qZ0\u0003\rQ+\b\u000f\\34!\u0011\u00119La5\n\u0007\tUwK\u0001\nUS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bc\u00014\u0003Z&\u0019!1\\+\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b\"CA6\u0017B\u0005\t\u0019AA8\u0011\u001d\u0011\to\u0013a\u0001\u0005\u007f\t1BY3d_6,'+Z1es\"I!Q]&\u0011\u0002\u0003\u0007!q]\u0001\ri&,'\u000fV8qS\u000e|\u0005\u000f\u001e\t\u0006=\n%(Q^\u0005\u0004\u0005W|&AB(qi&|g\u000eE\u0002g\u0005_L1A!=V\u0005%!\u0016.\u001a:U_BL7\rC\u0005\u0002D.\u0003\n\u00111\u0001\u0002H\"I\u0011QT&\u0011\u0002\u0003\u0007!q\u001f\t\u0004\u0005s\u001cQ\"\u0001\u0001\t\u0013\t}6\n%AA\u0002\t\u0005\u0017!H:fiV\u0004H+[3s\u0007>l\u0007o\u001c8f]R\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r\u0005!\u0006BA8\u0007\u0007Y#a!\u0002\u0011\t\r\u001d1\u0011C\u0007\u0003\u0007\u0013QAaa\u0003\u0004\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u001fy\u0016AC1o]>$\u0018\r^5p]&!11CB\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001eg\u0016$X\u000f\u001d+jKJ\u001cu.\u001c9p]\u0016tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0004\u0016\u0005\u0005O\u001c\u0019!A\u000ftKR,\b\u000fV5fe\u000e{W\u000e]8oK:$8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019yB\u000b\u0003\u0002H\u000e\r\u0011!H:fiV\u0004H+[3s\u0007>l\u0007o\u001c8f]R\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u0015\"\u0006\u0002B|\u0007\u0007\tQd]3ukB$\u0016.\u001a:D_6\u0004xN\\3oiN$C-\u001a4bk2$HEN\u000b\u0003\u0007WQCA!1\u0004\u0004\u0005IRn\u001c<f%\u0016\u001cwN\u001d3t)>\fE\u000e\\\"p]N,X.\u001a:t\u0003q\u0011Xm]3oIB\u0013XM^5pkN\u0004&o\u001c3vG\u0016\u0014V-];fgR\faBY3d_6,\u0017I]2iSZ,'\u000f\u0006\u0006\u0002x\u000eU2qGB\u001e\u0007\u007fAqAa-T\u0001\u0004\u0011)\fC\u0004\u0004:M\u0003\r!a\u0019\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0007{\u0019\u0006\u0019\u0001Bl\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'\u000fC\u0004\u0003@N\u0003\rA!1")
public class TierTopicManagerTest {
    private final String clusterId;
    private final File tempDir = TestUtils.tempDirectory(null, null);
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final short tierTopicNumPartitions = (short)7;
    private final int brokerId;
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, this.brokerId(), this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(-1L), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(false), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.boolean2Boolean(this.tierTopicMaterializationFromSnapshotEnable()));
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("discover", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
    private final LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final MockTime time = new MockTime();
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private Metrics metrics = new Metrics();

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier() {
        return this.discoverConsumerSupplier;
    }

    private InternalAdmin internalAdmin() {
        return this.internalAdmin;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    private int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean compactEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    public boolean tierPartitionStateSnapshotEnabled() {
        return false;
    }

    public boolean tierTopicMaterializationFromSnapshotEnable() {
        return false;
    }

    @AfterEach
    public void teardown() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Function1 & Serializable)tierPartitionState -> {
            TierTopicManagerTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        Mockito.framework().clearInlineMocks();
        Utils.delete((File)new File(this.logDir()), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTryBecomeReadyHandleException() {
        void var7_7;
        MockProducerSupplier<byte[], byte[]> x$6;
        LogManager x$5;
        Option x$4;
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        TierTopicManagerConfig x$3 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$3, false, (Option<TierTopic>)(x$4 = Option$.MODULE$.empty()), x$5 = this.setupTierComponents$default$4(), x$6 = this.setupTierComponents$default$5(), tierTopicConsumer);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var7_7.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        tierTopicConsumer.initialize((InitializedTierTopic)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TimeoutException()});
        Assertions.assertFalse((boolean)var7_7.tryBecomeReady(false));
        ((TierTopicConsumer)Mockito.doNothing().when((Object)tierTopicConsumer)).initialize((InitializedTierTopic)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)var7_7.tryBecomeReady(false));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRepeatedTryBecomeReadyCallsWillNotCreateDuplicatedProducerAndConsumer() {
        void var8_8;
        MockProducerSupplier producerSupplier = (MockProducerSupplier)Mockito.mock(MockProducerSupplier.class);
        MockConsumerSupplier primaryConsumerSupplier = (MockConsumerSupplier)Mockito.mock(MockConsumerSupplier.class);
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), (Supplier)primaryConsumerSupplier, this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), new LogDirFailureChannel(1)), this.tierStateFetcher(), Optional.empty(), (Time)new org.apache.kafka.common.utils.MockTime());
        tierTopicConsumer.setupMetrics();
        Mockito.when(producerSupplier.get()).thenReturn(this.producerSupplier().get());
        Mockito.when(primaryConsumerSupplier.get()).thenReturn(this.primaryConsumerSupplier().get());
        TierTopicManagerConfig x$4 = this.setupTierComponents$default$1();
        Option x$5 = Option$.MODULE$.empty();
        LogManager x$6 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$4, false, (Option<TierTopic>)x$5, x$6, producerSupplier, tierTopicConsumer);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var8_8.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        Assertions.assertTrue((boolean)var8_8.tryBecomeReady(false));
        Assertions.assertTrue((boolean)var8_8.tryBecomeReady(false));
        ((MockProducerSupplier)Mockito.verify((Object)producerSupplier, (VerificationMode)Mockito.times((int)1))).get();
        ((MockConsumerSupplier)Mockito.verify((Object)primaryConsumerSupplier, (VerificationMode)Mockito.times((int)1))).get();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddMetadataBeforeReady() {
        void var8_8;
        void var9_9;
        TierTopicConsumer x$6;
        MockProducerSupplier<byte[], byte[]> x$5;
        LogManager x$4;
        Option x$3;
        int epoch = 0;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, (Option<TierTopic>)(x$3 = Option$.MODULE$.empty()), x$4 = this.setupTierComponents$default$4(), x$5 = this.setupTierComponents$default$5(), x$6 = this.setupTierComponents$default$6());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var9_9.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo_1", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(topicIdPartition_1, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_1.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_1), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        var8_8.register(topicIdPartition_1, clientCtx_1);
        Assertions.assertEquals((int)1, (int)var8_8.immigratingPartitions().size());
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("foo_2", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(topicIdPartition_2, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_2.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_2), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        var8_8.register(topicIdPartition_2, clientCtx_2);
        Assertions.assertEquals((int)2, (int)var8_8.immigratingPartitions().size());
        CompletableFuture future_1 = var9_9.addMetadata((AbstractTierMetadata)initLeader_1);
        CompletableFuture future_2 = var9_9.addMetadata((AbstractTierMetadata)initLeader_2);
        Assertions.assertTrue((boolean)var9_9.tryBecomeReady(false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$1(this, (TierTopicConsumer)var8_8, future_1, future_2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for futures to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_1.get());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_2.get());
        Assertions.assertEquals((int)2, (int)var8_8.primaryConsumerPartitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateRequestBeforeReady() {
        void var10_10;
        void var9_9;
        TierTopicConsumer x$6;
        MockProducerSupplier<byte[], byte[]> x$5;
        LogManager x$4;
        Option x$3;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int epoch = 0;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, (Option<TierTopic>)(x$3 = Option$.MODULE$.empty()), x$4 = this.setupTierComponents$default$4(), x$5 = this.setupTierComponents$default$5(), x$6 = this.setupTierComponents$default$6());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        Assertions.assertFalse((boolean)var10_10.isReadyForWrites());
        UUID objectId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, epoch, objectId, 0);
        CompletableFuture oldInitLeaderResult = var10_10.addMetadata((AbstractTierMetadata)initLeader);
        CompletableFuture newInitLeaderResult = var10_10.addMetadata((AbstractTierMetadata)initLeader);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (TierPartitionState.AppendResult)oldInitLeaderResult.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierTopicManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221))).getCause() instanceof TierMetadataFatalException));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        Assertions.assertTrue((boolean)var10_10.tryBecomeReady(false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$2(this, (TierTopicConsumer)var9_9, newInitLeaderResult)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting to become archiver");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, newInitLeaderResult.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryOnUnknownExceptionDuringTopicCreation() {
        void var7_7;
        void var8_8;
        TierTopicConsumer x$6;
        MockProducerSupplier<byte[], byte[]> x$5;
        LogManager x$4;
        Option x$3;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, (Option<TierTopic>)(x$3 = Option$.MODULE$.empty()), x$4 = this.setupTierComponents$default$4(), x$5 = this.setupTierComponents$default$5(), x$6 = this.setupTierComponents$default$6());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var8_8.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new TimeoutException("timeout when creating topic")}).thenThrow(new Throwable[]{new AdminOperationException("admin operation exception")}).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        var8_8.tryBecomeReady(false);
        Assertions.assertFalse((boolean)var8_8.isReadyForWrites());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)1))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        var8_8.tryBecomeReady(false);
        Assertions.assertFalse((boolean)var8_8.isReadyForWrites());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)2))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        var8_8.tryBecomeReady(false);
        Assertions.assertTrue((boolean)var8_8.isReadyForWrites());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)3))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        Assertions.assertEquals((int)this.tierTopicNumPartitions(), (int)var7_7.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionerSetupWhenTopicExists() {
        void var8_8;
        void var9_9;
        TierTopicConsumer x$6;
        MockProducerSupplier<byte[], byte[]> x$5;
        LogManager x$4;
        Option x$3;
        int existingPartitions = this.tierTopicNumPartitions() - 2;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, (Option<TierTopic>)(x$3 = Option$.MODULE$.empty()), x$4 = this.setupTierComponents$default$4(), x$5 = this.setupTierComponents$default$5(), x$6 = this.setupTierComponents$default$6());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var9_9.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)existingPartitions));
        var9_9.tryBecomeReady(false);
        Assertions.assertTrue((boolean)var9_9.isReadyForWrites());
        Assertions.assertEquals((int)existingPartitions, (int)var8_8.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetriedMessages() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var10_10, (TierTopicConsumer)var9_9);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()), OpaqueData.ZEROED);
        CompletableFuture initiateResult = var10_10.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, initiateResult.get());
        this.resendPreviousProduceRequest();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        CompletableFuture completeResult = var10_10.addMetadata((AbstractTierMetadata)uploadComplete);
        var9_9.doWork();
        Assertions.assertFalse((boolean)completeResult.isDone(), (String)"Upload complete result should not have been completed by materialization of UploadInitiate");
        Assertions.assertEquals((long)1L, (long)var9_9.numListeners());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnEmptyTierPartitionState() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        CompletableFuture partitionFenceFuture = var10_10.addMetadata((AbstractTierMetadata)partitionFence);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(this, (TierTopicConsumer)var9_9, partitionFenceFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to finish TierPartitionFence");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var9_9.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnNonEmptyTierPartitionState() {
        void var11_11;
        void var10_10;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var10_10);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var11_11, (TierTopicConsumer)var10_10);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var11_11.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var10_10.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var10_10.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var10_10.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = var11_11.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        var10_10.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadCompleteFuture.get());
        Assertions.assertEquals((Object)uploadInitiate.messageId(), (Object)((TierLogSegment)this.tierPartitionStateFiles()[0].metadata(100L).get()).objectId());
        Assertions.assertEquals((int)0, (int)var10_10.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var10_10.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture partitionFenceFuture = var11_11.addMetadata((AbstractTierMetadata)partitionFence);
        this.moveRecordsToAllConsumers();
        var10_10.doWork();
        Assertions.assertTrue((boolean)partitionFenceFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var10_10.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var10_10.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var10_10.primaryConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFutureMessageFencedAfterPartitionDeletePreInitiate() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var10_10, (TierTopicConsumer)var9_9);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeletePreInitiate partitionDeletePreInitiate = new TierPartitionDeletePreInitiate(topicIdPartition, UUID.randomUUID());
        CompletableFuture partitionDeletePreInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)partitionDeletePreInitiate);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)partitionDeletePreInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, partitionDeletePreInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierSegmentUploadInitiate newUploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 101L, 200L, 200L, 200L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture newUploadInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)newUploadInitiate);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)newUploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, newUploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = var10_10.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID());
        CompletableFuture deleteInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)deleteInitiate);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)deleteInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, deleteInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetErrorPartitionsDuringFencing() {
        void var9_9;
        void var8_8;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var8_8);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture initiateResultFuture = var9_9.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$1(this, (TierTopicConsumer)var8_8, initiateResultFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to finish TierSegmentUploadInitiate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, initiateResultFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var8_8.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var8_8.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var8_8.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverWhileCatchupConsumer() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var10_10, (TierTopicConsumer)var9_9);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        state.flush();
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, state.lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = var10_10.addMetadata((AbstractTierMetadata)uploadComplete);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)uploadInitiate);
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("couldn't fetch")}).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)1, (int)var9_9.catchUpConsumerPartitions().size());
        Assertions.assertTrue((boolean)var9_9.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var9_9.catchUpConsumerErrorPartitions().isEmpty());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$1(this, (TierTopicConsumer)var9_9, uploadCompleteFuture, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CompletableFuture becomeArchiverFinalFuture = var10_10.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)2))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlingForRestoreOnNonErrorStatus() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        if (this.tierTopicMaterializationFromSnapshotEnable()) {
            var9_9.doWork();
        }
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        CompletableFuture becomeArchiverFinalFuture = var10_10.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var9_9.primaryConsumerPartitions().size());
        state.flush();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer restoreBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)restoreBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$1(this, (TierTopicConsumer)var9_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)var9_9.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var9_9.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessMessagesPostStateFencingDuringOnlineState() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var10_10, (TierTopicConsumer)var9_9);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = var10_10.addMetadata((AbstractTierMetadata)uploadComplete);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var9_9.primaryConsumerErrorPartitions()).asScala());
        state.flush();
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var9_9.primaryConsumerErrorPartitions()).asScala());
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(this, (TierTopicConsumer)var9_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)var9_9.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var9_9.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = var10_10.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)1))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery() {
        void var10_10;
        void var9_9;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Option x$3 = Option$.MODULE$.empty();
        LogManager x$4 = this.setupTierComponents$default$4();
        MockProducerSupplier<byte[], byte[]> x$5 = this.setupTierComponents$default$5();
        TierTopicConsumer x$6 = this.setupTierComponents$default$6();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, (Option<TierTopic>)x$3, x$4, x$5, x$6);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var9_9);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        if (this.tierTopicMaterializationFromSnapshotEnable()) {
            var9_9.doWork();
        }
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.primaryConsumerErrorPartitions().size());
        state.flush();
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var10_10.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(this, (TierTopicConsumer)var9_9, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for upload initiate future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)1, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertTrue((boolean)var9_9.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var9_9.primaryConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)1, (int)var9_9.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerPartitions().size());
        CompletableFuture becomeArchiverFuture = var10_10.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, becomeArchiverFuture.get());
        Assertions.assertEquals((int)0, (int)var9_9.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var9_9.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var9_9.primaryConsumerErrorPartitions()).asScala());
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(this, (TierTopicConsumer)var9_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)var9_9.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var9_9.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = var10_10.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var9_9.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
    }

    @Test
    public void testEnableSnapshotBasedMaterializationOnlyWhenFTPSSnapshotIsEnabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        props.put(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsEnableProp(), "false");
        props.put(KafkaConfig$.MODULE$.TierTopicMaterializationFromSnapshotEnableProp(), "true");
        boolean apply_doLog = true;
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(new KafkaConfig((Map)props, apply_doLog), () -> Collections.singletonMap("bootstrap.servers", "bootstrap"), this.clusterId());
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(tierTopicManagerConfig.enableSnapshotBasedMaterialization));
        props.put(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsEnableProp(), "true");
        boolean apply_doLog2 = true;
        tierTopicManagerConfig = new TierTopicManagerConfig(new KafkaConfig((Map)props, apply_doLog2), () -> Collections.singletonMap("bootstrap.servers", "bootstrap"), this.clusterId());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(tierTopicManagerConfig.enableSnapshotBasedMaterialization));
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer) {
        TopicPartition logDirName_topicPartition = topicIdPartition.topicPartition();
        Object var5_3 = null;
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), new TierPartitionStateCleanupConfig(this.cleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(21).append("TierTopicManagerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer snapshotBuffer, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.processSnapshotMaterializationEvent(metadata, snapshotBuffer, offsetAndEpoch);
            }

            public long localMaterializedOffset() {
                return this.tierPartitionState$1.lastLocalMaterializedSrcOffsetAndEpoch().offset();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }

            public void beginDiscover() {
                this.tierPartitionState$1.beginDiscover();
            }

            public void completeDiscover() {
                this.tierPartitionState$1.onDiscoverComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    private Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> setupTierComponents(TierTopicManagerConfig tierTopicManagerConfig, boolean becomeReady, Option<TierTopic> tierTopicOpt, LogManager logManager, MockProducerSupplier<byte[], byte[]> producerSupplier, TierTopicConsumer tierTopicConsumer) {
        TierReplicaManager tierReplicaManager = new TierReplicaManager();
        Mockito.when((Object)this.replicaManager().logManager()).thenReturn((Object)logManager);
        TierTopic tierTopic = (TierTopic)tierTopicOpt.getOrElse((Function0 & Serializable)() -> new TierTopic(tierTopicManagerConfig$1.tierNamespace));
        TierTopicDataLossValidator tierTopicDataLossValidator = new TierTopicDataLossValidator(tierTopicManagerConfig, tierTopic, this.tierObjectStore(), this.replicaManager(), (Supplier)Mockito.mock(Supplier.class), (LeaderEndpointSupplier)Mockito.mock(LeaderEndpointSupplier.class), (Time)this.time(), this.metrics());
        TierTopicManager tierTopicManager = new TierTopicManager(tierTopicManagerConfig, tierTopic, tierTopicConsumer, producerSupplier, () -> this.internalAdmin(), tierTopicDataLossValidator);
        if (becomeReady) {
            Assertions.assertTrue((boolean)tierTopicManager.tryBecomeReady(false));
        }
        return new Tuple3((Object)tierTopicConsumer, (Object)tierReplicaManager, (Object)tierTopicManager);
    }

    private TierTopicManagerConfig setupTierComponents$default$1() {
        return this.tierTopicManagerConfig();
    }

    private Option<TierTopic> setupTierComponents$default$3() {
        return Option$.MODULE$.empty();
    }

    private LogManager setupTierComponents$default$4() {
        return this.logManager();
    }

    private MockProducerSupplier<byte[], byte[]> setupTierComponents$default$5() {
        return this.producerSupplier();
    }

    private TierTopicConsumer setupTierComponents$default$6() {
        return new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), new LogDirFailureChannel(1)), this.tierStateFetcher(), Optional.empty(), (Time)new org.apache.kafka.common.utils.MockTime());
    }

    private void moveRecordsToAllConsumers() {
        this.primaryConsumerSupplier().moveRecordsFromProducer();
        this.catchupConsumerSupplier().moveRecordsFromProducer();
    }

    private void resendPreviousProduceRequest() {
        MockProducer<byte[], byte[]> mockProducer = this.producerSupplier().producer();
        ProducerRecord lastSentRecord = (ProducerRecord)mockProducer.history().get(mockProducer.history().size() - 1);
        this.producerSupplier().producer().send(lastSentRecord);
        this.moveRecordsToAllConsumers();
    }

    /*
     * WARNING - void declaration
     */
    private void becomeArchiver(TopicIdPartition topicIdPartition, int leaderEpoch, TierTopicManager tierTopicManager, TierTopicConsumer tierTopicConsumer) {
        CompletableFuture becomeArchiverFuture = tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$becomeArchiver$1(this, tierTopicConsumer, becomeArchiverFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting to become archiver");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFuture.get());
    }

    public static final /* synthetic */ void $anonfun$teardown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testAddMetadataBeforeReady$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$1, CompletableFuture future_1$1, CompletableFuture future_2$1) {
        $this.primaryConsumerSupplier().moveRecordsFromProducer();
        tierTopicConsumer$1.doWork();
        return future_1$1.isDone() && future_2$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testAddMetadataBeforeReady$2() {
        return "Timed out waiting for futures to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testDuplicateRequestBeforeReady$2(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$2, CompletableFuture newInitLeaderResult$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$2.doWork();
        return newInitLeaderResult$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testDuplicateRequestBeforeReady$3() {
        return "Timed out waiting to become archiver";
    }

    public static final /* synthetic */ boolean $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$3, CompletableFuture partitionFenceFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$3.doWork();
        return partitionFenceFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2() {
        return "Timed out trying to finish TierPartitionFence";
    }

    public static final /* synthetic */ boolean $anonfun$testSetErrorPartitionsDuringFencing$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$4, CompletableFuture initiateResultFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$4.doWork();
        return initiateResultFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testSetErrorPartitionsDuringFencing$2() {
        return "Timed out trying to finish TierSegmentUploadInitiate";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoverWhileCatchupConsumer$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$5, CompletableFuture uploadCompleteFuture$1, CompletableFuture uploadInitiateFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$5.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            if (uploadCompleteFuture$1.isDone() && uploadInitiateFuture$1.isDone()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRecoverWhileCatchupConsumer$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testHandlingForRestoreOnNonErrorStatus$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$6) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$6.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testHandlingForRestoreOnNonErrorStatus$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$7) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$7.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8, CompletableFuture uploadInitiateFuture$2) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        return uploadInitiateFuture$2.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2() {
        return "Timed out waiting for upload initiate future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$becomeArchiver$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$9, CompletableFuture becomeArchiverFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$9.doWork();
        return becomeArchiverFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$becomeArchiver$2() {
        return "Timed out waiting to become archiver";
    }

    public TierTopicManagerTest() {
        this.clusterId = "mycluster";
        this.brokerId = 3;
        this.cleanupIntervalMs = 0;
    }
}

