/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.AbstractLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1Bqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004A\u0001\u0001\u0006I!\u000e\u0005\b\u0003\u0002\u0011\r\u0011\"\u00015\u0011\u0019\u0011\u0005\u0001)A\u0005k!91\t\u0001b\u0001\n\u0003!\u0005B\u0002'\u0001A\u0003%Q\tC\u0004N\u0001\t\u0007I\u0011\u0001(\t\rU\u0003\u0001\u0015!\u0003P\u0011\u00151\u0006\u0001\"\u0011X\u0011\u001di\u0006A1A\u0005\u0002yCaa\u001a\u0001!\u0002\u0013y\u0006\"\u00025\u0001\t\u0003J\u0007\"\u0002?\u0001\t\u0003j\bBBA\u0003\u0001\u0011\u0005Q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003;\u0003A\u0011BAP\u0011%\ti\u000bAI\u0001\n\u0013\ty\u000bC\u0004\u0002F\u0002!I!a2\u0003;QKWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\(gM2Lg.\u001a+fgRT!AG\u000e\u0002\u000bQ|\u0007/[2\u000b\u0005qi\u0012\u0001\u0002;jKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%;\u000511/\u001a:wKJL!AJ\u0012\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\r\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t\u0019\u0011J\u001c;\u0002\rQ|\u0007/[22+\u0005)\u0004C\u0001\u001c>\u001d\t94\b\u0005\u00029_5\t\u0011H\u0003\u0002;?\u00051AH]8pizJ!\u0001P\u0018\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y=\nq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u0003%!\u0018.\u001a:U_BL7-F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003}\u001d\u000b!\u0002^5feR{\u0007/[2!\u0003\u0015\u0001(o\u001c9t+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*J\u0003\u0011)H/\u001b7\n\u0005Q\u000b&A\u0003)s_B,'\u000f^5fg\u00061\u0001O]8qg\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005a[\u0006C\u0001\u0018Z\u0013\tQvF\u0001\u0003V]&$\b\"\u0002/\f\u0001\u0004y\u0015A\u00039s_B,'\u000f^5fg\u00061Q\r_5uK\u0012,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fa!\u0019;p[&\u001c'B\u00013R\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003M\u0006\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00031*DQa\u001b\bA\u00021\f\u0001\u0002^3ti&sgm\u001c\t\u0003[Zl\u0011A\u001c\u0006\u0003_B\f1!\u00199j\u0015\t\t(/A\u0004kkBLG/\u001a:\u000b\u0005M$\u0018!\u00026v]&$(\"A;\u0002\u0007=\u0014x-\u0003\u0002x]\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u000fsB\u0011QN_\u0005\u0003w:\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001-)\u0005=y\bcA7\u0002\u0002%\u0019\u00111\u00018\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u00049sKB\f'/\u001a$peR+7\u000f^\u0001'i\u0016\u001cH/\u0011:dQ&4XM],iK:$\u0016.\u001a:QCJ$\u0018\u000e^5p]&\u001bxJ\u001a4mS:,Gc\u0001-\u0002\f!1\u0011QB\tA\u0002U\na!];peVl\u0007fB\t\u0002\u0012\u0005u\u0011q\u0004\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u00039\u0002\rA\f'/Y7t\u0013\u0011\tY\"!\u0006\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA\u0011\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\":\u0011#!\n\u00022\u0005M\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\t\u0005-\u0012QC\u0001\taJ|g/\u001b3fe&!\u0011qFA\u0015\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011QGA\u001dC\t\t9$\u0001\u0002{W\u0006\u0012\u00111H\u0001\u0006WJ\fg\r^\u0001\u0019m\u0016\u0014\u0018NZ=NCR,'/[1mSj\fG/[8o\u0019\u0006<Gc\u0001-\u0002B!1\u00111\t\nA\u00025\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0018GJ,\u0017\r^3TK\u000e|g\u000e\u001a+jKJ,G\rV8qS\u000e$\u0002\"!\u0013\u0002b\u0005M\u0014q\u000f\t\u0007]\u0005-S&a\u0014\n\u0007\u00055sF\u0001\u0004UkBdWM\r\t\u0005\u0003#\ni&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0019\u0019w.\\7p]*\u0019a$!\u0017\u000b\u0007\u0005mC/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003?\n\u0019F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\r4\u00031\u0001\u0002f\u0005)\u0011\rZ7j]B!\u0011qMA8\u001b\t\tIG\u0003\u0003\u0002d\u0005-$\u0002BA7\u0003/\nqa\u00197jK:$8/\u0003\u0003\u0002r\u0005%$!B!e[&t\u0007BBA;'\u0001\u0007Q&A\u000bfqB,7\r^3e)&,'\u000fU1si&$\u0018n\u001c8\t\u000f\u0005e4\u00031\u0001\u0002|\u0005Q\u0011m]:jO:lWM\u001c;\u0011\u000b\u0005u\u0014qQ\u0017\u000f\t\u0005}\u00141\u0011\b\u0004q\u0005\u0005\u0015\"\u0001\u0019\n\u0007\u0005\u0015u&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00151\u0012\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0006>\nQcZ3u)&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eF\u0002.\u0003#Cq!a%\u0015\u0001\u0004\t)*\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B!\u0011qSAM\u001b\u0005Y\u0012bAAN7\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u001cCB\u0004XM\u001c3NKN\u001c\u0018mZ3t\u0003:$g+\u001a:jMf$\u0016.\u001a:\u0015\u000fa\u000b\t+!*\u0002*\"1\u00111U\u000bA\u00025\n\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\b\u0003O+\u0002\u0019AA(\u0003\t!\b\u000f\u0003\u0005\u0002,V\u0001\n\u00111\u0001.\u0003-qW/\\*fO6,g\u000e^:\u0002K\u0005\u0004\b/\u001a8e\u001b\u0016\u001c8/Y4fg\u0006sGMV3sS\u001aLH+[3sI\u0011,g-Y;mi\u0012\u001aTCAAYU\ri\u00131W\u0016\u0003\u0003k\u0003B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,A\u0005v]\u000eDWmY6fI*\u0019\u0011qX\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0006e&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)\"/Z1tg&<g\u000eV5feB\u000b'\u000f^5uS>tG\u0003BAe\u0003\u0017\u0004rALA&\u0003w\nY\bC\u0004\u0002d]\u0001\r!!\u001a")
public class TierTopicPartitionOfflineTest
extends BaseRequestTest {
    private final String topic1;
    private final String topic2;
    private final String tierTopic;
    private final Properties props = new Properties();
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 6;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String tierTopic() {
        return this.tierTopic;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.prepareForTest();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.bytes", "1");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiverWhenTierPartitionIsOffline(String quorum) {
        void var5_5;
        void var13_13;
        void var12_12;
        void var4_4;
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), 15000L);
        ConfluentAdmin admin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        Tuple2<List<Object>, List<Object>> tuple2 = this.reassignTierPartition((Admin)admin);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List replicasTierStatePartition0 = (List)tuple2._1();
        List replicasTierStatePartition1 = (List)tuple2._2();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        int leader1 = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)var4_4)}))), this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(tp1);
        AbstractLog log1 = (AbstractLog)((KafkaBroker)this.brokerForId(leader1).get()).replicaManager().getLog(tp1).get();
        int tierStatePartitionForTopic1 = this.getTierTopicPartition((TopicIdPartition)log1.topicIdPartition().get());
        int tierStatePartitionForTopic2 = tierStatePartitionForTopic1 == 0 ? 1 : 0;
        Tuple2<Object, TopicPartition> tuple22 = this.createSecondTieredTopic((Admin)admin, tierStatePartitionForTopic2, (List<Object>)var4_4);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        TopicPartition tp2 = (TopicPartition)tuple22._2();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$1(log1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$2(tp1, leader1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AbstractLog log2 = (AbstractLog)((KafkaBroker)this.brokerForId((int)var12_12).get()).replicaManager().getLog((TopicPartition)var13_13).get();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$3(log2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$4((TopicPartition)var13_13, (int)var12_12));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        var5_5.foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$5(this, (List)var4_4, arg_0)));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "tier topic partition 1 is now offline");
        if (tierStatePartitionForTopic1 == 0) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), tp1.topic(), 100, -1);
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), var13_13.topic(), 100, -1);
            this.verifyMaterializationLag((int)var12_12);
            this.appendMessagesAndVerifyTier(leader1, tp1, 5);
            return;
        }
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), tp1.topic(), 100, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), var13_13.topic(), 100, -1);
        this.verifyMaterializationLag(leader1);
        this.appendMessagesAndVerifyTier((int)var12_12, (TopicPartition)var13_13, 5);
    }

    private void verifyMaterializationLag(int brokerId) {
        MetricName maxListeningMs = ((TierTopicConsumer)((KafkaBroker)this.brokerForId((int)brokerId).get()).replicaManager().tierReplicaComponents().logComponents().topicConsumerOpt().get()).maxListeningMsMetricName;
        DoubleRef curr = DoubleRef.create((double)0.0);
        DoubleRef prev = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            Thread.sleep(5000L);
            prev$1.elem = curr$1.elem;
            curr$1.elem = BoxesRunTime.unboxToDouble((Object)((KafkaBroker)this.brokerForId(brokerId).get()).metrics().metric(maxListeningMs).metricValue());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("curr: ").append(curr$1.elem).append(" prev ").append(prev$1.elem).toString());
            Predef$.MODULE$.assert(curr$1.elem >= prev$1.elem);
        });
    }

    private Tuple2<Object, TopicPartition> createSecondTieredTopic(Admin admin, int expectedTierPartition, List<Object> assignment) {
        boolean done = false;
        int idx = -1;
        int leader = 0;
        ObjectRef name = ObjectRef.create((Object)"");
        while (!done) {
            name.elem = new StringBuilder(1).append(this.topic2()).append("-").append(Integer.toString(++idx)).toString();
            leader = BoxesRunTime.unboxToInt((Object)this.createTopic((String)name.elem, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), assignment)}))), this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            TopicPartition tp = new TopicPartition((String)name.elem, 0);
            this.waitUntilLogCreatedOnBrokers(tp);
            AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leader).get()).replicaManager().getLog(tp).get();
            int toTierPart = this.getTierTopicPartition((TopicIdPartition)log.topicIdPartition().get());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append("Created TopicPartition ").append((String)name$1.elem).append(" that will append metadata to tier partition ").append(toTierPart).append(". Expected tier partition: ").append(expectedTierPartition).toString());
            if (toTierPart != expectedTierPartition) {
                admin.deleteTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)((String)name.elem), (List)Nil$.MODULE$)).asJavaCollection()).all().get(5000L, TimeUnit.MILLISECONDS);
                continue;
            }
            done = true;
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)leader), (Object)new TopicPartition((String)name.elem, 0));
    }

    private int getTierTopicPartition(TopicIdPartition topicIdPartition) {
        return new TierTopicPartitioner(2).partitionId(topicIdPartition);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMessagesAndVerifyTier(int leaderId, TopicPartition tp, int numSegments) {
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(tp).get();
        int numMessages = 50;
        int n = 0;
        long oldLogEndOffset = log.logEndOffset();
        int initTotalSegments = log.numberOfSegments();
        while (log.numberOfSegments() <= initTotalSegments + numSegments) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), tp.topic(), numMessages, -1);
            n += numMessages;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(log.logEndOffset() == oldLogEndOffset + (long)n && log.tierPartitionState().numSegments() >= log.numberOfSegments() - 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$appendMessagesAndVerifyTier$2(tp, leaderId, oldLogEndOffset, log, initTotalSegments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private int appendMessagesAndVerifyTier$default$3() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<List<Object>, List<Object>> reassignTierPartition(Admin admin) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$1(this, admin)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Tier topic was not created within timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.Map tierTopicDesc = (java.util.Map)admin.describeTopics(Collections.singletonList(this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
        List replicasForTierStatePartition0 = CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)((TopicDescription)tierTopicDesc.get(this.tierTopic())).partitions().get(0)).replicas()).asScala().toList().map((Function1 & Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()));
        ListBuffer replicasForTierStatePartition1 = (ListBuffer)new ListBuffer().$plus$plus((IterableOnce)((IterableOnceOps)this.brokers().map((Function1 & Serializable)broker -> BoxesRunTime.boxToInteger((int)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$4(broker)))).toList().filterNot((Function1)(JFunction1.mcZI.sp & Serializable)id -> replicasForTierStatePartition0.contains((Object)BoxesRunTime.boxToInteger((int)id))));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("replicasForTierStatePartition0 ").append(replicasForTierStatePartition0).append(" replicasForTierStatePartition1 ").append(replicasForTierStatePartition1).toString());
        TopicPartition tierPartition1 = new TopicPartition(this.tierTopic(), 1);
        java.util.Map reassignments = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierPartition1), Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicasForTierStatePartition1.toList().map((Function1 & Serializable)id -> TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$7(BoxesRunTime.unboxToInt((Object)id)))).asJava())))}))).asJava();
        admin.alterPartitionReassignments(reassignments).all().get(500L, TimeUnit.MILLISECONDS);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$8(admin)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for reassignment to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$10(this, admin, replicasForTierStatePartition1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Unexpected assignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        return new Tuple2((Object)replicasForTierStatePartition0, (Object)replicasForTierStatePartition1.toList());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverWhenTierPartitionIsOffline$1(AbstractLog log1$1) {
        TierPartitionStatus tierPartitionStatus = log1$1.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testArchiverWhenTierPartitionIsOffline$2(TopicPartition tp1$1, int leader1$1) {
        return new StringBuilder(62).append("Timeout waiting for tier partition status of ").append(tp1$1).append(" to be ONLINE on ").append(leader1$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverWhenTierPartitionIsOffline$3(AbstractLog log2$1) {
        TierPartitionStatus tierPartitionStatus = log2$1.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testArchiverWhenTierPartitionIsOffline$4(TopicPartition tp2$1, int leader2$1) {
        return new StringBuilder(62).append("Timeout waiting for tier partition status of ").append(tp2$1).append(" to be ONLINE on ").append(leader2$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testArchiverWhenTierPartitionIsOffline$5(TierTopicPartitionOfflineTest $this, List replicasTierStatePartition0$1, int id) {
        if (!replicasTierStatePartition0$1.contains((Object)BoxesRunTime.boxToInteger((int)id))) {
            ((KafkaBroker)$this.brokerForId(id).get()).shutdown();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndVerifyTier$1(AbstractLog log$1, long oldLogEndOffset$1, IntRef totalMessages$1) {
        return log$1.logEndOffset() == oldLogEndOffset$1 + (long)totalMessages$1.elem && log$1.tierPartitionState().numSegments() >= log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndVerifyTier$2(TopicPartition tp$1, int leaderId$1, long oldLogEndOffset$1, AbstractLog log$1, int initTotalSegments$1) {
        return new StringBuilder(177).append("Timeout waiting for all messages to be written and tiered for ").append(tp$1).append(". LeaderId=").append(leaderId$1).append(", old logEndOffset: ").append(oldLogEndOffset$1).append(", new logEndOffset: ").append(log$1.logEndOffset()).append(", ").append("old numOfSegments: ").append(initTotalSegments$1).append(", new numOfSegments: ").append(log$1.numberOfSegments()).append(", tiered numSegments: ").append(log$1.tierPartitionState().numSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$1(TierTopicPartitionOfflineTest $this, Admin admin$1) {
        try {
            admin$1.describeTopics(Collections.singletonList($this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$2() {
        return "Tier topic was not created within timeout";
    }

    public static final /* synthetic */ int $anonfun$reassignTierPartition$4(KafkaBroker broker) {
        return broker.config().brokerId();
    }

    public static final /* synthetic */ Integer $anonfun$reassignTierPartition$7(int id) {
        return BoxesRunTime.boxToInteger((int)id);
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$8(Admin admin$1) {
        return ((java.util.Map)admin$1.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$9() {
        return "Timed out waiting for reassignment to complete";
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$10(TierTopicPartitionOfflineTest $this, Admin admin$1, ListBuffer replicasForTierStatePartition1$1) {
        java.util.Map tierTopicDesc = (java.util.Map)admin$1.describeTopics(Collections.singletonList($this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
        List list = replicasForTierStatePartition1$1.toList();
        List list2 = CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)((TopicDescription)tierTopicDesc.get($this.tierTopic())).partitions().get(1)).replicas()).asScala().toList().map((Function1 & Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()));
        return !(list != null ? !list.equals(list2) : list2 != null);
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$12() {
        return "Unexpected assignment";
    }

    public TierTopicPartitionOfflineTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
        this.tierTopic = "_confluent-tier-state";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataMaxPollMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierArchiverNumThreadsProp(), "1");
        this.exited = new AtomicBoolean(false);
    }
}

