/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AbstractLog;
import kafka.log.LogManager$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001C\u0011\u0019i\u0005\u0001)A\u0005\u0007\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002,\u0001A\u0003%\u0001\u000bC\u0004X\u0001\t\u0007I\u0011A(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u001dI\u0006A1A\u0005\u0002=CaA\u0017\u0001!\u0002\u0013\u0001\u0006bB.\u0001\u0005\u0004%\ta\u0014\u0005\u00079\u0002\u0001\u000b\u0011\u0002)\t\u000fu\u0003!\u0019!C\u0001\u001f\"1a\f\u0001Q\u0001\nACqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004o\u0001\u0001\u0006I!\u0019\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0011\u0019!\b\u0001)A\u0005c\"9Q\u000f\u0001b\u0001\n\u00031\bB\u0002>\u0001A\u0003%q\u000fC\u0004|\u0001\t\u0007I\u0011\u0001?\t\u000f\u0005E\u0001\u0001)A\u0005{\"Y\u00111\u0003\u0001A\u0002\u0003\u0007I\u0011AA\u000b\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%\t!a\t\t\u0017\u0005=\u0002\u00011A\u0001B\u0003&\u0011q\u0003\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tY\u0004\u0001C\u0001\u0003gAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002X\u0001!\t!a\u0010\t\u000f\u0005e\u0003\u0001\"\u0001\u0002@!9\u00111\r\u0001\u0005\u0002\u0005}\u0002bBA7\u0001\u0011\u0005\u0011q\b\u0005\b\u0003c\u0002A\u0011AA \u0011\u001d\t)\b\u0001C\u0001\u0003\u007fAq!!\u001f\u0001\t\u0003\ty\u0004C\u0004\u0002~\u0001!\t!a\u0010\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002@!9\u0011Q\u0011\u0001\u0005\u0002\u0005}\u0002bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003W\u0003A\u0011AA \u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a2\u0001\t\u0013\tI\rC\u0004\u0002R\u0002!I!a5\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAz\u0001\u0011%\u0011q\b\u0002\u0014\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR+7\u000f\u001e\u0006\u0003eM\nQ\u0001^8pYNT\u0011\u0001N\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0007\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0002\"\u0001\u0011\u0001\u000e\u0003E\na\u0001^7q\t&\u0014X#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015AA5p\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013aC:fO6,g\u000e\u001e(b[\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u001e\u000bA\u0001\\1oO&\u0011QK\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019M,w-\\3oi:\u000bW.\u001a\u0011\u0002\u00171|wMR5mKB\u000bG\u000f[\u0001\rY><g)\u001b7f!\u0006$\b\u000eI\u0001\rg:\f\u0007o\u001d5piB\u000bG\u000f[\u0001\u000eg:\f\u0007o\u001d5piB\u000bG\u000f\u001b\u0011\u0002\u001b%tG-\u001a=GS2,\u0007+\u0019;i\u00039Ig\u000eZ3y\r&dW\rU1uQ\u0002\n\u0011\u0003^5nK&sG-\u001a=GS2,\u0007+\u0019;i\u0003I!\u0018.\\3J]\u0012,\u0007PR5mKB\u000bG\u000f\u001b\u0011\u0002\tQLW.Z\u000b\u0002CB\u0011!\r\\\u0007\u0002G*\u0011A-Z\u0001\u0005kRLGN\u0003\u0002gO\u000611/\u001a:wKJT!\u0001\u000e5\u000b\u0005%T\u0017AB1qC\u000eDWMC\u0001l\u0003\ry'oZ\u0005\u0003[\u000e\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u000fG2,\u0017M\\;q\t\u0016d\u0017-_'t+\u0005\t\bC\u0001\u001ds\u0013\t\u0019\u0018H\u0001\u0003M_:<\u0017aD2mK\u0006tW\u000f\u001d#fY\u0006LXj\u001d\u0011\u0002#\rdW-\u00198va&sG/\u001a:wC2l5/F\u0001x!\tA\u00040\u0003\u0002zs\t\u0019\u0011J\u001c;\u0002%\rdW-\u00198va&sG/\u001a:wC2l5\u000fI\u0001\bE\u0006$8\r[3t+\u0005i\b#\u0002@\u0002\b\u0005-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\b[V$\u0018M\u00197f\u0015\r\t)!O\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0005\u007f\nY\u0011I\u001d:bs\n+hMZ3s!\r\u0001\u0015QB\u0005\u0004\u0003\u001f\t$!\u0003\"bi\u000eD\u0017J\u001c4p\u0003!\u0011\u0017\r^2iKN\u0004\u0013a\u00017pOV\u0011\u0011q\u0003\t\u0005\u00033\ti\"\u0004\u0002\u0002\u001c)\u0019\u00111C\u001a\n\t\u0005}\u00111\u0004\u0002\f\u0003\n\u001cHO]1di2{w-A\u0004m_\u001e|F%Z9\u0015\t\u0005\u0015\u00121\u0006\t\u0004q\u0005\u001d\u0012bAA\u0015s\t!QK\\5u\u0011%\ti#GA\u0001\u0002\u0004\t9\"A\u0002yIE\nA\u0001\\8hA\u0005y1\r[3dWN,X.\u00128bE2,G-\u0006\u0002\u00026A\u0019\u0001(a\u000e\n\u0007\u0005e\u0012HA\u0004C_>dW-\u00198\u0002%\u0019$\bo]\"mK\u0006tW\u000f]#oC\ndW\rZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003KA3!HA\"!\u0011\t)%a\u0015\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n1!\u00199j\u0015\u0011\ti%a\u0014\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\u000b6\u0002\u000b),h.\u001b;\n\t\u0005U\u0013q\t\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001E1eINKW\u000e\u001d7f%\u0016\u001cwN\u001d3t\u0003!!X-\u0019:E_^t\u0007fA\u0010\u0002^A!\u0011QIA0\u0013\u0011\t\t'a\u0012\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\t;fgR\u0014\u0015\r^2i\u0003:$'+Z2pe\u0012lU\r^1eCR\fw*\u001e;qkRD3\u0001IA4!\u0011\t)%!\u001b\n\t\u0005-\u0014q\t\u0002\u0005)\u0016\u001cH/\u0001\tuKN$\bK]5oi\u0012\u000bG/\u0019'pO\"\u001a\u0011%a\u001a\u0002/Q,7\u000f\u001e#v[BLe\u000eZ3y\u001b&\u001cX.\u0019;dQ\u0016\u001c\bf\u0001\u0012\u0002h\u00059B/Z:u\tVl\u0007\u000fV5nK&sG-\u001a=FeJ|'o\u001d\u0015\u0004G\u0005\u001d\u0014A\u0007;fgR$U/\u001c9US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0007f\u0001\u0013\u0002h\u00059B/Z:u\tVl\u0007/T3uC\u0012\fG/\u0019*fG>\u0014Hm\u001d\u0015\u0004K\u0005\u001d\u0014\u0001\u0007;fgR$U/\u001c9NKR\fG-\u0019;b':\f\u0007o\u001d5pi\"\u001aa%a\u001a\u0002%Q,7\u000f\u001e#v[B,U\u000e\u001d;z\u0013:$W\r\u001f\u0015\u0004O\u0005\u001d\u0014A\u0005:v]\u0012+X\u000e\u001d'pON+w-\\3oiN$B!!$\u0002\"B!\u0011qRAO\u001d\u0011\t\t*!'\u0011\u0007\u0005M\u0015(\u0004\u0002\u0002\u0016*\u0019\u0011qS\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tY*O\u0001\u0007!J,G-\u001a4\n\u0007U\u000byJC\u0002\u0002\u001cfBq!a))\u0001\u0004\t)+\u0001\u0003be\u001e\u001c\b#\u0002\u001d\u0002(\u00065\u0015bAAUs\t)\u0011I\u001d:bs\u0006qB/Z:u!JLg\u000e\u001e#bi\u0006dun\u001a)beRL\u0017\r\u001c\"bi\u000eDWm\u001d\u0015\u0004S\u0005\u001d\u0014!\u0005:fC\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR!\u00111WA]!\u0015A\u0014QWAG\u0013\r\t9,\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005m&\u00061\u0001\u0002>\u0006)A.\u001b8fgB1\u0011qXAb\u0003\u001bk!!!1\u000b\u0005\u0011<\u0015\u0002BAc\u0003\u0003\u0014A\u0002T5ti&#XM]1u_J\fqC]3bIB\u000b'\u000f^5bY\n\u000bGo\u00195fg\nKH/Z:\u0015\u000b]\fY-!4\t\u000f\u0005m6\u00061\u0001\u0002>\"1\u0011qZ\u0016A\u0002]\fQ\u0001\\5nSR\fAbY8v]R\u0014\u0015\r^2iKN$2a^Ak\u0011\u001d\tY\f\fa\u0001\u0003{\u000b\u0001C]3bI\n\u000bGo\u00195SK\u000e|'\u000fZ:\u0015\t\u0005m\u00171\u001d\t\u0007\u0003;\fy.!$\u000e\u0005\u0005\r\u0011\u0002BAq\u0003\u0007\u00111aU3r\u0011\u001d\tY,\fa\u0001\u0003{\u000b1\u0003]1sg\u0016lU\r^1eCR\fg)[3mIN$B!!;\u0002pBA\u0011qRAv\u0003\u001b\u000bi)\u0003\u0003\u0002n\u0006}%aA'ba\"9\u0011\u0011\u001f\u0018A\u0002\u00055\u0015\u0001\u00027j]\u0016\f1$Y:tKJ$H)^7q\u0019><'+Z2pe\u0012lU\r^1eCR\f\u0007")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka");
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean ftpsCleanupEnabled() {
        return false;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        props.setProperty("confluent.tier.enable", "true");
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some(Mockito.mock(TierTopicConsumer.class)), (Option)new Some(Mockito.mock(TierObjectStore.class)), new TierPartitionStateFactory(true, this.checksumEnabled(), true, new TierPartitionStateCleanupConfig(this.ftpsCleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), true, 0), (Option)None$.MODULE$);
        Metrics metrics = new Metrics();
        LogManager$.MODULE$.createProducerStateSensors(metrics);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        None$ x$15 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        ChecksumParams x$18 = ChecksumParams.EMPTY;
        None$ x$19 = None$.MODULE$;
        LogOffsetsListener x$20 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        this.log_$eq((AbstractLog)MergedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, metrics, (Time)x$6, 300000, x$10, x$11, (Option)x$19, x$12, tierLogComponents, true, (Option)x$15, true, x$20, (Option)x$17, x$21, x$18));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            AbstractLog qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toSeq().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var8_5 = null;
            simpleRecordArray = null;
            MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.log(), (String)"AbstractLog");
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        AbstractLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var36_4 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        AbstractLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        Object var39_13 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$7 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, 3, x$9, x$10, x$11, x$12);
        AbstractLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var42_22 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, 3, x$15, x$16, x$17, x$18);
        AbstractLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var45_33 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$19 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        VerificationGuard x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, 3, x$21, x$22, x$23, x$24);
        AbstractLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.GZIP;
        Object var51_44 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$25 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        VerificationGuard x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, 5, x$27, x$28, x$29, x$30);
        AbstractLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        VerificationGuard x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, 7, AppendOrigin.COORDINATOR, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpTierPartitionState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.log().topicPartition().topic(), UUID.randomUUID(), this.log().topicPartition().partition());
        AbstractLog qual$1 = this.log();
        Uuid x$1 = topicIdPartition.kafkaTopicId();
        int x$2 = qual$1.assignTopicId$default$2();
        qual$1.assignTopicId(x$1, x$2);
        this.log().tierPartitionState().beginCatchup();
        this.log().tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.empty()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.log().tierPartitionState().append((AbstractTierMetadata)new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 1L, 1500L, 100L, 100, true, false, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), OpaqueData.ZEROED), new OffsetAndEpoch(1L, Optional.empty())));
        this.log().tierPartitionState().flush();
        String suffix = this.checksumEnabled() ? Algorithm.ADLER.suffix : Algorithm.NO_CHECKSUM.suffix;
        String[] stringArray = new String[2];
        stringArray[0] = "--files";
        stringArray[1] = new StringBuilder(0).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, "").getAbsolutePath()).append(suffix).toString();
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments(stringArray), topicIdPartition);
        String[] stringArray2 = new String[2];
        stringArray2[0] = "--files";
        stringArray2[1] = new StringBuilder(8).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, "").getAbsolutePath()).append(".mutable").append(suffix).toString();
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments(stringArray2), topicIdPartition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_records;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        String x$12 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$13 = 60000L;
        boolean x$14 = false;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        File x$23 = this.logDir();
        BrokerTopicStats x$25 = new BrokerTopicStats();
        MockScheduler x$26 = mockTime.scheduler;
        ChecksumParams x$28 = ChecksumParams.EMPTY;
        long x$29 = 0L;
        long x$30 = 0L;
        int x$31 = 300000;
        ProducerStateManagerConfig x$32 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$33 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        TierLogComponents x$34 = TierLogComponents$.MODULE$.EMPTY();
        LogDirFailureChannel x$35 = new LogDirFailureChannel(10);
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        this.log_$eq((AbstractLog)LogTestUtils$.MODULE$.createLog(x$23, logConfig, x$25, (Scheduler)x$26, (Time)mockTime, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, x$28));
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        AbstractLog qual$1 = this.log();
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var76_42 = null;
        MemoryRecords x$41 = MemoryRecords.withRecords((byte)2, (CompressionType)withRecords_compressionType, (SimpleRecord[])records);
        AppendOrigin x$43 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$44 = qual$1.appendAsLeader$default$4();
        RequestLocal x$45 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$46 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$41, 1, x$43, x$44, x$45, x$46);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        AbstractLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        CompressionType withRecords_compressionType2 = CompressionType.NONE;
        Object var77_53 = null;
        simpleRecordArray = null;
        MemoryRecords x$47 = MemoryRecords.withRecords((byte)2, (CompressionType)withRecords_compressionType2, (SimpleRecord[])withRecords_records);
        AppendOrigin x$49 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$50 = qual$2.appendAsLeader$default$4();
        RequestLocal x$51 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$52 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$47, 2, x$49, x$50, x$51, x$52);
        AbstractLog qual$3 = this.log();
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var79_60 = null;
        MemoryRecords x$53 = MemoryRecords.withRecords((byte)2, (CompressionType)withRecords_compressionType3, (SimpleRecord[])records);
        AppendOrigin x$55 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$56 = qual$3.appendAsLeader$default$4();
        RequestLocal x$57 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$58 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$53, 2, x$55, x$56, x$57, x$58);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), new Metrics(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1), KafkaMetadataLog$.MODULE$.apply$default$8(), KafkaMetadataLog$.MODULE$.apply$default$9());
        int lastContainedLogTimestamp = 10000;
        try (AutoCloseable resource_resource = (AutoCloseable)RecordsSnapshotWriter.createWithHeader(() -> metadataLog.createNewSnapshot(new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE).get();){
            SnapshotWriter snapshotWriter = (SnapshotWriter)resource_resource;
            DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2((Seq)metadataRecords, snapshotWriter);
        }
        Object var5_4 = null;
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"));
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"));
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        System.setOut(System.out);
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = Arrays.asList(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = (FetchDataInfo)this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true, false);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    private static final void validate$1(String output, TopicIdPartition topicIdPartition$1) {
        Object[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps(lines), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("Header"))).get()).contains(topicIdPartition$1.topicIdAsBase64()));
        Assertions.assertTrue((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps(lines), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("SEGMENT_UPLOAD_INITIATE"))));
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        snapshotWriter.append(CollectionConverters$.MODULE$.SeqHasAsJava(metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$18)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$20)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
        this.cleanupIntervalMs = 0;
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }
}

