/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.RestorePartitionOperator;
import kafka.server.Defaults$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.OpaqueData;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\u0002yBQA\u0011\u0001\u0005\u0002yBQa\u0011\u0001\u0005\u0002yBQ\u0001\u0012\u0001\u0005\u0002\u0015CQA\u0014\u0001\u0005\u0002yBQa\u0014\u0001\u0005\u0002ACq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004Z\u0001\u0001\u0006IA\u0016\u0005\b5\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019Y\u0006\u0001)A\u0005#\"9A\f\u0001b\u0001\n\u0003i\u0006BB6\u0001A\u0003%a\fC\u0004m\u0001\t\u0007I\u0011A7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u001d\u0011\bA1A\u0005\u0002MDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003{\u0011!\t)\u0001\u0001b\u0001\n\u0003I\bbBA\u0004\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"a\t\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003K\u0001!\u0019!C\u0001\u0003OA\u0001\"!\r\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003g\u0001!\u0019!C\u0001\u0003kA\u0001\"!\u0013\u0001A\u0003%\u0011q\u0007\u0005\n\u0003\u0017\u0002!\u0019!C\u0001\u0003\u001bB\u0001\"a\u0018\u0001A\u0003%\u0011q\n\u0005\t\u0013\u0002\u0011\r\u0011\"\u0001\u0002b!A\u0011\u0011\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0001\u0002n!A\u0011Q\u000f\u0001!\u0002\u0013\ty\u0007C\u0005\u0002x\u0001\u0011\r\u0011\"\u0001\u0002z!A\u0011\u0011\u0011\u0001!\u0002\u0013\tY\bC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002\u0006\"9\u0011Q\u0016\u0001\u0005\u0002\u0005\u0015\u0005bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\tI\u000f\u0001C\u0005\u0003WD\u0001B!\u0002\u0001\u0005\u0004%I!\u0016\u0005\b\u0005\u000f\u0001\u0001\u0015!\u0003W\u0005u\u0011Vm\u001d;pe\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3UKN$(B\u0001\u00180\u0003\u0015!xn\u001c7t\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0003\u0001M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001<!\ta\u0004!D\u0001.\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$W#A \u0011\u0005Q\u0002\u0015BA!6\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0004^5fe\u000ecW-\u00198fe\u001a+\u0017\r^;sK\u0016s\u0017M\u00197fI\u00069C/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u00072,\u0017M\\;q\r\u0016\fG/\u001e:f\u000b:\f'\r\\3e\u00035\u0019G.Z1okB\u001cuN\u001c4jOV\ta\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)1\u000f^1uK*\u00111jL\u0001\u0005i&,'/\u0003\u0002N\u0011\nyB+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u00072,\u0017M\\;q\u0007>tg-[4\u0002CQLWM\u001d)beRLG/[8o'R\fG/Z*oCB\u001c\bn\u001c;F]\u0006\u0014G.\u001a3\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012!\u0015\t\u0003iIK!aU\u001b\u0003\u0007%sG/\u0001\bdY\u0016\fg.\u001e9EK2\f\u00170T:\u0016\u0003Y\u0003\"\u0001N,\n\u0005a+$\u0001\u0002'p]\u001e\fqb\u00197fC:,\b\u000fR3mCfl5\u000fI\u0001\u0012G2,\u0017M\\;q\u0013:$XM\u001d<bY6\u001b\u0018AE2mK\u0006tW\u000f]%oi\u0016\u0014h/\u00197Ng\u0002\n\u0011c\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5n+\u0005q\u0006CA0j\u001b\u0005\u0001'BA1c\u0003!\u0019\u0007.Z2lgVl'BA2e\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001M3\u000b\u0005\u0019<\u0017!C2p]\u001adW/\u001a8u\u0015\u0005A\u0017AA5p\u0013\tQ\u0007MA\u0005BY\u001e|'/\u001b;i[\u0006\u00112\r[3dWN,X.\u00117h_JLG\u000f[7!\u0003A\u0019X\u000f]3s\u00052|7m\u001b'f]\u001e$\b.F\u0001o!\t!t.\u0003\u0002qk\t)1\u000b[8si\u0006\t2/\u001e9fe\ncwnY6MK:<G\u000f\u001b\u0011\u0002\u000f\u0019\f7\r^8ssV\tA\u000f\u0005\u0002Hk&\u0011a\u000f\u0013\u0002\u001a)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u00180\u0001\u0005gC\u000e$xN]=!\u0003%\u0001\u0018M]3oi\u0012K'/F\u0001{!\tYx0D\u0001}\u0015\tAWPC\u0001\u007f\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0005AP\u0001\u0003GS2,\u0017A\u00039be\u0016tG\u000fR5sA\u0005\u0019A-\u001b:\u0002\t\u0011L'\u000fI\u0001\u0003iB,\"!!\u0004\u0011\t\u0005=\u0011qD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u000511m\\7n_:T1\u0001MA\f\u0015\u0011\tI\"a\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti\"A\u0002pe\u001eLA!!\t\u0002\u0012\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005!A\u000f]5e+\t\tI\u0003\u0005\u0003\u0002,\u00055R\"\u0001&\n\u0007\u0005=\"J\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006)A\u000f]5eA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\"!a\u000e\u0011\t\u0005e\u0012QI\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005\u0019An\\4\u000b\t\u0005\u0005\u00131I\u0001\nS:$XM\u001d8bYNT1aYA\u000b\u0013\u0011\t9%a\u000f\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\nA\u0001^5nKV\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011)H/\u001b7\u000b\t\u0005e\u0013QC\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005u\u00131\u000b\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fAU\u0011\u00111\r\t\u0004\u000f\u0006\u0015\u0014bAA4\u0011\n1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-\u0001\u0004ti\u0006$X\rI\u0001\nY><7i\u001c8gS\u001e,\"!a\u001c\u0011\t\u0005e\u0012\u0011O\u0005\u0005\u0003g\nYDA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002%\r|gN\u001a7vK:$Hj\\4D_:4\u0017nZ\u000b\u0003\u0003w\u0002B!!\u000f\u0002~%!\u0011qPA\u001e\u0005I\u0019uN\u001c4mk\u0016tG\u000fT8h\u0007>tg-[4\u0002'\r|gN\u001a7vK:$Hj\\4D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005\u001d\u0005c\u0001\u001b\u0002\n&\u0019\u00111R\u001b\u0003\tUs\u0017\u000e\u001e\u0015\u0004I\u0005=\u0005\u0003BAI\u0003?k!!a%\u000b\t\u0005U\u0015qS\u0001\u0004CBL'\u0002BAM\u00037\u000bqA[;qSR,'O\u0003\u0003\u0002\u001e\u0006m\u0011!\u00026v]&$\u0018\u0002BAQ\u0003'\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007fA\u0013\u0002(B!\u0011\u0011SAU\u0013\u0011\tY+a%\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0006;fgR,\u0006\u000fZ1uKN+w-\\3oiN#\u0018\r^3)\u0007\u0019\n\t\f\u0005\u0003\u0002\u0012\u0006M\u0016\u0002BA[\u0003'\u0013A\u0001V3ti\u0006AR\u000f\u001d7pC\u0012Le.\u001b;bi\u0016\fe\u000eZ\"p[BdW\r^3\u0015\u001d\u0005\u001d\u00151XA`\u0003\u001b\f\t.!6\u0002Z\"1\u0011QX\u0014A\u0002E\u000bQ!\u001a9pG\"Dq!!1(\u0001\u0004\t\u0019-\u0001\u0005pE*,7\r^%e!\u0011\t)-!3\u000e\u0005\u0005\u001d'bAA+{&!\u00111ZAd\u0005\u0011)V+\u0013#\t\r\u0005=w\u00051\u0001W\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\r\u0005Mw\u00051\u0001W\u0003%)g\u000eZ(gMN,G\u000f\u0003\u0004\u0002X\u001e\u0002\r!U\u0001\u0005g&TX\r\u0003\u0004\u0002\\\u001e\u0002\rAV\u0001\r[\u0006DH+[7fgR\fW\u000e]\u0001\u001aI\u0016dW\r^3J]&$\u0018.\u0019;f\u0003:$7i\\7qY\u0016$X\r\u0006\u0005\u0002\b\u0006\u0005\u00181]As\u0011\u0019\ti\f\u000ba\u0001#\"9\u0011\u0011\u0019\u0015A\u0002\u0005\r\u0007BBAtQ\u0001\u0007a+\u0001\teK2,G/Z\"p[BdW\r^3Ug\u0006\u0001r-\u001a;US\u0016\u00148\u000b^1uK\u001aKG.\u001a\u000b\u0005\u0003[\u0014\u0019\u0001\u0005\u0003\u0002p\u0006uh\u0002BAy\u0003s\u00042!a=6\u001b\t\t)PC\u0002\u0002xF\na\u0001\u0010:p_Rt\u0014bAA~k\u00051\u0001K]3eK\u001aLA!a@\u0003\u0002\t11\u000b\u001e:j]\u001eT1!a?6\u0011\u0019\t)!\u000ba\u0001u\u0006\trN\\3NS:,H/Z%o\u001b&dG.[:\u0002%=tW-T5okR,\u0017J\\'jY2L7\u000f\t")
public class RestoreTierPartitionStateTest {
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final Algorithm checksumAlgorithm = this.checksumEnabled() ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    private final short superBlockLength = (short)(this.checksumEnabled() ? 512 : 0);
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled(), this.tierCleanerFeatureEnabled(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
    private final File parentDir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.parentDir(), "kafka");
    private final TopicPartition tp;
    private final TopicIdPartition tpid;
    private final LogDirFailureChannel logDirFailureChannel;
    private final MockTime time;
    private final FileTierPartitionState state;
    private final LogConfig logConfig;
    private final ConfluentLogConfig confluentLogConfig;
    private final long oneMinuteInMillis;

    public boolean checksumEnabled() {
        return false;
    }

    public boolean tierCleanerFeatureEnabled() {
        return false;
    }

    public boolean tierPartitionStateCleanupFeatureEnabled() {
        return false;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return new TierPartitionStateCleanupConfig(this.tierPartitionStateCleanupFeatureEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs());
    }

    public boolean tierPartitionStateSnapshotEnabled() {
        return false;
    }

    public int brokerId() {
        return 0;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public ConfluentLogConfig confluentLogConfig() {
        return this.confluentLogConfig;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = RestoreTierPartitionStateTest.$anonfun$setup$2(this, op);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().confluentLogConfig()).thenReturn((Object)this.confluentLogConfig());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.confluentLogConfig().tierEnable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void testUpdateSegmentState() {
        int epoch = 3;
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        long start = System.currentTimeMillis();
        LongRef timestamp = LongRef.create((long)start);
        ArrayBuffer objectIds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int endOffset = baseOffset$1.elem + numOffsetsInSegment;
            UUID objectId = UUID.randomUUID();
            objectIds.$plus$eq((Object)objectId);
            this.uploadInitateAndComplete(epoch, objectId, baseOffset$1.elem, endOffset, 100, timestamp$1.elem);
            timestamp$1.elem += this.oneMinuteInMillis();
            baseOffset$1.elem = endOffset + 1;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.deleteInitiateAndComplete(epoch, (UUID)objectIds.apply(i), start));
        this.state().close();
        RestorePartitionOperator restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        FtpsSegmentView operatorContext = restoreOperator.operatorContext();
        long headerSize = operatorContext.header().size();
        Assertions.assertEquals((long)150L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((int)3, (int)operatorContext.segmentStateMap().size());
        Assertions.assertEquals((int)2, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)1, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        Map pathmap = CollectionConverters$.MODULE$.MapHasAsScala(restoreOperator.restore()).asScala();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)2, (int)pathmap.size());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> Assertions.assertTrue((boolean)pathmap.keySet().contains(objectIds.apply(index))));
        restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        operatorContext = restoreOperator.operatorContext();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)0, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)3, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.tierCleanerFeatureEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.tierPartitionStateCleanupFeatureEnabled(), start);
        reopenedState.close();
    }

    private void uploadInitateAndComplete(int epoch, UUID objectId, long startOffset, long endOffset, int size, long maxTimestamp) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, startOffset, endOffset, maxTimestamp, -1L, size, false, false, false, TierUploadType.Archive, stateOffset, OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void deleteInitiateAndComplete(int epoch, UUID objectId, long deleteCompleteTs) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId, stateOffset, deleteCompleteTs), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private String getTierStateFile(File dir) {
        Object object = new Object();
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)file -> {
                RestoreTierPartitionStateTest.$anonfun$getTierStateFile$1(object, file);
                return BoxedUnit.UNIT;
            });
            return null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (String)ex.value();
            }
            throw ex;
        }
    }

    private long oneMinuteInMillis() {
        return this.oneMinuteInMillis;
    }

    public static final /* synthetic */ String $anonfun$setup$2(RestoreTierPartitionStateTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$getTierStateFile$1(Object nonLocalReturnKey1$1, File file) {
        if (file.isFile() && MergedLog$.MODULE$.isTierStateFile(file)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)file.getAbsolutePath());
        }
    }

    public RestoreTierPartitionStateTest() {
        this.cleanupIntervalMs = 0;
        File parseTopicPartitionName_dir = this.dir();
        Object var1_1 = null;
        this.tp = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
        this.logDirFailureChannel = new LogDirFailureChannel(5);
        this.time = new MockTime();
        this.state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.tierCleanerFeatureEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        this.logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        this.confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        this.oneMinuteInMillis = 60000L;
    }
}

