/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0005\u000b\u00013!)A\u0005\u0001C\u0001K!9q\u0005\u0001b\u0001\n\u0003A\u0003BB\u001a\u0001A\u0003%\u0011\u0006C\u00035\u0001\u0011\u0005Q\u0007C\u0003G\u0001\u0011\u0005Q\u0007C\u0003I\u0001\u0011\u0005Q\u0007C\u0003K\u0001\u0011\u0005Q\u0007C\u0003M\u0001\u0011\u0005Q\u0007C\u0003O\u0001\u0011\u0005Q\u0007C\u0003Q\u0001\u0011\u0005Q\u0007C\u0003S\u0001\u0011\u0005Q\u0007C\u0003U\u0001\u0011\u0005Q\u0007C\u0003W\u0001\u0011\u0005Q\u0007C\u0003Y\u0001\u0011\u0005Q\u0007C\u0003[\u0001\u0011\u0005Q\u0007C\u0003]\u0001\u0011\u0005Q\u0007C\u0003_\u0001\u0011\u0005Q\u0007C\u0003a\u0001\u0011\u0005QGA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003+Y\tQ!\u001e;jYNT\u0011aF\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\u000b\n\u0005\r\"\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"!\t\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0015\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013!\u0002:fO\u0016D(B\u0001\u00180\u0003\u0011)H/\u001b7\u000b\u0003A\nAA[1wC&\u0011!g\u000b\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u00017!\tYr'\u0003\u000299\t!QK\\5uQ\t!!\b\u0005\u0002<\t6\tAH\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005}\u0002\u0015a\u00026va&$XM\u001d\u0006\u0003\u0003\n\u000bQA[;oSRT\u0011aQ\u0001\u0004_J<\u0017BA#=\u0005\u0011!Vm\u001d;\u0002\u001bQ,7\u000f\u001e*fC\u0012\u0014\u0015\u0010^3tQ\t)!(A\u0007uKN$X\nZ\u001bTiJLgn\u001a\u0015\u0003\ri\nq\u0001^3ti\u0006\u00137\u000f\u000b\u0002\bu\u0005YA/Z:u\u0007N4H*[:uQ\tA!(\u0001\u0006uKN$8i\u001d<NCBD#!\u0003\u001e\u0002\u0015Q,7\u000f^%o\u0019>\u001c7\u000e\u000b\u0002\u000bu\u0005YB/Z:u+Jd7+\u00194f\u0005\u0006\u001cXM\u000e\u001bF]\u000e|G-Z+V\u0013\u0012C#a\u0003\u001e\u00021Q,7\u000f^$f]\u0016\u0014\u0018\r^3Vk&$\u0017i\u001d\"bg\u00164D\u0007\u000b\u0002\ru\u0005)B/Z:u\u0003R|W.[2HKR|%/\u00169eCR,\u0007FA\u0007;\u0003\r#Xm\u001d;DYV\u001cH/\u001a:MS:\\Gj\\2bYJ+g/\u001a:tK\u000e{gN\\3di&|g\u000eT5ti\u0016tWM]'baV\u001bXm]*qK\u000eLg-[3e\u0007>tg-[4)\u00059Q\u0014a\u000f;fgR\u001cE.^:uKJd\u0015N\\6M_\u000e\fGNU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0019&\u001cH/\u001a8fe6\u000b\u0007/V:fg\u0012+g-Y;mi\"\u0012qBO\u0001Gi\u0016\u001cHo\u00117vgR,'\u000fT5oW2{7-\u00197SKZ,'o]3D_:tWm\u0019;j_:d\u0015n\u001d;f]\u0016\u0014X*\u00199IC:$G.Z:Es:\fW.[2MSN$XM\\3sQ\t\u0001\"(A)uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u0019>\u001c\u0017\r\u001c*fm\u0016\u00148/Z\"p]:,7\r^5p]2K7\u000f^3oKJl\u0015\r\u001d+ie><8/\u0012=dKB$\u0018n\u001c8G_Jl\u0015n]:j]\u001ed\u0015n\u001d;f]\u0016\u0014\bFA\t;\u0003y#Xm\u001d;DYV\u001cH/\u001a:MS:\\Gj\\2bYJ+g/\u001a:tK\u000e{gN\\3di&|g\u000eT5ti\u0016tWM]'baRC'o\\<t\u000bb\u001cW\r\u001d;j_:4uN]+oW:|wO\u001c'jgR,g.\u001a:CK&tw-T1qa\u0016$Gk\u001c\u0015\u0003%i\u0002")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, (Logging)this, Level.INFO);
    }

    @Test
    public void testReadBytes() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"abcd", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)testCase -> {
            CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMd5String() {
        ByteBuffer buf = ByteBuffer.wrap("mystring".getBytes("utf-8"));
        Assertions.assertEquals((Object)"FpMZUBJhxkSlhhD5Z+j50A==", (Object)CoreUtils$.MODULE$.toBase64(CoreUtils$.MODULE$.md5hash(buf)));
    }

    @Test
    public void testAbs() {
        Assertions.assertEquals((int)0, (int)Utils.abs((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)-1));
        Assertions.assertEquals((int)0, (int)Utils.abs((int)0));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(null);
        scala.collection.immutable.Seq emptyStringList = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Assertions.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assertions.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assertions.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assertions.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$1(m);
            return BoxedUnit.UNIT;
        });
        String singleEntry = "key:value";
        Assertions.assertTrue((boolean)CoreUtils$.MODULE$.parseCsvMap(singleEntry).getOrElse((Object)"key", (Function0)(JFunction0.mcI.sp & Serializable)() -> 0).equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$3(m);
            return BoxedUnit.UNIT;
        });
        String kvPairsSpaces = "key:value      , key:   value";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$4(m);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)CoreUtils$.MODULE$.inLock((Lock)lock, (Function0)(JFunction0.mcI.sp & Serializable)() -> {
            Assertions.assertTrue((boolean)lock.isHeldByCurrentThread(), (String)"Should be in lock");
            return 2;
        }));
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertFalse((boolean)lock.isLocked(), (String)"Should be unlocked");
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assertions.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assertions.assertEquals((int)clusterId1.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assertions.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assertions.assertEquals((int)clusterId2.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assertions.assertEquals((int)clusterId.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.traverse((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count), (Function1 & Serializable)x$1 -> Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
                Object object;
                Integer atomicGetOrUpdate_key = BoxesRunTime.boxToInteger((int)0);
                Option option = map$1.get((Object)atomicGetOrUpdate_key);
                if (option instanceof Some) {
                    object = ((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    AtomicInteger atomicGetOrUpdate_value = CoreUtilsTest.$anonfun$testAtomicGetOrUpdate$3(createdCount$1);
                    object = map$1.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1((Object)atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option);
                }
                Object var2_2 = null;
                option = null;
                Object var4_4 = null;
                return ((AtomicInteger)object).incrementAndGet();
            }, (ExecutionContext)executionContext), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)executionContext), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES));
            Assertions.assertEquals((int)count, (int)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assertions.assertTrue((created > 0 && created <= nThreads ? 1 : 0) != 0, (String)new StringBuilder(19).append("Too many creations ").append(created).toString());
        }
        finally {
            executionContext.shutdownNow();
        }
    }

    @Test
    public void testClusterLinkLocalReverseConnectionListenerMapUsesSpecifiedConfig() {
        String config = "INTERNAL_TENANT_SCOPE:EXTERNAL,EXTERNAL:EXTERNAL,INTERNAL:INTERNAL";
        .colon.colon listeners = new .colon.colon((Object)new ListenerName("EXTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL_TENANT_SCOPE"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTERNAL_TENANT_SCOPE"), (Object)"EXTERNAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)"EXTERNAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTERNAL"), (Object)"INTERNAL")}))), (Object)CoreUtils$.MODULE$.clusterLinkLocalReverseConnectionListenerMap(config, (Seq)listeners));
    }

    @Test
    public void testClusterLinkLocalReverseConnectionListenerMapUsesDefault() {
        .colon.colon listeners = new .colon.colon((Object)new ListenerName("INTERNAL_TENANT_SCOPE"), (List)new .colon.colon((Object)new ListenerName("EXTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTERNAL_TENANT_SCOPE"), (Object)"INTERNAL_TENANT_SCOPE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)"EXTERNAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTERNAL"), (Object)"INTERNAL")}))), (Object)CoreUtils$.MODULE$.clusterLinkLocalReverseConnectionListenerMap(null, (Seq)listeners));
    }

    @Test
    public void testClusterLinkLocalReverseConnectionListenerMapHandlesDynamicListener() {
        String configWithDynamicListener = "DYNAMIC_LISTENER_ONE:EXTERNAL,DYNAMIC_LISTENER_TWO:DYNAMIC_LISTENER_THREE,INTERNAL_TENANT_SCOPE:EXTERNAL,EXTERNAL:EXTERNAL,INTERNAL:INTERNAL";
        .colon.colon listeners = new .colon.colon((Object)new ListenerName("EXTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL_TENANT_SCOPE"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DYNAMIC_LISTENER_ONE"), (Object)"EXTERNAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DYNAMIC_LISTENER_TWO"), (Object)"DYNAMIC_LISTENER_THREE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTERNAL_TENANT_SCOPE"), (Object)"EXTERNAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)"EXTERNAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTERNAL"), (Object)"INTERNAL")}))), (Object)CoreUtils$.MODULE$.clusterLinkLocalReverseConnectionListenerMap(configWithDynamicListener, (Seq)listeners));
    }

    @Test
    public void testClusterLinkLocalReverseConnectionListenerMapThrowsExceptionForMissingListener() {
        .colon.colon listeners = new .colon.colon((Object)new ListenerName("EXTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL_TENANT_SCOPE"), (List)Nil$.MODULE$)));
        String configWithMissingListener = "EXTERNAL:EXTERNAL,INTERNAL:INTERNAL";
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CoreUtilsTest.$anonfun$testClusterLinkLocalReverseConnectionListenerMapThrowsExceptionForMissingListener$1(configWithMissingListener, (scala.collection.immutable.Seq)listeners));
        Assertions.assertEquals((Object)"EXTERNAL:EXTERNAL,INTERNAL:INTERNAL does not contain a mapping for listener INTERNAL_TENANT_SCOPE.", (Object)ex.getMessage());
    }

    @Test
    public void testClusterLinkLocalReverseConnectionListenerMapThrowsExceptionForUnknownListenerBeingMappedTo() {
        .colon.colon listeners = new .colon.colon((Object)new ListenerName("EXTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL"), (List)new .colon.colon((Object)new ListenerName("INTERNAL_TENANT_SCOPE"), (List)Nil$.MODULE$)));
        String config = "INTERNAL_TENANT_SCOPE:UNKNOWN,EXTERNAL:EXTERNAL,INTERNAL:INTERNAL";
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CoreUtilsTest.$anonfun$testClusterLinkLocalReverseConnectionListenerMapThrowsExceptionForUnknownListenerBeingMappedTo$1(config, (scala.collection.immutable.Seq)listeners));
        Assertions.assertEquals((Object)"Listener UNKNOWN does not exist in the brokers configured listeners Set(EXTERNAL, INTERNAL, INTERNAL_TENANT_SCOPE)", (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assertions.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$1(Tuple2 m) {
        Assertions.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
        Assertions.assertTrue((boolean)((String)m._2()).equals("v"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$3(Tuple2 m) {
        Assertions.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
        Assertions.assertTrue((boolean)((String)m._2()).equals("allow"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$4(Tuple2 m) {
        Assertions.assertTrue((boolean)((String)m._1()).equals("key"));
        Assertions.assertTrue((boolean)((String)m._2()).equals("value"));
    }

    public static final /* synthetic */ AtomicInteger $anonfun$testAtomicGetOrUpdate$3(AtomicInteger createdCount$1) {
        createdCount$1.incrementAndGet();
        return new AtomicInteger();
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkLocalReverseConnectionListenerMapThrowsExceptionForMissingListener$1(String configWithMissingListener$1, scala.collection.immutable.Seq listeners$1) {
        CoreUtils$.MODULE$.clusterLinkLocalReverseConnectionListenerMap(configWithMissingListener$1, (Seq)listeners$1);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkLocalReverseConnectionListenerMapThrowsExceptionForUnknownListenerBeingMappedTo$1(String config$1, scala.collection.immutable.Seq listeners$2) {
        CoreUtils$.MODULE$.clusterLinkLocalReverseConnectionListenerMap(config$1, (Seq)listeners$2);
    }
}

