/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.TimeUnit;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004H\u0001\u0001\u0006IA\u000f\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019i\u0005\u0001)A\u0005\u0015\"9a\n\u0001b\u0001\n\u0013I\u0005BB(\u0001A\u0003%!\nC\u0004Q\u0001\t\u0007I\u0011B%\t\rE\u0003\u0001\u0015!\u0003K\u0011\u001d\u0011\u0006A1A\u0005\nMCaA\u0017\u0001!\u0002\u0013!\u0006\"B.\u0001\t\u0003a\u0006\"B6\u0001\t\u0003a\u0006\"B7\u0001\t\u0003a\u0006\"B8\u0001\t\u0003a\u0006\"B9\u0001\t\u0003a\u0006\"B:\u0001\t\u0003a\u0006\"B;\u0001\t\u0003a\u0006\"B<\u0001\t\u0003a\u0006\"B=\u0001\t\u0003a\u0006\"B>\u0001\t\u0003a\u0006\"B?\u0001\t\u0003a\u0006\"B@\u0001\t\u0003a\u0006BBA\u0002\u0001\u0011\u0005A\f\u0003\u0004\u0002\b\u0001!\t\u0001\u0018\u0005\u0007\u0003\u0017\u0001A\u0011\u0001/\t\r\u0005=\u0001\u0001\"\u0001]\u0011\u0019\t\u0019\u0002\u0001C\u00019\"1\u0011q\u0003\u0001\u0005\u0002qCa!a\u0007\u0001\t\u0003a\u0006BBA\u0010\u0001\u0011\u0005A\f\u0003\u0004\u0002$\u0001!\t\u0001\u0018\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011\u0011\u0010\u0001\u0005\n\u0005m$AD)v_R\fW\u000b^5mgR+7\u000f\u001e\u0006\u0003S)\nQ!\u001e;jYNT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003!\nA\u0001^5nKV\t!\b\u0005\u0002<\u000b6\tAH\u0003\u0002>}\u0005!Q\u000f^5m\u0015\ty\u0004)\u0001\u0004tKJ4XM\u001d\u0006\u0003W\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a\t\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Qa.^7TC6\u0004H.Z:\u0016\u0003)\u0003\"aL&\n\u00051\u0003$aA%oi\u0006Ya.^7TC6\u0004H.Z:!\u0003=\u0019\u0018-\u001c9mK^Kg\u000eZ8x'\u0016\u001c\u0017\u0001E:b[BdWmV5oI><8+Z2!\u0003Ei\u0017\r\u001f+ie>$H\u000f\\3US6,Wj]\u0001\u0013[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\b%\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0002\u000baaY8n[>t\u0017BA-W\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\f[\u0016$(/[2OC6,\u0007%A\u0014uKN$H\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3FcV\fGn])v_R\fG#A/\u0011\u0005=r\u0016BA01\u0005\u0011)f.\u001b;)\u00051\t\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003\r\t\u0007/\u001b\u0006\u0003M\u001e\fqA[;qSR,'O\u0003\u0002i\u0007\u0006)!.\u001e8ji&\u0011!n\u0019\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$H\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3CK2|w/U;pi\u0006D#!D1\u0002MQ,7\u000f\u001e+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0006\u0013wN^3Rk>$\u0018\r\u000b\u0002\u000fC\u0006qC/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,W)];bYN\fVo\u001c;bQ\ty\u0011-A\u0017uKN$(i\\;oI\u0016$G\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3CK2|w/U;pi\u0006D#\u0001E1\u0002oQ,7\u000f\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0006\u0013wN^3Rk>$\u0018MQ3m_^d\u0015.\\5uQ\t\t\u0012-A\u001cuKN$(i\\;oI\u0016$G\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3BE>4X-U;pi\u0006\f%m\u001c<f\u0019&l\u0017\u000e\u001e\u0015\u0003%\u0005\fa\u0007^3tiRC'o\u001c;uY\u0016$\u0016.\\3UQJ|wo]#yG\u0016\u0004H/[8o\u0013\u001a\u0004&o\u001c<jI\u0016$gj\u001c8SCR,W*\u001a;sS\u000eD#aE1\u0002{Q,7\u000f\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,G\u000b\u001b:poN,\u0005pY3qi&|g.\u00134Qe>4\u0018\u000eZ3e\u001d>t'+\u0019;f\u001b\u0016$(/[2)\u0005Q\t\u0017\u0001\r;fgR$vn[3o\u0005V\u001c7.\u001a;UQJ|G\u000f\u001e7f)&lWm\u00142tKJ4X\r\u001a*bi\u0016,\u0015/^1m5\u0016\u0014x\u000e\u000b\u0002\u0016C\u0006\u0001D/Z:u)>\\WM\u001c\"vG.,G\u000f\u00165s_R$H.\u001a+j[\u0016|%m]3sm\u0016$'+\u0019;f\u0003\n|g/\u001a.fe>D#AF1\u0002aQ,7\u000f\u001e+pW\u0016t')^2lKR$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/\u001a\"fY><(,\u001a:pQ\t9\u0012-A\u001cuKN$Hk\\6f]\n+8m[3u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,W)];bYj+'o\u001c\u0015\u00031\u0005\fq\u0007^3tiR{7.\u001a8Ck\u000e\\W\r\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0006\u0013wN^3[KJ|\u0007FA\rb\u0003\u0005#Xm\u001d;U_.,gNQ;dW\u0016$(i\\;oI\u0016$G\u000b\u001b:piRdW\rV5nK>\u00137/\u001a:wK\u0012\u0014\u0016\r^3CK2|wOW3s_\n+Gn\\<MS6LG\u000f\u000b\u0002\u001bC\u0006\tE/Z:u)>\\WM\u001c\"vG.,GOQ8v]\u0012,G\r\u00165s_R$H.\u001a+j[\u0016|%m]3sm\u0016$'+\u0019;f\u0005\u0016dwn\u001e.fe>\f%m\u001c<f\u0019&l\u0017\u000e\u001e\u0015\u00037\u0005\f\u0011\t^3tiR{7.\u001a8Ck\u000e\\W\r\u001e+ie>$H\u000f\\3US6,G\u000b\u001b:poN,\u0005pY3qi&|g.\u00134Qe>4\u0018\u000eZ3e\u001d>t'+\u0019;f\u001b\u0016$(/[2)\u0005q\t\u0017\u0001\u0013;fgR$vn[3o\u0005V\u001c7.\u001a;C_VtG-\u001a3UQJ|G\u000f\u001e7f)&lW\r\u00165s_^\u001cX\t_2faRLwN\\%g!J|g/\u001b3fI:{gNU1uK6+GO]5dQ\ti\u0012-\u0001%uKN$Hk\\6f]\n+8m[3u)\"\u0014x\u000e\u001e;mKRKW.\u001a+ie><8/\u0012=dKB$\u0018n\u001c8JMB\u0013xN^5eK\u0012tuN\u001c+pW\u0016t')^2lKRlU\r\u001e:jG\"\u0012a$Y\u0001Pi\u0016\u001cH\u000fV8lK:\u0014UoY6fi\n{WO\u001c3fIRC'o\u001c;uY\u0016$\u0016.\\3UQJ|wo]#yG\u0016\u0004H/[8o\u0013\u001a\u0004&o\u001c<jI\u0016$gj\u001c8U_.,gNQ;dW\u0016$X*\u001a;sS\u000eD#aH1\u0002qQ,7\u000f\u001e\"pk:$W\r\u001a+pW\u0016t')^2lKR$\u0006N]8ui2,G+[7f\u0003\n|g/Z'j]RC'o\u001c;uY\u0016$\u0016.\\3Ng\"\u0012\u0001%Y\u0001\u0018cV|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0002\"a\u000b\u00028\u0005\u0005\u0013Q\t\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007,\u0002\u000f5,GO]5dg&!\u0011QGA\u0018\u0005]\tVo\u001c;b-&|G.\u0019;j_:,\u0005pY3qi&|g\u000eC\u0004\u0002:\u0005\u0002\r!a\u000f\u0002\u001b=\u00147/\u001a:wK\u00124\u0016\r\\;f!\ry\u0013QH\u0005\u0004\u0003\u007f\u0001$A\u0002#pk\ndW\rC\u0004\u0002D\u0005\u0002\r!a\u000f\u0002\u000bE,x\u000e^1\t\u000b!\u000b\u0003\u0019\u0001&\u0002\u0019QD'o\u001c;uY\u0016$\u0016.\\3\u0015\u0011\u0005-\u0013\u0011KA*\u0003+\u00022aLA'\u0013\r\ty\u0005\r\u0002\u0005\u0019>tw\rC\u0004\u0002:\t\u0002\r!a\u000f\t\u000f\u0005\r#\u00051\u0001\u0002<!)\u0001J\ta\u0001\u0015\u0006\u0019\"m\\;oI\u0016$G\u000b\u001b:piRdW\rV5nKRQ\u00111JA.\u0003;\ny&!\u0019\t\u000f\u0005e2\u00051\u0001\u0002<!9\u00111I\u0012A\u0002\u0005m\u0002\"\u0002%$\u0001\u0004Q\u0005bBA2G\u0001\u0007\u00111J\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nK\u0006\u0011Co\\6f]\n+8m[3u#V|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0002\"a\u000b\u0002j\u0005-\u0014Q\u000e\u0005\b\u0003s!\u0003\u0019AA\u001e\u0011\u001d\t\u0019\u0005\na\u0001\u0003wAQ\u0001\u0013\u0013A\u0002)\u000bq\u0003^8lK:\u0014UoY6fiRC'o\u001c;uY\u0016$\u0016.\\3\u0015\u0011\u0005-\u00131OA;\u0003oBq!!\u000f&\u0001\u0004\tY\u0004C\u0004\u0002D\u0015\u0002\r!a\u000f\t\u000b!+\u0003\u0019\u0001&\u0002=Q|7.\u001a8Ck\u000e\\W\r\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,GCCA&\u0003{\ny(!!\u0002\u0004\"9\u0011\u0011\b\u0014A\u0002\u0005m\u0002bBA\"M\u0001\u0007\u00111\b\u0005\u0006\u0011\u001a\u0002\rA\u0013\u0005\b\u0003G2\u0003\u0019AA&\u0001")
public class QuotaUtilsTest {
    private final MockTime time = new MockTime();
    private final int numSamples;
    private final int sampleWindowSec;
    private final int maxThrottleTimeMs;
    private final MetricName metricName = new MetricName("test-metric", "groupA", "testA", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());

    private MockTime time() {
        return this.time;
    }

    private int numSamples() {
        return this.numSamples;
    }

    private int sampleWindowSec() {
        return this.sampleWindowSec;
    }

    private int maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName metricName() {
        return this.metricName;
    }

    @Test
    public void testThrottleTimeObservedRateEqualsQuota() {
        int numSamples = 10;
        double observedValue = 16.5;
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples));
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples + 1));
    }

    @Test
    public void testThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 20.4;
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.throttleTime(observedValue, quota, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleTimeObservedRateAboveQuota() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)2000L, (long)this.throttleTime(observedValue, quota, 3));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateEqualsQuota() {
        double observedValue = 18.2;
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 22.4;
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples() + 1, this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaBelowLimit() {
        double quota = 50.0;
        double observedValue = 55.0;
        Assertions.assertEquals((long)100L, (long)this.boundedThrottleTime(observedValue, quota, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaAboveLimit() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)this.maxThrottleTimeMs(), (long)this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.throttleTime(new QuotaViolationException(testMetric, 10.0, 20.0), this.time().milliseconds()));
    }

    @Test
    public void testBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.boundedThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs(), this.time().milliseconds()));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateEqualZero() {
        int refillRate = 5;
        boolean observedValue = false;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketThrottleTime((double)observedValue, refillRate, this.numSamples()));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketThrottleTime((double)observedValue, refillRate, this.numSamples() + 1));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateAboveZero() {
        int observedValue = 3;
        int refillRate = 5;
        Assertions.assertTrue((this.tokenBucketThrottleTime(observedValue, refillRate, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.tokenBucketThrottleTime(observedValue, refillRate, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateBelowZero() {
        int refillRate = 5;
        int observedValue = -10;
        Assertions.assertEquals((long)2000L, (long)this.tokenBucketThrottleTime(observedValue, refillRate, this.numSamples()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateEqualZero() {
        int refillRate = 5;
        boolean observedValue = false;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime((double)observedValue, refillRate, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime((double)observedValue, refillRate, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateAboveZero() {
        int refillRate = 5;
        int observedValue = 3;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, this.numSamples(), this.maxThrottleTimeMs()));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateBelowZeroBelowLimit() {
        int refillRate = 5;
        int observedValue = -1;
        Assertions.assertEquals((long)200L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateBelowZeroAboveLimit() {
        int refillRate = 5;
        int observedValue = -10;
        Assertions.assertEquals((long)this.maxThrottleTimeMs(), (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testTokenBucketThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.tokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0)));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            long boundedTokenBucketThrottleTime_maxThrottleTime = this.maxThrottleTimeMs();
            QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), 0L, boundedTokenBucketThrottleTime_maxThrottleTime);
        });
    }

    @Test
    public void testTokenBucketThrottleTimeThrowsExceptionIfProvidedNonTokenBucketMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils$.MODULE$.tokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0)));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeThrowsExceptionIfProvidedNonTokenBucketMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), new MetricConfig(), (Time)this.time());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            long boundedTokenBucketThrottleTime_maxThrottleTime = this.maxThrottleTimeMs();
            QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), 0L, boundedTokenBucketThrottleTime_maxThrottleTime);
        });
    }

    @Test
    public void testBoundedTokenBucketThrottleTimeAboveMinThrottleTimeMs() {
        int refillRate = 5;
        int observedValue = -1;
        QuotaViolationException e = this.tokenBucketQuotaViolationException(observedValue, refillRate, this.numSamples());
        int minThrottleTimeMs = 300;
        Assertions.assertEquals((long)minThrottleTimeMs, (long)QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(e, (long)minThrottleTimeMs, (long)this.maxThrottleTimeMs()));
    }

    private QuotaViolationException quotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long throttleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.throttleTime(e, this.time().milliseconds());
    }

    private long boundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, maxThrottleTime, this.time().milliseconds());
    }

    private QuotaViolationException tokenBucketQuotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new TokenBucket(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long tokenBucketThrottleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.tokenBucketQuotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.tokenBucketThrottleTime(e);
    }

    private long tokenBucketBoundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.tokenBucketQuotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(e, 0L, maxThrottleTime);
    }

    public QuotaUtilsTest() {
        this.numSamples = 10;
        this.sampleWindowSec = 1;
        this.maxThrottleTimeMs = 500;
    }
}

