/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import org.apache.kafka.clients.consumer.GroupProtocol;
import org.junit.jupiter.api.TestInfo;
import scala.None$;
import scala.Option;
import scala.Some;

public final class TestInfoUtils$ {
    public static final TestInfoUtils$ MODULE$ = new TestInfoUtils$();

    public boolean isKRaft(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("quorum=")) {
            if (testInfo.getDisplayName().contains("quorum=kraft")) {
                return true;
            }
            if (testInfo.getDisplayName().contains("quorum=zk")) {
                return false;
            }
            throw new RuntimeException("Unknown quorum value");
        }
        return false;
    }

    public boolean isPushReplication(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("push")) {
            if (this.isKRaft(testInfo)) {
                return true;
            }
            throw new IllegalArgumentException("Push replication is not supported for zookeeper quorum mode.");
        }
        return false;
    }

    public boolean isCombinedKRaft(TestInfo testInfo) {
        return testInfo.getDisplayName().contains("quorum=kraft_combined");
    }

    public boolean isZkMigrationTest(TestInfo testInfo) {
        if (!this.isKRaft(testInfo)) {
            return false;
        }
        return testInfo.getDisplayName().contains("quorum=zkMigration");
    }

    public final String TestWithParameterizedQuorumName() {
        return "{displayName}.{argumentsWithNames}";
    }

    public final String TestWithParameterizedTierTopicMaterializationFromSnapshot() {
        return "{displayName}.tierTopicMaterializationFromSnapshot={0}";
    }

    public final String ClusterLinkTestWithParameterizedName() {
        return "{displayName}.quorum={0}.coordinator={1}";
    }

    public final String ClusterLinkTestWithQuorumCoordinatorReplicationName() {
        return "{displayName}.quorum={0}.coordinator={1}.localReplication={2}";
    }

    public final String TestWithParameterizedQuorumNameAndReplication() {
        return "{displayName}.quorum={0}.replication={1}";
    }

    public final String TestWithParameterizeApiKey() {
        return "{displayName}.quorum={0}.apikey={1}";
    }

    public final String TestWithParameterizedQuorumAndGroupProtocolNames() {
        return "{displayName}.quorum={0}.groupProtocol={1}";
    }

    public boolean isNewGroupCoordinatorEnabled(TestInfo testInfo) {
        return testInfo.getDisplayName().contains("kraft+kip848");
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("groupProtocol=classic")) {
            return new Some((Object)GroupProtocol.CLASSIC);
        }
        if (testInfo.getDisplayName().contains("groupProtocol=consumer")) {
            return new Some((Object)GroupProtocol.CONSUMER);
        }
        return None$.MODULE$;
    }

    private TestInfoUtils$() {
    }
}

