/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.cloud;

import io.confluent.kafka.storage.cloud.EpochAndSeqNumber;
import io.confluent.kafka.storage.cloud.LinkedCloudObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\f\u0001C\u00013!)A\f\u0001C\u0005;\n)B*\u001b8lK\u0012\u001cEn\\;e\u001f\nTWm\u0019;UKN$(BA\u0004\t\u0003\u0015\u0019Gn\\;e\u0015\tI!\"A\u0003vi&d7OC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\ta!A\ruKN$H*\u0019;fgR\u001cu.\\7jiR,Gm\u00142kK\u000e$H#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\u0011)f.\u001b;)\u0005\tq\u0002CA\u0010)\u001b\u0005\u0001#BA\u0011#\u0003\r\t\u0007/\u001b\u0006\u0003G\u0011\nqA[;qSR,'O\u0003\u0002&M\u0005)!.\u001e8ji*\tq%A\u0002pe\u001eL!!\u000b\u0011\u0003\tQ+7\u000f\u001e\u0015\u0004\u0005-R\u0004cA\b-]%\u0011Q\u0006\u0005\u0002\u0007i\"\u0014xn^:\u0011\u0005=:dB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019D\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011a\u0007E\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\u000bJ]R,'O];qi\u0016$W\t_2faRLwN\u001c\u0006\u0003mA\tDAH\u001eD3B\u0011A\b\u0011\b\u0003{y\u0002\"!\r\t\n\u0005}\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\t2\u000b\r\"\u0005\nV%\u0016\u0005\u00153U#A\u001e\u0005\u000b\u001dc!\u0019\u0001'\u0003\u0003QK!!\u0013&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\tY\u0005#\u0001\u0004uQJ|wo]\t\u0003\u001bB\u0003\"a\u0004(\n\u0005=\u0003\"a\u0002(pi\"Lgn\u001a\t\u0003#Js!aD\u001b\n\u0005MK$!\u0003+ie><\u0018M\u00197fc\u0015\u0019SKV,L\u001d\tya+\u0003\u0002L!E\"!e\u0004\tY\u0005\u0015\u00198-\u00197bc\t1c&A\nuKN$x)\u001a;PaRLW.\u00197DQ\u0006Lg\u000e\u000b\u0002\u0004=\u0005y\u0001.\u001a7qKJ<UM\\3sCR|'\u000fF\u0003_MB,x\u000f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006A1O\\1qg\"|GO\u0003\u0002d\u0015\u0005!A/[3s\u0013\t)\u0007MA\fUS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_R|%M[3di\")q\r\u0002a\u0001Q\u0006a1-\u001e:sK:$X\t]8dQB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005Y\u0006twMC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'aB%oi\u0016<WM\u001d\u0005\u0006c\u0012\u0001\rA]\u0001\u0011GV\u0014(/\u001a8u'\u0016\fh*^7cKJ\u0004\"aD:\n\u0005Q\u0004\"\u0001\u0002'p]\u001eDQA\u001e\u0003A\u0002!\f\u0011\u0002\u001d:fm\u0016\u0003xn\u00195\t\u000ba$\u0001\u0019\u0001:\u0002\u001bA\u0014XM^*fc:+XNY3s\u0001")
public class LinkedCloudObjectTest {
    @Test
    public void testLatestCommittedObject() throws InterruptedException {
        TierTopicSnapshotObject obj1 = this.helperGenerator(Predef$.MODULE$.int2Integer(0), 0L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj2 = this.helperGenerator(Predef$.MODULE$.int2Integer(2), 1L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj3 = this.helperGenerator(Predef$.MODULE$.int2Integer(1), 2L, Predef$.MODULE$.int2Integer(0), 0L);
        Optional latestObject = LinkedCloudObject.latestCommittedObject(Arrays.asList(obj1, obj2, obj3));
        Assertions.assertTrue((boolean)latestObject.isPresent());
        Assertions.assertEquals((Object)obj2, latestObject.get());
    }

    @Test
    public void testGetOptimalChain() {
        TierTopicSnapshotObject obj1 = this.helperGenerator(Predef$.MODULE$.int2Integer(0), 0L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj2 = this.helperGenerator(Predef$.MODULE$.int2Integer(0), 1L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj3 = this.helperGenerator(Predef$.MODULE$.int2Integer(1), 0L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj4 = this.helperGenerator(Predef$.MODULE$.int2Integer(1), 1L, Predef$.MODULE$.int2Integer(1), 0L);
        TierTopicSnapshotObject obj5 = this.helperGenerator(Predef$.MODULE$.int2Integer(2), 0L, Predef$.MODULE$.int2Integer(0), 1L);
        List optimalList = LinkedCloudObject.getOptimalChain(Arrays.asList(obj1, obj2, obj3, obj4, obj5));
        Assertions.assertEquals(Arrays.asList(obj1, obj2, obj5), (Object)optimalList);
    }

    private TierTopicSnapshotObject helperGenerator(Integer currentEpoch, long currentSeqNumber, Integer prevEpoch, long prevSeqNumber) {
        return new TierTopicSnapshotObject(0L, 0L, new EpochAndSeqNumber(Predef$.MODULE$.Integer2int(currentEpoch), currentSeqNumber), new EpochAndSeqNumber(Predef$.MODULE$.Integer2int(prevEpoch), prevSeqNumber));
    }
}

