/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.zk.ConfluentAssignmentMigration$;
import kafka.zk.KRaftAssignment;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000513Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u0006\u0001C\u0001;!)\u0001\u0007\u0001C\u0001;!)!\u0007\u0001C\u0001;!)A\u0007\u0001C\u0001;!)a\u0007\u0001C\u0001;!)\u0001\b\u0001C\u0001;!)!\b\u0001C\u0001;!)A\b\u0001C\u0005{\t\u00013i\u001c8gYV,g\u000e^!tg&<g.\\3oi6KwM]1uS>tG+Z:u\u0015\tia\"\u0001\u0002{W*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0019\u0005YC/Z:u\rJ|WNW6U_.\u0013\u0016M\u001a;BgNLwM\\7f]R<\u0016\u000e\u001e5pkR|%m]3sm\u0016\u00148\u000fF\u0001\u001f!\t\u0019r$\u0003\u0002!)\t!QK\\5uQ\t\u0011!\u0005\u0005\u0002$Y5\tAE\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0005\u001dB\u0013a\u00026va&$XM\u001d\u0006\u0003S)\nQA[;oSRT\u0011aK\u0001\u0004_J<\u0017BA\u0017%\u0005\u0011!Vm\u001d;\u0002QQ,7\u000f\u001e$s_6T6\u000eV8L%\u00064G/Q:tS\u001etW.\u001a8u/&$\bn\u00142tKJ4XM]:)\u0005\r\u0011\u0013!\u0010;fgR4%o\\7[WR{7JU1gi\u0006\u001b8/[4o[\u0016tGoV5uQ>,Ho\u00142tKJ4XM]:EkJLgn\u001a*fCN\u001c\u0018n\u001a8nK:$\bF\u0001\u0003#\u0003i\"Xm\u001d;Ge>l'l\u001b+p\u0017J\u000bg\r^!tg&<g.\\3oi^KG\u000f[(cg\u0016\u0014h/\u001a:t\tV\u0014\u0018N\\4SK\u0006\u001c8/[4o[\u0016tG\u000f\u000b\u0002\u0006E\u0005YC/Z:u\rJ|Wn\u0013*bMR$vNW6BgNLwM\\7f]R<\u0016\u000e\u001e5pkR|%m]3sm\u0016\u00148\u000f\u000b\u0002\u0007E\u0005AC/Z:u\rJ|Wn\u0013*bMR$vNW6BgNLwM\\7f]R<\u0016\u000e\u001e5PEN,'O^3sg\"\u0012qAI\u0001>i\u0016\u001cHO\u0012:p[.\u0013\u0016M\u001a;U_j[\u0017i]:jO:lWM\u001c;XSRDw.\u001e;PEN,'O^3sg\u0012+(/\u001b8h%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0003\u0011\t\n!\b^3ti\u001a\u0013x.\\&SC\u001a$Hk\u001c.l\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001f\n\u001cXM\u001d<feN$UO]5oOJ+\u0017m]:jO:lWM\u001c;)\u0005%\u0011\u0013a\u0006;p!\u0006\u0014H/\u001b;j_:\u0014VmZ5tiJ\fG/[8o)\tqt\t\u0005\u0002@\u000b6\t\u0001I\u0003\u0002B\u0005\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0010\u0007*\u0011AIK\u0001\u0007CB\f7\r[3\n\u0005\u0019\u0003%!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\u0006\u0011*\u0001\r!S\u0001\u0010WJ\fg\r^!tg&<g.\\3oiB\u00111DS\u0005\u0003\u00172\u0011qb\u0013*bMR\f5o]5h]6,g\u000e\u001e")
public class ConfluentAssignmentMigrationTest {
    @Test
    public void testFromZkToKRaftAssignmentWithoutObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.empty();
        ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers);
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), observers, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(replicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromZkToKRaftAssignmentWithObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers);
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)observers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(replicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromZkToKRaftAssignmentWithoutObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.empty();
        ReplicaAssignment.Assignment targetAssignment = new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment reassignmentReplicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers).reassignTo(targetAssignment);
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 0, 1, 2}));
        Seq expectedAddingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}));
        Seq expectedRemovingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)expectedReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), observers, (Seq)expectedAddingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedRemovingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(reassignmentReplicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromZkToKRaftAssignmentWithObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        ReplicaAssignment.Assignment targetAssignment = new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})));
        ReplicaAssignment reassignmentReplicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers).reassignTo(targetAssignment);
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1, 7, 8, 5, 6}));
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 5, 6}));
        Seq expectedAddingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8}));
        Seq expectedRemovingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq expectedAddingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        Seq expectedRemovingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)expectedReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedAddingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedRemovingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedAddingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedRemovingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)));
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(reassignmentReplicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithoutObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.empty();
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), observers, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), observers, (Option)None$.MODULE$);
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)observers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), observers, (Option)None$.MODULE$);
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithoutObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 0, 1, 2}));
        Seq addingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}));
        Seq removingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)addingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)removingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, addingReplicas, removingReplicas, (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty()));
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1, 7, 8, 5, 6}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 5, 6}));
        Seq addingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8}));
        Seq removingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq addingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        Seq removingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        Seq originalObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        Seq targetObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)observers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)addingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)removingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)addingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)removingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)));
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, addingReplicas, removingReplicas, originalObservers, (Option)new Some((Object)targetObservers));
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    private PartitionRegistration toPartitionRegistration(KRaftAssignment kraftAssignment) {
        return new PartitionRegistration.Builder().setReplicas((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.replicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), (ClassTag)ClassTag$.MODULE$.Int())).setDirectories(DirectoryId.migratingArray((int)kraftAssignment.replicas().size())).setObservers((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.observers().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), (ClassTag)ClassTag$.MODULE$.Int())).setIsr((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.replicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), (ClassTag)ClassTag$.MODULE$.Int())).setRemovingReplicas((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.removingReplicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4)), (ClassTag)ClassTag$.MODULE$.Int())).setAddingReplicas((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.addingReplicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$5)), (ClassTag)ClassTag$.MODULE$.Int())).setRemovingObservers((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.removingObservers().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$6)), (ClassTag)ClassTag$.MODULE$.Int())).setAddingObservers((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.addingObservers().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$7)), (ClassTag)ClassTag$.MODULE$.Int())).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(1)).setPartitionEpoch(Predef$.MODULE$.int2Integer(1)).build();
    }
}

